/*
 * Decompiled with CFR 0.152.
 */
package io.hawt;

import io.hawt.jmx.About;
import io.hawt.jmx.JMXSecurity;
import io.hawt.jmx.JmxTreeWatcher;
import io.hawt.jmx.PluginRegistry;
import io.hawt.jmx.QuartzFacade;
import io.hawt.jmx.RBACRegistry;
import io.hawt.jmx.UploadManager;
import io.hawt.system.ConfigManager;
import javax.management.InstanceNotFoundException;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HawtioContextListener
implements ServletContextListener {
    private static final Logger LOG = LoggerFactory.getLogger(HawtioContextListener.class);
    private About about = new About();
    private QuartzFacade quartz = new QuartzFacade();
    private JmxTreeWatcher treeWatcher = new JmxTreeWatcher();
    private PluginRegistry registry = new PluginRegistry();
    private UploadManager uploadManager = new UploadManager();
    private ConfigManager configManager = new ConfigManager();
    private JMXSecurity jmxSecurity = new JMXSecurity();
    private RBACRegistry rbacRegistry = new RBACRegistry();

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        try {
            this.about.init();
            this.quartz.init();
            this.configManager.init();
            this.treeWatcher.init();
            this.registry.init();
            this.uploadManager.init(this.configManager);
            this.jmxSecurity.init();
            this.rbacRegistry.init();
        }
        catch (Exception e) {
            throw this.createServletException(e);
        }
        servletContextEvent.getServletContext().setAttribute("ConfigManager", (Object)this.configManager);
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        try {
            this.rbacRegistry.destroy();
            this.about.destroy();
            this.quartz.destroy();
            this.treeWatcher.destroy();
            this.registry.destroy();
            this.uploadManager.destroy();
            this.configManager.destroy();
            this.jmxSecurity.destroy();
        }
        catch (InstanceNotFoundException infe) {
            LOG.debug("Can't find MBean Instance when destroy context", (Throwable)infe);
        }
        catch (Exception e) {
            throw this.createServletException(e);
        }
    }

    protected RuntimeException createServletException(Exception e) {
        return new RuntimeException(e);
    }
}

