/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.system;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigManager {
    private static final transient Logger LOG = LoggerFactory.getLogger(ConfigManager.class);
    private Context envContext = null;

    public void init() {
        if (Boolean.parseBoolean(System.getProperty("hawtio.forceProperties", "false"))) {
            LOG.info("Forced using system properties");
            return;
        }
        try {
            this.envContext = (Context)new InitialContext().lookup("java:comp/env");
            LOG.info("Configuration will be discovered via JNDI");
        }
        catch (NamingException e) {
            LOG.debug("Failed to look up environment context: ", (Throwable)e);
            LOG.info("Configuration will be discovered via system properties");
        }
    }

    public void destroy() {
        if (this.envContext != null) {
            try {
                this.envContext.close();
            }
            catch (NamingException namingException) {
                // empty catch block
            }
            this.envContext = null;
        }
    }

    public String get(String name, String defaultValue) {
        String answer = null;
        if (this.envContext != null) {
            try {
                answer = (String)this.envContext.lookup("hawtio/" + name);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (answer == null) {
            answer = defaultValue == null ? System.getProperty("hawtio." + name) : System.getProperty("hawtio." + name, defaultValue.toString());
        }
        if (answer == null) {
            answer = defaultValue;
        }
        LOG.debug("Property {} is set to value {}", (Object)name, (Object)answer);
        return answer;
    }
}

