/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.web;

import io.hawt.web.ServletHelpers;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportContextServlet
extends HttpServlet {
    public static final String RENDER_JSON_ERROR_MESSAGES = "ERROR_MESSAGES";
    private static final transient Logger LOG = LoggerFactory.getLogger(ExportContextServlet.class);

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse resp) throws ServletException, IOException {
        String serverUrl = httpServletRequest.getParameter("server");
        String jobExecutionId = httpServletRequest.getParameter("execId");
        String key = httpServletRequest.getParameter("key");
        String jsonStringResponse = "";
        String exportCsvString = "Content not available";
        if (serverUrl != null && !serverUrl.isEmpty() && jobExecutionId != null && !jobExecutionId.isEmpty()) {
            JSONObject entry;
            jsonStringResponse = ExportContextServlet.executeHttpGetRequest(this.getServerUrl(serverUrl) + "jobs/executions/" + jobExecutionId + "/context.json");
            JSONObject jsonObject = this.parseStringToJSON(jsonStringResponse);
            Object entryObject = this.getEntryObject(jsonObject);
            if (entryObject != null && entryObject instanceof JSONArray) {
                JSONArray entry2 = (JSONArray)entryObject;
                JSONObject exportEntry = null;
                for (Object o : entry2) {
                    if (!(o instanceof JSONObject) || !((JSONObject)o).get((Object)"string").toString().equalsIgnoreCase(key)) continue;
                    exportEntry = (JSONObject)o;
                    exportCsvString = this.getCsvData(exportEntry, key);
                }
            } else if (entryObject != null && entryObject instanceof JSONObject && (entry = (JSONObject)entryObject).get((Object)"string").toString().equalsIgnoreCase(key)) {
                JSONObject exportEntry = (JSONObject)entry.get((Object)"string");
                exportCsvString = this.getCsvData(exportEntry, key);
            }
        }
        resp.setHeader("Content-Disposition", "attachment; filename=\"jsonData.csv\"");
        resp.getWriter().println(exportCsvString);
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse resp) throws ServletException, IOException {
        String serverUrl = httpServletRequest.getParameter("server");
        String jobExecutionId = httpServletRequest.getParameter("execId");
        String stepId = httpServletRequest.getParameter("stepId");
        String entryIndex = httpServletRequest.getParameter("entryIndex");
        String exportCsvString = "Content not available";
        if (serverUrl != null && !serverUrl.isEmpty() && jobExecutionId != null && !jobExecutionId.isEmpty()) {
            JSONArray entry;
            Object exportEntryObject;
            Object entryObject;
            String jsonStringResponse = stepId != null && !stepId.isEmpty() ? ExportContextServlet.executeHttpGetRequest(this.getServerUrl(serverUrl) + "jobs/executions/" + jobExecutionId + "/steps/" + stepId + "/context.json") : ExportContextServlet.executeHttpGetRequest(this.getServerUrl(serverUrl) + "jobs/executions/" + jobExecutionId + "/context.json");
            JSONObject jsonObject = this.parseStringToJSON(jsonStringResponse);
            Object object = entryObject = stepId != null && !stepId.isEmpty() ? this.getEntryObject(jsonObject, "stepExecutionContext") : this.getEntryObject(jsonObject);
            if (entryObject != null && entryObject instanceof JSONArray && (exportEntryObject = (entry = (JSONArray)entryObject).get(Integer.parseInt(entryIndex))) instanceof JSONObject) {
                String key = ((JSONObject)exportEntryObject).get((Object)"string").toString();
                exportCsvString = this.getCsvData((JSONObject)exportEntryObject, key);
            }
        }
        resp.setHeader("Content-Disposition", "attachment; filename=\"jsonData.csv\"");
        resp.getWriter().println(exportCsvString);
    }

    private String getCsvData(JSONObject exportEntry, String key) {
        if (exportEntry.get((Object)"list") != null && exportEntry.get((Object)"list") instanceof JSONObject) {
            JSONObject obj = (JSONObject)exportEntry.get((Object)"list");
            JSONArray exportArray = (JSONArray)new LinkedList(obj.values()).getFirst();
            Map xlData = key.equalsIgnoreCase(RENDER_JSON_ERROR_MESSAGES) ? ServletHelpers.populateErrorTableMapForXl((List)exportArray) : ServletHelpers.populateTableMapForXl((List)exportArray);
            return ServletHelpers.generateCsvString(xlData);
        }
        return "Content not available";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String executeHttpGetRequest(String url) throws IOException {
        try (CloseableHttpClient httpclient = HttpClients.createDefault();){
            HttpGet httpget = new HttpGet(url);
            ResponseHandler<String> responseHandler = new ResponseHandler<String>(){

                public String handleResponse(HttpResponse response) throws IOException {
                    int status = response.getStatusLine().getStatusCode();
                    if (status >= 200 && status < 300) {
                        HttpEntity entity = response.getEntity();
                        return entity != null ? EntityUtils.toString((HttpEntity)entity) : null;
                    }
                    throw new ClientProtocolException("Unexpected response status: " + status);
                }
            };
            String string = (String)httpclient.execute((HttpUriRequest)httpget, (ResponseHandler)responseHandler);
            return string;
        }
    }

    private JSONObject parseStringToJSON(String source) {
        JSONParser parser = new JSONParser();
        JSONObject jsonObject = null;
        try {
            jsonObject = (JSONObject)parser.parse(source);
        }
        catch (Exception pe) {
            LOG.error(pe.getMessage());
            return jsonObject;
        }
        return jsonObject;
    }

    private Object getEntryObject(JSONObject jsonObject, String contextType) {
        JSONObject jobExecutionContext = (JSONObject)jsonObject.get((Object)(contextType = contextType != null && !contextType.isEmpty() ? contextType : "jobExecutionContext"));
        JSONObject contextObject = (JSONObject)jobExecutionContext.get((Object)"context");
        if (contextObject.get((Object)"map") != null && contextObject.get((Object)"map") instanceof JSONObject) {
            return ((JSONObject)contextObject.get((Object)"map")).get((Object)"entry");
        }
        return null;
    }

    private Object getEntryObject(JSONObject jsonObject) {
        return this.getEntryObject(jsonObject, null);
    }

    private String getServerUrl(String serverUrl) {
        if (!(serverUrl = serverUrl.replaceAll("\\\\", "")).contains("http://")) {
            serverUrl = "http://" + serverUrl;
        }
        return serverUrl;
    }
}

