/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.web;

import io.hawt.web.RBACRestrictor;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.jolokia.config.ConfigKey;
import org.jolokia.config.Configuration;
import org.jolokia.http.AgentServlet;
import org.jolokia.restrictor.Restrictor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JolokiaConfiguredAgentServlet
extends AgentServlet {
    private static final transient Logger LOG = LoggerFactory.getLogger(JolokiaConfiguredAgentServlet.class);

    public void init(ServletConfig pServletConfig) throws ServletException {
        String policyLocation = System.getProperty("jolokia." + ConfigKey.POLICY_LOCATION.toString());
        if (policyLocation != null) {
            LOG.info("Jolokia will load jolokia-access.xml from [" + policyLocation + "]");
            ServletConfigWrapper pServletConfigWrapper = new ServletConfigWrapper(pServletConfig);
            pServletConfigWrapper.addProperty(ConfigKey.POLICY_LOCATION.toString(), policyLocation);
            super.init((ServletConfig)pServletConfigWrapper);
        } else {
            LOG.info("Jolokia has not found any jolokia-access.xml configured with jolokia." + ConfigKey.POLICY_LOCATION.toString() + " ; Default configuration values will be used.");
            super.init(pServletConfig);
        }
    }

    protected Restrictor createRestrictor(Configuration config) {
        String policyLocation = config.get(ConfigKey.POLICY_LOCATION);
        return new RBACRestrictor(policyLocation);
    }

    class TwoEnumerationsWrapper
    implements Enumeration<String> {
        Enumeration<String> a;
        Enumeration<String> b;

        public TwoEnumerationsWrapper(Enumeration a, Enumeration b) {
            this.a = a;
            this.b = b;
        }

        @Override
        public boolean hasMoreElements() {
            return this.a.hasMoreElements() || this.b.hasMoreElements();
        }

        @Override
        public String nextElement() {
            if (this.a.hasMoreElements()) {
                return this.a.nextElement();
            }
            return this.b.nextElement();
        }
    }

    class ServletConfigWrapper
    implements ServletConfig {
        ServletConfig wrapped;
        Hashtable<String, String> ownProps;

        public ServletConfigWrapper(ServletConfig pServletConfig) {
            this.wrapped = pServletConfig;
            this.ownProps = new Hashtable();
        }

        public String getServletName() {
            return this.wrapped.getServletName();
        }

        public ServletContext getServletContext() {
            return this.wrapped.getServletContext();
        }

        public String getInitParameter(String s) {
            if (this.ownProps.containsKey(s)) {
                return this.ownProps.get(s);
            }
            return this.wrapped.getInitParameter(s);
        }

        public Enumeration getInitParameterNames() {
            return new TwoEnumerationsWrapper(this.ownProps.keys(), this.wrapped.getInitParameterNames());
        }

        public void addProperty(String key, String value) {
            this.ownProps.put(key, value);
        }
    }
}

