/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.web;

import java.io.IOException;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedirectFilter
implements Filter {
    private static final transient Logger LOG = LoggerFactory.getLogger(RedirectFilter.class);
    private static final String[] knownServlets = new String[]{"jolokia", "auth", "upload", "javadoc", "proxy", "springBatch", "user", "plugin", "exportContext", "contextFormatter", "refresh"};
    private ServletContext context;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.context = filterConfig.getServletContext();
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (servletRequest instanceof HttpServletRequest && servletResponse instanceof HttpServletResponse) {
            this.process((HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse, filterChain);
        } else {
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    private void process(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        String[] uriParts;
        String uri = request.getRequestURI();
        if (uri.startsWith("/")) {
            uri = uri.substring(1);
        }
        if (uri.endsWith("/")) {
            uri = uri.substring(0, uri.length() - 1);
        }
        if ((uriParts = Pattern.compile("/").split(uri)).length == 1) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String myContext = uriParts[0];
        String lastPart = uriParts[uriParts.length - 1];
        if (lastPart.contains(".") && !lastPart.endsWith(".profile")) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String subContext = uriParts[1];
        for (String knownServlet : knownServlets) {
            if (!knownServlet.equals(subContext)) continue;
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String route = "";
        for (String part : uriParts) {
            if (part.equals(myContext)) continue;
            route = route + "/" + part;
        }
        LOG.debug("Accessing {}, which isn't valid, returning index.html", (Object)request.getRequestURI());
        String path = request.getRequestURI();
        String context = request.getContextPath();
        path = path.substring(context.length());
        String qs = request.getQueryString();
        response.sendRedirect(request.getContextPath() + "/#" + path + (qs != null && !"".equals(qs) ? "?" + qs : ""));
    }

    public void destroy() {
    }
}

