/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.web;

import io.hawt.jmx.UploadManager;
import io.hawt.util.Strings;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.ProgressListener;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final transient Logger LOG = LoggerFactory.getLogger(UploadServlet.class);

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String uploadDirectory = UploadManager.UPLOAD_DIRECTORY;
        File uploadDir = new File(uploadDirectory);
        this.uploadFiles(request, response, uploadDir);
    }

    protected List<File> uploadFiles(HttpServletRequest request, HttpServletResponse response, File uploadDir) throws IOException, ServletException {
        response.setContentType("text/html");
        final PrintWriter out = response.getWriter();
        ArrayList<File> uploadedFiles = new ArrayList<File>();
        boolean isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)request);
        if (isMultipart) {
            ServletContext context = this.getServletConfig().getServletContext();
            if (!uploadDir.exists()) {
                LOG.info("Creating directory {}" + uploadDir);
                if (!uploadDir.mkdirs()) {
                    LOG.warn("Failed to create upload directory at {}", (Object)uploadDir);
                }
            }
            DiskFileItemFactory factory = UploadManager.newDiskFileItemFactory(context, uploadDir);
            ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
            String targetDirectory = null;
            ArrayList<File> files = new ArrayList<File>();
            upload.setProgressListener(new ProgressListener(){
                private long mBytesRead = 0L;

                public void update(long pBytesRead, long pContentLength, int pItems) {
                    long nowMBytesRead = pBytesRead / 1024L / 1024L;
                    long lengthMBytes = pContentLength / 1024L / 1024L;
                    long anEighth = lengthMBytes / 8L;
                    if (nowMBytesRead > this.mBytesRead && nowMBytesRead % anEighth == 0L) {
                        this.mBytesRead = nowMBytesRead;
                        LOG.debug("On item {}, read {}mb, total: {}mb", new Object[]{pItems, this.mBytesRead, lengthMBytes});
                        out.write("<p>item: " + pItems + " read:" + this.mBytesRead + "mb total: " + lengthMBytes + "mb</p>");
                    }
                }
            });
            try {
                List items = upload.parseRequest(request);
                for (FileItem item : items) {
                    if (item.isFormField()) {
                        String name = item.getFieldName();
                        String value = item.getString();
                        LOG.info("Got form field {} with value {}", (Object)name, (Object)value);
                        if (!name.equals("parent")) continue;
                        targetDirectory = value;
                        continue;
                    }
                    String fieldName = item.getFieldName();
                    String fileName = item.getName();
                    String contentType = item.getContentType();
                    long sizeInBytes = item.getSize();
                    fileName = Strings.sanitize((String)fileName);
                    LOG.info("Got file upload, fieldName: {} fileName: {} contentType: {} size: {}", new Object[]{fieldName, fileName, contentType, sizeInBytes});
                    if (fileName.equals("")) {
                        LOG.info("Skipping field " + fieldName + " no filename given");
                        continue;
                    }
                    File target = new File(uploadDir, fileName);
                    try {
                        item.write(target);
                        files.add(target);
                        LOG.info("Wrote to file: {}", (Object)target.getAbsoluteFile());
                    }
                    catch (Exception e) {
                        LOG.warn("Failed to write to {} due to {}", (Object)target, (Object)e);
                    }
                }
            }
            catch (FileUploadException e) {
                throw new RuntimeException("Failed accepting file uploads: ", e);
            }
            if (targetDirectory != null) {
                targetDirectory = Strings.sanitizeDirectory(targetDirectory);
                File target = new File(uploadDir.getAbsolutePath(), targetDirectory);
                LOG.info("Putting files in subdirectory: {}", (Object)targetDirectory);
                if (!target.exists() && !target.mkdirs()) {
                    LOG.warn("Failed to create target directory: {}", (Object)target);
                }
                for (File file : files) {
                    File dest = new File(target.getAbsolutePath(), file.getName());
                    LOG.info("Renaming {} to {}", (Object)file, (Object)dest);
                    if (!file.renameTo(dest)) {
                        LOG.warn("Failed to rename {} to {}", (Object)file, (Object)dest);
                        continue;
                    }
                    uploadedFiles.add(dest);
                }
            } else {
                uploadedFiles = files;
            }
        } else {
            super.doPost(request, response);
        }
        return uploadedFiles;
    }
}

