/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.web.tomcat;

import io.hawt.web.AuthenticationConfiguration;
import io.hawt.web.AuthenticationContainerDiscovery;
import io.hawt.web.AuthenticationHelpers;
import io.hawt.web.tomcat.TomcatLoginContextConfiguration;
import io.hawt.web.tomcat.TomcatPrincipal;
import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TomcatAuthenticationContainerDiscovery
implements AuthenticationContainerDiscovery {
    private static final transient Logger LOG = LoggerFactory.getLogger(TomcatAuthenticationContainerDiscovery.class);

    @Override
    public String getContainerName() {
        return "Apache Tomcat";
    }

    @Override
    public boolean canAuthenticate(AuthenticationConfiguration configuration) {
        if (!AuthenticationHelpers.isEmptyOrAllRealm(configuration.getRealm())) {
            LOG.debug("Realm explicit configured {}. {} userdata authentication integration not in use.", (Object)configuration.getRealm(), (Object)this.getContainerName());
            return false;
        }
        try {
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            boolean isTomcat = server.isRegistered(new ObjectName("Catalina:type=Server"));
            if (!isTomcat) {
                isTomcat = server.isRegistered(new ObjectName("Tomcat:type=Server"));
            }
            LOG.debug("Checked for {} in JMX for {} -> {}", (Object)this.getContainerName(), (Object)isTomcat);
            if (isTomcat) {
                configuration.setConfiguration(new TomcatLoginContextConfiguration());
                configuration.setRolePrincipalClasses(TomcatPrincipal.class.getName());
            }
            return isTomcat;
        }
        catch (MalformedObjectNameException e) {
            LOG.warn("Error checking in JMX for " + this.getContainerName() + ". This exception is ignored.", (Throwable)e);
            return false;
        }
    }
}

