/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.config;

import io.hawt.config.ConfigFacadeMBean;
import io.hawt.config.URLHandler;
import io.hawt.util.MBeanSupport;
import io.hawt.util.Objects;
import io.hawt.util.Strings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigFacade
extends MBeanSupport
implements ConfigFacadeMBean {
    private static final transient Logger LOG = LoggerFactory.getLogger(ConfigFacade.class);
    private static ConfigFacade singleton;
    private static Map<String, URLHandler> urlStreamHandlerMap;
    private String configDir;
    private String version;

    public static ConfigFacade getSingleton() {
        if (singleton == null) {
            LOG.warn("No ConfigFacade constructed yet so using default configuration for now");
            singleton = new ConfigFacade();
        }
        return singleton;
    }

    @Override
    public void init() throws Exception {
        singleton = this;
        super.init();
    }

    @Override
    protected String getDefaultObjectName() {
        return "hawtio:type=ConfigFacade";
    }

    @Override
    public String getVersion() {
        if (this.version == null) {
            this.version = Objects.getVersion(this.getClass(), "io.hawt", "hawtio-core");
        }
        return this.version;
    }

    public File getConfigDirectory() {
        String dirName = this.getConfigDir();
        File answer = null;
        answer = Strings.isNotBlank(dirName) ? new File(dirName) : new File(".hawtio");
        answer.mkdirs();
        return answer;
    }

    @Override
    public String getConfigDir() {
        if (Strings.isBlank(this.configDir)) {
            String home = System.getProperty("user.home", "~");
            this.configDir = home + System.getProperty("hawtio.dirname", "/.hawtio");
        }
        return this.configDir;
    }

    public void setConfigDir(String configDir) {
        this.configDir = configDir;
    }

    @Override
    public boolean isOffline() {
        return "true".equals(System.getProperty("hawtio.offline", "false"));
    }

    public InputStream openURL(String url) throws IOException {
        int idx = url.indexOf(58);
        if (idx > 1) {
            String protocol = url.substring(0, idx);
            String path = url.substring(idx + 1);
            URLHandler urlHandler = this.getUrlHandler(protocol);
            if (urlHandler != null) {
                return urlHandler.openStream(path);
            }
        }
        return new URL(url).openStream();
    }

    public URLHandler getUrlHandler(String protocol) {
        return urlStreamHandlerMap.get(protocol);
    }

    public void addUrlHandler(String protocol, URLHandler handler) {
        urlStreamHandlerMap.put(protocol, handler);
    }

    public void removeUrlHandler(String protocol) {
        urlStreamHandlerMap.remove(protocol);
    }

    static {
        urlStreamHandlerMap = new ConcurrentHashMap<String, URLHandler>();
    }
}

