/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.git;

import io.hawt.git.GitFacadeSupport;
import io.hawt.util.Files;
import java.io.File;
import java.io.IOException;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.PersonIdent;

public class WriteContext {
    private final Git git;
    private final File rootDir;
    private final File file;
    private boolean requiresCommit;
    private PersonIdent author;
    private String message;

    public WriteContext(Git git, File rootDir, File file) {
        this.git = git;
        this.rootDir = rootDir;
        this.file = file;
    }

    public void addFile(File file) throws IOException, GitAPIException {
        String path = Files.getRelativePath(this.rootDir, file);
        String filePattern = GitFacadeSupport.getFilePattern(path);
        AddCommand add = this.git.add().addFilepattern(filePattern).addFilepattern(".");
        add.call();
        this.requiresCommit = true;
    }

    public Git getGit() {
        return this.git;
    }

    public File getRootDir() {
        return this.rootDir;
    }

    public File getFile() {
        return this.file;
    }

    public boolean isRequiresCommit() {
        return this.requiresCommit;
    }

    public void setRequiresCommit(boolean requiresCommit) {
        this.requiresCommit = requiresCommit;
    }

    public PersonIdent getAuthor() {
        return this.author;
    }

    public void setAuthor(PersonIdent author) {
        this.author = author;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}

