/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.url.mvn.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentMap;
import org.ops4j.pax.url.mvn.MavenResolver;
import org.ops4j.pax.url.mvn.internal.ConfigurableSettingsDecrypter;
import org.ops4j.pax.url.mvn.internal.HttpClients;
import org.ops4j.pax.url.mvn.internal.ManualWagonProvider;
import org.ops4j.pax.url.mvn.internal.Parser;
import org.ops4j.pax.url.mvn.internal.PaxUrlSecDispatcher;
import org.ops4j.pax.url.mvn.internal.config.MavenConfiguration;
import org.ops4j.pax.url.mvn.internal.config.MavenRepositoryURL;
import org.slf4j.Logger;
import shaded.org.apache.http.impl.client.CloseableHttpClient;
import shaded.org.apache.maven.artifact.repository.metadata.Metadata;
import shaded.org.apache.maven.artifact.repository.metadata.SnapshotVersion;
import shaded.org.apache.maven.artifact.repository.metadata.Versioning;
import shaded.org.apache.maven.artifact.repository.metadata.io.xpp3.MetadataXpp3Reader;
import shaded.org.apache.maven.artifact.repository.metadata.io.xpp3.MetadataXpp3Writer;
import shaded.org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import shaded.org.apache.maven.settings.Mirror;
import shaded.org.apache.maven.settings.Server;
import shaded.org.apache.maven.settings.Settings;
import shaded.org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import shaded.org.apache.maven.settings.crypto.SettingsDecrypter;
import shaded.org.apache.maven.settings.crypto.SettingsDecryptionResult;
import shaded.org.codehaus.plexus.util.xml.Xpp3Dom;
import shaded.org.eclipse.aether.DefaultRepositorySystemSession;
import shaded.org.eclipse.aether.RepositoryException;
import shaded.org.eclipse.aether.RepositorySystem;
import shaded.org.eclipse.aether.RepositorySystemSession;
import shaded.org.eclipse.aether.artifact.Artifact;
import shaded.org.eclipse.aether.artifact.DefaultArtifact;
import shaded.org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import shaded.org.eclipse.aether.impl.DefaultServiceLocator;
import shaded.org.eclipse.aether.installation.InstallRequest;
import shaded.org.eclipse.aether.internal.impl.SimpleLocalRepositoryManagerFactory;
import shaded.org.eclipse.aether.internal.impl.slf4j.Slf4jLoggerFactory;
import shaded.org.eclipse.aether.metadata.DefaultMetadata;
import shaded.org.eclipse.aether.metadata.Metadata;
import shaded.org.eclipse.aether.repository.Authentication;
import shaded.org.eclipse.aether.repository.LocalRepository;
import shaded.org.eclipse.aether.repository.MirrorSelector;
import shaded.org.eclipse.aether.repository.Proxy;
import shaded.org.eclipse.aether.repository.ProxySelector;
import shaded.org.eclipse.aether.repository.RemoteRepository;
import shaded.org.eclipse.aether.repository.RepositoryPolicy;
import shaded.org.eclipse.aether.resolution.ArtifactRequest;
import shaded.org.eclipse.aether.resolution.ArtifactResolutionException;
import shaded.org.eclipse.aether.resolution.MetadataRequest;
import shaded.org.eclipse.aether.resolution.MetadataResult;
import shaded.org.eclipse.aether.resolution.VersionRangeRequest;
import shaded.org.eclipse.aether.resolution.VersionRangeResolutionException;
import shaded.org.eclipse.aether.resolution.VersionRangeResult;
import shaded.org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import shaded.org.eclipse.aether.spi.connector.transport.TransporterFactory;
import shaded.org.eclipse.aether.spi.localrepo.LocalRepositoryManagerFactory;
import shaded.org.eclipse.aether.spi.log.LoggerFactory;
import shaded.org.eclipse.aether.transport.wagon.WagonProvider;
import shaded.org.eclipse.aether.transport.wagon.WagonTransporterFactory;
import shaded.org.eclipse.aether.util.repository.AuthenticationBuilder;
import shaded.org.eclipse.aether.util.repository.DefaultMirrorSelector;
import shaded.org.eclipse.aether.util.repository.DefaultProxySelector;
import shaded.org.eclipse.aether.util.version.GenericVersionScheme;
import shaded.org.eclipse.aether.version.InvalidVersionSpecificationException;
import shaded.org.eclipse.aether.version.Version;
import shaded.org.eclipse.aether.version.VersionConstraint;
import shaded.org.ops4j.lang.NullArgumentException;
import shaded.org.sonatype.plexus.components.cipher.DefaultPlexusCipher;
import shaded.org.sonatype.plexus.components.cipher.PlexusCipherException;

public class AetherBasedResolver
implements MavenResolver {
    private static final Logger LOG = org.slf4j.LoggerFactory.getLogger(AetherBasedResolver.class);
    private static final String LATEST_VERSION_RANGE = "(0.0,]";
    private static final String REPO_TYPE = "default";
    private static final String SCHEMA_HTTP = "http";
    private static final String SCHEMA_HTTPS = "https";
    private static final String PROXY_HOST = "proxyHost";
    private static final String PROXY_PORT = "proxyPort";
    private static final String PROXY_USER = "proxyUser";
    private static final String PROXY_PASSWORD = "proxyPassword";
    private static final String NON_PROXY_HOSTS = "nonProxyHosts";
    private final RepositorySystem m_repoSystem;
    private final MavenConfiguration m_config;
    private final MirrorSelector m_mirrorSelector;
    private final ProxySelector m_proxySelector;
    private final CloseableHttpClient m_client;
    private Settings m_settings;
    private ConfigurableSettingsDecrypter decrypter;
    private LocalRepository localRepository;
    private final ConcurrentMap<LocalRepository, Deque<RepositorySystemSession>> sessions = new ConcurrentHashMap<LocalRepository, Deque<RepositorySystemSession>>();
    private Comparator<String> VERSION_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String v1, String v2) {
            try {
                Version vv1 = new GenericVersionScheme().parseVersion(v1);
                Version vv2 = new GenericVersionScheme().parseVersion(v2);
                return vv1.compareTo(vv2);
            }
            catch (Exception e) {
                return v1.compareTo(v2);
            }
        }
    };
    private Comparator<SnapshotVersion> SNAPSHOT_VERSION_COMPARATOR = new Comparator<SnapshotVersion>(){

        @Override
        public int compare(SnapshotVersion o1, SnapshotVersion o2) {
            int c = AetherBasedResolver.this.VERSION_COMPARATOR.compare(o1.getVersion(), o2.getVersion());
            if (c == 0) {
                c = o1.getExtension().compareTo(o2.getExtension());
            }
            if (c == 0) {
                c = o1.getClassifier().compareTo(o2.getClassifier());
            }
            return c;
        }
    };

    public AetherBasedResolver(MavenConfiguration configuration) {
        this(configuration, null);
    }

    public AetherBasedResolver(MavenConfiguration configuration, Mirror mirror) {
        NullArgumentException.validateNotNull(configuration, "Maven configuration");
        this.m_client = HttpClients.createClient(configuration.getPropertyResolver());
        this.m_config = configuration;
        this.m_settings = configuration.getSettings();
        this.m_repoSystem = this.newRepositorySystem();
        this.decryptSettings();
        this.m_proxySelector = this.selectProxies();
        this.m_mirrorSelector = this.selectMirrors(mirror);
    }

    @Override
    public void close() throws IOException {
        this.m_client.close();
    }

    private void decryptSettings() {
        DefaultSettingsDecryptionRequest request = new DefaultSettingsDecryptionRequest(this.m_settings);
        SettingsDecryptionResult result = this.decrypter.decrypt(request);
        this.m_settings.setProxies(result.getProxies());
        this.m_settings.setServers(result.getServers());
    }

    private void assignProxyAndMirrors(List<RemoteRepository> remoteRepos) {
        HashMap map = new HashMap();
        HashMap<Object, RemoteRepository> naming = new HashMap<Object, RemoteRepository>();
        boolean aggregateReleaseEnabled = false;
        boolean aggregateSnapshotEnabled = false;
        String aggregateReleaseUpdateInterval = null;
        String aggregateSnapshotUpdateInterval = null;
        String aggregateReleaseChecksumPolicy = null;
        String aggregateSnapshotChecksumPolicy = null;
        ArrayList<RemoteRepository> resultingRepos = new ArrayList<RemoteRepository>();
        for (RemoteRepository r : remoteRepos) {
            naming.put(r.getId(), r);
            RemoteRepository rProxy = new RemoteRepository.Builder(r).setProxy(this.m_proxySelector.getProxy(r)).build();
            resultingRepos.add(rProxy);
            RemoteRepository mirror = this.m_mirrorSelector.getMirror(r);
            if (mirror == null) continue;
            String key = mirror.getId();
            naming.put(key, mirror);
            if (!map.containsKey(key)) {
                map.put(key, new ArrayList());
            }
            List mirrored = (List)map.get(key);
            mirrored.add(r.getId());
            aggregateReleaseEnabled |= r.getPolicy(false).isEnabled();
            aggregateSnapshotEnabled |= r.getPolicy(true).isEnabled();
            aggregateReleaseUpdateInterval = this.minUpdateInterval(aggregateReleaseUpdateInterval, r.getPolicy(false).getUpdatePolicy());
            aggregateSnapshotUpdateInterval = this.minUpdateInterval(aggregateSnapshotUpdateInterval, r.getPolicy(true).getUpdatePolicy());
            aggregateReleaseChecksumPolicy = this.aggregateChecksumPolicy(aggregateReleaseChecksumPolicy, r.getPolicy(false).getChecksumPolicy());
            aggregateSnapshotChecksumPolicy = this.aggregateChecksumPolicy(aggregateSnapshotChecksumPolicy, r.getPolicy(true).getChecksumPolicy());
        }
        for (String mirrorId : map.keySet()) {
            RemoteRepository mirror = (RemoteRepository)naming.get(mirrorId);
            ArrayList<RemoteRepository> mirroredRepos = new ArrayList<RemoteRepository>();
            for (String rep : (List)map.get(mirrorId)) {
                mirroredRepos.add((RemoteRepository)naming.get(rep));
            }
            RepositoryPolicy releasePolicy = new RepositoryPolicy(aggregateReleaseEnabled, aggregateReleaseUpdateInterval, aggregateReleaseChecksumPolicy);
            RepositoryPolicy snapshotPolicy = new RepositoryPolicy(aggregateSnapshotEnabled, aggregateSnapshotUpdateInterval, aggregateSnapshotChecksumPolicy);
            mirror = new RemoteRepository.Builder(mirror).setMirroredRepositories(mirroredRepos).setProxy(this.m_proxySelector.getProxy(mirror)).setReleasePolicy(releasePolicy).setSnapshotPolicy(snapshotPolicy).build();
            resultingRepos.removeAll(mirroredRepos);
            resultingRepos.add(0, mirror);
        }
        remoteRepos.clear();
        remoteRepos.addAll(resultingRepos);
    }

    private String minUpdateInterval(String interval1, String interval2) {
        int interval2InMin;
        LOG.debug("interval1: {}, interval2: {}", (Object)interval1, (Object)interval2);
        if (interval1 == null) {
            return interval2;
        }
        if (interval2 == null) {
            return interval1;
        }
        int interval1InMin = this.getIntervalInMinutes(interval1);
        if (interval1InMin <= (interval2InMin = this.getIntervalInMinutes(interval2))) {
            return this.getUpdatePolicyInterval(interval1InMin);
        }
        return this.getUpdatePolicyInterval(interval2InMin);
    }

    private int getIntervalInMinutes(String interval) {
        int intervalInMin;
        if (interval.equals("never")) {
            intervalInMin = Integer.MAX_VALUE;
        } else if (interval.equals("daily")) {
            intervalInMin = 1440;
        } else if (interval.equals("always")) {
            intervalInMin = Integer.MIN_VALUE;
        } else if (interval.startsWith("interval:")) {
            try {
                intervalInMin = Integer.parseInt(interval.substring("interval".length() + 1));
            }
            catch (NumberFormatException e) {
                LOG.warn("unable to parse update policy interval: \"{}\"", (Object)interval);
                intervalInMin = 1440;
            }
        } else {
            throw new IllegalArgumentException(String.format("Invalid update policy \"%s\"", interval));
        }
        return intervalInMin;
    }

    private String getUpdatePolicyInterval(int intervalInMin) {
        switch (intervalInMin) {
            case 0x7FFFFFFF: {
                return "never";
            }
            case -2147483648: {
                return "always";
            }
            case 1440: {
                return "daily";
            }
        }
        return String.format("%s:%d", "interval", intervalInMin);
    }

    private String aggregateChecksumPolicy(String policy1, String policy2) {
        if (policy1 == null) {
            return policy2;
        }
        if (policy2 == null) {
            return policy1;
        }
        if (policy1.equals("fail") || policy2.equals("fail")) {
            return "fail";
        }
        if (policy1.equals("warn") || policy2.equals("warn")) {
            return "warn";
        }
        return "ignore";
    }

    private ProxySelector selectProxies() {
        DefaultProxySelector proxySelector = new DefaultProxySelector();
        for (shaded.org.apache.maven.settings.Proxy proxy : this.m_settings.getProxies()) {
            String nonProxyHosts = proxy.getNonProxyHosts();
            Proxy proxyObj = new Proxy(proxy.getProtocol(), proxy.getHost(), proxy.getPort(), this.getAuthentication(proxy));
            proxySelector.add(proxyObj, nonProxyHosts);
        }
        if (this.m_settings.getProxies().size() == 0) {
            this.javaDefaultProxy(proxySelector);
        }
        return proxySelector;
    }

    private void javaDefaultProxy(DefaultProxySelector proxySelector) {
        String schema;
        String proxyHost = System.getProperty("https.proxyHost");
        String string = schema = proxyHost != null ? SCHEMA_HTTPS : SCHEMA_HTTP;
        if (proxyHost == null) {
            proxyHost = System.getProperty(schema + "." + PROXY_HOST);
        }
        if (proxyHost == null) {
            return;
        }
        String proxyUser = System.getProperty(schema + "." + PROXY_USER);
        String proxyPassword = System.getProperty(schema + "." + PROXY_PASSWORD);
        int proxyPort = Integer.parseInt(System.getProperty(schema + "." + PROXY_PORT, "8080"));
        String nonProxyHosts = System.getProperty(schema + "." + NON_PROXY_HOSTS);
        Authentication authentication = this.createAuthentication(proxyUser, proxyPassword);
        Proxy proxyObj = new Proxy(schema, proxyHost, proxyPort, authentication);
        proxySelector.add(proxyObj, nonProxyHosts);
    }

    private Authentication createAuthentication(String proxyUser, String proxyPassword) {
        Authentication authentication = null;
        if (proxyUser != null) {
            authentication = new AuthenticationBuilder().addUsername(proxyUser).addPassword(proxyPassword).build();
        }
        return authentication;
    }

    private MirrorSelector selectMirrors(Mirror mirror) {
        class DefaultMirrorSelectorWrapper
        implements MirrorSelector {
            final DefaultMirrorSelector delegate = new DefaultMirrorSelector();
            final Map<String, Authentication> authMap = new HashMap<String, Authentication>();

            DefaultMirrorSelectorWrapper() {
            }

            @Override
            public RemoteRepository getMirror(RemoteRepository repository) {
                Authentication mirrorAuth;
                RemoteRepository repo = this.delegate.getMirror(repository);
                if (repo != null && (mirrorAuth = this.authMap.get(repo.getId())) != null) {
                    RemoteRepository.Builder builder = new RemoteRepository.Builder(repo);
                    repo = builder.setAuthentication(mirrorAuth).build();
                }
                return repo;
            }

            public DefaultMirrorSelector add(String id, String url, String type, boolean repositoryManager, String mirrorOfIds, String mirrorOfTypes, Authentication authentication) {
                LOG.trace("adding mirror {} auth = {}", (Object)id, (Object)(authentication != null ? 1 : 0));
                if (authentication != null) {
                    this.authMap.put(id, authentication);
                }
                return this.delegate.add(id, url, type, repositoryManager, mirrorOfIds, mirrorOfTypes);
            }
        }
        DefaultMirrorSelectorWrapper selector = new DefaultMirrorSelectorWrapper();
        for (Mirror m : this.m_settings.getMirrors()) {
            selector.add(m.getId(), m.getUrl(), null, false, m.getMirrorOf(), "*", this.getAuthentication(m.getId()));
        }
        if (mirror != null) {
            selector.add(mirror.getId(), mirror.getUrl(), null, false, mirror.getMirrorOf(), "*", this.getAuthentication(mirror.getId()));
        }
        return selector;
    }

    private List<RemoteRepository> selectRepositories() {
        ArrayList<RemoteRepository> list = new ArrayList<RemoteRepository>();
        List<Object> urls = Collections.emptyList();
        try {
            urls = this.m_config.getRepositories();
        }
        catch (MalformedURLException exc) {
            LOG.error("invalid repository URLs", (Throwable)exc);
        }
        for (MavenRepositoryURL mavenRepositoryURL : urls) {
            if (mavenRepositoryURL.isMulti()) {
                this.addSubDirs(list, mavenRepositoryURL.getFile());
                continue;
            }
            this.addRepo(list, mavenRepositoryURL);
        }
        return list;
    }

    List<LocalRepository> selectDefaultRepositories() {
        ArrayList<LocalRepository> list = new ArrayList<LocalRepository>();
        List<Object> urls = Collections.emptyList();
        try {
            urls = this.m_config.getDefaultRepositories();
        }
        catch (MalformedURLException exc) {
            LOG.error("invalid repository URLs", (Throwable)exc);
        }
        for (MavenRepositoryURL mavenRepositoryURL : urls) {
            if (mavenRepositoryURL.isMulti()) {
                this.addLocalSubDirs(list, mavenRepositoryURL.getFile());
                continue;
            }
            this.addLocalRepo(list, mavenRepositoryURL);
        }
        return list;
    }

    private void addSubDirs(List<RemoteRepository> list, File parentDir) {
        if (!parentDir.isDirectory()) {
            LOG.debug("Repository marked with @multi does not resolve to a directory: " + parentDir);
            return;
        }
        for (File repo : parentDir.listFiles()) {
            if (!repo.isDirectory()) continue;
            try {
                String repoURI = repo.toURI().toString() + "@id=" + repo.getName();
                LOG.debug("Adding repo from inside multi dir: " + repoURI);
                this.addRepo(list, new MavenRepositoryURL(repoURI));
            }
            catch (MalformedURLException e) {
                LOG.error("Error resolving repo url of a multi repo " + repo.toURI());
            }
        }
    }

    private void addRepo(List<RemoteRepository> list, MavenRepositoryURL repo) {
        String snapshotsChecksumPolicy;
        String snapshotsUpdatePolicy;
        String releasesChecksumPolicy;
        String releasesUpdatePolicy = repo.getReleasesUpdatePolicy();
        if (releasesUpdatePolicy == null || releasesUpdatePolicy.isEmpty()) {
            releasesUpdatePolicy = "daily";
        }
        if ((releasesChecksumPolicy = repo.getReleasesChecksumPolicy()) == null || releasesChecksumPolicy.isEmpty()) {
            releasesChecksumPolicy = "warn";
        }
        if ((snapshotsUpdatePolicy = repo.getSnapshotsUpdatePolicy()) == null || snapshotsUpdatePolicy.isEmpty()) {
            snapshotsUpdatePolicy = "daily";
        }
        if ((snapshotsChecksumPolicy = repo.getSnapshotsChecksumPolicy()) == null || snapshotsChecksumPolicy.isEmpty()) {
            snapshotsChecksumPolicy = "warn";
        }
        RemoteRepository.Builder builder = new RemoteRepository.Builder(repo.getId(), REPO_TYPE, repo.getURL().toExternalForm());
        RepositoryPolicy releasePolicy = new RepositoryPolicy(repo.isReleasesEnabled(), releasesUpdatePolicy, releasesChecksumPolicy);
        builder.setReleasePolicy(releasePolicy);
        RepositoryPolicy snapshotPolicy = new RepositoryPolicy(repo.isSnapshotsEnabled(), snapshotsUpdatePolicy, snapshotsChecksumPolicy);
        builder.setSnapshotPolicy(snapshotPolicy);
        Authentication authentication = this.getAuthentication(repo.getId());
        if (authentication != null) {
            builder.setAuthentication(authentication);
        }
        list.add(builder.build());
    }

    private void addLocalSubDirs(List<LocalRepository> list, File parentDir) {
        if (!parentDir.isDirectory()) {
            LOG.debug("Repository marked with @multi does not resolve to a directory: " + parentDir);
            return;
        }
        for (File repo : parentDir.listFiles()) {
            if (!repo.isDirectory()) continue;
            try {
                String repoURI = repo.toURI().toString() + "@id=" + repo.getName();
                LOG.debug("Adding repo from inside multi dir: " + repoURI);
                this.addLocalRepo(list, new MavenRepositoryURL(repoURI));
            }
            catch (MalformedURLException e) {
                LOG.error("Error resolving repo url of a multi repo " + repo.toURI());
            }
        }
    }

    private void addLocalRepo(List<LocalRepository> list, MavenRepositoryURL repo) {
        if (repo.getFile() != null) {
            LocalRepository local = new LocalRepository(repo.getFile(), "simple");
            list.add(local);
        }
    }

    public RepositorySystem getRepositorySystem() {
        return this.m_repoSystem;
    }

    public List<RemoteRepository> getRepositories() {
        List<RemoteRepository> repos = this.selectRepositories();
        this.assignProxyAndMirrors(repos);
        return repos;
    }

    @Override
    public File resolve(String url) throws IOException {
        if (!url.startsWith("mvn:")) {
            throw new IllegalArgumentException("url should be a mvn based url");
        }
        url = url.substring("mvn:".length());
        Parser parser = new Parser(url);
        return this.resolve(parser.getGroup(), parser.getArtifact(), parser.getClassifier(), parser.getType(), parser.getVersion(), parser.getRepositoryURL());
    }

    @Override
    public File resolve(String groupId, String artifactId, String classifier, String extension, String version) throws IOException {
        return this.resolve(groupId, artifactId, classifier, extension, version, null);
    }

    public File resolve(String groupId, String artifactId, String classifier, String extension, String version, MavenRepositoryURL repositoryURL) throws IOException {
        DefaultArtifact artifact = new DefaultArtifact(groupId, artifactId, classifier, extension, version);
        return this.resolve(artifact, repositoryURL);
    }

    public File resolve(Artifact artifact) throws IOException {
        return this.resolve(artifact, null);
    }

    public File resolve(Artifact artifact, MavenRepositoryURL repositoryURL) throws IOException {
        List<LocalRepository> defaultRepos = this.selectDefaultRepositories();
        List<RemoteRepository> remoteRepos = this.selectRepositories();
        if (repositoryURL != null) {
            this.addRepo(remoteRepos, repositoryURL);
        }
        this.assignProxyAndMirrors(remoteRepos);
        File resolved = this.resolve(defaultRepos, remoteRepos, artifact);
        LOG.debug("Resolved ({}) as {}", (Object)artifact.toString(), (Object)resolved.getAbsolutePath());
        return resolved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File resolve(List<LocalRepository> defaultRepos, List<RemoteRepository> remoteRepos, Artifact artifact) throws IOException {
        if (artifact.getExtension().isEmpty()) {
            artifact = new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), "jar", artifact.getVersion());
        }
        try {
            VersionConstraint vc222 = new GenericVersionScheme().parseVersionConstraint(artifact.getVersion());
            if (vc222.getVersion() != null) {
                for (LocalRepository repo : defaultRepos) {
                    RepositorySystemSession session = this.newSession(repo);
                    try {
                        File file = this.m_repoSystem.resolveArtifact(session, new ArtifactRequest(artifact, null, null)).getArtifact().getFile();
                        return file;
                    }
                    catch (ArtifactResolutionException artifactResolutionException) {}
                    continue;
                    finally {
                        this.releaseSession(session);
                    }
                }
            }
        }
        catch (InvalidVersionSpecificationException vc222) {
            // empty catch block
        }
        RepositorySystemSession session = this.newSession(null);
        try {
            artifact = this.resolveLatestVersionRange(session, remoteRepos, artifact);
            File object = this.m_repoSystem.resolveArtifact(session, new ArtifactRequest(artifact, remoteRepos, null)).getArtifact().getFile();
            return object;
        }
        catch (ArtifactResolutionException e) {
            LOG.warn("Error resolving artifact" + artifact.toString() + ":" + e.getMessage(), (Throwable)e);
            throw new IOException("Error resolving artifact " + artifact.toString() + ": " + e.getMessage());
        }
        catch (RepositoryException e) {
            throw new IOException("Error resolving artifact " + artifact.toString(), e);
        }
        finally {
            this.releaseSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File resolveMetadata(String groupId, String artifactId, String type, String version) throws IOException {
        RepositorySystem system = this.getRepositorySystem();
        RepositorySystemSession session = this.newSession();
        try {
            DefaultMetadata metadata = new DefaultMetadata(groupId, artifactId, version, type, Metadata.Nature.RELEASE_OR_SNAPSHOT);
            ArrayList<MetadataRequest> requests = new ArrayList<MetadataRequest>();
            for (RemoteRepository repository : this.getRepositories()) {
                MetadataRequest request = new MetadataRequest(metadata, repository, null);
                request.setFavorLocalRepository(false);
                requests.add(request);
            }
            MetadataRequest request = new MetadataRequest(metadata, null, null);
            request.setFavorLocalRepository(true);
            requests.add(request);
            Metadata mr = new Metadata();
            mr.setModelVersion("1.1.0");
            mr.setGroupId(metadata.getGroupId());
            mr.setArtifactId(metadata.getArtifactId());
            mr.setVersioning(new Versioning());
            boolean merged = false;
            List<MetadataResult> results = system.resolveMetadata(session, requests);
            for (MetadataResult result : results) {
                if (result.getMetadata() == null || result.getMetadata().getFile() == null) continue;
                FileInputStream fis = new FileInputStream(result.getMetadata().getFile());
                Metadata m = new MetadataXpp3Reader().read(fis, false);
                fis.close();
                if (m.getVersioning() != null) {
                    mr.getVersioning().setLastUpdated(this.latestTimestamp(mr.getVersioning().getLastUpdated(), m.getVersioning().getLastUpdated()));
                    mr.getVersioning().setLatest(this.latestVersion(mr.getVersioning().getLatest(), m.getVersioning().getLatest()));
                    mr.getVersioning().setRelease(this.latestVersion(mr.getVersioning().getRelease(), m.getVersioning().getRelease()));
                    for (String v : m.getVersioning().getVersions()) {
                        if (mr.getVersioning().getVersions().contains(v)) continue;
                        mr.getVersioning().getVersions().add(v);
                    }
                    mr.getVersioning().getSnapshotVersions().addAll(m.getVersioning().getSnapshotVersions());
                }
                merged = true;
            }
            if (merged) {
                Collections.sort(mr.getVersioning().getVersions(), this.VERSION_COMPARATOR);
                Collections.sort(mr.getVersioning().getSnapshotVersions(), this.SNAPSHOT_VERSION_COMPARATOR);
                File tmpFile = Files.createTempFile("mvn-", ".tmp", new FileAttribute[0]).toFile();
                FileOutputStream fos = new FileOutputStream(tmpFile);
                try {
                    new MetadataXpp3Writer().write(fos, mr);
                }
                finally {
                    fos.close();
                }
                File file = tmpFile;
                return file;
            }
            Iterator<MetadataResult> iterator = null;
            return iterator;
        }
        catch (Exception e) {
            throw new IOException("Unable to resolve metadata", e);
        }
        finally {
            this.releaseSession(session);
        }
    }

    @Override
    public void upload(String groupId, String artifactId, String classifier, String extension, String version, File file) throws IOException {
        RepositorySystem system = this.getRepositorySystem();
        RepositorySystemSession session = this.newSession();
        try {
            DefaultArtifact artifact = new DefaultArtifact(groupId, artifactId, classifier, extension, version, null, file);
            InstallRequest request = new InstallRequest();
            request.addArtifact(artifact);
            system.install(session, request);
        }
        catch (Exception e) {
            throw new IOException("Unable to install artifact", e);
        }
        finally {
            this.releaseSession(session);
        }
    }

    @Override
    public void uploadMetadata(String groupId, String artifactId, String type, String version, File file) throws IOException {
        RepositorySystem system = this.getRepositorySystem();
        RepositorySystemSession session = this.newSession();
        try {
            DefaultMetadata metadata = new DefaultMetadata(groupId, artifactId, version, type, Metadata.Nature.RELEASE_OR_SNAPSHOT, file);
            InstallRequest request = new InstallRequest();
            request.addMetadata(metadata);
            system.install(session, request);
        }
        catch (Exception e) {
            throw new IOException("Unable to install metadata", e);
        }
        finally {
            this.releaseSession(session);
        }
    }

    private String latestTimestamp(String t1, String t2) {
        if (t1 == null) {
            return t2;
        }
        if (t2 == null) {
            return t1;
        }
        return t1.compareTo(t2) < 0 ? t2 : t1;
    }

    private String latestVersion(String v1, String v2) {
        if (v1 == null) {
            return v2;
        }
        if (v2 == null) {
            return v1;
        }
        return this.VERSION_COMPARATOR.compare(v1, v2) < 0 ? v2 : v1;
    }

    private Artifact resolveLatestVersionRange(RepositorySystemSession session, List<RemoteRepository> remoteRepos, Artifact artifact) throws VersionRangeResolutionException {
        VersionRangeResult versionResult;
        if (artifact.getVersion().equals("LATEST")) {
            artifact = artifact.setVersion(LATEST_VERSION_RANGE);
        }
        if ((versionResult = this.m_repoSystem.resolveVersionRange(session, new VersionRangeRequest(artifact, remoteRepos, null))) != null) {
            Version v = versionResult.getHighestVersion();
            if (v != null) {
                artifact = artifact.setVersion(v.toString());
            } else {
                throw new VersionRangeResolutionException(versionResult, "No highest version found for " + artifact);
            }
        }
        return artifact;
    }

    public RepositorySystemSession newSession() {
        return this.newSession(null);
    }

    private RepositorySystemSession newSession(LocalRepository repo) {
        if (repo == null) {
            repo = this.getLocalRepository();
        }
        Deque deque = (Deque)this.sessions.get(repo);
        RepositorySystemSession session = null;
        if (deque != null) {
            session = (RepositorySystemSession)deque.pollFirst();
        }
        if (session == null) {
            session = this.createSession(repo);
        }
        return session;
    }

    private void releaseSession(RepositorySystemSession session) {
        LocalRepository repo = session.getLocalRepository();
        Deque deque = (Deque)this.sessions.get(repo);
        if (deque == null) {
            this.sessions.putIfAbsent(repo, new ConcurrentLinkedDeque());
            deque = (Deque)this.sessions.get(repo);
        }
        deque.add(session);
    }

    private RepositorySystemSession createSession(LocalRepository repo) {
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        if (repo != null) {
            session.setLocalRepositoryManager(this.m_repoSystem.newLocalRepositoryManager(session, repo));
        } else {
            session.setLocalRepositoryManager(this.m_repoSystem.newLocalRepositoryManager(session, this.getLocalRepository()));
        }
        session.setMirrorSelector(this.m_mirrorSelector);
        session.setProxySelector(this.m_proxySelector);
        String updatePolicy = this.m_config.getGlobalUpdatePolicy();
        if (null != updatePolicy) {
            session.setUpdatePolicy(updatePolicy);
        }
        for (Server server : this.m_settings.getServers()) {
            if (server.getConfiguration() == null || ((Xpp3Dom)server.getConfiguration()).getChild("httpHeaders") == null) continue;
            this.addServerConfig(session, server);
        }
        session.setOffline(this.m_config.isOffline());
        return session;
    }

    private LocalRepository getLocalRepository() {
        if (this.localRepository == null) {
            File local = this.m_config.getLocalRepository() != null ? this.m_config.getLocalRepository().getFile() : new File(System.getProperty("user.home"), ".m2/repository");
            this.localRepository = new LocalRepository(local, "simple");
        }
        return this.localRepository;
    }

    private void addServerConfig(DefaultRepositorySystemSession session, Server server) {
        HashMap<String, String> headers = new HashMap<String, String>();
        Xpp3Dom configuration = (Xpp3Dom)server.getConfiguration();
        Xpp3Dom httpHeaders = configuration.getChild("httpHeaders");
        for (Xpp3Dom httpHeader : httpHeaders.getChildren("httpHeader")) {
            Xpp3Dom name = httpHeader.getChild("name");
            String headerName = name.getValue();
            Xpp3Dom value = httpHeader.getChild("value");
            String headerValue = value.getValue();
            headers.put(headerName, headerValue);
        }
        session.setConfigProperty(String.format("%s.%s", "aether.connector.http.headers", server.getId()), headers);
    }

    private Authentication getAuthentication(shaded.org.apache.maven.settings.Proxy proxy) {
        if (proxy.getUsername() != null) {
            return new AuthenticationBuilder().addUsername(proxy.getUsername()).addPassword(proxy.getPassword()).build();
        }
        return null;
    }

    private Authentication getAuthentication(String repoId) {
        Server server = this.m_settings.getServer(repoId);
        if (server != null && server.getUsername() != null) {
            AuthenticationBuilder authBuilder = new AuthenticationBuilder();
            authBuilder.addUsername(server.getUsername()).addPassword(server.getPassword());
            return authBuilder.build();
        }
        return null;
    }

    private RepositorySystem newRepositorySystem() {
        DefaultServiceLocator locator = MavenRepositorySystemUtils.newServiceLocator();
        locator.setServices(WagonProvider.class, new ManualWagonProvider(this.m_client, this.m_config.getTimeout()));
        locator.addService(TransporterFactory.class, WagonTransporterFactory.class);
        locator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        this.decrypter = new ConfigurableSettingsDecrypter();
        PaxUrlSecDispatcher secDispatcher = new PaxUrlSecDispatcher();
        try {
            secDispatcher.setCipher(new DefaultPlexusCipher());
        }
        catch (PlexusCipherException exc) {
            throw new IllegalStateException(exc);
        }
        secDispatcher.setConfigurationFile(this.m_config.getSecuritySettings());
        this.decrypter.setSecurityDispatcher(secDispatcher);
        locator.setServices(SettingsDecrypter.class, this.decrypter);
        locator.setService(LocalRepositoryManagerFactory.class, SimpleLocalRepositoryManagerFactory.class);
        locator.setService(LoggerFactory.class, Slf4jLoggerFactory.class);
        return locator.getService(RepositorySystem.class);
    }
}

