/*
 * Decompiled with CFR 0.152.
 */
package org.h2;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import org.h2.jdbc.JdbcConnection;
import org.h2.message.DbException;
import org.h2.message.TraceSystem;
import org.h2.upgrade.DbUpgrade;

public class Driver
implements java.sql.Driver {
    private static final Driver INSTANCE = new Driver();
    private static final String DEFAULT_URL = "jdbc:default:connection";
    private static final ThreadLocal<Connection> DEFAULT_CONNECTION = new ThreadLocal();
    private static volatile boolean registered;

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        try {
            if (info == null) {
                info = new Properties();
            }
            if (!this.acceptsURL(url)) {
                return null;
            }
            if (url.equals(DEFAULT_URL)) {
                return DEFAULT_CONNECTION.get();
            }
            Connection c = DbUpgrade.connectOrUpgrade(url, info);
            if (c != null) {
                return c;
            }
            return new JdbcConnection(url, info);
        }
        catch (Exception e) {
            throw DbException.toSQLException(e);
        }
    }

    @Override
    public boolean acceptsURL(String url) {
        if (url != null) {
            if (url.startsWith("jdbc:h2:")) {
                return true;
            }
            if (url.equals(DEFAULT_URL)) {
                return DEFAULT_CONNECTION.get() != null;
            }
        }
        return false;
    }

    @Override
    public int getMajorVersion() {
        return 1;
    }

    @Override
    public int getMinorVersion() {
        return 3;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) {
        return new DriverPropertyInfo[0];
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    public static synchronized Driver load() {
        try {
            if (!registered) {
                registered = true;
                DriverManager.registerDriver(INSTANCE);
            }
        }
        catch (SQLException e) {
            TraceSystem.traceThrowable(e);
        }
        return INSTANCE;
    }

    public static synchronized void unload() {
        try {
            if (registered) {
                registered = false;
                DriverManager.deregisterDriver(INSTANCE);
            }
        }
        catch (SQLException e) {
            TraceSystem.traceThrowable(e);
        }
    }

    public static void setDefaultConnection(Connection c) {
        DEFAULT_CONNECTION.set(c);
    }

    public static void setThreadContextClassLoader(Thread thread) {
        try {
            thread.setContextClassLoader(Driver.class.getClassLoader());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static {
        Driver.load();
    }
}

