/*
 * Decompiled with CFR 0.152.
 */
package org.h2.bnf;

import java.util.HashMap;
import org.h2.bnf.Bnf;
import org.h2.bnf.BnfVisitor;
import org.h2.bnf.Rule;
import org.h2.bnf.RuleHead;
import org.h2.bnf.Sentence;
import org.h2.util.StringUtils;

class RuleElement
implements Rule {
    private boolean keyword;
    private String name;
    private Rule link;
    private int type;

    RuleElement(String name, String topic) {
        this.name = name;
        if (name.length() == 1 || name.equals(StringUtils.toUpperEnglish(name))) {
            this.keyword = true;
        }
        this.type = (topic = StringUtils.toLowerEnglish(topic)).startsWith("function") ? 2 : 1;
    }

    @Override
    public void accept(BnfVisitor visitor) {
        visitor.visitRuleElement(this.keyword, this.name, this.link);
    }

    @Override
    public void setLinks(HashMap<String, RuleHead> ruleMap) {
        if (this.link != null) {
            this.link.setLinks(ruleMap);
        }
        if (this.keyword) {
            return;
        }
        String test = Bnf.getRuleMapKey(this.name);
        for (int i = 0; i < test.length(); ++i) {
            String t = test.substring(i);
            RuleHead r = ruleMap.get(t);
            if (r == null) continue;
            this.link = r.getRule();
            return;
        }
        throw new AssertionError((Object)("Unknown " + this.name + "/" + test));
    }

    @Override
    public boolean autoComplete(Sentence sentence) {
        sentence.stopIfRequired();
        if (this.keyword) {
            String query = sentence.getQuery();
            String q = query.trim();
            String up = sentence.getQueryUpper().trim();
            if (up.startsWith(this.name)) {
                query = query.substring(this.name.length());
                while (!"_".equals(this.name) && query.length() > 0 && Character.isSpaceChar(query.charAt(0))) {
                    query = query.substring(1);
                }
                sentence.setQuery(query);
                return true;
            }
            if ((q.length() == 0 || this.name.startsWith(up)) && q.length() < this.name.length()) {
                sentence.add(this.name, this.name.substring(q.length()), this.type);
            }
            return false;
        }
        return this.link.autoComplete(sentence);
    }
}

