/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.Collator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.h2.command.Command;
import org.h2.command.CommandContainer;
import org.h2.command.CommandList;
import org.h2.command.Prepared;
import org.h2.command.ddl.AlterIndexRename;
import org.h2.command.ddl.AlterSchemaRename;
import org.h2.command.ddl.AlterTableAddConstraint;
import org.h2.command.ddl.AlterTableAlterColumn;
import org.h2.command.ddl.AlterTableDropConstraint;
import org.h2.command.ddl.AlterTableRename;
import org.h2.command.ddl.AlterTableRenameColumn;
import org.h2.command.ddl.AlterUser;
import org.h2.command.ddl.AlterView;
import org.h2.command.ddl.Analyze;
import org.h2.command.ddl.CreateAggregate;
import org.h2.command.ddl.CreateConstant;
import org.h2.command.ddl.CreateFunctionAlias;
import org.h2.command.ddl.CreateIndex;
import org.h2.command.ddl.CreateLinkedTable;
import org.h2.command.ddl.CreateRole;
import org.h2.command.ddl.CreateSchema;
import org.h2.command.ddl.CreateSequence;
import org.h2.command.ddl.CreateTable;
import org.h2.command.ddl.CreateTableData;
import org.h2.command.ddl.CreateTrigger;
import org.h2.command.ddl.CreateUser;
import org.h2.command.ddl.CreateUserDataType;
import org.h2.command.ddl.CreateView;
import org.h2.command.ddl.DeallocateProcedure;
import org.h2.command.ddl.DefineCommand;
import org.h2.command.ddl.DropAggregate;
import org.h2.command.ddl.DropConstant;
import org.h2.command.ddl.DropDatabase;
import org.h2.command.ddl.DropFunctionAlias;
import org.h2.command.ddl.DropIndex;
import org.h2.command.ddl.DropRole;
import org.h2.command.ddl.DropSchema;
import org.h2.command.ddl.DropSequence;
import org.h2.command.ddl.DropTable;
import org.h2.command.ddl.DropTrigger;
import org.h2.command.ddl.DropUser;
import org.h2.command.ddl.DropUserDataType;
import org.h2.command.ddl.DropView;
import org.h2.command.ddl.GrantRevoke;
import org.h2.command.ddl.PrepareProcedure;
import org.h2.command.ddl.SetComment;
import org.h2.command.ddl.TruncateTable;
import org.h2.command.dml.AlterSequence;
import org.h2.command.dml.AlterTableSet;
import org.h2.command.dml.BackupCommand;
import org.h2.command.dml.Call;
import org.h2.command.dml.Delete;
import org.h2.command.dml.ExecuteProcedure;
import org.h2.command.dml.Explain;
import org.h2.command.dml.Insert;
import org.h2.command.dml.Merge;
import org.h2.command.dml.NoOperation;
import org.h2.command.dml.Query;
import org.h2.command.dml.RunScriptCommand;
import org.h2.command.dml.ScriptCommand;
import org.h2.command.dml.Select;
import org.h2.command.dml.SelectOrderBy;
import org.h2.command.dml.SelectUnion;
import org.h2.command.dml.Set;
import org.h2.command.dml.SetTypes;
import org.h2.command.dml.TransactionCommand;
import org.h2.command.dml.Update;
import org.h2.engine.Database;
import org.h2.engine.FunctionAlias;
import org.h2.engine.Procedure;
import org.h2.engine.Session;
import org.h2.engine.User;
import org.h2.engine.UserAggregate;
import org.h2.engine.UserDataType;
import org.h2.expression.Aggregate;
import org.h2.expression.Alias;
import org.h2.expression.CompareLike;
import org.h2.expression.Comparison;
import org.h2.expression.Condition;
import org.h2.expression.ConditionAndOr;
import org.h2.expression.ConditionExists;
import org.h2.expression.ConditionIn;
import org.h2.expression.ConditionInSelect;
import org.h2.expression.ConditionNot;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionList;
import org.h2.expression.Function;
import org.h2.expression.FunctionCall;
import org.h2.expression.JavaAggregate;
import org.h2.expression.JavaFunction;
import org.h2.expression.Operation;
import org.h2.expression.Parameter;
import org.h2.expression.Rownum;
import org.h2.expression.SequenceValue;
import org.h2.expression.Subquery;
import org.h2.expression.TableFunction;
import org.h2.expression.ValueExpression;
import org.h2.expression.Variable;
import org.h2.expression.Wildcard;
import org.h2.index.Index;
import org.h2.message.DbException;
import org.h2.schema.Schema;
import org.h2.schema.Sequence;
import org.h2.table.Column;
import org.h2.table.FunctionTable;
import org.h2.table.IndexColumn;
import org.h2.table.RangeTable;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.table.TableView;
import org.h2.util.MathUtils;
import org.h2.util.New;
import org.h2.util.StatementBuilder;
import org.h2.util.StringUtils;
import org.h2.value.CompareMode;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueBytes;
import org.h2.value.ValueDate;
import org.h2.value.ValueDecimal;
import org.h2.value.ValueInt;
import org.h2.value.ValueLong;
import org.h2.value.ValueNull;
import org.h2.value.ValueString;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimestamp;

public class Parser {
    private static final int CHAR_END = 1;
    private static final int CHAR_VALUE = 2;
    private static final int CHAR_QUOTED = 3;
    private static final int CHAR_NAME = 4;
    private static final int CHAR_SPECIAL_1 = 5;
    private static final int CHAR_SPECIAL_2 = 6;
    private static final int CHAR_STRING = 7;
    private static final int CHAR_DOT = 8;
    private static final int CHAR_DOLLAR_QUOTED_STRING = 9;
    private static final int KEYWORD = 1;
    private static final int IDENTIFIER = 2;
    private static final int PARAMETER = 3;
    private static final int END = 4;
    private static final int VALUE = 5;
    private static final int EQUAL = 6;
    private static final int BIGGER_EQUAL = 7;
    private static final int BIGGER = 8;
    private static final int SMALLER = 9;
    private static final int SMALLER_EQUAL = 10;
    private static final int NOT_EQUAL = 11;
    private static final int AT = 12;
    private static final int MINUS = 13;
    private static final int PLUS = 14;
    private static final int STRING_CONCAT = 15;
    private static final int OPEN = 16;
    private static final int CLOSE = 17;
    private static final int NULL = 18;
    private static final int TRUE = 19;
    private static final int FALSE = 20;
    private static final int CURRENT_TIMESTAMP = 21;
    private static final int CURRENT_DATE = 22;
    private static final int CURRENT_TIME = 23;
    private static final int ROWNUM = 24;
    private final Database database;
    private final Session session;
    private int[] characterTypes;
    private int currentTokenType;
    private String currentToken;
    private boolean currentTokenQuoted;
    private Value currentValue;
    private String sqlCommand;
    private String originalSQL;
    private char[] sqlCommandChars;
    private int lastParseIndex;
    private int parseIndex;
    private CreateView createView;
    private Prepared currentPrepared;
    private Select currentSelect;
    private ArrayList<Parameter> parameters;
    private String schemaName;
    private ArrayList<String> expectedList;
    private boolean rightsChecked;
    private boolean recompileAlways;
    private ArrayList<Parameter> indexedParameterList;
    private final boolean identifiersToUpper;

    public Parser(Session session) {
        this.database = session.getDatabase();
        this.identifiersToUpper = this.database.getSettings().databaseToUpper;
        this.session = session;
    }

    public Prepared prepare(String sql) {
        Prepared p = this.parse(sql);
        p.prepare();
        if (this.currentTokenType != 4) {
            throw this.getSyntaxError();
        }
        return p;
    }

    public Command prepareCommand(String sql) {
        try {
            Prepared p = this.parse(sql);
            p.prepare();
            Command c = new CommandContainer(this, sql, p);
            p.setCommand(c);
            if (this.isToken(";")) {
                String remaining = this.originalSQL.substring(this.parseIndex);
                if (remaining.trim().length() != 0) {
                    CommandList list = new CommandList(this, sql, c, remaining);
                    c = list;
                }
            } else if (this.currentTokenType != 4) {
                throw this.getSyntaxError();
            }
            return c;
        }
        catch (DbException e) {
            throw e.addSQL(this.originalSQL);
        }
    }

    Prepared parse(String sql) {
        Prepared p;
        try {
            p = this.parse(sql, false);
        }
        catch (DbException e) {
            if (e.getErrorCode() == 42000) {
                p = this.parse(sql, true);
            }
            throw e.addSQL(sql);
        }
        p.setPrepareAlways(this.recompileAlways);
        p.setParameterList(this.parameters);
        return p;
    }

    private Prepared parse(String sql, boolean withExpectedList) {
        this.initialize(sql);
        this.expectedList = withExpectedList ? New.arrayList() : null;
        this.parameters = New.arrayList();
        this.currentSelect = null;
        this.currentPrepared = null;
        this.createView = null;
        this.recompileAlways = false;
        this.indexedParameterList = null;
        this.read();
        return this.parsePrepared();
    }

    private Prepared parsePrepared() {
        int start = this.lastParseIndex;
        Prepared c = null;
        String token = this.currentToken;
        if (token.length() == 0) {
            c = new NoOperation(this.session);
        } else {
            char first = token.charAt(0);
            switch (first) {
                case '?': {
                    this.readTerm();
                    this.parameters.get(0).setValue(ValueNull.INSTANCE);
                    this.read("=");
                    this.read("CALL");
                    c = this.parseCall();
                    break;
                }
                case '(': {
                    c = this.parseSelect();
                    break;
                }
                case 'A': 
                case 'a': {
                    if (this.readIf("ALTER")) {
                        c = this.parseAlter();
                        break;
                    }
                    if (!this.readIf("ANALYZE")) break;
                    c = this.parseAnalyze();
                    break;
                }
                case 'B': 
                case 'b': {
                    if (this.readIf("BACKUP")) {
                        c = this.parseBackup();
                        break;
                    }
                    if (!this.readIf("BEGIN")) break;
                    c = this.parseBegin();
                    break;
                }
                case 'C': 
                case 'c': {
                    if (this.readIf("COMMIT")) {
                        c = this.parseCommit();
                        break;
                    }
                    if (this.readIf("CREATE")) {
                        c = this.parseCreate();
                        break;
                    }
                    if (this.readIf("CALL")) {
                        c = this.parseCall();
                        break;
                    }
                    if (this.readIf("CHECKPOINT")) {
                        c = this.parseCheckpoint();
                        break;
                    }
                    if (!this.readIf("COMMENT")) break;
                    c = this.parseComment();
                    break;
                }
                case 'D': 
                case 'd': {
                    if (this.readIf("DELETE")) {
                        c = this.parseDelete();
                        break;
                    }
                    if (this.readIf("DROP")) {
                        c = this.parseDrop();
                        break;
                    }
                    if (this.readIf("DECLARE")) {
                        c = this.parseCreate();
                        break;
                    }
                    if (!this.readIf("DEALLOCATE")) break;
                    c = this.parseDeallocate();
                    break;
                }
                case 'E': 
                case 'e': {
                    if (this.readIf("EXPLAIN")) {
                        c = this.parseExplain();
                        break;
                    }
                    if (!this.readIf("EXECUTE")) break;
                    c = this.parseExecute();
                    break;
                }
                case 'F': 
                case 'f': {
                    if (!this.isToken("FROM")) break;
                    c = this.parseSelect();
                    break;
                }
                case 'G': 
                case 'g': {
                    if (!this.readIf("GRANT")) break;
                    c = this.parseGrantRevoke(49);
                    break;
                }
                case 'H': 
                case 'h': {
                    if (!this.readIf("HELP")) break;
                    c = this.parseHelp();
                    break;
                }
                case 'I': 
                case 'i': {
                    if (!this.readIf("INSERT")) break;
                    c = this.parseInsert();
                    break;
                }
                case 'M': 
                case 'm': {
                    if (!this.readIf("MERGE")) break;
                    c = this.parseMerge();
                    break;
                }
                case 'P': 
                case 'p': {
                    if (!this.readIf("PREPARE")) break;
                    c = this.parsePrepare();
                    break;
                }
                case 'R': 
                case 'r': {
                    if (this.readIf("ROLLBACK")) {
                        c = this.parseRollback();
                        break;
                    }
                    if (this.readIf("REVOKE")) {
                        c = this.parseGrantRevoke(50);
                        break;
                    }
                    if (this.readIf("RUNSCRIPT")) {
                        c = this.parseRunScript();
                        break;
                    }
                    if (!this.readIf("RELEASE")) break;
                    c = this.parseReleaseSavepoint();
                    break;
                }
                case 'S': 
                case 's': {
                    if (this.isToken("SELECT")) {
                        c = this.parseSelect();
                        break;
                    }
                    if (this.readIf("SET")) {
                        c = this.parseSet();
                        break;
                    }
                    if (this.readIf("SAVEPOINT")) {
                        c = this.parseSavepoint();
                        break;
                    }
                    if (this.readIf("SCRIPT")) {
                        c = this.parseScript();
                        break;
                    }
                    if (this.readIf("SHUTDOWN")) {
                        c = this.parseShutdown();
                        break;
                    }
                    if (!this.readIf("SHOW")) break;
                    c = this.parseShow();
                    break;
                }
                case 'T': 
                case 't': {
                    if (!this.readIf("TRUNCATE")) break;
                    c = this.parseTruncate();
                    break;
                }
                case 'U': 
                case 'u': {
                    if (!this.readIf("UPDATE")) break;
                    c = this.parseUpdate();
                    break;
                }
                case 'V': 
                case 'v': {
                    if (!this.readIf("VALUES")) break;
                    c = this.parseValues();
                    break;
                }
                case 'W': 
                case 'w': {
                    if (!this.readIf("WITH")) break;
                    c = this.parserWith();
                    break;
                }
                default: {
                    throw this.getSyntaxError();
                }
            }
            if (this.indexedParameterList != null) {
                int size = this.indexedParameterList.size();
                for (int i = 0; i < size; ++i) {
                    if (this.indexedParameterList.get(i) != null) continue;
                    this.indexedParameterList.set(i, new Parameter(i));
                }
                this.parameters = this.indexedParameterList;
            }
            if (this.readIf("{")) {
                do {
                    int index;
                    if ((index = (int)this.readLong() - 1) < 0 || index >= this.parameters.size()) {
                        throw this.getSyntaxError();
                    }
                    Parameter p = this.parameters.get(index);
                    if (p == null) {
                        throw this.getSyntaxError();
                    }
                    this.read(":");
                    Expression expr = this.readExpression();
                    expr = expr.optimize(this.session);
                    p.setValue(expr.getValue(this.session));
                } while (this.readIf(","));
                this.read("}");
                for (Parameter p : this.parameters) {
                    p.checkSet();
                }
                this.parameters.clear();
            }
        }
        if (c == null) {
            throw this.getSyntaxError();
        }
        this.setSQL(c, null, start);
        return c;
    }

    private DbException getSyntaxError() {
        if (this.expectedList == null || this.expectedList.size() == 0) {
            return DbException.getSyntaxError(this.sqlCommand, this.parseIndex);
        }
        StatementBuilder buff = new StatementBuilder();
        for (String e : this.expectedList) {
            buff.appendExceptFirst(", ");
            buff.append(e);
        }
        return DbException.getSyntaxError(this.sqlCommand, this.parseIndex, buff.toString());
    }

    private Prepared parseBackup() {
        BackupCommand command = new BackupCommand(this.session);
        this.read("TO");
        command.setFileName(this.readExpression());
        return command;
    }

    private Prepared parseAnalyze() {
        Analyze command = new Analyze(this.session);
        if (this.readIf("SAMPLE_SIZE")) {
            command.setTop(this.getPositiveInt());
        }
        return command;
    }

    private TransactionCommand parseBegin() {
        if (!this.readIf("WORK")) {
            this.readIf("TRANSACTION");
        }
        TransactionCommand command = new TransactionCommand(this.session, 83);
        return command;
    }

    private TransactionCommand parseCommit() {
        if (this.readIf("TRANSACTION")) {
            TransactionCommand command = new TransactionCommand(this.session, 78);
            command.setTransactionName(this.readUniqueIdentifier());
            return command;
        }
        TransactionCommand command = new TransactionCommand(this.session, 71);
        this.readIf("WORK");
        return command;
    }

    private TransactionCommand parseShutdown() {
        int type = 80;
        if (this.readIf("IMMEDIATELY")) {
            type = 81;
        } else if (this.readIf("COMPACT")) {
            type = 82;
        } else if (this.readIf("DEFRAG")) {
            type = 84;
        } else {
            this.readIf("SCRIPT");
        }
        return new TransactionCommand(this.session, type);
    }

    private TransactionCommand parseRollback() {
        TransactionCommand command;
        if (this.readIf("TRANSACTION")) {
            TransactionCommand command2 = new TransactionCommand(this.session, 79);
            command2.setTransactionName(this.readUniqueIdentifier());
            return command2;
        }
        if (this.readIf("TO")) {
            this.read("SAVEPOINT");
            command = new TransactionCommand(this.session, 75);
            command.setSavepointName(this.readUniqueIdentifier());
        } else {
            this.readIf("WORK");
            command = new TransactionCommand(this.session, 72);
        }
        return command;
    }

    private Prepared parsePrepare() {
        if (this.readIf("COMMIT")) {
            TransactionCommand command = new TransactionCommand(this.session, 77);
            command.setTransactionName(this.readUniqueIdentifier());
            return command;
        }
        String procedureName = this.readAliasIdentifier();
        if (this.readIf("(")) {
            ArrayList list = New.arrayList();
            int i = 0;
            while (true) {
                Column column = this.parseColumnForTable("C" + i, true);
                list.add(column);
                if (this.readIf(")")) break;
                this.read(",");
                ++i;
            }
        }
        this.read("AS");
        Prepared prep = this.parsePrepared();
        PrepareProcedure command = new PrepareProcedure(this.session);
        command.setProcedureName(procedureName);
        command.setPrepared(prep);
        return command;
    }

    private TransactionCommand parseSavepoint() {
        TransactionCommand command = new TransactionCommand(this.session, 74);
        command.setSavepointName(this.readUniqueIdentifier());
        return command;
    }

    private Prepared parseReleaseSavepoint() {
        NoOperation command = new NoOperation(this.session);
        this.readIf("SAVEPOINT");
        this.readUniqueIdentifier();
        return command;
    }

    private Schema getSchema(String schemaName) {
        if (schemaName == null) {
            return null;
        }
        Schema schema = this.database.findSchema(schemaName);
        if (schema == null) {
            if (this.equalsToken("SESSION", schemaName)) {
                schema = this.database.getSchema(this.session.getCurrentSchemaName());
            } else if (!this.database.getMode().sysDummy1 || !"SYSIBM".equals(schemaName)) {
                throw DbException.get(90079, schemaName);
            }
        }
        return schema;
    }

    private Schema getSchema() {
        return this.getSchema(this.schemaName);
    }

    private Column readTableColumn(TableFilter filter) {
        String tableAlias = null;
        String columnName = this.readColumnIdentifier();
        if (this.readIf(".")) {
            tableAlias = columnName;
            columnName = this.readColumnIdentifier();
            if (this.readIf(".")) {
                String schema = tableAlias;
                tableAlias = columnName;
                columnName = this.readColumnIdentifier();
                if (this.readIf(".")) {
                    String catalogName = schema;
                    schema = tableAlias;
                    tableAlias = columnName;
                    columnName = this.readColumnIdentifier();
                    if (!this.equalsToken(catalogName, this.database.getShortName())) {
                        throw DbException.get(90013, catalogName);
                    }
                }
                if (!this.equalsToken(schema, filter.getTable().getSchema().getName())) {
                    throw DbException.get(90079, schema);
                }
            }
            if (!this.equalsToken(tableAlias, filter.getTableAlias())) {
                throw DbException.get(42102, tableAlias);
            }
        }
        if (this.database.getSettings().rowId && "_ROWID_".equals(columnName)) {
            return filter.getRowIdColumn();
        }
        return filter.getTable().getColumn(columnName);
    }

    private Update parseUpdate() {
        Update command = new Update(this.session);
        this.currentPrepared = command;
        int start = this.lastParseIndex;
        TableFilter filter = this.readSimpleTableFilter();
        command.setTableFilter(filter);
        this.read("SET");
        if (this.readIf("(")) {
            ArrayList columns = New.arrayList();
            do {
                Column column = this.readTableColumn(filter);
                columns.add(column);
            } while (this.readIf(","));
            this.read(")");
            this.read("=");
            Expression expression = this.readExpression();
            if (columns.size() == 1) {
                command.setAssignment((Column)columns.get(0), expression);
            } else {
                int size = columns.size();
                for (int i = 0; i < size; ++i) {
                    Column column = (Column)columns.get(i);
                    Function f = Function.getFunction(this.database, "ARRAY_GET");
                    f.setParameter(0, expression);
                    f.setParameter(1, ValueExpression.get(ValueInt.get(i + 1)));
                    f.doneWithParameters();
                    command.setAssignment(column, f);
                }
            }
        } else {
            do {
                Column column = this.readTableColumn(filter);
                this.read("=");
                Expression expression = this.readIf("DEFAULT") ? ValueExpression.getDefault() : this.readExpression();
                command.setAssignment(column, expression);
            } while (this.readIf(","));
        }
        if (this.readIf("WHERE")) {
            Expression condition = this.readExpression();
            command.setCondition(condition);
        }
        if (this.readIf("LIMIT")) {
            Expression limit = this.readTerm().optimize(this.session);
            command.setLimit(limit);
        }
        this.setSQL(command, "UPDATE", start);
        return command;
    }

    private TableFilter readSimpleTableFilter() {
        Table table = this.readTableOrView();
        String alias = null;
        if (this.readIf("AS")) {
            alias = this.readAliasIdentifier();
        } else if (this.currentTokenType == 2 && !this.equalsToken("SET", this.currentToken)) {
            alias = this.readAliasIdentifier();
        }
        return new TableFilter(this.session, table, alias, this.rightsChecked, this.currentSelect);
    }

    private Delete parseDelete() {
        Delete command = new Delete(this.session);
        Expression limit = null;
        if (this.readIf("TOP")) {
            limit = this.readTerm().optimize(this.session);
        }
        this.currentPrepared = command;
        int start = this.lastParseIndex;
        this.readIf("FROM");
        TableFilter filter = this.readSimpleTableFilter();
        command.setTableFilter(filter);
        if (this.readIf("WHERE")) {
            Expression condition = this.readExpression();
            command.setCondition(condition);
        }
        if (this.readIf("LIMIT") && limit == null) {
            limit = this.readTerm().optimize(this.session);
        }
        command.setLimit(limit);
        this.setSQL(command, "DELETE", start);
        return command;
    }

    private IndexColumn[] parseIndexColumnList() {
        ArrayList<IndexColumn> columns = New.arrayList();
        do {
            IndexColumn column = new IndexColumn();
            column.columnName = this.readColumnIdentifier();
            columns.add(column);
            if (!this.readIf("ASC") && this.readIf("DESC")) {
                column.sortType = 1;
            }
            if (!this.readIf("NULLS")) continue;
            if (this.readIf("FIRST")) {
                column.sortType |= 2;
                continue;
            }
            this.read("LAST");
            column.sortType |= 4;
        } while (this.readIf(","));
        this.read(")");
        return columns.toArray(new IndexColumn[columns.size()]);
    }

    private String[] parseColumnList() {
        ArrayList<String> columns = New.arrayList();
        do {
            String columnName = this.readColumnIdentifier();
            columns.add(columnName);
        } while (this.readIfMore());
        return columns.toArray(new String[columns.size()]);
    }

    private Column[] parseColumnList(Table table) {
        ArrayList<Column> columns = New.arrayList();
        HashSet set = New.hashSet();
        if (!this.readIf(")")) {
            do {
                Column column;
                if (!set.add(column = this.parseColumn(table))) {
                    throw DbException.get(42121, column.getSQL());
                }
                columns.add(column);
            } while (this.readIfMore());
        }
        return columns.toArray(new Column[columns.size()]);
    }

    private Column parseColumn(Table table) {
        String id = this.readColumnIdentifier();
        if (this.database.getSettings().rowId && "_ROWID_".equals(id)) {
            return table.getRowIdColumn();
        }
        return table.getColumn(id);
    }

    private boolean readIfMore() {
        if (this.readIf(",")) {
            return !this.readIf(")");
        }
        this.read(")");
        return false;
    }

    private Prepared parseHelp() {
        StringBuilder buff = new StringBuilder("SELECT * FROM INFORMATION_SCHEMA.HELP");
        int i = 0;
        ArrayList<Value> paramValues = New.arrayList();
        while (this.currentTokenType != 4) {
            String s = this.currentToken;
            this.read();
            if (i == 0) {
                buff.append(" WHERE ");
            } else {
                buff.append(" AND ");
            }
            ++i;
            buff.append("UPPER(TOPIC) LIKE ?");
            paramValues.add(ValueString.get("%" + s + "%"));
        }
        return Parser.prepare(this.session, buff.toString(), paramValues);
    }

    private Prepared parseShow() {
        ArrayList<Value> paramValues = New.arrayList();
        StringBuilder buff = new StringBuilder("SELECT ");
        if (this.readIf("CLIENT_ENCODING")) {
            buff.append("'UNICODE' AS CLIENT_ENCODING FROM DUAL");
        } else if (this.readIf("DEFAULT_TRANSACTION_ISOLATION")) {
            buff.append("'read committed' AS DEFAULT_TRANSACTION_ISOLATION FROM DUAL");
        } else if (this.readIf("DATESTYLE")) {
            buff.append("'ISO' AS DATESTYLE FROM DUAL");
        } else if (this.readIf("SERVER_VERSION")) {
            buff.append("'8.1.4' AS SERVER_VERSION FROM DUAL");
        } else if (this.readIf("SERVER_ENCODING")) {
            buff.append("'UTF8' AS SERVER_ENCODING FROM DUAL");
        } else if (this.readIf("TABLES")) {
            String schema = "PUBLIC";
            if (this.readIf("FROM")) {
                schema = this.readUniqueIdentifier();
            }
            buff.append("TABLE_NAME, TABLE_SCHEMA FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA=? ORDER BY TABLE_NAME");
            paramValues.add(ValueString.get(schema));
        } else if (this.readIf("COLUMNS")) {
            this.read("FROM");
            String tableName = this.readIdentifierWithSchema();
            String schemaName = this.getSchema().getName();
            paramValues.add(ValueString.get(tableName));
            if (this.readIf("FROM")) {
                schemaName = this.readUniqueIdentifier();
            }
            buff.append("C.COLUMN_NAME FIELD, C.TYPE_NAME || '(' || C.NUMERIC_PRECISION || ')' TYPE, C.IS_NULLABLE \"NULL\", CASE (SELECT MAX(I.INDEX_TYPE_NAME) FROM INFORMATION_SCHEMA.INDEXES I WHERE I.TABLE_SCHEMA=C.TABLE_SCHEMA AND I.TABLE_NAME=C.TABLE_NAME AND I.COLUMN_NAME=C.COLUMN_NAME)WHEN 'PRIMARY KEY' THEN 'PRI' WHEN 'UNIQUE INDEX' THEN 'UNI' ELSE '' END KEY, IFNULL(COLUMN_DEFAULT, 'NULL') DEFAULT FROM INFORMATION_SCHEMA.COLUMNS C WHERE C.TABLE_NAME=? AND C.TABLE_SCHEMA=? ORDER BY C.ORDINAL_POSITION");
            paramValues.add(ValueString.get(schemaName));
        } else if (this.readIf("DATABASES") || this.readIf("SCHEMAS")) {
            buff.append("SCHEMA_NAME FROM INFORMATION_SCHEMA.SCHEMATA");
        }
        return Parser.prepare(this.session, buff.toString(), paramValues);
    }

    private static Prepared prepare(Session s, String sql, ArrayList<Value> paramValues) {
        Prepared prep = s.prepare(sql);
        ArrayList<Parameter> params = prep.getParameters();
        if (params != null) {
            int size = params.size();
            for (int i = 0; i < size; ++i) {
                Parameter p = params.get(i);
                p.setValue(paramValues.get(i));
            }
        }
        return prep;
    }

    private boolean isSelect() {
        int start = this.lastParseIndex;
        while (this.readIf("(")) {
        }
        boolean select = this.isToken("SELECT") || this.isToken("FROM");
        this.parseIndex = start;
        this.read();
        return select;
    }

    private Merge parseMerge() {
        Merge command = new Merge(this.session);
        this.currentPrepared = command;
        this.read("INTO");
        Table table = this.readTableOrView();
        command.setTable(table);
        if (this.readIf("(")) {
            if (this.isSelect()) {
                command.setQuery(this.parseSelect());
                this.read(")");
                return command;
            }
            Column[] columns = this.parseColumnList(table);
            command.setColumns(columns);
        }
        if (this.readIf("KEY")) {
            this.read("(");
            Column[] keys = this.parseColumnList(table);
            command.setKeys(keys);
        }
        if (this.readIf("VALUES")) {
            do {
                ArrayList<Expression> values = New.arrayList();
                this.read("(");
                if (!this.readIf(")")) {
                    do {
                        if (this.readIf("DEFAULT")) {
                            values.add(null);
                            continue;
                        }
                        values.add(this.readExpression());
                    } while (this.readIfMore());
                }
                command.addRow(values.toArray(new Expression[values.size()]));
            } while (this.readIf(","));
        } else {
            command.setQuery(this.parseSelect());
        }
        return command;
    }

    private Insert parseInsert() {
        Insert command = new Insert(this.session);
        this.currentPrepared = command;
        this.read("INTO");
        Table table = this.readTableOrView();
        command.setTable(table);
        Column[] columns = null;
        if (this.readIf("(")) {
            if (this.isSelect()) {
                command.setQuery(this.parseSelect());
                this.read(")");
                return command;
            }
            columns = this.parseColumnList(table);
            command.setColumns(columns);
        }
        if (this.readIf("DIRECT")) {
            command.setInsertFromSelect(true);
        }
        if (this.readIf("SORTED")) {
            command.setSortedInsertMode(true);
        }
        if (this.readIf("DEFAULT")) {
            this.read("VALUES");
            Expression[] expr = new Expression[]{};
            command.addRow(expr);
        } else if (this.readIf("VALUES")) {
            this.read("(");
            do {
                ArrayList<Expression> values = New.arrayList();
                if (!this.readIf(")")) {
                    do {
                        if (this.readIf("DEFAULT")) {
                            values.add(null);
                            continue;
                        }
                        values.add(this.readExpression());
                    } while (this.readIfMore());
                }
                command.addRow(values.toArray(new Expression[values.size()]));
            } while (this.readIf(",") && this.readIf("("));
        } else if (this.readIf("SET")) {
            if (columns != null) {
                throw this.getSyntaxError();
            }
            ArrayList<Column> columnList = New.arrayList();
            ArrayList<Expression> values = New.arrayList();
            do {
                columnList.add(this.parseColumn(table));
                this.read("=");
                Expression expression = this.readIf("DEFAULT") ? ValueExpression.getDefault() : this.readExpression();
                values.add(expression);
            } while (this.readIf(","));
            command.setColumns(columnList.toArray(new Column[columnList.size()]));
            command.addRow(values.toArray(new Expression[values.size()]));
        } else {
            command.setQuery(this.parseSelect());
        }
        return command;
    }

    /*
     * Enabled aggressive block sorting
     */
    private TableFilter readTableFilter(boolean fromOuter) {
        Table table;
        String alias;
        block14: {
            alias = null;
            if (this.readIf("(")) {
                if (this.isSelect()) {
                    Query query = this.parseSelectUnion();
                    this.read(")");
                    query.setParameterList(New.arrayList(this.parameters));
                    query.init();
                    Session s = this.createView != null ? this.database.getSystemSession() : this.session;
                    alias = this.session.getNextSystemIdentifier(this.sqlCommand);
                    table = TableView.createTempView(s, this.session.getUser(), alias, query, this.currentSelect);
                    break block14;
                } else {
                    TableFilter top;
                    if (this.database.getSettings().nestedJoins) {
                        top = this.readTableFilter(false);
                        top = this.readJoin(top, this.currentSelect, false, false);
                        top = this.getNested(top);
                    } else {
                        top = this.readTableFilter(fromOuter);
                        top = this.readJoin(top, this.currentSelect, false, fromOuter);
                    }
                    this.read(")");
                    alias = this.readFromAlias(null);
                    if (alias != null) {
                        top.setAlias(alias);
                    }
                    return top;
                }
            }
            if (this.readIf("VALUES")) {
                table = this.parseValuesTable().getTable();
            } else {
                String tableName = this.readIdentifierWithSchema(null);
                Schema schema = this.getSchema();
                if (this.readIf("(")) {
                    Schema mainSchema = this.database.getSchema("PUBLIC");
                    if (this.equalsToken(tableName, "SYSTEM_RANGE")) {
                        Expression min = this.readExpression();
                        this.read(",");
                        Expression max = this.readExpression();
                        this.read(")");
                        table = new RangeTable(mainSchema, min, max, false);
                    } else {
                        Expression expr = this.readFunction(schema, tableName);
                        if (!(expr instanceof FunctionCall)) {
                            throw this.getSyntaxError();
                        }
                        FunctionCall call = (FunctionCall)((Object)expr);
                        if (!call.isDeterministic()) {
                            this.recompileAlways = true;
                        }
                        table = new FunctionTable(mainSchema, this.session, expr, call);
                    }
                } else {
                    table = this.equalsToken("DUAL", tableName) ? this.getDualTable(false) : (this.database.getMode().sysDummy1 && this.equalsToken("SYSDUMMY1", tableName) ? this.getDualTable(false) : this.readTableOrView(tableName));
                }
            }
        }
        alias = this.readFromAlias(alias);
        return new TableFilter(this.session, table, alias, this.rightsChecked, this.currentSelect);
    }

    private String readFromAlias(String alias) {
        if (this.readIf("AS")) {
            alias = this.readAliasIdentifier();
        } else if (!(this.currentTokenType != 2 || this.isToken("LEFT") || this.isToken("RIGHT") || this.isToken("FULL"))) {
            alias = this.readAliasIdentifier();
        }
        return alias;
    }

    private Prepared parseTruncate() {
        this.read("TABLE");
        Table table = this.readTableOrView();
        TruncateTable command = new TruncateTable(this.session);
        command.setTable(table);
        return command;
    }

    private boolean readIfExists(boolean ifExists) {
        if (this.readIf("IF")) {
            this.read("EXISTS");
            ifExists = true;
        }
        return ifExists;
    }

    private Prepared parseComment() {
        String objectName;
        int type = 0;
        this.read("ON");
        boolean column = false;
        if (this.readIf("TABLE") || this.readIf("VIEW")) {
            type = 0;
        } else if (this.readIf("COLUMN")) {
            column = true;
            type = 0;
        } else if (this.readIf("CONSTANT")) {
            type = 11;
        } else if (this.readIf("CONSTRAINT")) {
            type = 5;
        } else if (this.readIf("ALIAS")) {
            type = 9;
        } else if (this.readIf("INDEX")) {
            type = 1;
        } else if (this.readIf("ROLE")) {
            type = 7;
        } else if (this.readIf("SCHEMA")) {
            type = 10;
        } else if (this.readIf("SEQUENCE")) {
            type = 3;
        } else if (this.readIf("TRIGGER")) {
            type = 4;
        } else if (this.readIf("USER")) {
            type = 2;
        } else if (this.readIf("DOMAIN")) {
            type = 12;
        } else {
            throw this.getSyntaxError();
        }
        SetComment command = new SetComment(this.session);
        if (column) {
            ArrayList list = New.arrayList();
            do {
                list.add(this.readUniqueIdentifier());
            } while (this.readIf("."));
            this.schemaName = this.session.getCurrentSchemaName();
            if (list.size() == 4) {
                if (!this.equalsToken(this.database.getShortName(), (String)list.get(0))) {
                    throw DbException.getSyntaxError(this.sqlCommand, this.parseIndex, "database name");
                }
                list.remove(0);
            }
            if (list.size() == 3) {
                this.schemaName = (String)list.get(0);
                list.remove(0);
            }
            if (list.size() != 2) {
                throw DbException.getSyntaxError(this.sqlCommand, this.parseIndex, "table.column");
            }
            objectName = (String)list.get(0);
            command.setColumn(true);
            command.setColumnName((String)list.get(1));
        } else {
            objectName = this.readIdentifierWithSchema();
        }
        command.setSchemaName(this.schemaName);
        command.setObjectName(objectName);
        command.setObjectType(type);
        this.read("IS");
        command.setCommentExpression(this.readExpression());
        return command;
    }

    private Prepared parseDrop() {
        if (this.readIf("TABLE")) {
            boolean ifExists = this.readIfExists(false);
            String tableName = this.readIdentifierWithSchema();
            DropTable command = new DropTable(this.session, this.getSchema());
            command.setTableName(tableName);
            while (this.readIf(",")) {
                tableName = this.readIdentifierWithSchema();
                DropTable next = new DropTable(this.session, this.getSchema());
                next.setTableName(tableName);
                command.addNextDropTable(next);
            }
            ifExists = this.readIfExists(ifExists);
            command.setIfExists(ifExists);
            if (this.readIf("CASCADE")) {
                command.setDropAction(1);
                this.readIf("CONSTRAINTS");
            } else if (this.readIf("RESTRICT")) {
                command.setDropAction(0);
            } else if (this.readIf("IGNORE")) {
                command.setDropAction(2);
            }
            return command;
        }
        if (this.readIf("INDEX")) {
            boolean ifExists = this.readIfExists(false);
            String indexName = this.readIdentifierWithSchema();
            DropIndex command = new DropIndex(this.session, this.getSchema());
            command.setIndexName(indexName);
            ifExists = this.readIfExists(ifExists);
            command.setIfExists(ifExists);
            return command;
        }
        if (this.readIf("USER")) {
            boolean ifExists = this.readIfExists(false);
            DropUser command = new DropUser(this.session);
            command.setUserName(this.readUniqueIdentifier());
            ifExists = this.readIfExists(ifExists);
            this.readIf("CASCADE");
            command.setIfExists(ifExists);
            return command;
        }
        if (this.readIf("SEQUENCE")) {
            boolean ifExists = this.readIfExists(false);
            String sequenceName = this.readIdentifierWithSchema();
            DropSequence command = new DropSequence(this.session, this.getSchema());
            command.setSequenceName(sequenceName);
            ifExists = this.readIfExists(ifExists);
            command.setIfExists(ifExists);
            return command;
        }
        if (this.readIf("CONSTANT")) {
            boolean ifExists = this.readIfExists(false);
            String constantName = this.readIdentifierWithSchema();
            DropConstant command = new DropConstant(this.session, this.getSchema());
            command.setConstantName(constantName);
            ifExists = this.readIfExists(ifExists);
            command.setIfExists(ifExists);
            return command;
        }
        if (this.readIf("TRIGGER")) {
            boolean ifExists = this.readIfExists(false);
            String triggerName = this.readIdentifierWithSchema();
            DropTrigger command = new DropTrigger(this.session, this.getSchema());
            command.setTriggerName(triggerName);
            ifExists = this.readIfExists(ifExists);
            command.setIfExists(ifExists);
            return command;
        }
        if (this.readIf("VIEW")) {
            boolean ifExists = this.readIfExists(false);
            String viewName = this.readIdentifierWithSchema();
            DropView command = new DropView(this.session, this.getSchema());
            command.setViewName(viewName);
            ifExists = this.readIfExists(ifExists);
            command.setIfExists(ifExists);
            Integer dropAction = this.parseCascadeOrRestrict();
            if (dropAction != null) {
                command.setDropAction(dropAction);
            }
            return command;
        }
        if (this.readIf("ROLE")) {
            boolean ifExists = this.readIfExists(false);
            DropRole command = new DropRole(this.session);
            command.setRoleName(this.readUniqueIdentifier());
            ifExists = this.readIfExists(ifExists);
            command.setIfExists(ifExists);
            return command;
        }
        if (this.readIf("ALIAS")) {
            boolean ifExists = this.readIfExists(false);
            String aliasName = this.readIdentifierWithSchema();
            DropFunctionAlias command = new DropFunctionAlias(this.session, this.getSchema());
            command.setAliasName(aliasName);
            ifExists = this.readIfExists(ifExists);
            command.setIfExists(ifExists);
            return command;
        }
        if (this.readIf("SCHEMA")) {
            boolean ifExists = this.readIfExists(false);
            DropSchema command = new DropSchema(this.session);
            command.setSchemaName(this.readUniqueIdentifier());
            ifExists = this.readIfExists(ifExists);
            command.setIfExists(ifExists);
            return command;
        }
        if (this.readIf("ALL")) {
            this.read("OBJECTS");
            DropDatabase command = new DropDatabase(this.session);
            command.setDropAllObjects(true);
            if (this.readIf("DELETE")) {
                this.read("FILES");
                command.setDeleteFiles(true);
            }
            return command;
        }
        if (this.readIf("DOMAIN")) {
            return this.parseDropUserDataType();
        }
        if (this.readIf("TYPE")) {
            return this.parseDropUserDataType();
        }
        if (this.readIf("DATATYPE")) {
            return this.parseDropUserDataType();
        }
        if (this.readIf("AGGREGATE")) {
            return this.parseDropAggregate();
        }
        throw this.getSyntaxError();
    }

    private DropUserDataType parseDropUserDataType() {
        boolean ifExists = this.readIfExists(false);
        DropUserDataType command = new DropUserDataType(this.session);
        command.setTypeName(this.readUniqueIdentifier());
        ifExists = this.readIfExists(ifExists);
        command.setIfExists(ifExists);
        return command;
    }

    private DropAggregate parseDropAggregate() {
        boolean ifExists = this.readIfExists(false);
        DropAggregate command = new DropAggregate(this.session);
        command.setName(this.readUniqueIdentifier());
        ifExists = this.readIfExists(ifExists);
        command.setIfExists(ifExists);
        return command;
    }

    private TableFilter readJoin(TableFilter top, Select command, boolean nested, boolean fromOuter) {
        boolean joined = false;
        TableFilter last = top;
        boolean nestedJoins = this.database.getSettings().nestedJoins;
        while (true) {
            TableFilter join;
            Expression on;
            if (this.readIf("RIGHT")) {
                this.readIf("OUTER");
                this.read("JOIN");
                joined = true;
                TableFilter newTop = this.readTableFilter(fromOuter);
                newTop = this.readJoin(newTop, command, nested, true);
                on = null;
                if (this.readIf("ON")) {
                    on = this.readExpression();
                }
                if (nestedJoins) {
                    top = this.getNested(top);
                    newTop.addJoin(top, true, false, on);
                } else {
                    newTop.addJoin(top, true, false, on);
                }
                top = newTop;
                last = newTop;
                continue;
            }
            if (this.readIf("LEFT")) {
                this.readIf("OUTER");
                this.read("JOIN");
                joined = true;
                join = this.readTableFilter(true);
                if (nestedJoins) {
                    join = this.readJoin(join, command, true, true);
                } else {
                    top = this.readJoin(top, command, false, true);
                }
                on = null;
                if (this.readIf("ON")) {
                    on = this.readExpression();
                }
                top.addJoin(join, true, false, on);
                last = join;
                continue;
            }
            if (this.readIf("FULL")) {
                throw this.getSyntaxError();
            }
            if (this.readIf("INNER")) {
                this.read("JOIN");
                joined = true;
                join = this.readTableFilter(fromOuter);
                top = this.readJoin(top, command, false, false);
                on = null;
                if (this.readIf("ON")) {
                    on = this.readExpression();
                }
                if (nestedJoins) {
                    top.addJoin(join, false, false, on);
                } else {
                    top.addJoin(join, fromOuter, false, on);
                }
                last = join;
                continue;
            }
            if (this.readIf("JOIN")) {
                joined = true;
                join = this.readTableFilter(fromOuter);
                top = this.readJoin(top, command, false, false);
                on = null;
                if (this.readIf("ON")) {
                    on = this.readExpression();
                }
                if (nestedJoins) {
                    top.addJoin(join, false, false, on);
                } else {
                    top.addJoin(join, fromOuter, false, on);
                }
                last = join;
                continue;
            }
            if (this.readIf("CROSS")) {
                this.read("JOIN");
                joined = true;
                join = this.readTableFilter(fromOuter);
                if (nestedJoins) {
                    top.addJoin(join, false, false, null);
                } else {
                    top.addJoin(join, fromOuter, false, null);
                }
                last = join;
                continue;
            }
            if (!this.readIf("NATURAL")) break;
            this.read("JOIN");
            joined = true;
            join = this.readTableFilter(fromOuter);
            Column[] tableCols = last.getTable().getColumns();
            Column[] joinCols = join.getTable().getColumns();
            String tableSchema = last.getTable().getSchema().getName();
            String joinSchema = join.getTable().getSchema().getName();
            Condition on2 = null;
            for (Column tc : tableCols) {
                String tableColumnName = tc.getName();
                for (Column c : joinCols) {
                    String joinColumnName = c.getName();
                    if (!this.equalsToken(tableColumnName, joinColumnName)) continue;
                    join.addNaturalJoinColumn(c);
                    ExpressionColumn tableExpr = new ExpressionColumn(this.database, tableSchema, last.getTableAlias(), tableColumnName);
                    ExpressionColumn joinExpr = new ExpressionColumn(this.database, joinSchema, join.getTableAlias(), joinColumnName);
                    Comparison equal = new Comparison(this.session, 0, tableExpr, joinExpr);
                    on2 = on2 == null ? equal : new ConditionAndOr(0, on2, equal);
                }
            }
            if (nestedJoins) {
                top.addJoin(join, false, nested, on2);
            } else {
                top.addJoin(join, fromOuter, false, on2);
            }
            last = join;
        }
        if (nested && joined) {
            top = this.getNested(top);
        }
        return top;
    }

    private TableFilter getNested(TableFilter n) {
        String joinTable = "SYSTEM_JOIN_" + this.parseIndex;
        TableFilter top = new TableFilter(this.session, this.getDualTable(true), joinTable, this.rightsChecked, this.currentSelect);
        top.addJoin(n, false, true, null);
        return top;
    }

    private Prepared parseExecute() {
        ExecuteProcedure command = new ExecuteProcedure(this.session);
        String procedureName = this.readAliasIdentifier();
        Procedure p = this.session.getProcedure(procedureName);
        if (p == null) {
            throw DbException.get(90077, procedureName);
        }
        command.setProcedure(p);
        if (this.readIf("(")) {
            int i = 0;
            while (true) {
                command.setExpression(i, this.readExpression());
                if (this.readIf(")")) break;
                this.read(",");
                ++i;
            }
        }
        return command;
    }

    private DeallocateProcedure parseDeallocate() {
        this.readIf("PLAN");
        String procedureName = this.readAliasIdentifier();
        DeallocateProcedure command = new DeallocateProcedure(this.session);
        command.setProcedureName(procedureName);
        return command;
    }

    private Explain parseExplain() {
        Explain command = new Explain(this.session);
        if (this.readIf("ANALYZE")) {
            command.setExecuteCommand(true);
        } else if (this.readIf("PLAN")) {
            this.readIf("FOR");
        }
        if (this.isToken("SELECT") || this.isToken("FROM") || this.isToken("(")) {
            command.setCommand(this.parseSelect());
        } else if (this.readIf("DELETE")) {
            command.setCommand(this.parseDelete());
        } else if (this.readIf("UPDATE")) {
            command.setCommand(this.parseUpdate());
        } else if (this.readIf("INSERT")) {
            command.setCommand(this.parseInsert());
        } else if (this.readIf("MERGE")) {
            command.setCommand(this.parseMerge());
        } else if (this.readIf("WITH")) {
            command.setCommand(this.parserWith());
        } else {
            throw this.getSyntaxError();
        }
        return command;
    }

    private Query parseSelect() {
        int paramIndex = this.parameters.size();
        Query command = this.parseSelectUnion();
        ArrayList<Parameter> params = New.arrayList();
        int size = this.parameters.size();
        for (int i = paramIndex; i < size; ++i) {
            params.add(this.parameters.get(i));
        }
        command.setParameterList(params);
        command.init();
        return command;
    }

    private Query parseSelectUnion() {
        int start = this.lastParseIndex;
        Query command = this.parseSelectSub();
        return this.parseSelectUnionExtension(command, start, false);
    }

    private Query parseSelectUnionExtension(Query command, int start, boolean unionOnly) {
        while (true) {
            SelectUnion union;
            if (this.readIf("UNION")) {
                union = new SelectUnion(this.session, command);
                if (this.readIf("ALL")) {
                    union.setUnionType(1);
                } else {
                    this.readIf("DISTINCT");
                    union.setUnionType(0);
                }
                union.setRight(this.parseSelectSub());
                command = union;
                continue;
            }
            if (this.readIf("MINUS") || this.readIf("EXCEPT")) {
                union = new SelectUnion(this.session, command);
                union.setUnionType(2);
                union.setRight(this.parseSelectSub());
                command = union;
                continue;
            }
            if (!this.readIf("INTERSECT")) break;
            union = new SelectUnion(this.session, command);
            union.setUnionType(3);
            union.setRight(this.parseSelectSub());
            command = union;
        }
        if (!unionOnly) {
            this.parseEndOfQuery(command);
        }
        this.setSQL(command, null, start);
        return command;
    }

    private void parseEndOfQuery(Query command) {
        Expression limit;
        Select temp;
        if (this.readIf("ORDER")) {
            this.read("BY");
            Select oldSelect = this.currentSelect;
            if (command instanceof Select) {
                this.currentSelect = (Select)command;
            }
            ArrayList<SelectOrderBy> orderList = New.arrayList();
            do {
                boolean canBeNumber = true;
                if (this.readIf("=")) {
                    canBeNumber = false;
                }
                SelectOrderBy order = new SelectOrderBy();
                Expression expr = this.readExpression();
                if (canBeNumber && expr instanceof ValueExpression && expr.getType() == 4) {
                    order.columnIndexExpr = expr;
                } else if (expr instanceof Parameter) {
                    this.recompileAlways = true;
                    order.columnIndexExpr = expr;
                } else {
                    order.expression = expr;
                }
                if (this.readIf("DESC")) {
                    order.descending = true;
                } else {
                    this.readIf("ASC");
                }
                if (this.readIf("NULLS")) {
                    if (this.readIf("FIRST")) {
                        order.nullsFirst = true;
                    } else {
                        this.read("LAST");
                        order.nullsLast = true;
                    }
                }
                orderList.add(order);
            } while (this.readIf(","));
            command.setOrder(orderList);
            this.currentSelect = oldSelect;
        }
        if (this.database.getMode().supportOffsetFetch) {
            temp = this.currentSelect;
            this.currentSelect = null;
            if (this.readIf("OFFSET")) {
                command.setOffset(this.readExpression().optimize(this.session));
                if (!this.readIf("ROW")) {
                    this.read("ROWS");
                }
            }
            if (this.readIf("FETCH")) {
                if (!this.readIf("FIRST")) {
                    this.read("NEXT");
                }
                if (this.readIf("ROW")) {
                    command.setLimit(ValueExpression.get(ValueInt.get(1)));
                } else {
                    limit = this.readExpression().optimize(this.session);
                    command.setLimit(limit);
                    if (!this.readIf("ROW")) {
                        this.read("ROWS");
                    }
                }
                this.read("ONLY");
            }
            this.currentSelect = temp;
        }
        if (this.readIf("LIMIT")) {
            temp = this.currentSelect;
            this.currentSelect = null;
            limit = this.readExpression().optimize(this.session);
            command.setLimit(limit);
            if (this.readIf("OFFSET")) {
                Expression offset = this.readExpression().optimize(this.session);
                command.setOffset(offset);
            } else if (this.readIf(",")) {
                Expression offset = limit;
                limit = this.readExpression().optimize(this.session);
                command.setOffset(offset);
                command.setLimit(limit);
            }
            if (this.readIf("SAMPLE_SIZE")) {
                command.setSampleSize(this.getPositiveInt());
            }
            this.currentSelect = temp;
        }
        if (this.readIf("FOR")) {
            if (this.readIf("UPDATE")) {
                if (this.readIf("OF")) {
                    do {
                        this.readIdentifierWithSchema();
                    } while (this.readIf(","));
                } else if (!this.readIf("NOWAIT") && this.readIf("WITH")) {
                    this.read("RR");
                }
                command.setForUpdate(true);
            } else if (this.readIf("READ")) {
                this.read("ONLY");
                if (this.readIf("WITH")) {
                    this.read("RS");
                }
            }
        }
    }

    private Query parseSelectSub() {
        if (this.readIf("(")) {
            Query command = this.parseSelectUnion();
            this.read(")");
            return command;
        }
        Select select = this.parseSelectSimple();
        return select;
    }

    private void parseSelectSimpleFromPart(Select command) {
        do {
            TableFilter filter = this.readTableFilter(false);
            this.parseJoinTableFilter(filter, command);
        } while (this.readIf(","));
    }

    private void parseJoinTableFilter(TableFilter top, final Select command) {
        top = this.readJoin(top, command, false, top.isJoinOuter());
        command.addTableFilter(top, true);
        boolean isOuter = false;
        while (true) {
            TableFilter join;
            TableFilter n;
            if ((n = top.getNestedJoin()) != null) {
                n.visit(new TableFilter.TableFilterVisitor(){

                    @Override
                    public void accept(TableFilter f) {
                        command.addTableFilter(f, false);
                    }
                });
            }
            if ((join = top.getJoin()) == null) break;
            if (isOuter |= join.isJoinOuter()) {
                command.addTableFilter(join, false);
            } else {
                Expression on = join.getJoinCondition();
                if (on != null) {
                    command.addCondition(on);
                }
                join.removeJoinCondition();
                top.removeJoin();
                command.addTableFilter(join, true);
            }
            top = join;
        }
    }

    private void parseSelectSimpleSelectPart(Select command) {
        Select temp = this.currentSelect;
        this.currentSelect = null;
        if (this.readIf("TOP")) {
            Expression limit = this.readTerm().optimize(this.session);
            command.setLimit(limit);
        } else if (this.readIf("LIMIT")) {
            Expression offset = this.readTerm().optimize(this.session);
            command.setOffset(offset);
            Expression limit = this.readTerm().optimize(this.session);
            command.setLimit(limit);
        }
        this.currentSelect = temp;
        if (this.readIf("DISTINCT")) {
            command.setDistinct(true);
        } else {
            this.readIf("ALL");
        }
        ArrayList<Expression> expressions = New.arrayList();
        do {
            if (this.readIf("*")) {
                expressions.add(new Wildcard(null, null));
                continue;
            }
            Expression expr = this.readExpression();
            if (this.readIf("AS") || this.currentTokenType == 2) {
                String alias = this.readAliasIdentifier();
                boolean aliasColumnName = this.database.getSettings().aliasColumnName;
                expr = new Alias(expr, alias, aliasColumnName |= this.database.getMode().aliasColumnName);
            }
            expressions.add(expr);
        } while (this.readIf(","));
        command.setExpressions(expressions);
    }

    private Select parseSelectSimple() {
        Expression condition;
        boolean fromFirst;
        if (this.readIf("SELECT")) {
            fromFirst = false;
        } else if (this.readIf("FROM")) {
            fromFirst = true;
        } else {
            throw this.getSyntaxError();
        }
        Select command = new Select(this.session);
        int start = this.lastParseIndex;
        Select oldSelect = this.currentSelect;
        this.currentSelect = command;
        this.currentPrepared = command;
        if (fromFirst) {
            this.parseSelectSimpleFromPart(command);
            this.read("SELECT");
            this.parseSelectSimpleSelectPart(command);
        } else {
            this.parseSelectSimpleSelectPart(command);
            if (!this.readIf("FROM")) {
                Table dual = this.getDualTable(false);
                TableFilter filter = new TableFilter(this.session, dual, null, this.rightsChecked, this.currentSelect);
                command.addTableFilter(filter, true);
            } else {
                this.parseSelectSimpleFromPart(command);
            }
        }
        if (this.readIf("WHERE")) {
            condition = this.readExpression();
            command.addCondition(condition);
        }
        this.currentSelect = oldSelect;
        if (this.readIf("GROUP")) {
            this.read("BY");
            command.setGroupQuery();
            ArrayList<Expression> list = New.arrayList();
            do {
                Expression expr = this.readExpression();
                list.add(expr);
            } while (this.readIf(","));
            command.setGroupBy(list);
        }
        this.currentSelect = command;
        if (this.readIf("HAVING")) {
            command.setGroupQuery();
            condition = this.readExpression();
            command.setHaving(condition);
        }
        command.setParameterList(this.parameters);
        this.currentSelect = oldSelect;
        this.setSQL(command, "SELECT", start);
        return command;
    }

    private Table getDualTable(boolean noColumns) {
        Schema main = this.database.findSchema("PUBLIC");
        ValueExpression one = ValueExpression.get(ValueLong.get(1L));
        return new RangeTable(main, one, one, noColumns);
    }

    private void setSQL(Prepared command, String start, int startIndex) {
        String sql = this.originalSQL.substring(startIndex, this.lastParseIndex).trim();
        if (start != null) {
            sql = start + " " + sql;
        }
        command.setSQL(sql);
    }

    private Expression readExpression() {
        Expression r = this.readAnd();
        while (this.readIf("OR")) {
            r = new ConditionAndOr(1, r, this.readAnd());
        }
        return r;
    }

    private Expression readAnd() {
        Expression r = this.readCondition();
        while (this.readIf("AND")) {
            r = new ConditionAndOr(0, r, this.readCondition());
        }
        return r;
    }

    private Expression readCondition() {
        if (this.readIf("NOT")) {
            return new ConditionNot(this.readCondition());
        }
        if (this.readIf("EXISTS")) {
            this.read("(");
            Query query = this.parseSelect();
            this.read(")");
            return new ConditionExists(query);
        }
        Expression r = this.readConcat();
        while (true) {
            int backup = this.parseIndex;
            boolean not = false;
            if (this.readIf("NOT")) {
                not = true;
                if (this.isToken("NULL")) {
                    this.parseIndex = backup;
                    this.currentToken = "NOT";
                    break;
                }
            }
            if (this.readIf("LIKE")) {
                Expression b = this.readConcat();
                Expression esc = null;
                if (this.readIf("ESCAPE")) {
                    esc = this.readConcat();
                }
                this.recompileAlways = true;
                r = new CompareLike(this.database, r, b, esc, false);
            } else if (this.readIf("REGEXP")) {
                Expression b = this.readConcat();
                r = new CompareLike(this.database, r, b, null, true);
            } else if (this.readIf("IS")) {
                if (this.readIf("NOT")) {
                    if (this.readIf("NULL")) {
                        r = new Comparison(this.session, 7, r, null);
                    } else if (this.readIf("DISTINCT")) {
                        this.read("FROM");
                        r = new Comparison(this.session, 16, r, this.readConcat());
                    } else {
                        r = new Comparison(this.session, 21, r, this.readConcat());
                    }
                } else if (this.readIf("NULL")) {
                    r = new Comparison(this.session, 6, r, null);
                } else if (this.readIf("DISTINCT")) {
                    this.read("FROM");
                    r = new Comparison(this.session, 21, r, this.readConcat());
                } else {
                    r = new Comparison(this.session, 16, r, this.readConcat());
                }
            } else if (this.readIf("IN")) {
                this.read("(");
                if (this.readIf(")")) {
                    r = ValueExpression.get(ValueBoolean.get(false));
                } else {
                    if (this.isSelect()) {
                        Query query = this.parseSelect();
                        r = new ConditionInSelect(this.database, r, query, false, 0);
                    } else {
                        Expression last;
                        ArrayList<Expression> v = New.arrayList();
                        do {
                            last = this.readExpression();
                            v.add(last);
                        } while (this.readIf(","));
                        if (v.size() == 1 && last instanceof Subquery) {
                            Subquery s = (Subquery)last;
                            Query q = s.getQuery();
                            r = new ConditionInSelect(this.database, r, q, false, 0);
                        } else {
                            r = new ConditionIn(this.database, r, v);
                        }
                    }
                    this.read(")");
                }
            } else if (this.readIf("BETWEEN")) {
                Expression low = this.readConcat();
                this.read("AND");
                Expression high = this.readConcat();
                Comparison condLow = new Comparison(this.session, 3, low, r);
                Comparison condHigh = new Comparison(this.session, 1, high, r);
                r = new ConditionAndOr(0, condLow, condHigh);
            } else {
                Query query;
                int compareType = Parser.getCompareType(this.currentTokenType);
                if (compareType < 0) break;
                this.read();
                if (this.readIf("ALL")) {
                    this.read("(");
                    query = this.parseSelect();
                    r = new ConditionInSelect(this.database, r, query, true, compareType);
                    this.read(")");
                } else if (this.readIf("ANY") || this.readIf("SOME")) {
                    this.read("(");
                    query = this.parseSelect();
                    r = new ConditionInSelect(this.database, r, query, false, compareType);
                    this.read(")");
                } else {
                    Expression right = this.readConcat();
                    if (this.readIf("(") && this.readIf("+") && this.readIf(")")) {
                        if (r instanceof ExpressionColumn && right instanceof ExpressionColumn) {
                            ExpressionColumn leftCol = (ExpressionColumn)r;
                            ExpressionColumn rightCol = (ExpressionColumn)right;
                            ArrayList<TableFilter> filters = this.currentSelect.getTopFilters();
                            Iterator<TableFilter> i$ = filters.iterator();
                            while (i$.hasNext()) {
                                for (TableFilter f = i$.next(); f != null; f = f.getJoin()) {
                                    leftCol.mapColumns(f, 0);
                                    rightCol.mapColumns(f, 0);
                                }
                            }
                            TableFilter leftFilter = leftCol.getTableFilter();
                            TableFilter rightFilter = rightCol.getTableFilter();
                            r = new Comparison(this.session, compareType, r, right);
                            if (leftFilter != null && rightFilter != null) {
                                int idx = filters.indexOf(rightFilter);
                                if (idx >= 0) {
                                    filters.remove(idx);
                                    leftFilter.addJoin(rightFilter, true, false, r);
                                } else {
                                    rightFilter.mapAndAddFilter(r);
                                }
                                r = ValueExpression.get(ValueBoolean.get(true));
                            }
                        }
                    } else {
                        r = new Comparison(this.session, compareType, r, right);
                    }
                }
            }
            if (!not) continue;
            r = new ConditionNot(r);
        }
        return r;
    }

    private Expression readConcat() {
        Expression r = this.readSum();
        while (true) {
            Function function;
            if (this.readIf("||")) {
                r = new Operation(0, r, this.readSum());
                continue;
            }
            if (this.readIf("~")) {
                if (this.readIf("*")) {
                    function = Function.getFunction(this.database, "CAST");
                    function.setDataType(new Column("X", 14));
                    function.setParameter(0, r);
                    r = function;
                }
                r = new CompareLike(this.database, r, this.readSum(), null, true);
                continue;
            }
            if (!this.readIf("!~")) break;
            if (this.readIf("*")) {
                function = Function.getFunction(this.database, "CAST");
                function.setDataType(new Column("X", 14));
                function.setParameter(0, r);
                r = function;
            }
            r = new ConditionNot(new CompareLike(this.database, r, this.readSum(), null, true));
        }
        return r;
    }

    private Expression readSum() {
        Expression r = this.readFactor();
        while (true) {
            if (this.readIf("+")) {
                r = new Operation(1, r, this.readFactor());
                continue;
            }
            if (!this.readIf("-")) break;
            r = new Operation(2, r, this.readFactor());
        }
        return r;
    }

    private Expression readFactor() {
        Expression r = this.readTerm();
        while (true) {
            if (this.readIf("*")) {
                r = new Operation(3, r, this.readTerm());
                continue;
            }
            if (this.readIf("/")) {
                r = new Operation(4, r, this.readTerm());
                continue;
            }
            if (!this.readIf("%")) break;
            r = new Operation(6, r, this.readTerm());
        }
        return r;
    }

    private Expression readAggregate(int aggregateType) {
        Aggregate r;
        if (this.currentSelect == null) {
            throw this.getSyntaxError();
        }
        this.currentSelect.setGroupQuery();
        if (aggregateType == 1) {
            if (this.readIf("*")) {
                r = new Aggregate(0, null, this.currentSelect, false);
            } else {
                boolean distinct = this.readIf("DISTINCT");
                Expression on = this.readExpression();
                r = on instanceof Wildcard && !distinct ? new Aggregate(0, null, this.currentSelect, false) : new Aggregate(1, on, this.currentSelect, distinct);
            }
        } else if (aggregateType == 2) {
            boolean distinct = this.readIf("DISTINCT");
            Aggregate agg = new Aggregate(2, this.readExpression(), this.currentSelect, distinct);
            if (this.readIf("ORDER")) {
                this.read("BY");
                agg.setOrder(this.parseSimpleOrderList());
            }
            if (this.readIf("SEPARATOR")) {
                agg.setSeparator(this.readExpression());
            }
            r = agg;
        } else {
            boolean distinct = this.readIf("DISTINCT");
            r = new Aggregate(aggregateType, this.readExpression(), this.currentSelect, distinct);
        }
        this.read(")");
        return r;
    }

    private ArrayList<SelectOrderBy> parseSimpleOrderList() {
        ArrayList<SelectOrderBy> orderList = New.arrayList();
        do {
            Expression expr;
            SelectOrderBy order = new SelectOrderBy();
            order.expression = expr = this.readExpression();
            if (this.readIf("DESC")) {
                order.descending = true;
            } else {
                this.readIf("ASC");
            }
            orderList.add(order);
        } while (this.readIf(","));
        return orderList;
    }

    private JavaFunction readJavaFunction(Schema schema, String functionName) {
        FunctionAlias functionAlias = null;
        functionAlias = schema != null ? schema.findFunction(functionName) : this.findFunctionAlias(this.session.getCurrentSchemaName(), functionName);
        if (functionAlias == null) {
            throw DbException.get(90022, functionName);
        }
        ArrayList<Expression> argList = New.arrayList();
        int numArgs = 0;
        while (!this.readIf(")")) {
            if (numArgs++ > 0) {
                this.read(",");
            }
            argList.add(this.readExpression());
        }
        Expression[] args = new Expression[numArgs];
        argList.toArray(args);
        JavaFunction func = new JavaFunction(functionAlias, args);
        return func;
    }

    private JavaAggregate readJavaAggregate(UserAggregate aggregate) {
        ArrayList<Expression> params = New.arrayList();
        do {
            params.add(this.readExpression());
        } while (this.readIf(","));
        this.read(")");
        Expression[] list = new Expression[params.size()];
        params.toArray(list);
        JavaAggregate agg = new JavaAggregate(aggregate, list, this.currentSelect);
        this.currentSelect.setGroupQuery();
        return agg;
    }

    private int getAggregateType(String name) {
        if (!this.identifiersToUpper) {
            name = StringUtils.toUpperEnglish(name);
        }
        return Aggregate.getAggregateType(name);
    }

    private Expression readFunction(Schema schema, String name) {
        if (schema != null) {
            return this.readJavaFunction(schema, name);
        }
        int agg = this.getAggregateType(name);
        if (agg >= 0) {
            return this.readAggregate(agg);
        }
        Function function = Function.getFunction(this.database, name);
        if (function == null) {
            UserAggregate aggregate = this.database.findAggregate(name);
            if (aggregate != null) {
                return this.readJavaAggregate(aggregate);
            }
            return this.readJavaFunction(null, name);
        }
        switch (function.getFunctionType()) {
            case 203: {
                function.setParameter(0, this.readExpression());
                this.read("AS");
                Column type = this.parseColumnWithType(null);
                function.setDataType(type);
                this.read(")");
                break;
            }
            case 202: {
                function.setParameter(0, this.readExpression());
                this.read(",");
                Column type = this.parseColumnWithType(null);
                function.setDataType(type);
                this.read(")");
                break;
            }
            case 120: {
                function.setParameter(0, ValueExpression.get(ValueString.get(this.currentToken)));
                this.read();
                this.read("FROM");
                function.setParameter(1, this.readExpression());
                this.read(")");
                break;
            }
            case 102: 
            case 103: {
                if (Function.isDatePart(this.currentToken)) {
                    function.setParameter(0, ValueExpression.get(ValueString.get(this.currentToken)));
                    this.read();
                } else {
                    function.setParameter(0, this.readExpression());
                }
                this.read(",");
                function.setParameter(1, this.readExpression());
                this.read(",");
                function.setParameter(2, this.readExpression());
                this.read(")");
                break;
            }
            case 73: {
                function.setParameter(0, this.readExpression());
                if (!this.readIf(",")) {
                    this.read("FROM");
                }
                function.setParameter(1, this.readExpression());
                if (this.readIf("FOR") || this.readIf(",")) {
                    function.setParameter(2, this.readExpression());
                }
                this.read(")");
                break;
            }
            case 77: {
                function.setParameter(0, this.readConcat());
                if (!this.readIf(",")) {
                    this.read("IN");
                }
                function.setParameter(1, this.readExpression());
                this.read(")");
                break;
            }
            case 78: {
                Expression space = null;
                if (this.readIf("LEADING")) {
                    function = Function.getFunction(this.database, "LTRIM");
                    if (!this.readIf("FROM")) {
                        space = this.readExpression();
                        this.read("FROM");
                    }
                } else if (this.readIf("TRAILING")) {
                    function = Function.getFunction(this.database, "RTRIM");
                    if (!this.readIf("FROM")) {
                        space = this.readExpression();
                        this.read("FROM");
                    }
                } else if (this.readIf("BOTH") && !this.readIf("FROM")) {
                    space = this.readExpression();
                    this.read("FROM");
                }
                Expression p0 = this.readExpression();
                if (this.readIf(",")) {
                    space = this.readExpression();
                } else if (this.readIf("FROM")) {
                    space = p0;
                    p0 = this.readExpression();
                }
                function.setParameter(0, p0);
                if (space != null) {
                    function.setParameter(1, space);
                }
                this.read(")");
                break;
            }
            case 223: 
            case 224: {
                int i = 0;
                ArrayList<Column> columns = New.arrayList();
                do {
                    String columnName = this.readAliasIdentifier();
                    Column column = this.parseColumnWithType(columnName);
                    columns.add(column);
                    this.read("=");
                    function.setParameter(i, this.readExpression());
                    ++i;
                } while (this.readIf(","));
                this.read(")");
                TableFunction tf = (TableFunction)function;
                tf.setColumns(columns);
                break;
            }
            case 300: {
                this.read(")");
                this.read("OVER");
                this.read("(");
                this.read(")");
                return new Rownum(this.currentSelect == null ? this.currentPrepared : this.currentSelect);
            }
            default: {
                if (this.readIf(")")) break;
                int i = 0;
                do {
                    function.setParameter(i++, this.readExpression());
                } while (this.readIf(","));
                this.read(")");
            }
        }
        function.doneWithParameters();
        return function;
    }

    private Function readFunctionWithoutParameters(String name) {
        if (this.readIf("(")) {
            this.read(")");
        }
        Function function = Function.getFunction(this.database, name);
        function.doneWithParameters();
        return function;
    }

    private Expression readWildcardOrSequenceValue(String schema, String objectName) {
        Sequence sequence;
        if (this.readIf("*")) {
            return new Wildcard(schema, objectName);
        }
        if (schema == null) {
            schema = this.session.getCurrentSchemaName();
        }
        if (this.readIf("NEXTVAL")) {
            Sequence sequence2 = this.findSequence(schema, objectName);
            if (sequence2 != null) {
                return new SequenceValue(sequence2);
            }
        } else if (this.readIf("CURRVAL") && (sequence = this.findSequence(schema, objectName)) != null) {
            Function function = Function.getFunction(this.database, "CURRVAL");
            function.setParameter(0, ValueExpression.get(ValueString.get(sequence.getSchema().getName())));
            function.setParameter(1, ValueExpression.get(ValueString.get(sequence.getName())));
            function.doneWithParameters();
            return function;
        }
        return null;
    }

    private Expression readTermObjectDot(String objectName) {
        Expression expr = this.readWildcardOrSequenceValue(null, objectName);
        if (expr != null) {
            return expr;
        }
        String name = this.readColumnIdentifier();
        Schema s = this.database.findSchema(objectName);
        if (s != null && this.readIf("(")) {
            return this.readFunction(s, name);
        }
        if (this.readIf(".")) {
            String schema = objectName;
            expr = this.readWildcardOrSequenceValue(schema, objectName = name);
            if (expr != null) {
                return expr;
            }
            name = this.readColumnIdentifier();
            if (this.readIf("(")) {
                String databaseName = schema;
                if (!this.equalsToken(this.database.getShortName(), databaseName)) {
                    throw DbException.get(90013, databaseName);
                }
                schema = objectName;
                return this.readFunction(this.database.getSchema(schema), name);
            }
            if (this.readIf(".")) {
                String databaseName = schema;
                if (!this.equalsToken(this.database.getShortName(), databaseName)) {
                    throw DbException.get(90013, databaseName);
                }
                schema = objectName;
                expr = this.readWildcardOrSequenceValue(schema, objectName = name);
                if (expr != null) {
                    return expr;
                }
                name = this.readColumnIdentifier();
                return new ExpressionColumn(this.database, schema, objectName, name);
            }
            return new ExpressionColumn(this.database, schema, objectName, name);
        }
        return new ExpressionColumn(this.database, null, objectName, name);
    }

    private Expression readTerm() {
        Function function;
        Expression r;
        switch (this.currentTokenType) {
            case 12: {
                this.read();
                r = new Variable(this.session, this.readAliasIdentifier());
                if (!this.readIf(":=")) break;
                Expression value = this.readExpression();
                function = Function.getFunction(this.database, "SET");
                function.setParameter(0, r);
                function.setParameter(1, value);
                r = function;
                break;
            }
            case 3: {
                Parameter p;
                boolean indexed = Character.isDigit(this.sqlCommandChars[this.parseIndex]);
                this.read();
                if (indexed && this.currentTokenType == 5 && this.currentValue.getType() == 4) {
                    int index;
                    if (this.indexedParameterList == null) {
                        if (this.parameters == null) {
                            throw this.getSyntaxError();
                        }
                        if (this.parameters.size() > 0) {
                            throw DbException.get(90123);
                        }
                        this.indexedParameterList = New.arrayList();
                    }
                    if ((index = this.currentValue.getInt() - 1) < 0 || index >= 100000) {
                        throw DbException.getInvalidValueException("parameter index", index);
                    }
                    if (this.indexedParameterList.size() <= index) {
                        this.indexedParameterList.ensureCapacity(index + 1);
                        while (this.indexedParameterList.size() <= index) {
                            this.indexedParameterList.add(null);
                        }
                    }
                    if ((p = this.indexedParameterList.get(index)) == null) {
                        p = new Parameter(index);
                        this.indexedParameterList.set(index, p);
                    }
                    this.read();
                } else {
                    if (this.indexedParameterList != null) {
                        throw DbException.get(90123);
                    }
                    p = new Parameter(this.parameters.size());
                }
                this.parameters.add(p);
                r = p;
                break;
            }
            case 1: {
                if (this.isToken("SELECT") || this.isToken("FROM")) {
                    Query query = this.parseSelect();
                    r = new Subquery(query);
                    break;
                }
                throw this.getSyntaxError();
            }
            case 2: {
                String name = this.currentToken;
                if (this.currentTokenQuoted) {
                    this.read();
                    if (this.readIf("(")) {
                        r = this.readFunction(null, name);
                        break;
                    }
                    if (this.readIf(".")) {
                        r = this.readTermObjectDot(name);
                        break;
                    }
                    r = new ExpressionColumn(this.database, null, null, name);
                    break;
                }
                this.read();
                if (this.readIf(".")) {
                    r = this.readTermObjectDot(name);
                    break;
                }
                if (this.equalsToken("CASE", name)) {
                    if (this.isToken("WHEN")) {
                        r = this.readWhen(null);
                        break;
                    }
                    Expression left = this.readExpression();
                    r = this.readWhen(left);
                    break;
                }
                if (this.readIf("(")) {
                    r = this.readFunction(null, name);
                    break;
                }
                if (this.equalsToken("CURRENT_USER", name)) {
                    r = this.readFunctionWithoutParameters("USER");
                    break;
                }
                if (this.equalsToken("CURRENT", name)) {
                    if (this.readIf("TIMESTAMP")) {
                        r = this.readFunctionWithoutParameters("CURRENT_TIMESTAMP");
                        break;
                    }
                    if (this.readIf("TIME")) {
                        r = this.readFunctionWithoutParameters("CURRENT_TIME");
                        break;
                    }
                    if (this.readIf("DATE")) {
                        r = this.readFunctionWithoutParameters("CURRENT_DATE");
                        break;
                    }
                    r = new ExpressionColumn(this.database, null, null, name);
                    break;
                }
                if (this.equalsToken("NEXT", name) && this.readIf("VALUE")) {
                    this.read("FOR");
                    Sequence sequence = this.readSequence();
                    r = new SequenceValue(sequence);
                    break;
                }
                if (this.currentTokenType == 5 && this.currentValue.getType() == 13) {
                    if (this.equalsToken("DATE", name)) {
                        String date = this.currentValue.getString();
                        this.read();
                        r = ValueExpression.get(ValueDate.parse(date));
                        break;
                    }
                    if (this.equalsToken("TIME", name)) {
                        String time = this.currentValue.getString();
                        this.read();
                        r = ValueExpression.get(ValueTime.parse(time));
                        break;
                    }
                    if (this.equalsToken("TIMESTAMP", name)) {
                        String timestamp = this.currentValue.getString();
                        this.read();
                        r = ValueExpression.get(ValueTimestamp.parse(timestamp));
                        break;
                    }
                    if (this.equalsToken("X", name)) {
                        this.read();
                        byte[] buffer = StringUtils.convertHexToBytes(this.currentValue.getString());
                        r = ValueExpression.get(ValueBytes.getNoCopy(buffer));
                        break;
                    }
                    if (this.equalsToken("E", name)) {
                        String text = this.currentValue.getString();
                        text = StringUtils.replaceAll(text, "\\\\", "\\");
                        this.read();
                        r = ValueExpression.get(ValueString.get(text));
                        break;
                    }
                    if (this.equalsToken("N", name)) {
                        String text = this.currentValue.getString();
                        this.read();
                        r = ValueExpression.get(ValueString.get(text));
                        break;
                    }
                    r = new ExpressionColumn(this.database, null, null, name);
                    break;
                }
                r = new ExpressionColumn(this.database, null, null, name);
                break;
            }
            case 13: {
                this.read();
                if (this.currentTokenType == 5) {
                    r = ValueExpression.get(this.currentValue.negate());
                    if (((Expression)r).getType() == 5 && ((Expression)r).getValue(this.session).getLong() == Integer.MIN_VALUE) {
                        r = ValueExpression.get(ValueInt.get(Integer.MIN_VALUE));
                    } else if (((Expression)r).getType() == 6 && ((Expression)r).getValue(this.session).getBigDecimal().compareTo(ValueLong.MIN_BD) == 0) {
                        r = ValueExpression.get(ValueLong.get(Long.MIN_VALUE));
                    }
                    this.read();
                    break;
                }
                r = new Operation(5, this.readTerm(), null);
                break;
            }
            case 14: {
                this.read();
                r = this.readTerm();
                break;
            }
            case 16: {
                this.read();
                if (this.readIf(")")) {
                    r = new ExpressionList(new Expression[0]);
                    break;
                }
                r = this.readExpression();
                if (this.readIf(",")) {
                    ArrayList<Expression> list = New.arrayList();
                    list.add(r);
                    while (!this.readIf(")")) {
                        r = this.readExpression();
                        list.add(r);
                        if (this.readIf(",")) continue;
                        this.read(")");
                        break;
                    }
                    Expression[] array = new Expression[list.size()];
                    list.toArray(array);
                    r = new ExpressionList(array);
                    break;
                }
                this.read(")");
                break;
            }
            case 19: {
                this.read();
                r = ValueExpression.get(ValueBoolean.get(true));
                break;
            }
            case 20: {
                this.read();
                r = ValueExpression.get(ValueBoolean.get(false));
                break;
            }
            case 23: {
                this.read();
                r = this.readFunctionWithoutParameters("CURRENT_TIME");
                break;
            }
            case 22: {
                this.read();
                r = this.readFunctionWithoutParameters("CURRENT_DATE");
                break;
            }
            case 21: {
                Function function2 = Function.getFunction(this.database, "CURRENT_TIMESTAMP");
                this.read();
                if (this.readIf("(") && !this.readIf(")")) {
                    function2.setParameter(0, this.readExpression());
                    this.read(")");
                }
                function2.doneWithParameters();
                r = function2;
                break;
            }
            case 24: {
                this.read();
                if (this.readIf("(")) {
                    this.read(")");
                }
                r = new Rownum(this.currentSelect == null ? this.currentPrepared : this.currentSelect);
                break;
            }
            case 18: {
                this.read();
                r = ValueExpression.getNull();
                break;
            }
            case 5: {
                r = ValueExpression.get(this.currentValue);
                this.read();
                break;
            }
            default: {
                throw this.getSyntaxError();
            }
        }
        if (this.readIf("[")) {
            Function function3 = Function.getFunction(this.database, "ARRAY_GET");
            function3.setParameter(0, r);
            r = this.readExpression();
            r = new Operation(1, r, ValueExpression.get(ValueInt.get(1)));
            function3.setParameter(1, r);
            r = function3;
            this.read("]");
        }
        if (this.readIf("::")) {
            if (this.readIf("REGCLASS")) {
                FunctionAlias f = this.findFunctionAlias("PUBLIC", "PG_GET_OID");
                if (f == null) {
                    throw this.getSyntaxError();
                }
                Expression[] args = new Expression[]{r};
                JavaFunction func = new JavaFunction(f, args);
                r = func;
            } else {
                Column col = this.parseColumnWithType(null);
                function = Function.getFunction(this.database, "CAST");
                function.setDataType(col);
                function.setParameter(0, r);
                r = function;
            }
        }
        return r;
    }

    private Expression readWhen(Expression left) {
        if (this.readIf("END")) {
            this.readIf("CASE");
            return ValueExpression.getNull();
        }
        if (this.readIf("ELSE")) {
            Expression elsePart = this.readExpression();
            this.read("END");
            this.readIf("CASE");
            return elsePart;
        }
        this.readIf("WHEN");
        Expression when = this.readExpression();
        if (left != null) {
            when = new Comparison(this.session, 0, left, when);
        }
        this.read("THEN");
        Expression then = this.readExpression();
        Expression elsePart = this.readWhen(left);
        Function function = Function.getFunction(this.session.getDatabase(), "CASEWHEN");
        function.setParameter(0, when);
        function.setParameter(1, then);
        function.setParameter(2, elsePart);
        function.doneWithParameters();
        return function;
    }

    private int getPositiveInt() {
        int v = this.getInt();
        if (v < 0) {
            throw DbException.getInvalidValueException("positive integer", v);
        }
        return v;
    }

    private int getInt() {
        boolean minus = false;
        if (this.currentTokenType == 13) {
            minus = true;
            this.read();
        } else if (this.currentTokenType == 14) {
            this.read();
        }
        if (this.currentTokenType != 5 || this.currentValue.getType() != 4) {
            throw DbException.getSyntaxError(this.sqlCommand, this.parseIndex, "integer");
        }
        int i = this.currentValue.getInt();
        this.read();
        return minus ? -i : i;
    }

    private long readLong() {
        boolean minus = false;
        if (this.currentTokenType == 13) {
            minus = true;
            this.read();
        }
        if (this.currentTokenType != 5 || this.currentValue.getType() != 4 && this.currentValue.getType() != 5) {
            throw DbException.getSyntaxError(this.sqlCommand, this.parseIndex, "long");
        }
        long i = this.currentValue.getLong();
        this.read();
        return minus ? -i : i;
    }

    private boolean readBooleanSetting() {
        if (this.currentTokenType == 5) {
            boolean result = this.currentValue.getBoolean();
            this.read();
            return result;
        }
        if (this.readIf("TRUE") || this.readIf("ON")) {
            return true;
        }
        if (this.readIf("FALSE") || this.readIf("OFF")) {
            return false;
        }
        throw this.getSyntaxError();
    }

    private String readString() {
        Expression expr = this.readExpression().optimize(this.session);
        if (!(expr instanceof ValueExpression)) {
            throw DbException.getSyntaxError(this.sqlCommand, this.parseIndex, "string");
        }
        String s = expr.getValue(this.session).getString();
        return s;
    }

    private String readIdentifierWithSchema(String defaultSchemaName) {
        if (this.currentTokenType != 2) {
            throw DbException.getSyntaxError(this.sqlCommand, this.parseIndex, "identifier");
        }
        String s = this.currentToken;
        this.read();
        this.schemaName = defaultSchemaName;
        if (this.readIf(".")) {
            this.schemaName = s;
            if (this.currentTokenType != 2) {
                throw DbException.getSyntaxError(this.sqlCommand, this.parseIndex, "identifier");
            }
            s = this.currentToken;
            this.read();
        }
        if (this.equalsToken(".", this.currentToken) && this.equalsToken(this.schemaName, this.database.getShortName())) {
            this.read(".");
            this.schemaName = s;
            if (this.currentTokenType != 2) {
                throw DbException.getSyntaxError(this.sqlCommand, this.parseIndex, "identifier");
            }
            s = this.currentToken;
            this.read();
        }
        return s;
    }

    private String readIdentifierWithSchema() {
        return this.readIdentifierWithSchema(this.session.getCurrentSchemaName());
    }

    private String readAliasIdentifier() {
        return this.readColumnIdentifier();
    }

    private String readUniqueIdentifier() {
        return this.readColumnIdentifier();
    }

    private String readColumnIdentifier() {
        if (this.currentTokenType != 2) {
            throw DbException.getSyntaxError(this.sqlCommand, this.parseIndex, "identifier");
        }
        String s = this.currentToken;
        this.read();
        return s;
    }

    private void read(String expected) {
        if (this.currentTokenQuoted || !this.equalsToken(expected, this.currentToken)) {
            this.addExpected(expected);
            throw this.getSyntaxError();
        }
        this.read();
    }

    private boolean readIf(String token) {
        if (!this.currentTokenQuoted && this.equalsToken(token, this.currentToken)) {
            this.read();
            return true;
        }
        this.addExpected(token);
        return false;
    }

    private boolean isToken(String token) {
        boolean result;
        boolean bl = result = this.equalsToken(token, this.currentToken) && !this.currentTokenQuoted;
        if (result) {
            return true;
        }
        this.addExpected(token);
        return false;
    }

    private boolean equalsToken(String a, String b) {
        if (a == null) {
            return b == null;
        }
        if (a.equals(b)) {
            return true;
        }
        return !this.identifiersToUpper && a.equalsIgnoreCase(b);
    }

    private void addExpected(String token) {
        if (this.expectedList != null) {
            this.expectedList.add(token);
        }
    }

    private void read() {
        this.currentTokenQuoted = false;
        if (this.expectedList != null) {
            this.expectedList.clear();
        }
        int[] types = this.characterTypes;
        this.lastParseIndex = this.parseIndex;
        int i = this.parseIndex;
        int type = types[i];
        while (type == 0) {
            type = types[++i];
        }
        int start = i;
        char[] chars = this.sqlCommandChars;
        char c = chars[i++];
        this.currentToken = "";
        switch (type) {
            case 4: {
                while ((type = types[i]) == 4 || type == 2) {
                    ++i;
                }
                this.currentToken = StringUtils.fromCacheOrNew(this.sqlCommand.substring(start, i));
                this.currentTokenType = this.getTokenType(this.currentToken);
                this.parseIndex = i;
                return;
            }
            case 3: {
                String result = null;
                while (true) {
                    int begin = ++i;
                    while (true) {
                        if (chars[i] == '\"') {
                            if (result == null) {
                                result = this.sqlCommand.substring(begin, i);
                                break;
                            }
                            result = result + this.sqlCommand.substring(begin - 1, i);
                            break;
                        }
                        ++i;
                    }
                    if (chars[++i] != '\"') break;
                }
                this.currentToken = StringUtils.fromCacheOrNew(result);
                this.parseIndex = i;
                this.currentTokenQuoted = true;
                this.currentTokenType = 2;
                return;
            }
            case 6: {
                if (types[i] == 6) {
                    ++i;
                }
                this.currentToken = this.sqlCommand.substring(start, i);
                this.currentTokenType = this.getSpecialType(this.currentToken);
                this.parseIndex = i;
                return;
            }
            case 5: {
                this.currentToken = this.sqlCommand.substring(start, i);
                this.currentTokenType = this.getSpecialType(this.currentToken);
                this.parseIndex = i;
                return;
            }
            case 2: {
                if (c == '0' && chars[i] == 'X') {
                    long number = 0L;
                    start += 2;
                    ++i;
                    while (true) {
                        if (!((c = chars[i]) >= '0' && c <= '9' || c >= 'A' && c <= 'F')) {
                            this.checkLiterals(false);
                            this.currentValue = ValueInt.get((int)number);
                            this.currentTokenType = 5;
                            this.currentToken = "0";
                            this.parseIndex = i;
                            return;
                        }
                        if ((number = (number << 4) + (long)c - (long)(c >= 'A' ? 55 : 48)) > Integer.MAX_VALUE) {
                            this.readHexDecimal(start, i);
                            return;
                        }
                        ++i;
                    }
                }
                long number = c - 48;
                while (true) {
                    if ((c = chars[i]) < '0' || c > '9') {
                        if (c == '.') {
                            this.readDecimal(start, i);
                            break;
                        }
                        if (c == 'E') {
                            this.readDecimal(start, i);
                            break;
                        }
                        this.checkLiterals(false);
                        this.currentValue = ValueInt.get((int)number);
                        this.currentTokenType = 5;
                        this.currentToken = "0";
                        this.parseIndex = i;
                        break;
                    }
                    if ((number = number * 10L + (long)(c - 48)) > Integer.MAX_VALUE) {
                        this.readDecimal(start, i);
                        break;
                    }
                    ++i;
                }
                return;
            }
            case 8: {
                if (types[i] != 2) {
                    this.currentTokenType = 1;
                    this.currentToken = ".";
                    this.parseIndex = i;
                    return;
                }
                this.readDecimal(i - 1, i);
                return;
            }
            case 7: {
                String result = null;
                while (true) {
                    int begin = ++i;
                    while (true) {
                        if (chars[i] == '\'') {
                            if (result == null) {
                                result = this.sqlCommand.substring(begin, i);
                                break;
                            }
                            result = result + this.sqlCommand.substring(begin - 1, i);
                            break;
                        }
                        ++i;
                    }
                    if (chars[++i] != '\'') break;
                }
                this.currentToken = "'";
                this.checkLiterals(true);
                this.currentValue = ValueString.get(StringUtils.fromCacheOrNew(result));
                this.parseIndex = i;
                this.currentTokenType = 5;
                return;
            }
            case 9: {
                String result = null;
                int begin = i - 1;
                while (types[i] == 9) {
                    ++i;
                }
                result = this.sqlCommand.substring(begin, i);
                this.currentToken = "'";
                this.checkLiterals(true);
                this.currentValue = ValueString.get(StringUtils.fromCacheOrNew(result));
                this.parseIndex = i;
                this.currentTokenType = 5;
                return;
            }
            case 1: {
                this.currentToken = "";
                this.currentTokenType = 4;
                this.parseIndex = i;
                return;
            }
        }
        throw this.getSyntaxError();
    }

    private void checkLiterals(boolean text) {
        int allowed;
        if (!this.session.getAllowLiterals() && ((allowed = this.database.getAllowLiterals()) == 0 || text && allowed != 2)) {
            throw DbException.get(90116);
        }
    }

    private void readHexDecimal(int start, int i) {
        char c;
        char[] chars = this.sqlCommandChars;
        while ((c = chars[++i]) >= '0' && c <= '9' || c >= 'A' && c <= 'F') {
        }
        this.parseIndex = i;
        String sub = this.sqlCommand.substring(start, i);
        BigDecimal bd = new BigDecimal(new BigInteger(sub, 16));
        this.checkLiterals(false);
        this.currentValue = ValueDecimal.get(bd);
        this.currentTokenType = 5;
    }

    private void readDecimal(int start, int i) {
        BigDecimal bd;
        BigInteger bi;
        int t;
        char[] chars = this.sqlCommandChars;
        int[] types = this.characterTypes;
        while ((t = types[i]) == 8 || t == 2) {
            ++i;
        }
        boolean containsE = false;
        if (chars[i] == 'E' || chars[i] == 'e') {
            containsE = true;
            if (chars[++i] == '+' || chars[i] == '-') {
                ++i;
            }
            if (types[i] != 2) {
                throw this.getSyntaxError();
            }
            while (types[++i] == 2) {
            }
        }
        this.parseIndex = i;
        String sub = this.sqlCommand.substring(start, i);
        this.checkLiterals(false);
        if (!containsE && sub.indexOf(46) < 0 && (bi = new BigInteger(sub)).compareTo(ValueLong.MAX) <= 0) {
            this.currentValue = ValueLong.get(bi.longValue());
            this.currentTokenType = 5;
            return;
        }
        try {
            bd = new BigDecimal(sub);
        }
        catch (NumberFormatException e) {
            throw DbException.get(22018, e, sub);
        }
        this.currentValue = ValueDecimal.get(bd);
        this.currentTokenType = 5;
    }

    public Session getSession() {
        return this.session;
    }

    private void initialize(String sql) {
        if (sql == null) {
            sql = "";
        }
        this.originalSQL = sql;
        this.sqlCommand = sql;
        int len = sql.length() + 1;
        char[] command = new char[len];
        int[] types = new int[len];
        sql.getChars(0, --len, command, 0);
        boolean changed = false;
        command[len] = 32;
        int startLoop = 0;
        int lastType = 0;
        for (int i = 0; i < len; ++i) {
            char c = command[i];
            int type = 0;
            switch (c) {
                case '/': {
                    if (command[i + 1] == '*') {
                        changed = true;
                        command[i] = 32;
                        command[i + 1] = 32;
                        startLoop = i;
                        this.checkRunOver(i += 2, len, startLoop);
                        while (command[i] != '*' || command[i + 1] != '/') {
                            command[i++] = 32;
                            this.checkRunOver(i, len, startLoop);
                        }
                        command[i] = 32;
                        command[i + 1] = 32;
                        ++i;
                        break;
                    }
                    if (command[i + 1] == '/') {
                        changed = true;
                        startLoop = i;
                        while ((c = command[i]) != '\n' && c != '\r' && i < len - 1) {
                            command[i++] = 32;
                            this.checkRunOver(i, len, startLoop);
                        }
                        break;
                    }
                    type = 5;
                    break;
                }
                case '-': {
                    if (command[i + 1] == '-') {
                        changed = true;
                        startLoop = i;
                        while ((c = command[i]) != '\n' && c != '\r' && i < len - 1) {
                            command[i++] = 32;
                            this.checkRunOver(i, len, startLoop);
                        }
                        break;
                    }
                    type = 5;
                    break;
                }
                case '$': {
                    if (command[i + 1] == '$' && (i == 0 || command[i - 1] <= ' ')) {
                        changed = true;
                        command[i] = 32;
                        command[i + 1] = 32;
                        startLoop = i;
                        this.checkRunOver(i += 2, len, startLoop);
                        while (command[i] != '$' || command[i + 1] != '$') {
                            types[i++] = 9;
                            this.checkRunOver(i, len, startLoop);
                        }
                        command[i] = 32;
                        command[i + 1] = 32;
                        ++i;
                        break;
                    }
                    if (lastType == 4 || lastType == 2) {
                        type = 4;
                        break;
                    }
                    type = 5;
                    break;
                }
                case '%': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case ';': 
                case '?': 
                case '@': 
                case ']': 
                case '{': 
                case '}': {
                    type = 5;
                    break;
                }
                case '!': 
                case ':': 
                case '<': 
                case '=': 
                case '>': 
                case '|': 
                case '~': {
                    type = 6;
                    break;
                }
                case '.': {
                    type = 8;
                    break;
                }
                case '\'': {
                    types[i] = 7;
                    type = 7;
                    startLoop = i;
                    while (command[++i] != '\'') {
                        this.checkRunOver(i, len, startLoop);
                    }
                    break;
                }
                case '[': {
                    if (this.database.getMode().squareBracketQuotedNames) {
                        command[i] = 34;
                        changed = true;
                        types[i] = 3;
                        type = 3;
                        startLoop = i;
                        while (command[++i] != ']') {
                            this.checkRunOver(i, len, startLoop);
                        }
                        command[i] = 34;
                        break;
                    }
                    type = 5;
                    break;
                }
                case '`': {
                    command[i] = 34;
                    changed = true;
                    types[i] = 3;
                    type = 3;
                    startLoop = i;
                    while (command[++i] != '`') {
                        this.checkRunOver(i, len, startLoop);
                        c = command[i];
                        command[i] = Character.toUpperCase(c);
                    }
                    command[i] = 34;
                    break;
                }
                case '\"': {
                    types[i] = 3;
                    type = 3;
                    startLoop = i;
                    while (command[++i] != '\"') {
                        this.checkRunOver(i, len, startLoop);
                    }
                    break;
                }
                case '_': {
                    type = 4;
                    break;
                }
                default: {
                    if (c >= 'a' && c <= 'z') {
                        if (this.identifiersToUpper) {
                            command[i] = (char)(c - 32);
                            changed = true;
                        }
                        type = 4;
                        break;
                    }
                    if (c >= 'A' && c <= 'Z') {
                        type = 4;
                        break;
                    }
                    if (c >= '0' && c <= '9') {
                        type = 2;
                        break;
                    }
                    if (c <= ' ' || Character.isSpaceChar(c)) break;
                    if (Character.isJavaIdentifierPart(c)) {
                        char u;
                        type = 4;
                        if (!this.identifiersToUpper || (u = Character.toUpperCase(c)) == c) break;
                        command[i] = u;
                        changed = true;
                        break;
                    }
                    type = 5;
                }
            }
            types[i] = type;
            lastType = type;
        }
        this.sqlCommandChars = command;
        types[len] = 1;
        this.characterTypes = types;
        if (changed) {
            this.sqlCommand = new String(command);
        }
        this.parseIndex = 0;
    }

    private void checkRunOver(int i, int len, int startLoop) {
        if (i >= len) {
            this.parseIndex = startLoop;
            throw this.getSyntaxError();
        }
    }

    private int getSpecialType(String s) {
        char c0 = s.charAt(0);
        if (s.length() == 1) {
            switch (c0) {
                case '$': 
                case '?': {
                    return 3;
                }
                case '@': {
                    return 12;
                }
                case '+': {
                    return 14;
                }
                case '-': {
                    return 13;
                }
                case '%': 
                case '*': 
                case ',': 
                case '/': 
                case ':': 
                case ';': 
                case '[': 
                case ']': 
                case '{': 
                case '}': 
                case '~': {
                    return 1;
                }
                case '(': {
                    return 16;
                }
                case ')': {
                    return 17;
                }
                case '<': {
                    return 9;
                }
                case '>': {
                    return 8;
                }
                case '=': {
                    return 6;
                }
            }
        } else if (s.length() == 2) {
            switch (c0) {
                case ':': {
                    if ("::".equals(s)) {
                        return 1;
                    }
                    if (!":=".equals(s)) break;
                    return 1;
                }
                case '>': {
                    if (!">=".equals(s)) break;
                    return 7;
                }
                case '<': {
                    if ("<=".equals(s)) {
                        return 10;
                    }
                    if (!"<>".equals(s)) break;
                    return 11;
                }
                case '!': {
                    if ("!=".equals(s)) {
                        return 11;
                    }
                    if (!"!~".equals(s)) break;
                    return 1;
                }
                case '|': {
                    if (!"||".equals(s)) break;
                    return 15;
                }
            }
        }
        throw this.getSyntaxError();
    }

    private int getTokenType(String s) {
        int len = s.length();
        if (len == 0) {
            throw this.getSyntaxError();
        }
        if (!this.identifiersToUpper) {
            s = StringUtils.toUpperEnglish(s);
        }
        return Parser.getSaveTokenType(s, this.database.getMode().supportOffsetFetch);
    }

    private boolean isKeyword(String s) {
        if (!this.identifiersToUpper) {
            s = StringUtils.toUpperEnglish(s);
        }
        return Parser.isKeyword(s, false);
    }

    public static boolean isKeyword(String s, boolean supportOffsetFetch) {
        if (s == null || s.length() == 0) {
            return false;
        }
        return Parser.getSaveTokenType(s, supportOffsetFetch) != 2;
    }

    private static int getSaveTokenType(String s, boolean supportOffsetFetch) {
        switch (s.charAt(0)) {
            case 'C': {
                if (s.equals("CURRENT_TIMESTAMP")) {
                    return 21;
                }
                if (s.equals("CURRENT_TIME")) {
                    return 23;
                }
                if (s.equals("CURRENT_DATE")) {
                    return 22;
                }
                return Parser.getKeywordOrIdentifier(s, "CROSS", 1);
            }
            case 'D': {
                return Parser.getKeywordOrIdentifier(s, "DISTINCT", 1);
            }
            case 'E': {
                if ("EXCEPT".equals(s)) {
                    return 1;
                }
                return Parser.getKeywordOrIdentifier(s, "EXISTS", 1);
            }
            case 'F': {
                if ("FROM".equals(s)) {
                    return 1;
                }
                if ("FOR".equals(s)) {
                    return 1;
                }
                if ("FULL".equals(s)) {
                    return 1;
                }
                if (supportOffsetFetch && "FETCH".equals(s)) {
                    return 1;
                }
                return Parser.getKeywordOrIdentifier(s, "FALSE", 20);
            }
            case 'G': {
                return Parser.getKeywordOrIdentifier(s, "GROUP", 1);
            }
            case 'H': {
                return Parser.getKeywordOrIdentifier(s, "HAVING", 1);
            }
            case 'I': {
                if ("INNER".equals(s)) {
                    return 1;
                }
                if ("INTERSECT".equals(s)) {
                    return 1;
                }
                return Parser.getKeywordOrIdentifier(s, "IS", 1);
            }
            case 'J': {
                return Parser.getKeywordOrIdentifier(s, "JOIN", 1);
            }
            case 'L': {
                if ("LIMIT".equals(s)) {
                    return 1;
                }
                return Parser.getKeywordOrIdentifier(s, "LIKE", 1);
            }
            case 'M': {
                return Parser.getKeywordOrIdentifier(s, "MINUS", 1);
            }
            case 'N': {
                if ("NOT".equals(s)) {
                    return 1;
                }
                if ("NATURAL".equals(s)) {
                    return 1;
                }
                return Parser.getKeywordOrIdentifier(s, "NULL", 18);
            }
            case 'O': {
                if ("ON".equals(s)) {
                    return 1;
                }
                if (supportOffsetFetch && "OFFSET".equals(s)) {
                    return 1;
                }
                return Parser.getKeywordOrIdentifier(s, "ORDER", 1);
            }
            case 'P': {
                return Parser.getKeywordOrIdentifier(s, "PRIMARY", 1);
            }
            case 'R': {
                return Parser.getKeywordOrIdentifier(s, "ROWNUM", 24);
            }
            case 'S': {
                if (s.equals("SYSTIMESTAMP")) {
                    return 21;
                }
                if (s.equals("SYSTIME")) {
                    return 23;
                }
                if (s.equals("SYSDATE")) {
                    return 21;
                }
                return Parser.getKeywordOrIdentifier(s, "SELECT", 1);
            }
            case 'T': {
                if ("TODAY".equals(s)) {
                    return 22;
                }
                return Parser.getKeywordOrIdentifier(s, "TRUE", 19);
            }
            case 'U': {
                if ("UNIQUE".equals(s)) {
                    return 1;
                }
                return Parser.getKeywordOrIdentifier(s, "UNION", 1);
            }
            case 'W': {
                return Parser.getKeywordOrIdentifier(s, "WHERE", 1);
            }
        }
        return 2;
    }

    private static int getKeywordOrIdentifier(String s1, String s2, int keywordType) {
        if (s1.equals(s2)) {
            return keywordType;
        }
        return 2;
    }

    private Column parseColumnForTable(String columnName, boolean defaultNullable) {
        String comment;
        Column column;
        boolean isIdentity = false;
        if (this.readIf("IDENTITY") || this.readIf("SERIAL")) {
            column = new Column(columnName, 5);
            column.setOriginalSQL("IDENTITY");
            this.parseAutoIncrement(column);
            column.setPrimaryKey(true);
        } else {
            column = this.parseColumnWithType(columnName);
        }
        if (this.readIf("NOT")) {
            this.read("NULL");
            column.setNullable(false);
        } else if (this.readIf("NULL")) {
            column.setNullable(true);
        } else {
            column.setNullable(defaultNullable & column.isNullable());
        }
        if (this.readIf("AS")) {
            if (isIdentity) {
                this.getSyntaxError();
            }
            Expression expr = this.readExpression();
            column.setComputedExpression(expr);
        } else if (this.readIf("DEFAULT")) {
            Expression defaultExpression = this.readExpression();
            column.setDefaultExpression(this.session, defaultExpression);
        } else if (this.readIf("GENERATED")) {
            if (!this.readIf("ALWAYS")) {
                this.read("BY");
                this.read("DEFAULT");
            }
            this.read("AS");
            this.read("IDENTITY");
            long start = 1L;
            long increment = 1L;
            if (this.readIf("(")) {
                this.read("START");
                this.readIf("WITH");
                start = this.readLong();
                this.readIf(",");
                if (this.readIf("INCREMENT")) {
                    this.readIf("BY");
                    increment = this.readLong();
                }
                this.read(")");
            }
            column.setPrimaryKey(true);
            column.setAutoIncrement(true, start, increment);
        }
        if (this.readIf("NOT")) {
            this.read("NULL");
            column.setNullable(false);
        } else {
            this.readIf("NULL");
        }
        if (this.readIf("AUTO_INCREMENT")) {
            this.parseAutoIncrement(column);
            if (this.readIf("NOT")) {
                this.read("NULL");
            }
        } else if (this.readIf("IDENTITY")) {
            this.parseAutoIncrement(column);
            column.setPrimaryKey(true);
            if (this.readIf("NOT")) {
                this.read("NULL");
            }
        }
        if (this.readIf("NULL_TO_DEFAULT")) {
            column.setConvertNullToDefault(true);
        }
        if (this.readIf("SEQUENCE")) {
            Sequence sequence = this.readSequence();
            column.setSequence(sequence);
        }
        if (this.readIf("SELECTIVITY")) {
            int value = this.getPositiveInt();
            column.setSelectivity(value);
        }
        if ((comment = this.readCommentIf()) != null) {
            column.setComment(comment);
        }
        return column;
    }

    private void parseAutoIncrement(Column column) {
        long start = 1L;
        long increment = 1L;
        if (this.readIf("(")) {
            start = this.readLong();
            if (this.readIf(",")) {
                increment = this.readLong();
            }
            this.read(")");
        }
        column.setAutoIncrement(true, start, increment);
    }

    private String readCommentIf() {
        if (this.readIf("COMMENT")) {
            this.readIf("IS");
            return this.readString();
        }
        return null;
    }

    private Column parseColumnWithType(String columnName) {
        DataType dataType;
        UserDataType userDataType;
        String original = this.currentToken;
        boolean regular = false;
        if (this.readIf("LONG")) {
            if (this.readIf("RAW")) {
                original = original + " RAW";
            }
        } else if (this.readIf("DOUBLE")) {
            if (this.readIf("PRECISION")) {
                original = original + " PRECISION";
            }
        } else if (this.readIf("CHARACTER")) {
            if (this.readIf("VARYING")) {
                original = original + " VARYING";
            }
        } else {
            regular = true;
        }
        long precision = -1L;
        int displaySize = -1;
        int scale = -1;
        String comment = null;
        Column templateColumn = null;
        if (!this.identifiersToUpper) {
            original = StringUtils.toUpperEnglish(original);
        }
        if ((userDataType = this.database.findUserDataType(original)) != null) {
            templateColumn = userDataType.getColumn();
            dataType = DataType.getDataType(templateColumn.getType());
            comment = templateColumn.getComment();
            original = templateColumn.getOriginalSQL();
            precision = templateColumn.getPrecision();
            displaySize = templateColumn.getDisplaySize();
            scale = templateColumn.getScale();
        } else {
            dataType = DataType.getTypeByName(original);
            if (dataType == null) {
                throw DbException.get(50004, this.currentToken);
            }
        }
        if (this.database.getIgnoreCase() && dataType.type == 13 && !this.equalsToken("VARCHAR_CASESENSITIVE", original)) {
            original = "VARCHAR_IGNORECASE";
            dataType = DataType.getTypeByName(original);
        }
        if (regular) {
            this.read();
        }
        precision = precision == -1L ? dataType.defaultPrecision : precision;
        displaySize = displaySize == -1 ? dataType.defaultDisplaySize : displaySize;
        int n = scale = scale == -1 ? dataType.defaultScale : scale;
        if (dataType.supportsPrecision || dataType.supportsScale) {
            if (this.readIf("(")) {
                if (!this.readIf("MAX")) {
                    long p = this.readLong();
                    if (this.readIf("K")) {
                        p *= 1024L;
                    } else if (this.readIf("M")) {
                        p *= 0x100000L;
                    } else if (this.readIf("G")) {
                        p *= 0x40000000L;
                    }
                    if (p > Long.MAX_VALUE) {
                        p = Long.MAX_VALUE;
                    }
                    original = original + "(" + p;
                    this.readIf("CHAR");
                    if (dataType.supportsScale) {
                        if (this.readIf(",")) {
                            scale = this.getInt();
                            original = original + ", " + scale;
                        } else if (dataType.type == 11) {
                            scale = MathUtils.convertLongToInt(p);
                            p = precision;
                        } else {
                            scale = 0;
                        }
                    }
                    precision = p;
                    displaySize = MathUtils.convertLongToInt(precision);
                    original = original + ")";
                }
                this.read(")");
            }
        } else if (this.readIf("(")) {
            this.getPositiveInt();
            this.read(")");
        }
        if (this.readIf("FOR")) {
            this.read("BIT");
            this.read("DATA");
            if (dataType.type == 13) {
                dataType = DataType.getTypeByName("BINARY");
            }
        }
        this.readIf("UNSIGNED");
        int type = dataType.type;
        if ((long)scale > precision) {
            throw DbException.get(90008, Integer.toString(scale), "scale (precision = " + precision + ")");
        }
        Column column = new Column(columnName, type, precision, scale, displaySize);
        if (templateColumn != null) {
            Expression checkConstraint;
            column.setNullable(templateColumn.isNullable());
            column.setDefaultExpression(this.session, templateColumn.getDefaultExpression());
            int selectivity = templateColumn.getSelectivity();
            if (selectivity != 50) {
                column.setSelectivity(selectivity);
            }
            if ((checkConstraint = templateColumn.getCheckConstraint(this.session, columnName)) != null) {
                column.addCheckConstraint(this.session, checkConstraint);
            }
        }
        column.setComment(comment);
        column.setOriginalSQL(original);
        return column;
    }

    private Prepared parseCreate() {
        boolean orReplace = false;
        if (this.readIf("OR")) {
            this.read("REPLACE");
            orReplace = true;
        }
        boolean force = this.readIf("FORCE");
        if (this.readIf("VIEW")) {
            return this.parseCreateView(force, orReplace);
        }
        if (this.readIf("ALIAS")) {
            return this.parseCreateFunctionAlias(force);
        }
        if (this.readIf("SEQUENCE")) {
            return this.parseCreateSequence();
        }
        if (this.readIf("USER")) {
            return this.parseCreateUser();
        }
        if (this.readIf("TRIGGER")) {
            return this.parseCreateTrigger(force);
        }
        if (this.readIf("ROLE")) {
            return this.parseCreateRole();
        }
        if (this.readIf("SCHEMA")) {
            return this.parseCreateSchema();
        }
        if (this.readIf("CONSTANT")) {
            return this.parseCreateConstant();
        }
        if (this.readIf("DOMAIN")) {
            return this.parseCreateUserDataType();
        }
        if (this.readIf("TYPE")) {
            return this.parseCreateUserDataType();
        }
        if (this.readIf("DATATYPE")) {
            return this.parseCreateUserDataType();
        }
        if (this.readIf("AGGREGATE")) {
            return this.parseCreateAggregate(force);
        }
        if (this.readIf("LINKED")) {
            return this.parseCreateLinkedTable(false, false, force);
        }
        boolean memory = false;
        boolean cached = false;
        if (this.readIf("MEMORY")) {
            memory = true;
        } else if (this.readIf("CACHED")) {
            cached = true;
        }
        if (this.readIf("LOCAL")) {
            this.read("TEMPORARY");
            if (this.readIf("LINKED")) {
                return this.parseCreateLinkedTable(true, false, force);
            }
            this.read("TABLE");
            return this.parseCreateTable(true, false, cached);
        }
        if (this.readIf("GLOBAL")) {
            this.read("TEMPORARY");
            if (this.readIf("LINKED")) {
                return this.parseCreateLinkedTable(true, true, force);
            }
            this.read("TABLE");
            return this.parseCreateTable(true, true, cached);
        }
        if (this.readIf("TEMP") || this.readIf("TEMPORARY")) {
            if (this.readIf("LINKED")) {
                return this.parseCreateLinkedTable(true, true, force);
            }
            this.read("TABLE");
            return this.parseCreateTable(true, true, cached);
        }
        if (this.readIf("TABLE")) {
            if (!cached && !memory) {
                cached = this.database.getDefaultTableType() == 0;
            }
            return this.parseCreateTable(false, false, cached);
        }
        boolean hash = false;
        boolean primaryKey = false;
        boolean unique = false;
        String indexName = null;
        Schema oldSchema = null;
        boolean ifNotExists = false;
        if (this.readIf("PRIMARY")) {
            this.read("KEY");
            if (this.readIf("HASH")) {
                hash = true;
            }
            primaryKey = true;
            if (!this.isToken("ON")) {
                ifNotExists = this.readIfNoExists();
                indexName = this.readIdentifierWithSchema(null);
                oldSchema = this.getSchema();
            }
        } else {
            if (this.readIf("UNIQUE")) {
                unique = true;
            }
            if (this.readIf("HASH")) {
                hash = true;
            }
            if (this.readIf("INDEX")) {
                if (!this.isToken("ON")) {
                    ifNotExists = this.readIfNoExists();
                    indexName = this.readIdentifierWithSchema(null);
                    oldSchema = this.getSchema();
                }
            } else {
                throw this.getSyntaxError();
            }
        }
        this.read("ON");
        String tableName = this.readIdentifierWithSchema();
        this.checkSchema(oldSchema);
        CreateIndex command = new CreateIndex(this.session, this.getSchema());
        command.setIfNotExists(ifNotExists);
        command.setHash(hash);
        command.setPrimaryKey(primaryKey);
        command.setTableName(tableName);
        command.setUnique(unique);
        command.setIndexName(indexName);
        command.setComment(this.readCommentIf());
        this.read("(");
        command.setIndexColumns(this.parseIndexColumnList());
        return command;
    }

    private boolean addRoleOrRight(GrantRevoke command) {
        if (this.readIf("SELECT")) {
            command.addRight(1);
            return false;
        }
        if (this.readIf("DELETE")) {
            command.addRight(2);
            return false;
        }
        if (this.readIf("INSERT")) {
            command.addRight(4);
            return false;
        }
        if (this.readIf("UPDATE")) {
            command.addRight(8);
            return false;
        }
        if (this.readIf("ALL")) {
            command.addRight(15);
            return false;
        }
        if (this.readIf("CONNECT")) {
            return false;
        }
        if (this.readIf("RESOURCE")) {
            return false;
        }
        command.addRoleName(this.readUniqueIdentifier());
        return true;
    }

    private GrantRevoke parseGrantRevoke(int operationType) {
        GrantRevoke command = new GrantRevoke(this.session);
        command.setOperationType(operationType);
        boolean isRoleBased = this.addRoleOrRight(command);
        while (this.readIf(",")) {
            boolean next = this.addRoleOrRight(command);
            if (next == isRoleBased) continue;
            throw DbException.get(90072);
        }
        if (!isRoleBased && this.readIf("ON")) {
            do {
                Table table = this.readTableOrView();
                command.addTable(table);
            } while (this.readIf(","));
        }
        if (operationType == 49) {
            this.read("TO");
        } else {
            this.read("FROM");
        }
        command.setGranteeName(this.readUniqueIdentifier());
        return command;
    }

    private Select parseValues() {
        Select command;
        this.currentSelect = command = new Select(this.session);
        TableFilter filter = this.parseValuesTable();
        ArrayList<Expression> list = New.arrayList();
        list.add(new Wildcard(null, null));
        command.setExpressions(list);
        command.addTableFilter(filter, true);
        command.init();
        return command;
    }

    private TableFilter parseValuesTable() {
        int i;
        Schema mainSchema = this.database.getSchema("PUBLIC");
        TableFunction tf = (TableFunction)Function.getFunction(this.database, "TABLE");
        ArrayList<Column> columns = New.arrayList();
        ArrayList rows = New.arrayList();
        do {
            int i2 = 0;
            ArrayList row = New.arrayList();
            boolean multiColumn = this.readIf("(");
            do {
                Column column;
                int displaySize;
                int scale;
                long prec;
                Expression expr = this.readExpression();
                expr = expr.optimize(this.session);
                int type = expr.getType();
                String columnName = "C" + (i2 + 1);
                if (rows.size() == 0) {
                    if (type == -1) {
                        type = 13;
                    }
                    DataType dt = DataType.getDataType(type);
                    prec = dt.defaultPrecision;
                    scale = dt.defaultScale;
                    displaySize = dt.defaultDisplaySize;
                    column = new Column(columnName, type, prec, scale, displaySize);
                    columns.add(column);
                }
                prec = expr.getPrecision();
                scale = expr.getScale();
                displaySize = expr.getDisplaySize();
                if (i2 >= columns.size()) {
                    throw DbException.get(21002);
                }
                Column c = (Column)columns.get(i2);
                type = Value.getHigherOrder(c.getType(), type);
                prec = Math.max(c.getPrecision(), prec);
                scale = Math.max(c.getScale(), scale);
                displaySize = Math.max(c.getDisplaySize(), displaySize);
                column = new Column(columnName, type, prec, scale, displaySize);
                columns.set(i2, column);
                row.add(expr);
                ++i2;
            } while (multiColumn && this.readIf(","));
            if (multiColumn) {
                this.read(")");
            }
            rows.add(row);
        } while (this.readIf(","));
        int columnCount = columns.size();
        int rowCount = rows.size();
        for (i = 0; i < rowCount; ++i) {
            if (((ArrayList)rows.get(i)).size() == columnCount) continue;
            throw DbException.get(21002);
        }
        for (i = 0; i < columnCount; ++i) {
            Column c = (Column)columns.get(i);
            if (c.getType() == -1) {
                c = new Column(c.getName(), 13, 0L, 0, 0);
                columns.set(i, c);
            }
            Expression[] array = new Expression[rowCount];
            for (int j = 0; j < rowCount; ++j) {
                array[j] = (Expression)((ArrayList)rows.get(j)).get(i);
            }
            ExpressionList list = new ExpressionList(array);
            tf.setParameter(i, list);
        }
        tf.setColumns(columns);
        tf.doneWithParameters();
        FunctionTable table = new FunctionTable(mainSchema, this.session, tf, tf);
        TableFilter filter = new TableFilter(this.session, table, null, this.rightsChecked, this.currentSelect);
        return filter;
    }

    private Call parseCall() {
        Call command = new Call(this.session);
        this.currentPrepared = command;
        command.setExpression(this.readExpression());
        return command;
    }

    private CreateRole parseCreateRole() {
        CreateRole command = new CreateRole(this.session);
        command.setIfNotExists(this.readIfNoExists());
        command.setRoleName(this.readUniqueIdentifier());
        return command;
    }

    private CreateSchema parseCreateSchema() {
        CreateSchema command = new CreateSchema(this.session);
        command.setIfNotExists(this.readIfNoExists());
        command.setSchemaName(this.readUniqueIdentifier());
        if (this.readIf("AUTHORIZATION")) {
            command.setAuthorization(this.readUniqueIdentifier());
        } else {
            command.setAuthorization(this.session.getUser().getName());
        }
        return command;
    }

    private CreateSequence parseCreateSequence() {
        boolean ifNotExists = this.readIfNoExists();
        String sequenceName = this.readIdentifierWithSchema();
        CreateSequence command = new CreateSequence(this.session, this.getSchema());
        command.setIfNotExists(ifNotExists);
        command.setSequenceName(sequenceName);
        while (true) {
            if (this.readIf("START")) {
                this.readIf("WITH");
                command.setStartWith(this.readExpression());
                continue;
            }
            if (this.readIf("INCREMENT")) {
                this.readIf("BY");
                command.setIncrement(this.readExpression());
                continue;
            }
            if (this.readIf("CACHE")) {
                command.setCacheSize(this.readExpression());
                continue;
            }
            if (!this.readIf("BELONGS_TO_TABLE")) break;
            command.setBelongsToTable(true);
        }
        return command;
    }

    private boolean readIfNoExists() {
        if (this.readIf("IF")) {
            this.read("NOT");
            this.read("EXISTS");
            return true;
        }
        return false;
    }

    private CreateConstant parseCreateConstant() {
        boolean ifNotExists = this.readIfNoExists();
        String constantName = this.readIdentifierWithSchema();
        Schema schema = this.getSchema();
        if (this.isKeyword(constantName)) {
            throw DbException.get(90114, constantName);
        }
        this.read("VALUE");
        Expression expr = this.readExpression();
        CreateConstant command = new CreateConstant(this.session, schema);
        command.setConstantName(constantName);
        command.setExpression(expr);
        command.setIfNotExists(ifNotExists);
        return command;
    }

    private CreateAggregate parseCreateAggregate(boolean force) {
        boolean ifNotExists = this.readIfNoExists();
        CreateAggregate command = new CreateAggregate(this.session);
        command.setForce(force);
        String name = this.readIdentifierWithSchema();
        if (this.isKeyword(name) || Function.getFunction(this.database, name) != null || this.getAggregateType(name) >= 0) {
            throw DbException.get(90076, name);
        }
        command.setName(name);
        command.setSchema(this.getSchema());
        command.setIfNotExists(ifNotExists);
        this.read("FOR");
        command.setJavaClassMethod(this.readUniqueIdentifier());
        return command;
    }

    private CreateUserDataType parseCreateUserDataType() {
        boolean ifNotExists = this.readIfNoExists();
        CreateUserDataType command = new CreateUserDataType(this.session);
        command.setTypeName(this.readUniqueIdentifier());
        this.read("AS");
        Column col = this.parseColumnForTable("VALUE", true);
        if (this.readIf("CHECK")) {
            Expression expr = this.readExpression();
            col.addCheckConstraint(this.session, expr);
        }
        col.rename(null);
        command.setColumn(col);
        command.setIfNotExists(ifNotExists);
        return command;
    }

    private CreateTrigger parseCreateTrigger(boolean force) {
        boolean insteadOf;
        boolean isBefore;
        boolean ifNotExists = this.readIfNoExists();
        String triggerName = this.readIdentifierWithSchema(null);
        Schema schema = this.getSchema();
        if (this.readIf("INSTEAD")) {
            this.read("OF");
            isBefore = true;
            insteadOf = true;
        } else if (this.readIf("BEFORE")) {
            insteadOf = false;
            isBefore = true;
        } else {
            this.read("AFTER");
            insteadOf = false;
            isBefore = false;
        }
        int typeMask = 0;
        boolean onRollback = false;
        do {
            if (this.readIf("INSERT")) {
                typeMask |= 1;
                continue;
            }
            if (this.readIf("UPDATE")) {
                typeMask |= 2;
                continue;
            }
            if (this.readIf("DELETE")) {
                typeMask |= 4;
                continue;
            }
            if (this.readIf("SELECT")) {
                typeMask |= 8;
                continue;
            }
            if (this.readIf("ROLLBACK")) {
                onRollback = true;
                continue;
            }
            throw this.getSyntaxError();
        } while (this.readIf(","));
        this.read("ON");
        String tableName = this.readIdentifierWithSchema();
        this.checkSchema(schema);
        CreateTrigger command = new CreateTrigger(this.session, this.getSchema());
        command.setForce(force);
        command.setTriggerName(triggerName);
        command.setIfNotExists(ifNotExists);
        command.setInsteadOf(insteadOf);
        command.setBefore(isBefore);
        command.setOnRollback(onRollback);
        command.setTypeMask(typeMask);
        command.setTableName(tableName);
        if (this.readIf("FOR")) {
            this.read("EACH");
            this.read("ROW");
            command.setRowBased(true);
        } else {
            command.setRowBased(false);
        }
        if (this.readIf("QUEUE")) {
            command.setQueueSize(this.getPositiveInt());
        }
        command.setNoWait(this.readIf("NOWAIT"));
        this.read("CALL");
        command.setTriggerClassName(this.readUniqueIdentifier());
        return command;
    }

    private CreateUser parseCreateUser() {
        CreateUser command = new CreateUser(this.session);
        command.setIfNotExists(this.readIfNoExists());
        command.setUserName(this.readUniqueIdentifier());
        command.setComment(this.readCommentIf());
        if (this.readIf("PASSWORD")) {
            command.setPassword(this.readExpression());
        } else if (this.readIf("SALT")) {
            command.setSalt(this.readExpression());
            this.read("HASH");
            command.setHash(this.readExpression());
        } else if (this.readIf("IDENTIFIED")) {
            this.read("BY");
            command.setPassword(ValueExpression.get(ValueString.get(this.readColumnIdentifier())));
        } else {
            throw this.getSyntaxError();
        }
        if (this.readIf("ADMIN")) {
            command.setAdmin(true);
        }
        return command;
    }

    private CreateFunctionAlias parseCreateFunctionAlias(boolean force) {
        boolean ifNotExists = this.readIfNoExists();
        String aliasName = this.readIdentifierWithSchema();
        if (this.isKeyword(aliasName) || Function.getFunction(this.database, aliasName) != null || this.getAggregateType(aliasName) >= 0) {
            throw DbException.get(90076, aliasName);
        }
        CreateFunctionAlias command = new CreateFunctionAlias(this.session, this.getSchema());
        command.setForce(force);
        command.setAliasName(aliasName);
        command.setIfNotExists(ifNotExists);
        command.setDeterministic(this.readIf("DETERMINISTIC"));
        if (this.readIf("AS")) {
            command.setSource(this.readString());
        } else {
            this.read("FOR");
            command.setJavaClassMethod(this.readUniqueIdentifier());
        }
        return command;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Query parserWith() {
        String querySQL;
        String[] cols;
        this.readIf("RECURSIVE");
        String tempViewName = this.readIdentifierWithSchema();
        Schema schema = this.getSchema();
        this.read("(");
        ArrayList columns = New.arrayList();
        for (String c : cols = this.parseColumnList()) {
            columns.add(new Column(c, 13));
        }
        Table old = this.session.findLocalTempTable(tempViewName);
        if (old != null) {
            if (!(old instanceof TableView)) {
                throw DbException.get(42101, tempViewName);
            }
            TableView tv = (TableView)old;
            if (!tv.isTableExpression()) {
                throw DbException.get(42101, tempViewName);
            }
            this.session.removeLocalTempTable(old);
        }
        CreateTableData data = new CreateTableData();
        data.id = this.database.allocateObjectId();
        data.columns = columns;
        data.tableName = tempViewName;
        data.temporary = true;
        data.persistData = true;
        data.persistIndexes = false;
        data.create = true;
        data.session = this.session;
        Table recursiveTable = schema.createTable(data);
        this.session.addLocalTempTable(recursiveTable);
        try {
            this.read("AS");
            this.read("(");
            Query withQuery = this.parseSelect();
            this.read(")");
            withQuery.prepare();
            querySQL = StringUtils.fromCacheOrNew(withQuery.getPlanSQL());
        }
        finally {
            this.session.removeLocalTempTable(recursiveTable);
        }
        int id = this.database.allocateObjectId();
        TableView view = new TableView(schema, id, tempViewName, querySQL, null, cols, this.session, true);
        view.setTableExpression(true);
        view.setTemporary(true);
        this.session.addLocalTempTable(view);
        view.setOnCommitDrop(true);
        Query q = this.parseSelect();
        q.setPrepareAlways(true);
        return q;
    }

    private CreateView parseCreateView(boolean force, boolean orReplace) {
        CreateView command;
        boolean ifNotExists = this.readIfNoExists();
        String viewName = this.readIdentifierWithSchema();
        this.createView = command = new CreateView(this.session, this.getSchema());
        command.setViewName(viewName);
        command.setIfNotExists(ifNotExists);
        command.setComment(this.readCommentIf());
        command.setOrReplace(orReplace);
        command.setForce(force);
        if (this.readIf("(")) {
            String[] cols = this.parseColumnList();
            command.setColumnNames(cols);
        }
        String select = StringUtils.fromCacheOrNew(this.sqlCommand.substring(this.parseIndex));
        this.read("AS");
        try {
            Query query = this.parseSelect();
            query.prepare();
            command.setSelect(query);
        }
        catch (DbException e) {
            if (force) {
                command.setSelectSQL(select);
                while (this.currentTokenType != 4) {
                    this.read();
                }
            }
            throw e;
        }
        return command;
    }

    private TransactionCommand parseCheckpoint() {
        TransactionCommand command = this.readIf("SYNC") ? new TransactionCommand(this.session, 76) : new TransactionCommand(this.session, 73);
        return command;
    }

    private Prepared parseAlter() {
        if (this.readIf("TABLE")) {
            return this.parseAlterTable();
        }
        if (this.readIf("USER")) {
            return this.parseAlterUser();
        }
        if (this.readIf("INDEX")) {
            return this.parseAlterIndex();
        }
        if (this.readIf("SCHEMA")) {
            return this.parseAlterSchema();
        }
        if (this.readIf("SEQUENCE")) {
            return this.parseAlterSequence();
        }
        if (this.readIf("VIEW")) {
            return this.parseAlterView();
        }
        throw this.getSyntaxError();
    }

    private void checkSchema(Schema old) {
        if (old != null && this.getSchema() != old) {
            throw DbException.get(90080);
        }
    }

    private AlterIndexRename parseAlterIndex() {
        String indexName = this.readIdentifierWithSchema();
        Schema old = this.getSchema();
        AlterIndexRename command = new AlterIndexRename(this.session);
        command.setOldIndex(this.getSchema().getIndex(indexName));
        this.read("RENAME");
        this.read("TO");
        String newName = this.readIdentifierWithSchema(old.getName());
        this.checkSchema(old);
        command.setNewName(newName);
        return command;
    }

    private AlterView parseAlterView() {
        AlterView command = new AlterView(this.session);
        String viewName = this.readIdentifierWithSchema();
        Table tableView = this.getSchema().findTableOrView(this.session, viewName);
        if (!(tableView instanceof TableView)) {
            throw DbException.get(90037, viewName);
        }
        TableView view = (TableView)tableView;
        command.setView(view);
        this.read("RECOMPILE");
        return command;
    }

    private AlterSchemaRename parseAlterSchema() {
        String schemaName = this.readIdentifierWithSchema();
        Schema old = this.getSchema();
        AlterSchemaRename command = new AlterSchemaRename(this.session);
        command.setOldSchema(this.getSchema(schemaName));
        this.read("RENAME");
        this.read("TO");
        String newName = this.readIdentifierWithSchema(old.getName());
        this.checkSchema(old);
        command.setNewName(newName);
        return command;
    }

    private AlterSequence parseAlterSequence() {
        String sequenceName = this.readIdentifierWithSchema();
        Sequence sequence = this.getSchema().getSequence(sequenceName);
        AlterSequence command = new AlterSequence(this.session, sequence.getSchema());
        command.setSequence(sequence);
        if (this.readIf("RESTART")) {
            this.read("WITH");
            command.setStartWith(this.readExpression());
        }
        if (this.readIf("INCREMENT")) {
            this.read("BY");
            command.setIncrement(this.readExpression());
        }
        return command;
    }

    private AlterUser parseAlterUser() {
        String userName = this.readUniqueIdentifier();
        if (this.readIf("SET")) {
            AlterUser command = new AlterUser(this.session);
            command.setType(19);
            command.setUser(this.database.getUser(userName));
            if (this.readIf("PASSWORD")) {
                command.setPassword(this.readExpression());
            } else if (this.readIf("SALT")) {
                command.setSalt(this.readExpression());
                this.read("HASH");
                command.setHash(this.readExpression());
            } else {
                throw this.getSyntaxError();
            }
            return command;
        }
        if (this.readIf("RENAME")) {
            this.read("TO");
            AlterUser command = new AlterUser(this.session);
            command.setType(18);
            command.setUser(this.database.getUser(userName));
            String newName = this.readUniqueIdentifier();
            command.setNewName(newName);
            return command;
        }
        if (this.readIf("ADMIN")) {
            AlterUser command = new AlterUser(this.session);
            command.setType(17);
            User user = this.database.getUser(userName);
            command.setUser(user);
            if (this.readIf("TRUE")) {
                command.setAdmin(true);
            } else if (this.readIf("FALSE")) {
                command.setAdmin(false);
            } else {
                throw this.getSyntaxError();
            }
            return command;
        }
        throw this.getSyntaxError();
    }

    private void readIfEqualOrTo() {
        if (!this.readIf("=")) {
            this.readIf("TO");
        }
    }

    private Prepared parseSet() {
        int type;
        if (this.readIf("@")) {
            Set command = new Set(this.session, 35);
            command.setString(this.readAliasIdentifier());
            this.readIfEqualOrTo();
            command.setExpression(this.readExpression());
            return command;
        }
        if (this.readIf("AUTOCOMMIT")) {
            this.readIfEqualOrTo();
            boolean value = this.readBooleanSetting();
            int setting = value ? 69 : 70;
            return new TransactionCommand(this.session, setting);
        }
        if (this.readIf("MVCC")) {
            this.readIfEqualOrTo();
            boolean value = this.readBooleanSetting();
            Set command = new Set(this.session, 31);
            command.setInt(value ? 1 : 0);
            return command;
        }
        if (this.readIf("EXCLUSIVE")) {
            this.readIfEqualOrTo();
            Set command = new Set(this.session, 33);
            command.setExpression(this.readExpression());
            return command;
        }
        if (this.readIf("IGNORECASE")) {
            this.readIfEqualOrTo();
            boolean value = this.readBooleanSetting();
            Set command = new Set(this.session, 1);
            command.setInt(value ? 1 : 0);
            return command;
        }
        if (this.readIf("PASSWORD")) {
            this.readIfEqualOrTo();
            AlterUser command = new AlterUser(this.session);
            command.setType(19);
            command.setUser(this.session.getUser());
            command.setPassword(this.readExpression());
            return command;
        }
        if (this.readIf("SALT")) {
            this.readIfEqualOrTo();
            AlterUser command = new AlterUser(this.session);
            command.setType(19);
            command.setUser(this.session.getUser());
            command.setSalt(this.readExpression());
            this.read("HASH");
            command.setHash(this.readExpression());
            return command;
        }
        if (this.readIf("MODE")) {
            this.readIfEqualOrTo();
            Set command = new Set(this.session, 3);
            command.setString(this.readAliasIdentifier());
            return command;
        }
        if (this.readIf("COMPRESS_LOB")) {
            this.readIfEqualOrTo();
            Set command = new Set(this.session, 23);
            if (this.currentTokenType == 5) {
                command.setString(this.readString());
            } else {
                command.setString(this.readUniqueIdentifier());
            }
            return command;
        }
        if (this.readIf("DATABASE")) {
            this.readIfEqualOrTo();
            this.read("COLLATION");
            return this.parseSetCollation();
        }
        if (this.readIf("COLLATION")) {
            this.readIfEqualOrTo();
            return this.parseSetCollation();
        }
        if (this.readIf("CLUSTER")) {
            this.readIfEqualOrTo();
            Set command = new Set(this.session, 13);
            command.setString(this.readString());
            return command;
        }
        if (this.readIf("DATABASE_EVENT_LISTENER")) {
            this.readIfEqualOrTo();
            Set command = new Set(this.session, 15);
            command.setString(this.readString());
            return command;
        }
        if (this.readIf("ALLOW_LITERALS")) {
            this.readIfEqualOrTo();
            Set command = new Set(this.session, 24);
            if (this.readIf("NONE")) {
                command.setInt(0);
            } else if (this.readIf("ALL")) {
                command.setInt(2);
            } else if (this.readIf("NUMBERS")) {
                command.setInt(1);
            } else {
                command.setInt(this.getPositiveInt());
            }
            return command;
        }
        if (this.readIf("DEFAULT_TABLE_TYPE")) {
            this.readIfEqualOrTo();
            Set command = new Set(this.session, 7);
            if (this.readIf("MEMORY")) {
                command.setInt(1);
            } else if (this.readIf("CACHED")) {
                command.setInt(0);
            } else {
                command.setInt(this.getPositiveInt());
            }
            return command;
        }
        if (this.readIf("CREATE")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("HSQLDB.DEFAULT_TABLE_TYPE")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("PAGE_STORE")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("CACHE_TYPE")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("FILE_LOCK")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("DB_CLOSE_ON_EXIT")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("AUTO_SERVER")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("AUTO_SERVER_PORT")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("AUTO_RECONNECT")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("ASSERT")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("ACCESS_MODE_DATA")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("OPEN_NEW")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("JMX")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("PAGE_SIZE")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("RECOVER")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("SCHEMA")) {
            this.readIfEqualOrTo();
            Set command = new Set(this.session, 26);
            command.setString(this.readAliasIdentifier());
            return command;
        }
        if (this.readIf("DATESTYLE")) {
            String s;
            this.readIfEqualOrTo();
            if (!this.readIf("ISO") && !this.equalsToken(s = this.readString(), "ISO")) {
                throw this.getSyntaxError();
            }
            return new NoOperation(this.session);
        }
        if (this.readIf("SEARCH_PATH") || this.readIf(SetTypes.getTypeName(28))) {
            this.readIfEqualOrTo();
            Set command = new Set(this.session, 28);
            ArrayList<String> list = New.arrayList();
            list.add(this.readAliasIdentifier());
            while (this.readIf(",")) {
                list.add(this.readAliasIdentifier());
            }
            String[] schemaNames = new String[list.size()];
            list.toArray(schemaNames);
            command.setStringArray(schemaNames);
            return command;
        }
        if (this.isToken("LOGSIZE")) {
            this.currentToken = SetTypes.getTypeName(2);
        }
        if ((type = SetTypes.getType(this.currentToken)) < 0) {
            throw this.getSyntaxError();
        }
        this.read();
        this.readIfEqualOrTo();
        Set command = new Set(this.session, type);
        command.setExpression(this.readExpression());
        return command;
    }

    private Set parseSetCollation() {
        Set command = new Set(this.session, 12);
        String name = this.readAliasIdentifier();
        command.setString(name);
        if (this.equalsToken(name, "OFF")) {
            return command;
        }
        Collator coll = CompareMode.getCollator(name);
        if (coll == null) {
            throw DbException.getInvalidValueException("collation", name);
        }
        if (this.readIf("STRENGTH")) {
            if (this.readIf("PRIMARY")) {
                command.setInt(0);
            } else if (this.readIf("SECONDARY")) {
                command.setInt(1);
            } else if (this.readIf("TERTIARY")) {
                command.setInt(2);
            } else if (this.readIf("IDENTICAL")) {
                command.setInt(3);
            }
        } else {
            command.setInt(coll.getStrength());
        }
        return command;
    }

    private RunScriptCommand parseRunScript() {
        RunScriptCommand command = new RunScriptCommand(this.session);
        this.read("FROM");
        command.setFileNameExpr(this.readExpression());
        if (this.readIf("COMPRESSION")) {
            command.setCompressionAlgorithm(this.readUniqueIdentifier());
        }
        if (this.readIf("CIPHER")) {
            command.setCipher(this.readUniqueIdentifier());
            if (this.readIf("PASSWORD")) {
                command.setPassword(this.readExpression());
            }
        }
        if (this.readIf("CHARSET")) {
            command.setCharset(this.readString());
        }
        return command;
    }

    private ScriptCommand parseScript() {
        ScriptCommand command = new ScriptCommand(this.session);
        boolean data = true;
        boolean passwords = true;
        boolean settings = true;
        boolean dropTables = false;
        boolean simple = false;
        if (this.readIf("SIMPLE")) {
            simple = true;
        }
        if (this.readIf("NODATA")) {
            data = false;
        }
        if (this.readIf("NOPASSWORDS")) {
            passwords = false;
        }
        if (this.readIf("NOSETTINGS")) {
            settings = false;
        }
        if (this.readIf("DROP")) {
            dropTables = true;
        }
        if (this.readIf("BLOCKSIZE")) {
            long blockSize = this.readLong();
            command.setLobBlockSize(blockSize);
        }
        command.setData(data);
        command.setPasswords(passwords);
        command.setSettings(settings);
        command.setDrop(dropTables);
        command.setSimple(simple);
        if (this.readIf("TO")) {
            command.setFileNameExpr(this.readExpression());
            if (this.readIf("COMPRESSION")) {
                command.setCompressionAlgorithm(this.readUniqueIdentifier());
            }
            if (this.readIf("CIPHER")) {
                command.setCipher(this.readUniqueIdentifier());
                if (this.readIf("PASSWORD")) {
                    command.setPassword(this.readExpression());
                }
            }
            if (this.readIf("CHARSET")) {
                command.setCharset(this.readString());
            }
        }
        if (this.readIf("SCHEMA")) {
            HashSet<String> schemaNames = New.hashSet();
            do {
                schemaNames.add(this.readUniqueIdentifier());
            } while (this.readIf(","));
            command.setSchemaNames(schemaNames);
        } else if (this.readIf("TABLE")) {
            ArrayList<Table> tables = New.arrayList();
            do {
                tables.add(this.readTableOrView());
            } while (this.readIf(","));
            command.setTables(tables);
        }
        return command;
    }

    private Table readTableOrView() {
        return this.readTableOrView(this.readIdentifierWithSchema(null));
    }

    private Table readTableOrView(String tableName) {
        if (this.schemaName != null) {
            return this.getSchema().getTableOrView(this.session, tableName);
        }
        Table table = this.database.getSchema(this.session.getCurrentSchemaName()).findTableOrView(this.session, tableName);
        if (table != null) {
            return table;
        }
        String[] schemaNames = this.session.getSchemaSearchPath();
        if (schemaNames != null) {
            for (String name : schemaNames) {
                Schema s = this.database.getSchema(name);
                table = s.findTableOrView(this.session, tableName);
                if (table == null) continue;
                return table;
            }
        }
        throw DbException.get(42102, tableName);
    }

    private FunctionAlias findFunctionAlias(String schema, String aliasName) {
        FunctionAlias functionAlias = this.database.getSchema(schema).findFunction(aliasName);
        if (functionAlias != null) {
            return functionAlias;
        }
        String[] schemaNames = this.session.getSchemaSearchPath();
        if (schemaNames != null) {
            for (String n : schemaNames) {
                functionAlias = this.database.getSchema(n).findFunction(aliasName);
                if (functionAlias == null) continue;
                return functionAlias;
            }
        }
        return null;
    }

    private Sequence findSequence(String schema, String sequenceName) {
        Sequence sequence = this.database.getSchema(schema).findSequence(sequenceName);
        if (sequence != null) {
            return sequence;
        }
        String[] schemaNames = this.session.getSchemaSearchPath();
        if (schemaNames != null) {
            for (String n : schemaNames) {
                sequence = this.database.getSchema(n).findSequence(sequenceName);
                if (sequence == null) continue;
                return sequence;
            }
        }
        return null;
    }

    private Sequence readSequence() {
        String sequenceName = this.readIdentifierWithSchema(null);
        if (this.schemaName != null) {
            return this.getSchema().getSequence(sequenceName);
        }
        Sequence sequence = this.findSequence(this.session.getCurrentSchemaName(), sequenceName);
        if (sequence != null) {
            return sequence;
        }
        throw DbException.get(90036, sequenceName);
    }

    private Prepared parseAlterTable() {
        Table table = this.readTableOrView();
        if (this.readIf("ADD")) {
            DefineCommand command = this.parseAlterTableAddConstraintIf(table.getName(), table.getSchema());
            if (command != null) {
                return command;
            }
            return this.parseAlterTableAddColumn(table);
        }
        if (this.readIf("SET")) {
            this.read("REFERENTIAL_INTEGRITY");
            int type = 55;
            boolean value = this.readBooleanSetting();
            AlterTableSet command = new AlterTableSet(this.session, table.getSchema(), type, value);
            command.setTableName(table.getName());
            if (this.readIf("CHECK")) {
                command.setCheckExisting(true);
            } else if (this.readIf("NOCHECK")) {
                command.setCheckExisting(false);
            }
            return command;
        }
        if (this.readIf("RENAME")) {
            this.read("TO");
            String newName = this.readIdentifierWithSchema(table.getSchema().getName());
            this.checkSchema(table.getSchema());
            AlterTableRename command = new AlterTableRename(this.session, this.getSchema());
            command.setOldTable(table);
            command.setNewTableName(newName);
            command.setHidden(this.readIf("HIDDEN"));
            return command;
        }
        if (this.readIf("DROP")) {
            if (this.readIf("CONSTRAINT")) {
                boolean ifExists = this.readIfExists(false);
                String constraintName = this.readIdentifierWithSchema(table.getSchema().getName());
                ifExists = this.readIfExists(ifExists);
                this.checkSchema(table.getSchema());
                AlterTableDropConstraint command = new AlterTableDropConstraint(this.session, this.getSchema(), ifExists);
                command.setConstraintName(constraintName);
                return command;
            }
            if (this.readIf("PRIMARY")) {
                this.read("KEY");
                Index idx = table.getPrimaryKey();
                DropIndex command = new DropIndex(this.session, table.getSchema());
                command.setIndexName(idx.getName());
                return command;
            }
            this.readIf("COLUMN");
            boolean ifExists = this.readIfExists(false);
            AlterTableAlterColumn command = new AlterTableAlterColumn(this.session, table.getSchema());
            command.setType(12);
            String columnName = this.readColumnIdentifier();
            command.setTable(table);
            if (ifExists && !table.doesColumnExist(columnName)) {
                return new NoOperation(this.session);
            }
            command.setOldColumn(table.getColumn(columnName));
            return command;
        }
        if (this.readIf("ALTER")) {
            this.readIf("COLUMN");
            String columnName = this.readColumnIdentifier();
            Column column = table.getColumn(columnName);
            if (this.readIf("RENAME")) {
                this.read("TO");
                AlterTableRenameColumn command = new AlterTableRenameColumn(this.session);
                command.setTable(table);
                command.setColumn(column);
                String newName = this.readColumnIdentifier();
                command.setNewColumnName(newName);
                return command;
            }
            if (this.readIf("DROP")) {
                if (this.readIf("DEFAULT")) {
                    AlterTableAlterColumn command = new AlterTableAlterColumn(this.session, table.getSchema());
                    command.setTable(table);
                    command.setOldColumn(column);
                    command.setType(10);
                    command.setDefaultExpression(null);
                    return command;
                }
                this.read("NOT");
                this.read("NULL");
                AlterTableAlterColumn command = new AlterTableAlterColumn(this.session, table.getSchema());
                command.setTable(table);
                command.setOldColumn(column);
                command.setType(9);
                return command;
            }
            if (this.readIf("TYPE")) {
                return this.parseAlterTableAlterColumnType(table, columnName, column);
            }
            if (this.readIf("SET")) {
                if (this.readIf("DATA")) {
                    this.read("TYPE");
                    return this.parseAlterTableAlterColumnType(table, columnName, column);
                }
                AlterTableAlterColumn command = new AlterTableAlterColumn(this.session, table.getSchema());
                command.setTable(table);
                command.setOldColumn(column);
                if (this.readIf("NULL")) {
                    command.setType(9);
                    return command;
                }
                if (this.readIf("NOT")) {
                    this.read("NULL");
                    command.setType(8);
                    return command;
                }
                if (this.readIf("DEFAULT")) {
                    Expression defaultExpression = this.readExpression();
                    command.setType(10);
                    command.setDefaultExpression(defaultExpression);
                    return command;
                }
            } else {
                if (this.readIf("RESTART")) {
                    this.readIf("WITH");
                    Expression start = this.readExpression();
                    AlterSequence command = new AlterSequence(this.session, table.getSchema());
                    command.setColumn(column);
                    command.setStartWith(start);
                    return command;
                }
                if (this.readIf("SELECTIVITY")) {
                    AlterTableAlterColumn command = new AlterTableAlterColumn(this.session, table.getSchema());
                    command.setTable(table);
                    command.setType(13);
                    command.setOldColumn(column);
                    command.setSelectivity(this.readExpression());
                    return command;
                }
                return this.parseAlterTableAlterColumnType(table, columnName, column);
            }
        }
        throw this.getSyntaxError();
    }

    private AlterTableAlterColumn parseAlterTableAlterColumnType(Table table, String columnName, Column column) {
        Column newColumn = this.parseColumnForTable(columnName, column.isNullable());
        AlterTableAlterColumn command = new AlterTableAlterColumn(this.session, table.getSchema());
        command.setTable(table);
        command.setType(11);
        command.setOldColumn(column);
        command.setNewColumn(newColumn);
        return command;
    }

    private AlterTableAlterColumn parseAlterTableAddColumn(Table table) {
        this.readIf("COLUMN");
        Schema schema = table.getSchema();
        AlterTableAlterColumn command = new AlterTableAlterColumn(this.session, schema);
        command.setType(7);
        command.setTable(table);
        ArrayList<Column> columnsToAdd = New.arrayList();
        if (this.readIf("(")) {
            command.setIfNotExists(false);
            do {
                String columnName = this.readColumnIdentifier();
                Column column = this.parseColumnForTable(columnName, true);
                columnsToAdd.add(column);
            } while (this.readIf(","));
            this.read(")");
            command.setNewColumns(columnsToAdd);
        } else {
            boolean ifNotExists = this.readIfNoExists();
            command.setIfNotExists(ifNotExists);
            String columnName = this.readColumnIdentifier();
            Column column = this.parseColumnForTable(columnName, true);
            columnsToAdd.add(column);
            if (this.readIf("BEFORE")) {
                command.setAddBefore(this.readColumnIdentifier());
            }
        }
        command.setNewColumns(columnsToAdd);
        return command;
    }

    private int parseAction() {
        Integer result = this.parseCascadeOrRestrict();
        if (result != null) {
            return result;
        }
        if (this.readIf("NO")) {
            this.read("ACTION");
            return 0;
        }
        this.read("SET");
        if (this.readIf("NULL")) {
            return 3;
        }
        this.read("DEFAULT");
        return 2;
    }

    private Integer parseCascadeOrRestrict() {
        if (this.readIf("CASCADE")) {
            return 1;
        }
        if (this.readIf("RESTRICT")) {
            return 0;
        }
        return null;
    }

    private DefineCommand parseAlterTableAddConstraintIf(String tableName, Schema schema) {
        AlterTableAddConstraint command;
        String constraintName = null;
        String comment = null;
        boolean ifNotExists = false;
        boolean allowIndexDefinition = this.database.getMode().indexDefinitionInCreateTable;
        if (this.readIf("CONSTRAINT")) {
            ifNotExists = this.readIfNoExists();
            constraintName = this.readIdentifierWithSchema(schema.getName());
            this.checkSchema(schema);
            comment = this.readCommentIf();
            allowIndexDefinition = true;
        }
        if (this.readIf("PRIMARY")) {
            this.read("KEY");
            AlterTableAddConstraint command2 = new AlterTableAddConstraint(this.session, schema, ifNotExists);
            command2.setType(6);
            command2.setComment(comment);
            command2.setConstraintName(constraintName);
            command2.setTableName(tableName);
            if (this.readIf("HASH")) {
                command2.setPrimaryKeyHash(true);
            }
            this.read("(");
            command2.setIndexColumns(this.parseIndexColumnList());
            if (this.readIf("INDEX")) {
                String indexName = this.readIdentifierWithSchema();
                command2.setIndex(this.getSchema().findIndex(this.session, indexName));
            }
            return command2;
        }
        if (allowIndexDefinition && (this.isToken("INDEX") || this.isToken("KEY"))) {
            int start = this.lastParseIndex;
            this.read();
            if (DataType.getTypeByName(this.currentToken) != null) {
                this.parseIndex = start;
                this.read();
                return null;
            }
            CreateIndex command3 = new CreateIndex(this.session, schema);
            command3.setComment(comment);
            command3.setTableName(tableName);
            if (!this.readIf("(")) {
                command3.setIndexName(this.readUniqueIdentifier());
                this.read("(");
            }
            command3.setIndexColumns(this.parseIndexColumnList());
            return command3;
        }
        if (this.readIf("CHECK")) {
            command = new AlterTableAddConstraint(this.session, schema, ifNotExists);
            command.setType(3);
            command.setCheckExpression(this.readExpression());
        } else if (this.readIf("UNIQUE")) {
            this.readIf("KEY");
            this.readIf("INDEX");
            command = new AlterTableAddConstraint(this.session, schema, ifNotExists);
            command.setType(4);
            if (!this.readIf("(")) {
                constraintName = this.readUniqueIdentifier();
                this.read("(");
            }
            command.setIndexColumns(this.parseIndexColumnList());
            if (this.readIf("INDEX")) {
                String indexName = this.readIdentifierWithSchema();
                command.setIndex(this.getSchema().findIndex(this.session, indexName));
            }
        } else if (this.readIf("FOREIGN")) {
            command = new AlterTableAddConstraint(this.session, schema, ifNotExists);
            command.setType(5);
            this.read("KEY");
            this.read("(");
            command.setIndexColumns(this.parseIndexColumnList());
            if (this.readIf("INDEX")) {
                String indexName = this.readIdentifierWithSchema();
                command.setIndex(schema.findIndex(this.session, indexName));
            }
            this.read("REFERENCES");
            this.parseReferences(command, schema, tableName);
        } else {
            if (constraintName != null) {
                throw this.getSyntaxError();
            }
            return null;
        }
        if (this.readIf("NOCHECK")) {
            command.setCheckExisting(false);
        } else {
            this.readIf("CHECK");
            command.setCheckExisting(true);
        }
        command.setTableName(tableName);
        command.setConstraintName(constraintName);
        command.setComment(comment);
        return command;
    }

    private void parseReferences(AlterTableAddConstraint command, Schema schema, String tableName) {
        if (this.readIf("(")) {
            command.setRefTableName(schema, tableName);
            command.setRefIndexColumns(this.parseIndexColumnList());
        } else {
            String refTableName = this.readIdentifierWithSchema(schema.getName());
            command.setRefTableName(this.getSchema(), refTableName);
            if (this.readIf("(")) {
                command.setRefIndexColumns(this.parseIndexColumnList());
            }
        }
        if (this.readIf("INDEX")) {
            String indexName = this.readIdentifierWithSchema();
            command.setRefIndex(this.getSchema().findIndex(this.session, indexName));
        }
        while (this.readIf("ON")) {
            if (this.readIf("DELETE")) {
                command.setDeleteAction(this.parseAction());
                continue;
            }
            this.read("UPDATE");
            command.setUpdateAction(this.parseAction());
        }
        if (this.readIf("NOT")) {
            this.read("DEFERRABLE");
        } else {
            this.readIf("DEFERRABLE");
        }
    }

    private CreateLinkedTable parseCreateLinkedTable(boolean temp, boolean globalTemp, boolean force) {
        this.read("TABLE");
        boolean ifNotExists = this.readIfNoExists();
        String tableName = this.readIdentifierWithSchema();
        CreateLinkedTable command = new CreateLinkedTable(this.session, this.getSchema());
        command.setTemporary(temp);
        command.setGlobalTemporary(globalTemp);
        command.setForce(force);
        command.setIfNotExists(ifNotExists);
        command.setTableName(tableName);
        command.setComment(this.readCommentIf());
        this.read("(");
        command.setDriver(this.readString());
        this.read(",");
        command.setUrl(this.readString());
        this.read(",");
        command.setUser(this.readString());
        this.read(",");
        command.setPassword(this.readString());
        this.read(",");
        String originalTable = this.readString();
        if (this.readIf(",")) {
            command.setOriginalSchema(originalTable);
            originalTable = this.readString();
        }
        command.setOriginalTable(originalTable);
        this.read(")");
        if (this.readIf("EMIT")) {
            this.read("UPDATES");
            command.setEmitUpdates(true);
        } else if (this.readIf("READONLY")) {
            command.setReadOnly(true);
        }
        return command;
    }

    private CreateTable parseCreateTable(boolean temp, boolean globalTemp, boolean persistIndexes) {
        boolean ifNotExists = this.readIfNoExists();
        String tableName = this.readIdentifierWithSchema();
        if (temp && globalTemp && this.equalsToken("SESSION", this.schemaName)) {
            this.schemaName = this.session.getCurrentSchemaName();
            globalTemp = false;
        }
        Schema schema = this.getSchema();
        CreateTable command = new CreateTable(this.session, schema);
        command.setPersistIndexes(persistIndexes);
        command.setTemporary(temp);
        command.setGlobalTemporary(globalTemp);
        command.setIfNotExists(ifNotExists);
        command.setTableName(tableName);
        command.setComment(this.readCommentIf());
        if (this.readIf("(") && !this.readIf(")")) {
            do {
                IndexColumn[] cols;
                DefineCommand c;
                if ((c = this.parseAlterTableAddConstraintIf(tableName, schema)) != null) {
                    command.addConstraintCommand(c);
                    continue;
                }
                String columnName = this.readColumnIdentifier();
                Column column = this.parseColumnForTable(columnName, true);
                if (column.isAutoIncrement() && column.isPrimaryKey()) {
                    column.setPrimaryKey(false);
                    IndexColumn[] cols2 = new IndexColumn[]{new IndexColumn()};
                    cols2[0].columnName = column.getName();
                    AlterTableAddConstraint pk = new AlterTableAddConstraint(this.session, schema, false);
                    pk.setType(6);
                    pk.setTableName(tableName);
                    pk.setIndexColumns(cols2);
                    command.addConstraintCommand(pk);
                }
                command.addColumn(column);
                String constraintName = null;
                if (this.readIf("CONSTRAINT")) {
                    constraintName = this.readColumnIdentifier();
                }
                if (this.readIf("PRIMARY")) {
                    this.read("KEY");
                    boolean hash = this.readIf("HASH");
                    cols = new IndexColumn[]{new IndexColumn()};
                    cols[0].columnName = column.getName();
                    AlterTableAddConstraint pk = new AlterTableAddConstraint(this.session, schema, false);
                    pk.setPrimaryKeyHash(hash);
                    pk.setType(6);
                    pk.setTableName(tableName);
                    pk.setIndexColumns(cols);
                    command.addConstraintCommand(pk);
                    if (this.readIf("AUTO_INCREMENT")) {
                        this.parseAutoIncrement(column);
                    }
                } else if (this.readIf("UNIQUE")) {
                    AlterTableAddConstraint unique = new AlterTableAddConstraint(this.session, schema, false);
                    unique.setConstraintName(constraintName);
                    unique.setType(4);
                    cols = new IndexColumn[]{new IndexColumn()};
                    cols[0].columnName = columnName;
                    unique.setIndexColumns(cols);
                    unique.setTableName(tableName);
                    command.addConstraintCommand(unique);
                }
                if (this.readIf("NOT")) {
                    this.read("NULL");
                    column.setNullable(false);
                } else {
                    this.readIf("NULL");
                }
                if (this.readIf("CHECK")) {
                    Expression expr = this.readExpression();
                    column.addCheckConstraint(this.session, expr);
                }
                if (!this.readIf("REFERENCES")) continue;
                AlterTableAddConstraint ref = new AlterTableAddConstraint(this.session, schema, false);
                ref.setConstraintName(constraintName);
                ref.setType(5);
                cols = new IndexColumn[]{new IndexColumn()};
                cols[0].columnName = columnName;
                ref.setIndexColumns(cols);
                ref.setTableName(tableName);
                this.parseReferences(ref, schema, tableName);
                command.addConstraintCommand(ref);
            } while (this.readIfMore());
        }
        if (this.readIf("ENGINE")) {
            command.setTableEngine(this.readUniqueIdentifier());
        }
        if (temp) {
            if (this.readIf("ON")) {
                this.read("COMMIT");
                if (this.readIf("DROP")) {
                    command.setOnCommitDrop();
                } else if (this.readIf("DELETE")) {
                    this.read("ROWS");
                    command.setOnCommitTruncate();
                }
            } else if (this.readIf("NOT")) {
                if (this.readIf("PERSISTENT")) {
                    command.setPersistData(false);
                } else {
                    this.read("LOGGED");
                }
            }
            if (this.readIf("TRANSACTIONAL")) {
                command.setTransactional(true);
            }
        } else if (!persistIndexes && this.readIf("NOT")) {
            this.read("PERSISTENT");
            command.setPersistData(false);
        }
        if (this.readIf("HIDDEN")) {
            command.setHidden(true);
        }
        if (this.readIf("AS")) {
            if (this.readIf("SORTED")) {
                command.setSortedInsertMode(true);
            }
            command.setQuery(this.parseSelect());
        }
        return command;
    }

    private static int getCompareType(int tokenType) {
        switch (tokenType) {
            case 6: {
                return 0;
            }
            case 7: {
                return 1;
            }
            case 8: {
                return 2;
            }
            case 9: {
                return 4;
            }
            case 10: {
                return 3;
            }
            case 11: {
                return 5;
            }
        }
        return -1;
    }

    public static String quoteIdentifier(String s) {
        if (s == null || s.length() == 0) {
            return "\"\"";
        }
        char c = s.charAt(0);
        if (!Character.isLetter(c) && c != '_' || Character.isLowerCase(c)) {
            return StringUtils.quoteIdentifier(s);
        }
        int length = s.length();
        for (int i = 1; i < length; ++i) {
            c = s.charAt(i);
            if ((Character.isLetterOrDigit(c) || c == '_') && !Character.isLowerCase(c)) continue;
            return StringUtils.quoteIdentifier(s);
        }
        if (Parser.isKeyword(s, true)) {
            return StringUtils.quoteIdentifier(s);
        }
        return s;
    }

    public void setRightsChecked(boolean rightsChecked) {
        this.rightsChecked = rightsChecked;
    }

    public Expression parseExpression(String sql) {
        this.parameters = New.arrayList();
        this.initialize(sql);
        this.read();
        return this.readExpression();
    }
}

