/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import org.h2.command.ddl.SchemaCommand;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.message.DbException;
import org.h2.schema.Schema;
import org.h2.schema.Sequence;
import org.h2.table.Column;
import org.h2.table.Table;

public class AlterSequence
extends SchemaCommand {
    private Table table;
    private Sequence sequence;
    private Expression start;
    private Expression increment;

    public AlterSequence(Session session, Schema schema) {
        super(session, schema);
    }

    public void setSequence(Sequence sequence) {
        this.sequence = sequence;
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    public void setColumn(Column column) {
        this.table = column.getTable();
        this.sequence = column.getSequence();
        if (this.sequence == null) {
            throw DbException.get(90036, column.getSQL());
        }
    }

    public void setStartWith(Expression start) {
        this.start = start;
    }

    public void setIncrement(Expression increment) {
        this.increment = increment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int update() {
        Session sysSession;
        Database db = this.session.getDatabase();
        if (this.table != null) {
            this.session.getUser().checkRight(this.table, 15);
        }
        if (this.start != null) {
            long startValue = this.start.optimize(this.session).getValue(this.session).getLong();
            this.sequence.setStartValue(startValue);
        }
        if (this.increment != null) {
            long incrementValue = this.increment.optimize(this.session).getValue(this.session).getLong();
            if (incrementValue == 0L) {
                throw DbException.getInvalidValueException("INCREMENT", 0);
            }
            this.sequence.setIncrement(incrementValue);
        }
        Session session = sysSession = db.getSystemSession();
        synchronized (session) {
            db.update(sysSession, this.sequence);
            sysSession.commit(true);
        }
        return 0;
    }

    @Override
    public int getType() {
        return 54;
    }
}

