/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.h2.api.DatabaseEventListener;
import org.h2.command.ddl.CreateTableData;
import org.h2.command.dml.SetTypes;
import org.h2.constant.DbSettings;
import org.h2.constant.SysProperties;
import org.h2.constraint.Constraint;
import org.h2.engine.Comment;
import org.h2.engine.ConnectionInfo;
import org.h2.engine.DatabaseCloser;
import org.h2.engine.DbObject;
import org.h2.engine.Engine;
import org.h2.engine.MetaRecord;
import org.h2.engine.Mode;
import org.h2.engine.Right;
import org.h2.engine.Role;
import org.h2.engine.Session;
import org.h2.engine.Setting;
import org.h2.engine.User;
import org.h2.engine.UserAggregate;
import org.h2.engine.UserDataType;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.jdbc.JdbcConnection;
import org.h2.message.DbException;
import org.h2.message.Trace;
import org.h2.message.TraceSystem;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.schema.Schema;
import org.h2.schema.SchemaObject;
import org.h2.schema.Sequence;
import org.h2.schema.TriggerObject;
import org.h2.store.DataHandler;
import org.h2.store.FileLock;
import org.h2.store.FileStore;
import org.h2.store.InDoubtTransaction;
import org.h2.store.LobStorage;
import org.h2.store.PageStore;
import org.h2.store.WriterThread;
import org.h2.store.fs.FileUtils;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.MetaTable;
import org.h2.table.Table;
import org.h2.table.TableLinkConnection;
import org.h2.table.TableView;
import org.h2.tools.DeleteDbFiles;
import org.h2.tools.Server;
import org.h2.util.BitField;
import org.h2.util.MathUtils;
import org.h2.util.NetUtils;
import org.h2.util.New;
import org.h2.util.SmallLRUCache;
import org.h2.util.SourceCompiler;
import org.h2.util.StringUtils;
import org.h2.util.TempFileDeleter;
import org.h2.util.Utils;
import org.h2.value.CaseInsensitiveMap;
import org.h2.value.CompareMode;
import org.h2.value.Value;
import org.h2.value.ValueInt;

public class Database
implements DataHandler {
    private static int initialPowerOffCount;
    private static final String SYSTEM_USER_NAME = "DBA";
    private final boolean persistent;
    private final String databaseName;
    private final String databaseShortName;
    private final String databaseURL;
    private final String cipher;
    private final byte[] filePasswordHash;
    private final HashMap<String, Role> roles = New.hashMap();
    private final HashMap<String, User> users = New.hashMap();
    private final HashMap<String, Setting> settings = New.hashMap();
    private final HashMap<String, Schema> schemas = New.hashMap();
    private final HashMap<String, Right> rights = New.hashMap();
    private final HashMap<String, UserDataType> userDataTypes = New.hashMap();
    private final HashMap<String, UserAggregate> aggregates = New.hashMap();
    private final HashMap<String, Comment> comments = New.hashMap();
    private final Set<Session> userSessions = Collections.synchronizedSet(new HashSet());
    private Session exclusiveSession;
    private final BitField objectIds = new BitField();
    private final Object lobSyncObject = new Object();
    private Schema mainSchema;
    private Schema infoSchema;
    private int nextSessionId;
    private int nextTempTableId;
    private User systemUser;
    private Session systemSession;
    private Table meta;
    private Index metaIdIndex;
    private FileLock lock;
    private WriterThread writer;
    private boolean starting;
    private TraceSystem traceSystem;
    private Trace trace;
    private int fileLockMethod;
    private Role publicRole;
    private long modificationDataId;
    private long modificationMetaId;
    private CompareMode compareMode;
    private String cluster = "''";
    private boolean readOnly;
    private boolean noDiskSpace;
    private int writeDelay = 500;
    private DatabaseEventListener eventListener;
    private int maxMemoryRows = 10000;
    private int maxMemoryUndo = 50000;
    private int lockMode = 3;
    private int maxLengthInplaceLob;
    private int allowLiterals = 2;
    private int powerOffCount = initialPowerOffCount;
    private int closeDelay;
    private DatabaseCloser delayedCloser;
    private volatile boolean closing;
    private boolean ignoreCase;
    private boolean deleteFilesOnDisconnect;
    private String lobCompressionAlgorithm;
    private boolean optimizeReuseResults = true;
    private String cacheType;
    private String accessModeData;
    private boolean referentialIntegrity = true;
    private boolean multiVersion;
    private DatabaseCloser closeOnExit;
    private Mode mode = Mode.getInstance("REGULAR");
    private boolean multiThreaded;
    private int maxOperationMemory = 100000;
    private SmallLRUCache<String, String[]> lobFileListCache;
    private boolean autoServerMode;
    private int autoServerPort;
    private Server server;
    private HashMap<TableLinkConnection, TableLinkConnection> linkConnections;
    private TempFileDeleter tempFileDeleter = TempFileDeleter.getInstance();
    private PageStore pageStore;
    private Properties reconnectLastLock;
    private volatile long reconnectCheckNext;
    private volatile boolean reconnectChangePending;
    private volatile int checkpointAllowed;
    private volatile boolean checkpointRunning;
    private final Object reconnectSync = new Object();
    private int cacheSize;
    private int compactMode;
    private SourceCompiler compiler;
    private volatile boolean metaTablesInitialized;
    private boolean flushOnEachCommit;
    private LobStorage lobStorage;
    private int pageSize = 2048;
    private int defaultTableType = 0;
    private final DbSettings dbSettings;
    private final int reconnectCheckDelay;
    private int logMode;

    public Database(ConnectionInfo ci, String cipher) {
        String modeName;
        String name = ci.getName();
        this.dbSettings = ci.getDbSettings();
        this.reconnectCheckDelay = this.dbSettings.reconnectCheckDelay;
        this.compareMode = CompareMode.getInstance(null, 0);
        this.persistent = ci.isPersistent();
        this.filePasswordHash = ci.getFilePasswordHash();
        this.databaseName = name;
        this.databaseShortName = this.parseDatabaseShortName();
        this.maxLengthInplaceLob = SysProperties.LOB_IN_DATABASE ? 128 : 4096;
        this.cipher = cipher;
        String lockMethodName = ci.getProperty("FILE_LOCK", null);
        this.accessModeData = StringUtils.toLowerEnglish(ci.getProperty("ACCESS_MODE_DATA", "rw"));
        this.autoServerMode = ci.getProperty("AUTO_SERVER", false);
        this.autoServerPort = ci.getProperty("AUTO_SERVER_PORT", 0);
        this.cacheSize = ci.getProperty("CACHE_SIZE", 16384);
        this.pageSize = ci.getProperty("PAGE_SIZE", 2048);
        if ("r".equals(this.accessModeData)) {
            this.readOnly = true;
        }
        this.fileLockMethod = FileLock.getFileLockMethod(lockMethodName);
        this.databaseURL = ci.getURL();
        String listener = ci.removeProperty("DATABASE_EVENT_LISTENER", null);
        if (listener != null) {
            listener = StringUtils.trim(listener, true, true, "'");
            this.setEventListenerClass(listener);
        }
        if ((modeName = ci.removeProperty("MODE", null)) != null) {
            this.mode = Mode.getInstance(modeName);
        }
        this.multiVersion = ci.getProperty("MVCC", false);
        this.logMode = ci.getProperty("LOG", 2);
        boolean closeAtVmShutdown = this.dbSettings.dbCloseOnExit;
        int traceLevelFile = ci.getIntProperty(10, 1);
        int traceLevelSystemOut = ci.getIntProperty(9, 0);
        this.cacheType = StringUtils.toUpperEnglish(ci.removeProperty("CACHE_TYPE", "LRU"));
        this.openDatabase(traceLevelFile, traceLevelSystemOut, closeAtVmShutdown);
    }

    private void openDatabase(int traceLevelFile, int traceLevelSystemOut, boolean closeAtVmShutdown) {
        try {
            this.open(traceLevelFile, traceLevelSystemOut);
            if (closeAtVmShutdown) {
                try {
                    this.closeOnExit = new DatabaseCloser(this, 0, true);
                    Runtime.getRuntime().addShutdownHook(this.closeOnExit);
                }
                catch (IllegalStateException e) {
                }
                catch (SecurityException e) {}
            }
        }
        catch (Throwable e) {
            if (e instanceof OutOfMemoryError) {
                e.fillInStackTrace();
            }
            if (this.traceSystem != null) {
                SQLException e2;
                if (e instanceof SQLException && (e2 = (SQLException)e).getErrorCode() != 90020) {
                    this.trace.error(e, "opening {0}", this.databaseName);
                }
                this.traceSystem.close();
            }
            this.closeOpenFilesAndUnlock(false);
            throw DbException.convert(e);
        }
    }

    public static void setInitialPowerOffCount(int count) {
        initialPowerOffCount = count;
    }

    public void setPowerOffCount(int count) {
        if (this.powerOffCount == -1) {
            return;
        }
        this.powerOffCount = count;
    }

    public boolean areEqual(Value a, Value b) {
        return a.compareTo(b, this.compareMode) == 0;
    }

    public int compare(Value a, Value b) {
        return a.compareTo(b, this.compareMode);
    }

    public int compareTypeSave(Value a, Value b) {
        return a.compareTypeSave(b, this.compareMode);
    }

    public long getModificationDataId() {
        return this.modificationDataId;
    }

    private synchronized boolean reconnectModified(boolean pending) {
        if (this.readOnly || this.lock == null || this.fileLockMethod != 3) {
            return true;
        }
        try {
            if (pending == this.reconnectChangePending) {
                long now = System.currentTimeMillis();
                if (now > this.reconnectCheckNext) {
                    if (pending) {
                        String pos = this.pageStore == null ? null : "" + this.pageStore.getWriteCountTotal();
                        this.lock.setProperty("logPos", pos);
                        this.lock.save();
                    }
                    this.reconnectCheckNext = now + (long)this.reconnectCheckDelay;
                }
                return true;
            }
            Properties old = this.lock.load();
            if (pending) {
                if (old.getProperty("changePending") != null) {
                    return false;
                }
                this.trace.debug("wait before writing");
                Thread.sleep((int)((double)this.reconnectCheckDelay * 1.1));
                Properties now = this.lock.load();
                if (!now.equals(old)) {
                    return false;
                }
            }
            String pos = this.pageStore == null ? null : "" + this.pageStore.getWriteCountTotal();
            this.lock.setProperty("logPos", pos);
            if (pending) {
                this.lock.setProperty("changePending", "true-" + Math.random());
            } else {
                this.lock.setProperty("changePending", null);
            }
            this.reconnectCheckNext = System.currentTimeMillis() + (long)(2 * this.reconnectCheckDelay);
            old = this.lock.save();
            if (pending) {
                this.trace.debug("wait before writing again");
                Thread.sleep((int)((double)this.reconnectCheckDelay * 1.1));
                Properties now = this.lock.load();
                if (!now.equals(old)) {
                    return false;
                }
            } else {
                Thread.sleep(1L);
            }
            this.reconnectLastLock = old;
            this.reconnectChangePending = pending;
            this.reconnectCheckNext = System.currentTimeMillis() + (long)this.reconnectCheckDelay;
            return true;
        }
        catch (Exception e) {
            this.trace.error(e, "pending {0}", pending);
            return false;
        }
    }

    public long getNextModificationDataId() {
        return ++this.modificationDataId;
    }

    public long getModificationMetaId() {
        return this.modificationMetaId;
    }

    public long getNextModificationMetaId() {
        ++this.modificationDataId;
        return this.modificationMetaId++;
    }

    public int getPowerOffCount() {
        return this.powerOffCount;
    }

    @Override
    public void checkPowerOff() {
        if (this.powerOffCount == 0) {
            return;
        }
        if (this.powerOffCount > 1) {
            --this.powerOffCount;
            return;
        }
        if (this.powerOffCount != -1) {
            try {
                this.powerOffCount = -1;
                this.stopWriter();
                if (this.pageStore != null) {
                    try {
                        this.pageStore.close();
                    }
                    catch (DbException e) {
                        // empty catch block
                    }
                    this.pageStore = null;
                }
                if (this.lock != null) {
                    this.stopServer();
                    if (this.fileLockMethod != 3) {
                        this.lock.unlock();
                    }
                    this.lock = null;
                }
                if (this.traceSystem != null) {
                    this.traceSystem.close();
                }
            }
            catch (DbException e) {
                TraceSystem.traceThrowable(e);
            }
        }
        Engine.getInstance().close(this.databaseName);
        throw DbException.get(90098);
    }

    static boolean exists(String name) {
        return FileUtils.exists(name + ".h2.db");
    }

    public Trace getTrace(String module) {
        return this.traceSystem.getTrace(module);
    }

    @Override
    public FileStore openFile(String name, String openMode, boolean mustExist) {
        if (mustExist && !FileUtils.exists(name)) {
            throw DbException.get(90124, name);
        }
        FileStore store = FileStore.open(this, name, openMode, this.cipher, this.filePasswordHash);
        try {
            store.init();
        }
        catch (DbException e) {
            store.closeSilently();
            throw e;
        }
        return store;
    }

    boolean validateFilePasswordHash(String testCipher, byte[] testHash) {
        if (!StringUtils.equals(testCipher, this.cipher)) {
            return false;
        }
        return Utils.compareSecure(testHash, this.filePasswordHash);
    }

    private String parseDatabaseShortName() {
        String n = this.databaseName;
        if (n.endsWith(":")) {
            n = null;
        }
        if (n != null) {
            StringTokenizer tokenizer = new StringTokenizer(n, "/\\:,;");
            while (tokenizer.hasMoreTokens()) {
                n = tokenizer.nextToken();
            }
        }
        if (n == null || n.length() == 0) {
            n = "unnamed";
        }
        return this.dbSettings.databaseToUpper ? StringUtils.toUpperEnglish(n) : n;
    }

    private synchronized void open(int traceLevelFile, int traceLevelSystemOut) {
        if (this.persistent) {
            String dataFileName = this.databaseName + ".data.db";
            boolean existsData = FileUtils.exists(dataFileName);
            String pageFileName = this.databaseName + ".h2.db";
            boolean existsPage = FileUtils.exists(pageFileName);
            if (existsData && !existsPage) {
                throw DbException.get(90048, "Old database: " + dataFileName + " - please convert the database to a SQL script and re-create it.");
            }
            if (existsPage && !FileUtils.canWrite(pageFileName)) {
                this.readOnly = true;
            }
            this.traceSystem = this.readOnly ? new TraceSystem(null) : new TraceSystem(this.databaseName + ".trace.db");
            this.traceSystem.setLevelFile(traceLevelFile);
            this.traceSystem.setLevelSystemOut(traceLevelSystemOut);
            this.trace = this.traceSystem.getTrace("database");
            this.trace.info("opening {0} (build {1})", this.databaseName, 168);
            if (this.autoServerMode && (this.readOnly || this.fileLockMethod == 0 || this.fileLockMethod == 3 || this.fileLockMethod == 4 || !this.persistent)) {
                throw DbException.getUnsupportedException("autoServerMode && (readOnly || fileLockMethod == NO || fileLockMethod == SERIALIZED || inMemory)");
            }
            String lockFileName = this.databaseName + ".lock.db";
            if (this.readOnly && FileUtils.exists(lockFileName)) {
                throw DbException.get(90020, "Lock file exists: " + lockFileName);
            }
            if (!this.readOnly && this.fileLockMethod != 0 && this.fileLockMethod != 4) {
                this.lock = new FileLock(this.traceSystem, lockFileName, 1000);
                this.lock.lock(this.fileLockMethod);
                if (this.autoServerMode) {
                    this.startServer(this.lock.getUniqueId());
                }
            }
            if (SysProperties.MODIFY_ON_WRITE) {
                while (this.isReconnectNeeded()) {
                }
            } else {
                while (this.isReconnectNeeded() && !this.beforeWriting()) {
                }
            }
            this.deleteOldTempFiles();
            this.starting = true;
            if (SysProperties.MODIFY_ON_WRITE) {
                try {
                    this.getPageStore();
                }
                catch (DbException e) {
                    if (e.getErrorCode() != 90097) {
                        throw e;
                    }
                    this.pageStore = null;
                    while (!this.beforeWriting()) {
                    }
                    this.getPageStore();
                }
            } else {
                this.getPageStore();
            }
            this.starting = false;
            this.writer = WriterThread.create(this, this.writeDelay);
        } else {
            if (this.autoServerMode) {
                throw DbException.getUnsupportedException("autoServerMode && inMemory");
            }
            this.traceSystem = new TraceSystem(null);
            this.trace = this.traceSystem.getTrace("database");
        }
        this.systemUser = new User(this, 0, SYSTEM_USER_NAME, true);
        this.mainSchema = new Schema(this, 0, "PUBLIC", this.systemUser, true);
        this.infoSchema = new Schema(this, -1, "INFORMATION_SCHEMA", this.systemUser, true);
        this.schemas.put(this.mainSchema.getName(), this.mainSchema);
        this.schemas.put(this.infoSchema.getName(), this.infoSchema);
        this.publicRole = new Role(this, 0, "PUBLIC", true);
        this.roles.put("PUBLIC", this.publicRole);
        this.systemUser.setAdmin(true);
        this.systemSession = new Session(this, this.systemUser, ++this.nextSessionId);
        CreateTableData data = new CreateTableData();
        ArrayList<Column> cols = data.columns;
        Column columnId = new Column("ID", 4);
        columnId.setNullable(false);
        cols.add(columnId);
        cols.add(new Column("HEAD", 4));
        cols.add(new Column("TYPE", 4));
        cols.add(new Column("SQL", 13));
        boolean create = true;
        if (this.pageStore != null) {
            create = this.pageStore.isNew();
        }
        data.tableName = "SYS";
        data.id = 0;
        data.temporary = false;
        data.persistData = this.persistent;
        data.persistIndexes = this.persistent;
        data.create = create;
        data.isHidden = true;
        data.session = this.systemSession;
        this.meta = this.mainSchema.createTable(data);
        IndexColumn[] pkCols = IndexColumn.wrap(new Column[]{columnId});
        this.metaIdIndex = this.meta.addIndex(this.systemSession, "SYS_ID", 0, pkCols, IndexType.createPrimaryKey(false, false), true, null);
        this.objectIds.set(0);
        this.starting = true;
        Cursor cursor = this.metaIdIndex.find(this.systemSession, null, null);
        ArrayList<MetaRecord> records = New.arrayList();
        while (cursor.next()) {
            MetaRecord rec = new MetaRecord(cursor.get());
            this.objectIds.set(rec.getId());
            records.add(rec);
        }
        Collections.sort(records);
        for (MetaRecord rec : records) {
            rec.execute(this, this.systemSession, this.eventListener);
        }
        this.recompileInvalidViews(this.systemSession);
        this.starting = false;
        if (!this.readOnly) {
            String name = SetTypes.getTypeName(34);
            if (this.settings.get(name) == null) {
                Setting setting = new Setting(this, this.allocateObjectId(), name);
                setting.setIntValue(168);
                this.lockMeta(this.systemSession);
                this.addDatabaseObject(this.systemSession, setting);
            }
            if (this.pageStore != null) {
                BitField f = this.pageStore.getObjectIds();
                int len = f.length();
                for (int i = 0; i < len; ++i) {
                    if (!f.get(i) || this.objectIds.get(i)) continue;
                    this.trace.info("unused object id: " + i);
                    this.objectIds.set(i);
                }
            }
        }
        this.getLobStorage().init();
        this.systemSession.commit(true);
        this.trace.info("opened {0}", this.databaseName);
        if (this.checkpointAllowed > 0) {
            this.afterWriting();
        }
    }

    private void startServer(String key) {
        try {
            this.server = Server.createTcpServer("-tcpPort", Integer.toString(this.autoServerPort), "-tcpAllowOthers", "-tcpDaemon", "-key", key, this.databaseName);
            this.server.start();
        }
        catch (SQLException e) {
            throw DbException.convert(e);
        }
        String address = NetUtils.getLocalAddress() + ":" + this.server.getPort();
        this.lock.setProperty("server", address);
        this.lock.save();
    }

    private void stopServer() {
        if (this.server != null) {
            Server s = this.server;
            this.server = null;
            s.stop();
        }
    }

    private void recompileInvalidViews(Session session) {
        TableView view;
        boolean recompileSuccessful;
        do {
            recompileSuccessful = false;
            for (Table obj : this.getAllTablesAndViews(false)) {
                if (!(obj instanceof TableView) || !(view = (TableView)obj).isInvalid()) continue;
                view.recompile(session, true);
                if (view.isInvalid()) continue;
                recompileSuccessful = true;
            }
        } while (recompileSuccessful);
        for (Table obj : this.getAllTablesAndViews(false)) {
            if (!(obj instanceof TableView) || (view = (TableView)obj).isInvalid()) continue;
            view.recompile(this.systemSession, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initMetaTables() {
        if (this.metaTablesInitialized) {
            return;
        }
        Schema schema = this.infoSchema;
        synchronized (schema) {
            if (!this.metaTablesInitialized) {
                int count = MetaTable.getMetaTableTypeCount();
                for (int type = 0; type < count; ++type) {
                    MetaTable m = new MetaTable(this.infoSchema, -1 - type, type);
                    this.infoSchema.add(m);
                }
                this.metaTablesInitialized = true;
            }
        }
    }

    private synchronized void addMeta(Session session, DbObject obj) {
        int id = obj.getId();
        if (id > 0 && !this.starting && !obj.isTemporary()) {
            Row r = this.meta.getTemplateRow();
            MetaRecord rec = new MetaRecord(obj);
            rec.setRecord(r);
            this.objectIds.set(id);
            if (SysProperties.CHECK) {
                this.verifyMetaLocked(session);
            }
            this.meta.addRow(session, r);
            if (this.isMultiVersion()) {
                session.log(this.meta, (short)0, r);
            }
        }
    }

    public void verifyMetaLocked(Session session) {
        if (!this.lockMeta(session) && this.lockMode != 0) {
            throw DbException.throwInternalError();
        }
    }

    public synchronized boolean lockMeta(Session session) {
        if (this.meta == null) {
            return true;
        }
        boolean wasLocked = this.meta.isLockedExclusivelyBy(session);
        this.meta.lock(session, true, true);
        return wasLocked;
    }

    public synchronized void removeMeta(Session session, int id) {
        if (id > 0 && !this.starting) {
            SearchRow r = this.meta.getTemplateSimpleRow(false);
            r.setValue(0, ValueInt.get(id));
            boolean wasLocked = this.lockMeta(session);
            Cursor cursor = this.metaIdIndex.find(session, r, r);
            if (cursor.next()) {
                if (SysProperties.CHECK && this.lockMode != 0 && !wasLocked) {
                    throw DbException.throwInternalError();
                }
                Row found = cursor.get();
                this.meta.removeRow(session, found);
                if (this.isMultiVersion()) {
                    session.log(this.meta, (short)1, found);
                }
                this.objectIds.clear(id);
                if (SysProperties.CHECK) {
                    this.checkMetaFree(session, id);
                }
            } else if (!wasLocked) {
                this.meta.unlock(session);
                session.unlock(this.meta);
            }
        }
    }

    private HashMap<String, DbObject> getMap(int type) {
        HashMap<String, DbObject> result;
        switch (type) {
            case 2: {
                result = this.users;
                break;
            }
            case 6: {
                result = this.settings;
                break;
            }
            case 7: {
                result = this.roles;
                break;
            }
            case 8: {
                result = this.rights;
                break;
            }
            case 10: {
                result = this.schemas;
                break;
            }
            case 12: {
                result = this.userDataTypes;
                break;
            }
            case 13: {
                result = this.comments;
                break;
            }
            case 14: {
                result = this.aggregates;
                break;
            }
            default: {
                throw DbException.throwInternalError("type=" + type);
            }
        }
        return result;
    }

    public synchronized void addSchemaObject(Session session, SchemaObject obj) {
        int id = obj.getId();
        if (id > 0 && !this.starting) {
            this.checkWritingAllowed();
        }
        this.lockMeta(session);
        obj.getSchema().add(obj);
        this.addMeta(session, obj);
    }

    public synchronized void addDatabaseObject(Session session, DbObject obj) {
        User user;
        int id = obj.getId();
        if (id > 0 && !this.starting) {
            this.checkWritingAllowed();
        }
        HashMap<String, DbObject> map = this.getMap(obj.getType());
        if (obj.getType() == 2 && (user = (User)obj).isAdmin() && this.systemUser.getName().equals(SYSTEM_USER_NAME)) {
            this.systemUser.rename(user.getName());
        }
        String name = obj.getName();
        if (SysProperties.CHECK && map.get(name) != null) {
            DbException.throwInternalError("object already exists");
        }
        this.lockMeta(session);
        this.addMeta(session, obj);
        map.put(name, obj);
    }

    public UserAggregate findAggregate(String name) {
        return this.aggregates.get(name);
    }

    public Comment findComment(DbObject object) {
        if (object.getType() == 13) {
            return null;
        }
        String key = Comment.getKey(object);
        return this.comments.get(key);
    }

    public Role findRole(String roleName) {
        return this.roles.get(roleName);
    }

    public Schema findSchema(String schemaName) {
        Schema schema = this.schemas.get(schemaName);
        if (schema == this.infoSchema) {
            this.initMetaTables();
        }
        return schema;
    }

    public Setting findSetting(String name) {
        return this.settings.get(name);
    }

    public User findUser(String name) {
        return this.users.get(name);
    }

    public UserDataType findUserDataType(String name) {
        return this.userDataTypes.get(name);
    }

    public User getUser(String name) {
        User user = this.findUser(name);
        if (user == null) {
            throw DbException.get(90032, name);
        }
        return user;
    }

    synchronized Session createSession(User user) {
        if (this.exclusiveSession != null) {
            throw DbException.get(90135);
        }
        Session session = new Session(this, user, ++this.nextSessionId);
        this.userSessions.add(session);
        this.trace.info("connecting session #{0} to {1}", session.getId(), this.databaseName);
        if (this.delayedCloser != null) {
            this.delayedCloser.reset();
            this.delayedCloser = null;
        }
        return session;
    }

    public synchronized void removeSession(Session session) {
        if (session != null) {
            if (this.exclusiveSession == session) {
                this.exclusiveSession = null;
            }
            this.userSessions.remove(session);
            if (session != this.systemSession) {
                this.trace.info("disconnecting session #{0}", session.getId());
            }
        }
        if (this.userSessions.size() == 0 && session != this.systemSession) {
            if (this.closeDelay == 0) {
                this.close(false);
            } else {
                if (this.closeDelay < 0) {
                    return;
                }
                this.delayedCloser = new DatabaseCloser(this, this.closeDelay * 1000, false);
                this.delayedCloser.setName("H2 Close Delay " + this.getShortName());
                this.delayedCloser.setDaemon(true);
                this.delayedCloser.start();
            }
        }
        if (session != this.systemSession && session != null) {
            this.trace.info("disconnected session #{0}", session.getId());
        }
    }

    private synchronized void closeAllSessionsException(Session except) {
        Session[] all = new Session[this.userSessions.size()];
        this.userSessions.toArray(all);
        for (Session s : all) {
            if (s == except) continue;
            try {
                s.rollback();
                s.close();
            }
            catch (DbException e) {
                this.trace.error(e, "disconnecting session #{0}", s.getId());
            }
        }
    }

    synchronized void close(boolean fromShutdownHook) {
        if (this.closing) {
            return;
        }
        if (this.fileLockMethod == 3 && !this.reconnectChangePending) {
            try {
                this.closeOpenFilesAndUnlock(false);
            }
            catch (DbException e) {
                // empty catch block
            }
            this.traceSystem.close();
            Engine.getInstance().close(this.databaseName);
            return;
        }
        this.closing = true;
        this.stopServer();
        if (this.userSessions.size() > 0) {
            if (!fromShutdownHook) {
                return;
            }
            this.trace.info("closing {0} from shutdown hook", this.databaseName);
            this.closeAllSessionsException(null);
        }
        this.trace.info("closing {0}", this.databaseName);
        if (this.eventListener != null) {
            this.closing = false;
            DatabaseEventListener e = this.eventListener;
            this.eventListener = null;
            e.closingDatabase();
            if (this.userSessions.size() > 0) {
                return;
            }
            this.closing = true;
        }
        if (this.persistent) {
            boolean lobStorageIsUsed;
            boolean bl = lobStorageIsUsed = this.infoSchema.findTableOrView(this.systemSession, "LOB_DATA") != null;
            if (lobStorageIsUsed) {
                try {
                    this.getLobStorage();
                    this.lobStorage.removeAllForTable(-1);
                }
                catch (DbException e) {
                    this.trace.error(e, "close");
                }
            }
        }
        try {
            if (this.systemSession != null) {
                if (this.powerOffCount != -1) {
                    for (Table table : this.getAllTablesAndViews(false)) {
                        if (table.isGlobalTemporary()) {
                            table.removeChildrenAndResources(this.systemSession);
                            continue;
                        }
                        table.close(this.systemSession);
                    }
                    for (SchemaObject obj : this.getAllSchemaObjects(3)) {
                        Sequence sequence = (Sequence)obj;
                        sequence.close();
                    }
                }
                for (SchemaObject obj : this.getAllSchemaObjects(4)) {
                    TriggerObject trigger = (TriggerObject)obj;
                    try {
                        trigger.close();
                    }
                    catch (SQLException e) {
                        this.trace.error(e, "close");
                    }
                }
                if (this.powerOffCount != -1) {
                    this.meta.close(this.systemSession);
                    this.systemSession.commit(true);
                }
            }
        }
        catch (DbException e) {
            this.trace.error(e, "close");
        }
        this.tempFileDeleter.deleteAll();
        try {
            this.closeOpenFilesAndUnlock(true);
        }
        catch (DbException e) {
            this.trace.error(e, "close");
        }
        this.trace.info("closed");
        this.traceSystem.close();
        if (this.closeOnExit != null) {
            this.closeOnExit.reset();
            try {
                Runtime.getRuntime().removeShutdownHook(this.closeOnExit);
            }
            catch (IllegalStateException e) {
            }
            catch (SecurityException e) {
                // empty catch block
            }
            this.closeOnExit = null;
        }
        Engine.getInstance().close(this.databaseName);
        if (this.deleteFilesOnDisconnect && this.persistent) {
            this.deleteFilesOnDisconnect = false;
            try {
                String directory = FileUtils.getParent(this.databaseName);
                String name = FileUtils.getName(this.databaseName);
                DeleteDbFiles.execute(directory, name, true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void stopWriter() {
        if (this.writer != null) {
            this.writer.stopThread();
            this.writer = null;
        }
    }

    private synchronized void closeOpenFilesAndUnlock(boolean flush) {
        this.stopWriter();
        if (this.pageStore != null && flush) {
            try {
                this.pageStore.checkpoint();
                if (!this.readOnly) {
                    this.lockMeta(this.pageStore.getSystemSession());
                    this.pageStore.compact(this.compactMode);
                }
            }
            catch (DbException e) {
                int code;
                if (SysProperties.CHECK2 && (code = e.getErrorCode()) != 90098 && code != 50200 && code != 90031) {
                    e.printStackTrace();
                }
                this.trace.error(e, "close");
            }
            catch (Throwable t) {
                if (SysProperties.CHECK2) {
                    t.printStackTrace();
                }
                this.trace.error(t, "close");
            }
        }
        this.reconnectModified(false);
        this.closeFiles();
        if (this.persistent && this.lock == null && this.fileLockMethod != 0 && this.fileLockMethod != 4) {
            return;
        }
        if (this.persistent) {
            this.deleteOldTempFiles();
        }
        if (this.systemSession != null) {
            this.systemSession.close();
            this.systemSession = null;
        }
        if (this.lock != null) {
            if (this.fileLockMethod == 3 && this.lock.load().containsKey("changePending")) {
                try {
                    Thread.sleep((int)((double)this.reconnectCheckDelay * 1.1));
                }
                catch (InterruptedException e) {
                    this.trace.error(e, "close");
                }
            }
            this.lock.unlock();
            this.lock = null;
        }
    }

    private synchronized void closeFiles() {
        try {
            if (this.pageStore != null) {
                this.pageStore.close();
                this.pageStore = null;
            }
        }
        catch (DbException e) {
            this.trace.error(e, "close");
        }
    }

    private void checkMetaFree(Session session, int id) {
        SearchRow r = this.meta.getTemplateSimpleRow(false);
        r.setValue(0, ValueInt.get(id));
        Cursor cursor = this.metaIdIndex.find(session, r, r);
        if (cursor.next()) {
            DbException.throwInternalError();
        }
    }

    public synchronized int allocateObjectId() {
        int i = this.objectIds.nextClearBit(0);
        this.objectIds.set(i);
        return i;
    }

    public ArrayList<UserAggregate> getAllAggregates() {
        return New.arrayList(this.aggregates.values());
    }

    public ArrayList<Comment> getAllComments() {
        return New.arrayList(this.comments.values());
    }

    public int getAllowLiterals() {
        if (this.starting) {
            return 2;
        }
        return this.allowLiterals;
    }

    public ArrayList<Right> getAllRights() {
        return New.arrayList(this.rights.values());
    }

    public ArrayList<Role> getAllRoles() {
        return New.arrayList(this.roles.values());
    }

    public ArrayList<SchemaObject> getAllSchemaObjects() {
        this.initMetaTables();
        ArrayList<SchemaObject> list = New.arrayList();
        for (Schema schema : this.schemas.values()) {
            list.addAll(schema.getAll());
        }
        return list;
    }

    public ArrayList<SchemaObject> getAllSchemaObjects(int type) {
        if (type == 0) {
            this.initMetaTables();
        }
        ArrayList<SchemaObject> list = New.arrayList();
        for (Schema schema : this.schemas.values()) {
            list.addAll(schema.getAll(type));
        }
        return list;
    }

    public ArrayList<Table> getAllTablesAndViews(boolean includeMeta) {
        if (includeMeta) {
            this.initMetaTables();
        }
        ArrayList<Table> list = New.arrayList();
        for (Schema schema : this.schemas.values()) {
            list.addAll(schema.getAllTablesAndViews());
        }
        return list;
    }

    public ArrayList<Schema> getAllSchemas() {
        this.initMetaTables();
        return New.arrayList(this.schemas.values());
    }

    public ArrayList<Setting> getAllSettings() {
        return New.arrayList(this.settings.values());
    }

    public ArrayList<UserDataType> getAllUserDataTypes() {
        return New.arrayList(this.userDataTypes.values());
    }

    public ArrayList<User> getAllUsers() {
        return New.arrayList(this.users.values());
    }

    public String getCacheType() {
        return this.cacheType;
    }

    public String getCluster() {
        return this.cluster;
    }

    public CompareMode getCompareMode() {
        return this.compareMode;
    }

    @Override
    public String getDatabasePath() {
        if (this.persistent) {
            return FileUtils.toRealPath(this.databaseName);
        }
        return null;
    }

    public String getShortName() {
        return this.databaseShortName;
    }

    public String getName() {
        return this.databaseName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session[] getSessions(boolean includingSystemSession) {
        ArrayList<Session> list;
        Set<Session> set = this.userSessions;
        synchronized (set) {
            list = New.arrayList(this.userSessions);
        }
        Session sys = this.systemSession;
        if (includingSystemSession && sys != null) {
            list.add(sys);
        }
        Session[] array = new Session[list.size()];
        list.toArray(array);
        return array;
    }

    public synchronized void update(Session session, DbObject obj) {
        this.lockMeta(session);
        int id = obj.getId();
        this.removeMeta(session, id);
        this.addMeta(session, obj);
    }

    public synchronized void renameSchemaObject(Session session, SchemaObject obj, String newName) {
        this.checkWritingAllowed();
        obj.getSchema().rename(obj, newName);
        this.updateWithChildren(session, obj);
    }

    private synchronized void updateWithChildren(Session session, DbObject obj) {
        ArrayList<DbObject> list = obj.getChildren();
        Comment comment = this.findComment(obj);
        if (comment != null) {
            DbException.throwInternalError();
        }
        this.update(session, obj);
        if (list != null) {
            for (DbObject o : list) {
                if (o.getCreateSQL() == null) continue;
                this.update(session, o);
            }
        }
    }

    public synchronized void renameDatabaseObject(Session session, DbObject obj, String newName) {
        this.checkWritingAllowed();
        int type = obj.getType();
        HashMap<String, DbObject> map = this.getMap(type);
        if (SysProperties.CHECK) {
            if (!map.containsKey(obj.getName())) {
                DbException.throwInternalError("not found: " + obj.getName());
            }
            if (obj.getName().equals(newName) || map.containsKey(newName)) {
                DbException.throwInternalError("object already exists: " + newName);
            }
        }
        obj.checkRename();
        int id = obj.getId();
        this.lockMeta(session);
        this.removeMeta(session, id);
        map.remove(obj.getName());
        obj.rename(newName);
        map.put(newName, obj);
        this.updateWithChildren(session, obj);
    }

    public String createTempFile() {
        try {
            boolean inTempDir = this.readOnly;
            String name = this.databaseName;
            if (!this.persistent) {
                name = "memFS:" + name;
            }
            return FileUtils.createTempFile(name, ".temp.db", true, inTempDir);
        }
        catch (IOException e) {
            throw DbException.convertIOException(e, this.databaseName);
        }
    }

    private void deleteOldTempFiles() {
        String path = FileUtils.getParent(this.databaseName);
        for (String name : FileUtils.newDirectoryStream(path)) {
            if (!name.endsWith(".temp.db") || !name.startsWith(this.databaseName)) continue;
            FileUtils.tryDelete(name);
        }
    }

    public Schema getSchema(String schemaName) {
        Schema schema = this.findSchema(schemaName);
        if (schema == null) {
            throw DbException.get(90079, schemaName);
        }
        return schema;
    }

    public synchronized void removeDatabaseObject(Session session, DbObject obj) {
        this.checkWritingAllowed();
        String objName = obj.getName();
        int type = obj.getType();
        HashMap<String, DbObject> map = this.getMap(type);
        if (SysProperties.CHECK && !map.containsKey(objName)) {
            DbException.throwInternalError("not found: " + objName);
        }
        Comment comment = this.findComment(obj);
        this.lockMeta(session);
        if (comment != null) {
            this.removeDatabaseObject(session, comment);
        }
        int id = obj.getId();
        obj.removeChildrenAndResources(session);
        map.remove(objName);
        this.removeMeta(session, id);
    }

    public Table getDependentTable(SchemaObject obj, Table except) {
        switch (obj.getType()) {
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 8: 
            case 13: {
                return null;
            }
        }
        HashSet<DbObject> set = New.hashSet();
        for (Table t : this.getAllTablesAndViews(false)) {
            if (except == t) continue;
            set.clear();
            t.addDependencies(set);
            if (!set.contains(obj)) continue;
            return t;
        }
        return null;
    }

    public synchronized void removeSchemaObject(Session session, SchemaObject obj) {
        Constraint constraint;
        Table table;
        int type = obj.getType();
        if (type == 0) {
            Table table2 = (Table)obj;
            if (table2.isTemporary() && !table2.isGlobalTemporary()) {
                session.removeLocalTempTable(table2);
                return;
            }
        } else if (type == 1) {
            Index index = (Index)obj;
            table = index.getTable();
            if (table.isTemporary() && !table.isGlobalTemporary()) {
                session.removeLocalTempTableIndex(index);
                return;
            }
        } else if (type == 5 && (table = (constraint = (Constraint)obj).getTable()).isTemporary() && !table.isGlobalTemporary()) {
            session.removeLocalTempTableConstraint(constraint);
            return;
        }
        this.checkWritingAllowed();
        this.lockMeta(session);
        Comment comment = this.findComment(obj);
        if (comment != null) {
            this.removeDatabaseObject(session, comment);
        }
        obj.getSchema().remove(obj);
        int id = obj.getId();
        if (!this.starting) {
            Table t = this.getDependentTable(obj, null);
            if (t != null) {
                obj.getSchema().add(obj);
                throw DbException.get(90107, obj.getSQL(), t.getSQL());
            }
            obj.removeChildrenAndResources(session);
        }
        this.removeMeta(session, id);
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public TraceSystem getTraceSystem() {
        return this.traceSystem;
    }

    public synchronized void setCacheSize(int kb) {
        if (this.starting) {
            int max = MathUtils.convertLongToInt(Utils.getMemoryMax()) / 2;
            kb = Math.min(kb, max);
        }
        this.cacheSize = kb;
        if (this.pageStore != null) {
            this.pageStore.getCache().setMaxMemory(kb);
        }
    }

    public synchronized void setMasterUser(User user) {
        this.lockMeta(this.systemSession);
        this.addDatabaseObject(this.systemSession, user);
        this.systemSession.commit(true);
    }

    public Role getPublicRole() {
        return this.publicRole;
    }

    public synchronized String getTempTableName(String baseName, Session session) {
        String tempName;
        while (this.mainSchema.findTableOrView(session, tempName = baseName + "_COPY_" + session.getId() + "_" + this.nextTempTableId++) != null) {
        }
        return tempName;
    }

    public void setCompareMode(CompareMode compareMode) {
        this.compareMode = compareMode;
    }

    public void setCluster(String cluster) {
        this.cluster = cluster;
    }

    @Override
    public void checkWritingAllowed() {
        if (this.readOnly) {
            throw DbException.get(90097);
        }
        if (this.noDiskSpace) {
            throw DbException.get(90100);
        }
        if (this.fileLockMethod == 3 && !this.reconnectChangePending) {
            throw DbException.get(90097);
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setWriteDelay(int value) {
        this.writeDelay = value;
        if (this.writer != null) {
            this.writer.setWriteDelay(value);
            this.flushOnEachCommit = this.writeDelay < 5;
        }
    }

    public boolean getFlushOnEachCommit() {
        return this.flushOnEachCommit;
    }

    public ArrayList<InDoubtTransaction> getInDoubtTransactions() {
        return this.pageStore == null ? null : this.pageStore.getInDoubtTransactions();
    }

    synchronized void prepareCommit(Session session, String transaction) {
        if (this.readOnly) {
            return;
        }
        this.pageStore.prepareCommit(session, transaction);
    }

    synchronized void commit(Session session) {
        if (this.readOnly) {
            return;
        }
        if (this.pageStore != null) {
            this.pageStore.commit(session);
        }
        session.setAllCommitted();
    }

    public synchronized void flush() {
        if (this.readOnly || this.pageStore == null) {
            return;
        }
        this.pageStore.flushLog();
    }

    public void setEventListener(DatabaseEventListener eventListener) {
        this.eventListener = eventListener;
    }

    public void setEventListenerClass(String className) {
        if (className == null || className.length() == 0) {
            this.eventListener = null;
        } else {
            try {
                this.eventListener = (DatabaseEventListener)Utils.loadUserClass(className).newInstance();
                String url = this.databaseURL;
                if (this.cipher != null) {
                    url = url + ";CIPHER=" + this.cipher;
                }
                this.eventListener.init(url);
            }
            catch (Throwable e) {
                throw DbException.get(90099, e, className, e.toString());
            }
        }
    }

    public void setProgress(int state, String name, int x, int max) {
        if (this.eventListener != null) {
            try {
                this.eventListener.setProgress(state, name, x, max);
            }
            catch (Exception e2) {
                // empty catch block
            }
        }
    }

    public void exceptionThrown(SQLException e, String sql) {
        if (this.eventListener != null) {
            try {
                this.eventListener.exceptionThrown(e, sql);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public synchronized void sync() {
        if (this.readOnly || this.pageStore == null) {
            return;
        }
        this.pageStore.sync();
    }

    public int getMaxMemoryRows() {
        return this.maxMemoryRows;
    }

    public void setMaxMemoryRows(int value) {
        this.maxMemoryRows = value;
    }

    public void setMaxMemoryUndo(int value) {
        this.maxMemoryUndo = value;
    }

    public int getMaxMemoryUndo() {
        return this.maxMemoryUndo;
    }

    public void setLockMode(int lockMode) {
        switch (lockMode) {
            case 0: {
                if (!this.multiThreaded) break;
                throw DbException.get(90133, "LOCK_MODE=0 & MULTI_THREADED");
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw DbException.getInvalidValueException("lock mode", lockMode);
            }
        }
        this.lockMode = lockMode;
    }

    public int getLockMode() {
        return this.lockMode;
    }

    public synchronized void setCloseDelay(int value) {
        this.closeDelay = value;
    }

    public Session getSystemSession() {
        return this.systemSession;
    }

    public boolean isClosing() {
        return this.closing;
    }

    public void setMaxLengthInplaceLob(int value) {
        this.maxLengthInplaceLob = value;
    }

    @Override
    public int getMaxLengthInplaceLob() {
        return this.persistent ? this.maxLengthInplaceLob : Integer.MAX_VALUE;
    }

    public void setIgnoreCase(boolean b) {
        this.ignoreCase = b;
    }

    public boolean getIgnoreCase() {
        if (this.starting) {
            return false;
        }
        return this.ignoreCase;
    }

    public synchronized void setDeleteFilesOnDisconnect(boolean b) {
        this.deleteFilesOnDisconnect = b;
    }

    @Override
    public String getLobCompressionAlgorithm(int type) {
        return this.lobCompressionAlgorithm;
    }

    public void setLobCompressionAlgorithm(String stringValue) {
        this.lobCompressionAlgorithm = stringValue;
    }

    public synchronized void setMaxLogSize(long value) {
        if (this.pageStore != null) {
            this.pageStore.setMaxLogSize(value);
        }
    }

    public void setAllowLiterals(int value) {
        this.allowLiterals = value;
    }

    public boolean getOptimizeReuseResults() {
        return this.optimizeReuseResults;
    }

    public void setOptimizeReuseResults(boolean b) {
        this.optimizeReuseResults = b;
    }

    @Override
    public Object getLobSyncObject() {
        return this.lobSyncObject;
    }

    public int getSessionCount() {
        return this.userSessions.size();
    }

    public void setReferentialIntegrity(boolean b) {
        this.referentialIntegrity = b;
    }

    public boolean getReferentialIntegrity() {
        return this.referentialIntegrity;
    }

    public boolean isStarting() {
        return this.starting;
    }

    public boolean isMultiVersion() {
        return this.multiVersion;
    }

    void opened() {
        if (this.eventListener != null) {
            this.eventListener.opened();
        }
        if (this.writer != null) {
            this.writer.startThread();
        }
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public Mode getMode() {
        return this.mode;
    }

    public boolean isMultiThreaded() {
        return this.multiThreaded;
    }

    public void setMultiThreaded(boolean multiThreaded) {
        if (multiThreaded && this.multiThreaded != multiThreaded) {
            if (this.multiVersion) {
                throw DbException.get(90133, "MVCC & MULTI_THREADED");
            }
            if (this.lockMode == 0) {
                throw DbException.get(90133, "LOCK_MODE=0 & MULTI_THREADED");
            }
        }
        this.multiThreaded = multiThreaded;
    }

    public void setMaxOperationMemory(int maxOperationMemory) {
        this.maxOperationMemory = maxOperationMemory;
    }

    public int getMaxOperationMemory() {
        return this.maxOperationMemory;
    }

    public Session getExclusiveSession() {
        return this.exclusiveSession;
    }

    public void setExclusiveSession(Session session, boolean closeOthers) {
        this.exclusiveSession = session;
        if (closeOthers) {
            this.closeAllSessionsException(session);
        }
    }

    @Override
    public SmallLRUCache<String, String[]> getLobFileListCache() {
        if (this.lobFileListCache == null) {
            this.lobFileListCache = SmallLRUCache.newInstance(128);
        }
        return this.lobFileListCache;
    }

    public boolean isSysTableLocked() {
        return this.meta == null || this.meta.isLockedExclusively();
    }

    public TableLinkConnection getLinkConnection(String driver, String url, String user, String password) {
        if (this.linkConnections == null) {
            this.linkConnections = New.hashMap();
        }
        return TableLinkConnection.open(this.linkConnections, driver, url, user, password, this.dbSettings.shareLinkedConnections);
    }

    public String toString() {
        return this.databaseShortName + ":" + super.toString();
    }

    public void shutdownImmediately() {
        this.setPowerOffCount(1);
        try {
            this.checkPowerOff();
        }
        catch (DbException dbException) {
            // empty catch block
        }
        this.closeFiles();
    }

    @Override
    public TempFileDeleter getTempFileDeleter() {
        return this.tempFileDeleter;
    }

    public PageStore getPageStore() {
        if (this.pageStore == null) {
            this.pageStore = new PageStore(this, this.databaseName + ".h2.db", this.accessModeData, this.cacheSize);
            if (this.pageSize != 2048) {
                this.pageStore.setPageSize(this.pageSize);
            }
            if (!this.readOnly && this.fileLockMethod == 4) {
                this.pageStore.setLockFile(true);
            }
            this.pageStore.setLogMode(this.logMode);
            this.pageStore.open();
        }
        return this.pageStore;
    }

    public Table getFirstUserTable() {
        for (Table table : this.getAllTablesAndViews(false)) {
            if (table.getCreateSQL() == null || table.isHidden()) continue;
            return table;
        }
        return null;
    }

    public boolean isReconnectNeeded() {
        if (this.fileLockMethod != 3) {
            return false;
        }
        if (this.reconnectChangePending) {
            return false;
        }
        long now = System.currentTimeMillis();
        if (now < this.reconnectCheckNext) {
            return false;
        }
        this.reconnectCheckNext = now + (long)this.reconnectCheckDelay;
        if (this.lock == null) {
            this.lock = new FileLock(this.traceSystem, this.databaseName + ".lock.db", 1000);
        }
        try {
            Properties prop;
            Properties first = prop = this.lock.load();
            while (true) {
                if (prop.equals(this.reconnectLastLock)) {
                    return false;
                }
                if (prop.getProperty("changePending", null) == null) break;
                if (System.currentTimeMillis() > now + (long)(this.reconnectCheckDelay * 10) && first.equals(prop)) {
                    this.lock.setProperty("changePending", null);
                    this.lock.save();
                    break;
                }
                this.trace.debug("delay (change pending)");
                Thread.sleep(this.reconnectCheckDelay);
                prop = this.lock.load();
            }
            this.reconnectLastLock = prop;
        }
        catch (Exception e) {
            this.trace.error(e, "readOnly {0}", this.readOnly);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkpointIfRequired() {
        if (this.fileLockMethod != 3 || this.readOnly || !this.reconnectChangePending || this.closing) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now > this.reconnectCheckNext + (long)this.reconnectCheckDelay) {
            if (SysProperties.CHECK && this.checkpointAllowed < 0) {
                DbException.throwInternalError();
            }
            Object object = this.reconnectSync;
            synchronized (object) {
                if (this.checkpointAllowed > 0) {
                    return;
                }
                this.checkpointRunning = true;
            }
            object = this;
            synchronized (object) {
                this.trace.debug("checkpoint start");
                this.flushSequences();
                this.checkpoint();
                this.reconnectModified(false);
                this.trace.debug("checkpoint end");
            }
            object = this.reconnectSync;
            synchronized (object) {
                this.checkpointRunning = false;
            }
        }
    }

    public boolean isFileLockSerialized() {
        return this.fileLockMethod == 3;
    }

    private void flushSequences() {
        for (SchemaObject obj : this.getAllSchemaObjects(3)) {
            Sequence sequence = (Sequence)obj;
            sequence.flushWithoutMargin();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkpoint() {
        if (this.persistent) {
            Database database = this;
            synchronized (database) {
                if (this.pageStore != null) {
                    this.pageStore.checkpoint();
                }
            }
        }
        this.getTempFileDeleter().deleteUnused();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean beforeWriting() {
        if (this.fileLockMethod != 3) {
            return true;
        }
        while (this.checkpointRunning) {
            try {
                Thread.sleep(10 + (int)(Math.random() * 10.0));
            }
            catch (Exception exception) {}
        }
        Object object = this.reconnectSync;
        synchronized (object) {
            if (this.reconnectModified(true)) {
                ++this.checkpointAllowed;
                if (SysProperties.CHECK && this.checkpointAllowed > 20) {
                    throw DbException.throwInternalError();
                }
                return true;
            }
        }
        this.reconnectCheckNext = System.currentTimeMillis() - 1L;
        this.reconnectLastLock = null;
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterWriting() {
        if (this.fileLockMethod != 3) {
            return;
        }
        Object object = this.reconnectSync;
        synchronized (object) {
            --this.checkpointAllowed;
        }
        if (SysProperties.CHECK && this.checkpointAllowed < 0) {
            throw DbException.throwInternalError();
        }
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void setCompactMode(int compactMode) {
        this.compactMode = compactMode;
    }

    public SourceCompiler getCompiler() {
        if (this.compiler == null) {
            this.compiler = new SourceCompiler();
        }
        return this.compiler;
    }

    @Override
    public LobStorage getLobStorage() {
        if (this.lobStorage == null) {
            this.lobStorage = new LobStorage(this);
        }
        return this.lobStorage;
    }

    @Override
    public Connection getLobConnection() {
        String url = "jdbc:default:connection";
        JdbcConnection conn = new JdbcConnection(this.systemSession, this.systemUser.getName(), url);
        conn.setTraceLevel(0);
        return conn;
    }

    public void setLogMode(int log) {
        if (log < 0 || log > 2) {
            throw DbException.getInvalidValueException("LOG", log);
        }
        if (this.pageStore != null) {
            if (log != 2 || this.pageStore.getLogMode() != 2) {
                this.trace.error(null, "log {0}", log);
            }
            this.logMode = log;
            this.pageStore.setLogMode(log);
        }
    }

    public int getLogMode() {
        if (this.pageStore != null) {
            return this.pageStore.getLogMode();
        }
        return 0;
    }

    public int getDefaultTableType() {
        return this.defaultTableType;
    }

    public void setDefaultTableType(int defaultTableType) {
        this.defaultTableType = defaultTableType;
    }

    public void setMultiVersion(boolean multiVersion) {
        this.multiVersion = multiVersion;
    }

    public DbSettings getSettings() {
        return this.dbSettings;
    }

    public <V> HashMap<String, V> newStringMap() {
        return this.dbSettings.databaseToUpper ? new HashMap() : new CaseInsensitiveMap();
    }

    public boolean equalsIdentifiers(String a, String b) {
        if (a == b || a.equals(b)) {
            return true;
        }
        return !this.dbSettings.databaseToUpper && a.equalsIgnoreCase(b);
    }

    @Override
    public int readLob(long lobId, byte[] hmac, long offset, byte[] buff, int off, int length) {
        throw DbException.throwInternalError();
    }
}

