/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import java.lang.ref.WeakReference;
import org.h2.engine.Database;
import org.h2.message.Trace;

class DatabaseCloser
extends Thread {
    private final boolean shutdownHook;
    private final Trace trace;
    private volatile WeakReference<Database> databaseRef;
    private int delayInMillis;
    private boolean stopImmediately;

    DatabaseCloser(Database db, int delayInMillis, boolean shutdownHook) {
        this.databaseRef = new WeakReference<Database>(db);
        this.delayInMillis = delayInMillis;
        this.shutdownHook = shutdownHook;
        this.trace = db.getTrace("database");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reset() {
        DatabaseCloser databaseCloser = this;
        synchronized (databaseCloser) {
            this.databaseRef = null;
        }
        ThreadGroup threadGroup = this.getThreadGroup();
        if (threadGroup != null && threadGroup.activeCount() > 100) {
            this.stopImmediately = true;
            try {
                this.start();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.stopImmediately) {
            return;
        }
        while (this.delayInMillis > 0) {
            try {
                int step = 100;
                Thread.sleep(step);
                this.delayInMillis -= step;
            }
            catch (Exception e) {
                // empty catch block
            }
            if (this.databaseRef != null) continue;
            return;
        }
        Database database = null;
        DatabaseCloser databaseCloser = this;
        synchronized (databaseCloser) {
            if (this.databaseRef != null) {
                database = (Database)this.databaseRef.get();
            }
        }
        if (database != null) {
            try {
                database.close(this.shutdownHook);
            }
            catch (RuntimeException e) {
                try {
                    this.trace.error(e, "could not close the database");
                }
                catch (RuntimeException e2) {
                    throw e;
                }
            }
        }
    }
}

