/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.DbObjectBase;
import org.h2.engine.RightOwner;
import org.h2.engine.Role;
import org.h2.engine.Session;
import org.h2.message.DbException;
import org.h2.table.Table;

public class Right
extends DbObjectBase {
    public static final int SELECT = 1;
    public static final int DELETE = 2;
    public static final int INSERT = 4;
    public static final int UPDATE = 8;
    public static final int ALL = 15;
    private Role grantedRole;
    private int grantedRight;
    private Table grantedTable;
    private RightOwner grantee;

    public Right(Database db, int id, RightOwner grantee, Role grantedRole) {
        this.initDbObjectBase(db, id, "RIGHT_" + id, "user");
        this.grantee = grantee;
        this.grantedRole = grantedRole;
    }

    public Right(Database db, int id, RightOwner grantee, int grantedRight, Table grantedRightOnTable) {
        this.initDbObjectBase(db, id, "" + id, "user");
        this.grantee = grantee;
        this.grantedRight = grantedRight;
        this.grantedTable = grantedRightOnTable;
    }

    private static boolean appendRight(StringBuilder buff, int right, int mask, String name, boolean comma) {
        if ((right & mask) != 0) {
            if (comma) {
                buff.append(", ");
            }
            buff.append(name);
            return true;
        }
        return comma;
    }

    public String getRights() {
        StringBuilder buff = new StringBuilder();
        if (this.grantedRight == 15) {
            buff.append("ALL");
        } else {
            boolean comma = false;
            comma = Right.appendRight(buff, this.grantedRight, 1, "SELECT", comma);
            comma = Right.appendRight(buff, this.grantedRight, 2, "DELETE", comma);
            comma = Right.appendRight(buff, this.grantedRight, 4, "INSERT", comma);
            Right.appendRight(buff, this.grantedRight, 8, "UPDATE", comma);
        }
        return buff.toString();
    }

    public Role getGrantedRole() {
        return this.grantedRole;
    }

    public Table getGrantedTable() {
        return this.grantedTable;
    }

    public DbObject getGrantee() {
        return this.grantee;
    }

    @Override
    public String getDropSQL() {
        return null;
    }

    @Override
    public String getCreateSQLForCopy(Table table, String quotedName) {
        StringBuilder buff = new StringBuilder();
        buff.append("GRANT ");
        if (this.grantedRole != null) {
            buff.append(this.grantedRole.getSQL());
        } else {
            buff.append(this.getRights()).append(" ON ").append(table.getSQL());
        }
        buff.append(" TO ").append(this.grantee.getSQL());
        return buff.toString();
    }

    @Override
    public String getCreateSQL() {
        return this.getCreateSQLForCopy(this.grantedTable, null);
    }

    @Override
    public int getType() {
        return 8;
    }

    @Override
    public void removeChildrenAndResources(Session session) {
        if (this.grantedTable != null) {
            this.grantee.revokeRight(this.grantedTable);
        } else {
            this.grantee.revokeRole(this.grantedRole);
        }
        this.database.removeMeta(session, this.getId());
        this.grantedRole = null;
        this.grantedTable = null;
        this.grantee = null;
        this.invalidate();
    }

    @Override
    public void checkRename() {
        DbException.throwInternalError();
    }

    public void setRightMask(int rightMask) {
        this.grantedRight = rightMask;
    }

    public int getRightMask() {
        return this.grantedRight;
    }
}

