/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.h2.engine.Database;
import org.h2.message.DbException;
import org.h2.util.IntIntHashMap;
import org.h2.util.New;
import org.h2.util.ValueHashMap;
import org.h2.value.CompareMode;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueDouble;
import org.h2.value.ValueInt;
import org.h2.value.ValueLong;
import org.h2.value.ValueNull;

class AggregateData {
    private final int aggregateType;
    private final int dataType;
    private long count;
    private IntIntHashMap distinctHashes;
    private ValueHashMap<AggregateData> distinctValues;
    private Value value;
    private double m2;
    private double mean;
    private ArrayList<Value> list;

    AggregateData(int aggregateType, int dataType) {
        this.aggregateType = aggregateType;
        this.dataType = dataType;
    }

    void add(Database database, boolean distinct, Value v) {
        if (this.aggregateType == 13) {
            int size;
            ++this.count;
            if (this.distinctHashes == null) {
                this.distinctHashes = new IntIntHashMap();
            }
            if ((size = this.distinctHashes.size()) > 10000) {
                this.distinctHashes = new IntIntHashMap();
                this.m2 += (double)size;
            }
            int hash = v.hashCode();
            this.distinctHashes.put(hash, 1);
            return;
        }
        if (this.aggregateType == 0) {
            ++this.count;
            return;
        }
        if (this.aggregateType == 14) {
            AggregateData a;
            if (this.distinctValues == null) {
                this.distinctValues = ValueHashMap.newInstance();
            }
            if ((a = this.distinctValues.get(v)) == null && this.distinctValues.size() < 10000) {
                a = new AggregateData(14, this.dataType);
                this.distinctValues.put(v, a);
            }
            if (a != null) {
                ++a.count;
            }
            return;
        }
        if (v == ValueNull.INSTANCE) {
            return;
        }
        ++this.count;
        if (distinct) {
            if (this.distinctValues == null) {
                this.distinctValues = ValueHashMap.newInstance();
            }
            this.distinctValues.put(v, this);
            return;
        }
        switch (this.aggregateType) {
            case 1: 
            case 14: {
                return;
            }
            case 3: {
                if (this.value == null) {
                    this.value = v.convertTo(this.dataType);
                    break;
                }
                v = v.convertTo(this.value.getType());
                this.value = this.value.add(v);
                break;
            }
            case 6: {
                if (this.value == null) {
                    this.value = v.convertTo(DataType.getAddProofType(this.dataType));
                    break;
                }
                v = v.convertTo(this.value.getType());
                this.value = this.value.add(v);
                break;
            }
            case 4: {
                if (this.value != null && database.compare(v, this.value) >= 0) break;
                this.value = v;
                break;
            }
            case 5: {
                if (this.value != null && database.compare(v, this.value) <= 0) break;
                this.value = v;
                break;
            }
            case 2: {
                if (this.list == null) {
                    this.list = New.arrayList();
                }
                this.list.add(v);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                double x = v.getDouble();
                if (this.count == 1L) {
                    this.mean = x;
                    this.m2 = 0.0;
                    break;
                }
                double delta = x - this.mean;
                this.mean += delta / (double)this.count;
                this.m2 += delta * (x - this.mean);
                break;
            }
            case 12: {
                v = v.convertTo(1);
                if (this.value == null) {
                    this.value = v;
                    break;
                }
                this.value = ValueBoolean.get(this.value.getBoolean() != false && v.getBoolean() != false);
                break;
            }
            case 11: {
                v = v.convertTo(1);
                if (this.value == null) {
                    this.value = v;
                    break;
                }
                this.value = ValueBoolean.get(this.value.getBoolean() != false || v.getBoolean() != false);
                break;
            }
            default: {
                DbException.throwInternalError("type=" + this.aggregateType);
            }
        }
    }

    ArrayList<Value> getList() {
        return this.list;
    }

    Value getValue(Database database, boolean distinct) {
        if (distinct) {
            this.count = 0L;
            this.groupDistinct(database);
        }
        Value v = null;
        switch (this.aggregateType) {
            case 13: {
                int s = 0;
                if (this.count == 0L) {
                    s = 0;
                } else {
                    this.m2 += (double)this.distinctHashes.size();
                    this.m2 = 100.0 * this.m2 / (double)this.count;
                    s = (int)this.m2;
                    s = s <= 0 ? 1 : (s > 100 ? 100 : s);
                }
                v = ValueInt.get(s);
                break;
            }
            case 0: 
            case 1: {
                v = ValueLong.get(this.count);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 11: 
            case 12: {
                v = this.value;
                break;
            }
            case 6: {
                if (this.value == null) break;
                v = AggregateData.divide(this.value, this.count);
                break;
            }
            case 2: {
                return null;
            }
            case 7: {
                if (this.count < 1L) {
                    return ValueNull.INSTANCE;
                }
                v = ValueDouble.get(Math.sqrt(this.m2 / (double)this.count));
                break;
            }
            case 8: {
                if (this.count < 2L) {
                    return ValueNull.INSTANCE;
                }
                v = ValueDouble.get(Math.sqrt(this.m2 / (double)(this.count - 1L)));
                break;
            }
            case 9: {
                if (this.count < 1L) {
                    return ValueNull.INSTANCE;
                }
                v = ValueDouble.get(this.m2 / (double)this.count);
                break;
            }
            case 10: {
                if (this.count < 2L) {
                    return ValueNull.INSTANCE;
                }
                v = ValueDouble.get(this.m2 / (double)(this.count - 1L));
                break;
            }
            case 14: {
                Value[] values = new ValueArray[this.distinctValues.size()];
                int i = 0;
                for (Value dv : this.distinctValues.keys()) {
                    AggregateData d = this.distinctValues.get(dv);
                    values[i] = ValueArray.get(new Value[]{dv, ValueLong.get(d.count)});
                    ++i;
                }
                final CompareMode compareMode = database.getCompareMode();
                Arrays.sort(values, new Comparator<ValueArray>(){

                    @Override
                    public int compare(ValueArray v1, ValueArray v2) {
                        Value a1 = v1.getList()[0];
                        Value a2 = v2.getList()[0];
                        return a1.compareTo(a2, compareMode);
                    }
                });
                v = ValueArray.get(values);
                break;
            }
            default: {
                DbException.throwInternalError("type=" + this.aggregateType);
            }
        }
        return v == null ? ValueNull.INSTANCE : v.convertTo(this.dataType);
    }

    private static Value divide(Value a, long by) {
        if (by == 0L) {
            return ValueNull.INSTANCE;
        }
        int type = Value.getHigherOrder(a.getType(), 5);
        Value b = ValueLong.get(by).convertTo(type);
        a = a.convertTo(type).divide(b);
        return a;
    }

    private void groupDistinct(Database database) {
        if (this.distinctValues == null) {
            return;
        }
        if (this.aggregateType == 1) {
            this.count = this.distinctValues.size();
        } else {
            this.count = 0L;
            for (Value v : this.distinctValues.keys()) {
                this.add(database, false, v);
            }
        }
    }
}

