/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import org.h2.command.Parser;
import org.h2.engine.FunctionAlias;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.FunctionCall;
import org.h2.expression.ValueExpression;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.util.StatementBuilder;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueNull;
import org.h2.value.ValueResultSet;

public class JavaFunction
extends Expression
implements FunctionCall {
    private FunctionAlias functionAlias;
    private FunctionAlias.JavaMethod javaMethod;
    private Expression[] args;

    public JavaFunction(FunctionAlias functionAlias, Expression[] args) {
        this.functionAlias = functionAlias;
        this.javaMethod = functionAlias.findJavaMethod(args);
        this.args = args;
    }

    @Override
    public Value getValue(Session session) {
        return this.javaMethod.getValue(session, this.args, false);
    }

    @Override
    public int getType() {
        return this.javaMethod.getDataType();
    }

    @Override
    public void mapColumns(ColumnResolver resolver, int level) {
        for (Expression e : this.args) {
            e.mapColumns(resolver, level);
        }
    }

    @Override
    public Expression optimize(Session session) {
        boolean allConst = this.isDeterministic();
        int len = this.args.length;
        for (int i = 0; i < len; ++i) {
            Expression e;
            this.args[i] = e = this.args[i].optimize(session);
            allConst &= e.isConstant();
        }
        if (allConst) {
            return ValueExpression.get(this.getValue(session));
        }
        return this;
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean b) {
        for (Expression e : this.args) {
            if (e == null) continue;
            e.setEvaluatable(tableFilter, b);
        }
    }

    @Override
    public int getScale() {
        return DataType.getDataType((int)this.getType()).defaultScale;
    }

    @Override
    public long getPrecision() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getDisplaySize() {
        return Integer.MAX_VALUE;
    }

    @Override
    public String getSQL() {
        StatementBuilder buff = new StatementBuilder();
        if (this.functionAlias.getDatabase().getSettings().functionsInSchema || !this.functionAlias.getSchema().getName().equals("PUBLIC")) {
            buff.append(Parser.quoteIdentifier(this.functionAlias.getSchema().getName())).append('.');
        }
        buff.append(Parser.quoteIdentifier(this.functionAlias.getName())).append('(');
        for (Expression e : this.args) {
            buff.appendExceptFirst(", ");
            buff.append(e.getSQL());
        }
        return buff.append(')').toString();
    }

    @Override
    public void updateAggregate(Session session) {
        for (Expression e : this.args) {
            if (e == null) continue;
            e.updateAggregate(session);
        }
    }

    @Override
    public String getName() {
        return this.functionAlias.getName();
    }

    @Override
    public int getParameterCount() {
        return this.javaMethod.getParameterCount();
    }

    @Override
    public ValueResultSet getValueForColumnList(Session session, Expression[] argList) {
        Value v = this.javaMethod.getValue(session, argList, true);
        return v == ValueNull.INSTANCE ? null : (ValueResultSet)v;
    }

    @Override
    public Expression[] getArgs() {
        return this.args;
    }

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        switch (visitor.getType()) {
            case 2: {
                if (this.isDeterministic()) break;
                return false;
            }
            case 7: {
                visitor.addDependency(this.functionAlias);
                break;
            }
        }
        for (Expression e : this.args) {
            if (e == null || e.isEverything(visitor)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getCost() {
        int cost = this.javaMethod.hasConnectionParam() ? 25 : 5;
        for (Expression e : this.args) {
            cost += e.getCost();
        }
        return cost;
    }

    @Override
    public boolean isDeterministic() {
        return this.functionAlias.isDeterministic();
    }

    @Override
    public Expression[] getExpressionColumns(Session session) {
        switch (this.getType()) {
            case 18: {
                ValueResultSet rs = this.getValueForColumnList(session, this.getArgs());
                return JavaFunction.getExpressionColumns(session, rs.getResultSet());
            }
            case 17: {
                return JavaFunction.getExpressionColumns(session, (ValueArray)this.getValue(session));
            }
        }
        return super.getExpressionColumns(session);
    }

    @Override
    public boolean isFast() {
        return false;
    }
}

