/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.util.ArrayList;
import org.h2.engine.Session;
import org.h2.index.Cursor;
import org.h2.index.HashIndex;
import org.h2.index.IndexType;
import org.h2.index.NonUniqueHashCursor;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.table.IndexColumn;
import org.h2.table.RegularTable;
import org.h2.util.New;
import org.h2.util.ValueHashMap;
import org.h2.value.Value;

public class NonUniqueHashIndex
extends HashIndex {
    private ValueHashMap<ArrayList<Long>> rows;
    private RegularTable tableData;
    private long rowCount;

    public NonUniqueHashIndex(RegularTable table, int id, String indexName, IndexColumn[] columns, IndexType indexType) {
        super(table, id, indexName, columns, indexType);
        this.tableData = table;
        this.reset();
    }

    private void reset() {
        this.rows = ValueHashMap.newInstance();
        this.rowCount = 0L;
    }

    @Override
    public void truncate(Session session) {
        this.reset();
    }

    @Override
    public void add(Session session, Row row) {
        Value key = row.getValue(this.indexColumn);
        ArrayList<Long> positions = this.rows.get(key);
        if (positions == null) {
            positions = New.arrayList();
            this.rows.put(key, positions);
        }
        positions.add(row.getKey());
        ++this.rowCount;
    }

    @Override
    public void remove(Session session, Row row) {
        if (this.rowCount == 1L) {
            this.reset();
        } else {
            Value key = row.getValue(this.indexColumn);
            ArrayList<Long> positions = this.rows.get(key);
            if (positions.size() == 1) {
                this.rows.remove(key);
            } else {
                positions.remove(row.getKey());
            }
            --this.rowCount;
        }
    }

    @Override
    public Cursor find(Session session, SearchRow first, SearchRow last) {
        if (first == null || last == null) {
            throw DbException.throwInternalError();
        }
        if (first != last && this.compareKeys(first, last) != 0) {
            throw DbException.throwInternalError();
        }
        ArrayList<Long> positions = this.rows.get(first.getValue(this.indexColumn));
        return new NonUniqueHashCursor(session, this.tableData, positions);
    }

    @Override
    public long getRowCount(Session session) {
        return this.rowCount;
    }

    @Override
    public long getRowCountApproximation() {
        return this.rowCount;
    }
}

