/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import org.h2.engine.Session;
import org.h2.index.Cursor;
import org.h2.index.PageDataIndex;
import org.h2.index.PageDataLeaf;
import org.h2.result.Row;
import org.h2.store.Data;
import org.h2.store.Page;

abstract class PageData
extends Page {
    static final int START_PARENT = 3;
    static final int ROOT = 0;
    static final int UNKNOWN_ROWCOUNT = -1;
    protected final PageDataIndex index;
    protected int parentPageId;
    protected final Data data;
    protected int entryCount;
    protected long[] keys;
    protected boolean written;
    protected int memoryEstimated;

    PageData(PageDataIndex index, int pageId, Data data) {
        this.index = index;
        this.data = data;
        this.setPos(pageId);
        this.memoryEstimated = index.getMemoryPerPage();
    }

    abstract int getRowCount();

    abstract void setRowCountStored(int var1);

    int find(long key) {
        int l = 0;
        int r = this.entryCount;
        while (l < r) {
            int i = l + r >>> 1;
            long k = this.keys[i];
            if (k == key) {
                return i;
            }
            if (k > key) {
                r = i;
                continue;
            }
            l = i + 1;
        }
        return l;
    }

    abstract int addRowTry(Row var1);

    abstract Cursor find(Session var1, long var2, long var4, boolean var6);

    long getKey(int at) {
        return this.keys[at];
    }

    abstract PageData split(int var1);

    void setPageId(int id) {
        int old = this.getPos();
        this.index.getPageStore().removeRecord(this.getPos());
        this.setPos(id);
        this.index.getPageStore().logUndo(this, null);
        this.remapChildren(old);
    }

    abstract long getLastKey();

    abstract PageDataLeaf getFirstLeaf();

    void setParentPageId(int id) {
        this.index.getPageStore().logUndo(this, this.data);
        this.parentPageId = id;
        if (this.written) {
            this.changeCount = this.index.getPageStore().getChangeCount();
            this.data.setInt(3, this.parentPageId);
        }
    }

    abstract void remapChildren(int var1);

    abstract boolean remove(long var1);

    abstract void freeRecursive();

    abstract Row getRowWithKey(long var1);

    @Override
    public int getMemory() {
        return this.memoryEstimated;
    }

    int getParentPageId() {
        return this.parentPageId;
    }

    @Override
    public boolean canRemove() {
        return this.changeCount < this.index.getPageStore().getChangeCount();
    }
}

