/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import org.h2.engine.Session;
import org.h2.index.BaseIndex;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.index.RangeCursor;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.table.IndexColumn;
import org.h2.table.RangeTable;

public class RangeIndex
extends BaseIndex {
    private RangeTable rangeTable;

    public RangeIndex(RangeTable table, IndexColumn[] columns) {
        this.initBaseIndex(table, 0, "RANGE_INDEX", columns, IndexType.createNonUnique(true));
        this.rangeTable = table;
    }

    @Override
    public void close(Session session) {
    }

    @Override
    public void add(Session session, Row row) {
        throw DbException.getUnsupportedException("SYSTEM_RANGE");
    }

    @Override
    public void remove(Session session, Row row) {
        throw DbException.getUnsupportedException("SYSTEM_RANGE");
    }

    @Override
    public Cursor find(Session session, SearchRow first, SearchRow last) {
        long max;
        long min;
        long start = min = this.rangeTable.getMin(session);
        long end = max = this.rangeTable.getMax(session);
        try {
            start = Math.max(min, first == null ? min : first.getValue(0).getLong());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            end = Math.min(max, last == null ? max : last.getValue(0).getLong());
        }
        catch (Exception e) {
            // empty catch block
        }
        return new RangeCursor(start, end);
    }

    @Override
    public double getCost(Session session, int[] masks) {
        return 1.0;
    }

    @Override
    public String getCreateSQL() {
        return null;
    }

    @Override
    public void remove(Session session) {
        throw DbException.getUnsupportedException("SYSTEM_RANGE");
    }

    @Override
    public void truncate(Session session) {
        throw DbException.getUnsupportedException("SYSTEM_RANGE");
    }

    @Override
    public boolean needRebuild() {
        return false;
    }

    @Override
    public void checkRename() {
        throw DbException.getUnsupportedException("SYSTEM_RANGE");
    }

    @Override
    public boolean canGetFirstOrLast() {
        return true;
    }

    @Override
    public Cursor findFirstOrLast(Session session, boolean first) {
        long pos = first ? this.rangeTable.getMin(session) : this.rangeTable.getMax(session);
        return new RangeCursor(pos, pos);
    }

    @Override
    public long getRowCount(Session session) {
        return this.rangeTable.getRowCountApproximation();
    }

    @Override
    public long getRowCountApproximation() {
        return this.rangeTable.getRowCountApproximation();
    }
}

