/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import org.h2.constant.SysProperties;
import org.h2.engine.Session;
import org.h2.index.BaseIndex;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.index.TreeCursor;
import org.h2.index.TreeNode;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.table.IndexColumn;
import org.h2.table.RegularTable;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public class TreeIndex
extends BaseIndex {
    private TreeNode root;
    private RegularTable tableData;
    private long rowCount;
    private boolean closed;

    public TreeIndex(RegularTable table, int id, String indexName, IndexColumn[] columns, IndexType indexType) {
        this.initBaseIndex(table, id, indexName, columns, indexType);
        this.tableData = table;
    }

    @Override
    public void close(Session session) {
        this.root = null;
        this.closed = true;
    }

    @Override
    public void add(Session session, Row row) {
        TreeNode n;
        if (this.closed) {
            throw DbException.throwInternalError();
        }
        TreeNode i = new TreeNode(row);
        TreeNode x = n = this.root;
        boolean isLeft = true;
        while (true) {
            if (n == null) {
                if (x == null) {
                    this.root = i;
                    ++this.rowCount;
                    return;
                }
                break;
            }
            Row r = n.row;
            int compare = this.compareRows(row, r);
            if (compare == 0) {
                if (this.indexType.isUnique() && !this.containsNullAndAllowMultipleNull(row)) {
                    throw this.getDuplicateKeyException();
                }
                compare = this.compareKeys(row, r);
            }
            isLeft = compare < 0;
            x = n;
            n = TreeIndex.child(x, isLeft);
        }
        TreeIndex.set(x, isLeft, i);
        this.balance(x, isLeft);
        ++this.rowCount;
    }

    private void balance(TreeNode x, boolean isLeft) {
        while (true) {
            int sign = isLeft ? 1 : -1;
            switch (x.balance * sign) {
                case 1: {
                    x.balance = 0;
                    return;
                }
                case 0: {
                    x.balance = -sign;
                    break;
                }
                case -1: {
                    TreeNode l = TreeIndex.child(x, isLeft);
                    if (l.balance == -sign) {
                        this.replace(x, l);
                        TreeIndex.set(x, isLeft, TreeIndex.child(l, !isLeft));
                        TreeIndex.set(l, !isLeft, x);
                        x.balance = 0;
                        l.balance = 0;
                    } else {
                        TreeNode r = TreeIndex.child(l, !isLeft);
                        this.replace(x, r);
                        TreeIndex.set(l, !isLeft, TreeIndex.child(r, isLeft));
                        TreeIndex.set(r, isLeft, l);
                        TreeIndex.set(x, isLeft, TreeIndex.child(r, !isLeft));
                        TreeIndex.set(r, !isLeft, x);
                        int rb = r.balance;
                        x.balance = rb == -sign ? sign : 0;
                        l.balance = rb == sign ? -sign : 0;
                        r.balance = 0;
                    }
                    return;
                }
                default: {
                    DbException.throwInternalError("b:" + x.balance * sign);
                }
            }
            if (x == this.root) {
                return;
            }
            isLeft = x.isFromLeft();
            x = x.parent;
        }
    }

    private static TreeNode child(TreeNode x, boolean isLeft) {
        return isLeft ? x.left : x.right;
    }

    private void replace(TreeNode x, TreeNode n) {
        if (x == this.root) {
            this.root = n;
            if (n != null) {
                n.parent = null;
            }
        } else {
            TreeIndex.set(x.parent, x.isFromLeft(), n);
        }
    }

    private static void set(TreeNode parent, boolean left, TreeNode n) {
        if (left) {
            parent.left = n;
        } else {
            parent.right = n;
        }
        if (n != null) {
            n.parent = parent;
        }
    }

    @Override
    public void remove(Session session, Row row) {
        TreeNode n;
        if (this.closed) {
            throw DbException.throwInternalError();
        }
        TreeNode x = this.findFirstNode(row, true);
        if (x == null) {
            throw DbException.throwInternalError("not found!");
        }
        if (x.left == null) {
            n = x.right;
        } else if (x.right == null) {
            n = x.left;
        } else {
            TreeNode d = x;
            TreeNode temp = x = x.left;
            while ((temp = temp.right) != null) {
                x = temp;
            }
            n = x.left;
            int b = x.balance;
            x.balance = d.balance;
            d.balance = b;
            TreeNode xp = x.parent;
            TreeNode dp = d.parent;
            if (d == this.root) {
                this.root = x;
            }
            x.parent = dp;
            if (dp != null) {
                if (dp.right == d) {
                    dp.right = x;
                } else {
                    dp.left = x;
                }
            }
            if (xp == d) {
                d.parent = x;
                if (d.left == x) {
                    x.left = d;
                    x.right = d.right;
                } else {
                    x.right = d;
                    x.left = d.left;
                }
            } else {
                d.parent = xp;
                xp.right = d;
                x.right = d.right;
                x.left = d.left;
            }
            if (SysProperties.CHECK && x.right == null) {
                DbException.throwInternalError("tree corrupted");
            }
            x.right.parent = x;
            x.left.parent = x;
            d.left = n;
            if (n != null) {
                n.parent = d;
            }
            d.right = null;
            x = d;
        }
        --this.rowCount;
        boolean isLeft = x.isFromLeft();
        this.replace(x, n);
        n = x.parent;
        while (n != null) {
            x = n;
            int sign = isLeft ? 1 : -1;
            switch (x.balance * sign) {
                case -1: {
                    x.balance = 0;
                    break;
                }
                case 0: {
                    x.balance = sign;
                    return;
                }
                case 1: {
                    TreeNode r = TreeIndex.child(x, !isLeft);
                    int b = r.balance;
                    if (b * sign >= 0) {
                        this.replace(x, r);
                        TreeIndex.set(x, !isLeft, TreeIndex.child(r, isLeft));
                        TreeIndex.set(r, isLeft, x);
                        if (b == 0) {
                            x.balance = sign;
                            r.balance = -sign;
                            return;
                        }
                        x.balance = 0;
                        r.balance = 0;
                        x = r;
                        break;
                    }
                    TreeNode l = TreeIndex.child(r, isLeft);
                    this.replace(x, l);
                    b = l.balance;
                    TreeIndex.set(r, isLeft, TreeIndex.child(l, !isLeft));
                    TreeIndex.set(l, !isLeft, r);
                    TreeIndex.set(x, !isLeft, TreeIndex.child(l, isLeft));
                    TreeIndex.set(l, isLeft, x);
                    x.balance = b == sign ? -sign : 0;
                    r.balance = b == -sign ? sign : 0;
                    l.balance = 0;
                    x = l;
                    break;
                }
                default: {
                    DbException.throwInternalError("b: " + x.balance * sign);
                }
            }
            isLeft = x.isFromLeft();
            n = x.parent;
        }
    }

    private TreeNode findFirstNode(SearchRow row, boolean withKey) {
        TreeNode x;
        TreeNode result = x = this.root;
        while (x != null) {
            result = x;
            int compare = this.compareRows(x.row, row);
            if (compare == 0 && withKey) {
                compare = this.compareKeys(x.row, row);
            }
            if (compare == 0) {
                if (withKey) {
                    return x;
                }
                x = x.left;
                continue;
            }
            if (compare > 0) {
                x = x.left;
                continue;
            }
            x = x.right;
        }
        return result;
    }

    @Override
    public Cursor find(TableFilter filter, SearchRow first, SearchRow last) {
        return this.find(first, last);
    }

    @Override
    public Cursor find(Session session, SearchRow first, SearchRow last) {
        return this.find(first, last);
    }

    private Cursor find(SearchRow first, SearchRow last) {
        if (first == null) {
            TreeNode n;
            TreeNode x = this.root;
            while (x != null && (n = x.left) != null) {
                x = n;
            }
            return new TreeCursor(this, x, null, last);
        }
        TreeNode x = this.findFirstNode(first, false);
        return new TreeCursor(this, x, first, last);
    }

    @Override
    public double getCost(Session session, int[] masks) {
        return this.getCostRangeIndex(masks, this.tableData.getRowCountApproximation());
    }

    @Override
    public void remove(Session session) {
        this.truncate(session);
    }

    @Override
    public void truncate(Session session) {
        this.root = null;
        this.rowCount = 0L;
    }

    @Override
    public void checkRename() {
    }

    @Override
    public boolean needRebuild() {
        return true;
    }

    @Override
    public boolean canGetFirstOrLast() {
        return true;
    }

    @Override
    public Cursor findFirstOrLast(Session session, boolean first) {
        SearchRow row;
        TreeNode n;
        if (this.closed) {
            throw DbException.throwInternalError();
        }
        if (first) {
            Cursor cursor = this.find(session, null, null);
            while (cursor.next()) {
                SearchRow row2 = cursor.getSearchRow();
                Value v = row2.getValue(this.columnIds[0]);
                if (v == ValueNull.INSTANCE) continue;
                return cursor;
            }
            return cursor;
        }
        TreeNode x = this.root;
        while (x != null && (n = x.right) != null) {
            x = n;
        }
        TreeCursor cursor = new TreeCursor(this, x, null, null);
        if (x == null) {
            return cursor;
        }
        while ((row = cursor.getSearchRow()) != null) {
            Value v = row.getValue(this.columnIds[0]);
            if (v != ValueNull.INSTANCE) {
                return cursor;
            }
            if (cursor.previous()) continue;
        }
        return cursor;
    }

    @Override
    public long getRowCount(Session session) {
        return this.rowCount;
    }

    @Override
    public long getRowCountApproximation() {
        return this.rowCount;
    }
}

