/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbcx;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.StatementEventListener;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.h2.Driver;
import org.h2.jdbc.JdbcConnection;
import org.h2.jdbcx.JdbcDataSourceFactory;
import org.h2.jdbcx.JdbcXid;
import org.h2.message.DbException;
import org.h2.message.TraceObject;
import org.h2.util.JdbcUtils;
import org.h2.util.New;

public class JdbcXAConnection
extends TraceObject
implements XAConnection,
XAResource {
    private JdbcDataSourceFactory factory;
    private JdbcConnection physicalConn;
    private volatile Connection handleConn;
    private ArrayList<ConnectionEventListener> listeners = New.arrayList();
    private Xid currentTransaction;
    private boolean prepared;

    JdbcXAConnection(JdbcDataSourceFactory factory, int id, JdbcConnection physicalConn) {
        this.factory = factory;
        this.setTrace(factory.getTrace(), 13, id);
        this.physicalConn = physicalConn;
    }

    @Override
    public XAResource getXAResource() {
        this.debugCodeCall("getXAResource");
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        this.debugCodeCall("close");
        Connection lastHandle = this.handleConn;
        if (lastHandle != null) {
            this.listeners.clear();
            lastHandle.close();
        }
        if (this.physicalConn != null) {
            try {
                this.physicalConn.close();
            }
            finally {
                this.physicalConn = null;
            }
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.debugCodeCall("getConnection");
        Connection lastHandle = this.handleConn;
        if (lastHandle != null) {
            lastHandle.close();
        }
        this.physicalConn.rollback();
        this.handleConn = new PooledJdbcConnection(this.physicalConn);
        return this.handleConn;
    }

    @Override
    public void addConnectionEventListener(ConnectionEventListener listener) {
        this.debugCode("addConnectionEventListener(listener);");
        this.listeners.add(listener);
    }

    @Override
    public void removeConnectionEventListener(ConnectionEventListener listener) {
        this.debugCode("removeConnectionEventListener(listener);");
        this.listeners.remove(listener);
    }

    void closedHandle() {
        this.debugCode("closedHandle();");
        ConnectionEvent event = new ConnectionEvent(this);
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            ConnectionEventListener listener = this.listeners.get(i);
            listener.connectionClosed(event);
        }
        this.handleConn = null;
    }

    @Override
    public int getTransactionTimeout() {
        this.debugCodeCall("getTransactionTimeout");
        return 0;
    }

    @Override
    public boolean setTransactionTimeout(int seconds) {
        this.debugCodeCall("setTransactionTimeout", seconds);
        return false;
    }

    @Override
    public boolean isSameRM(XAResource xares) {
        this.debugCode("isSameRM(xares);");
        return xares == this;
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        this.debugCodeCall("recover", JdbcXAConnection.quoteFlags(flag));
        this.checkOpen();
        Statement stat = null;
        try {
            stat = this.physicalConn.createStatement();
            ResultSet rs = stat.executeQuery("SELECT * FROM INFORMATION_SCHEMA.IN_DOUBT ORDER BY TRANSACTION");
            ArrayList<Xid> list = New.arrayList();
            while (rs.next()) {
                String tid = rs.getString("TRANSACTION");
                int id = JdbcXAConnection.getNextId(15);
                JdbcXid xid = new JdbcXid(this.factory, id, tid);
                list.add(xid);
            }
            rs.close();
            Xid[] result = new Xid[list.size()];
            list.toArray(result);
            if (list.size() > 0) {
                this.prepared = true;
            }
            Xid[] xidArray = result;
            return xidArray;
        }
        catch (SQLException e) {
            XAException xa = new XAException(-3);
            xa.initCause(e);
            throw xa;
        }
        finally {
            JdbcUtils.closeSilently(stat);
        }
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        if (this.isDebugEnabled()) {
            this.debugCode("prepare(" + JdbcXid.toString(xid) + ");");
        }
        this.checkOpen();
        if (!this.currentTransaction.equals(xid)) {
            throw new XAException(-5);
        }
        Statement stat = null;
        try {
            stat = this.physicalConn.createStatement();
            stat.execute("PREPARE COMMIT " + JdbcXid.toString(xid));
            this.prepared = true;
        }
        catch (SQLException e) {
            throw JdbcXAConnection.convertException(e);
        }
        finally {
            JdbcUtils.closeSilently(stat);
        }
        return 0;
    }

    @Override
    public void forget(Xid xid) {
        if (this.isDebugEnabled()) {
            this.debugCode("forget(" + JdbcXid.toString(xid) + ");");
        }
        this.prepared = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(Xid xid) throws XAException {
        block6: {
            if (this.isDebugEnabled()) {
                this.debugCode("rollback(" + JdbcXid.toString(xid) + ");");
            }
            try {
                this.physicalConn.rollback();
                this.physicalConn.setAutoCommit(true);
                if (!this.prepared) break block6;
                Statement stat = null;
                try {
                    stat = this.physicalConn.createStatement();
                    stat.execute("ROLLBACK TRANSACTION " + JdbcXid.toString(xid));
                }
                finally {
                    JdbcUtils.closeSilently(stat);
                }
                this.prepared = false;
            }
            catch (SQLException e) {
                throw JdbcXAConnection.convertException(e);
            }
        }
        this.currentTransaction = null;
    }

    @Override
    public void end(Xid xid, int flags) throws XAException {
        if (this.isDebugEnabled()) {
            this.debugCode("end(" + JdbcXid.toString(xid) + ", " + JdbcXAConnection.quoteFlags(flags) + ");");
        }
        if (flags == 0x2000000) {
            return;
        }
        if (!this.currentTransaction.equals(xid)) {
            throw new XAException(-9);
        }
        this.prepared = false;
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
        if (this.isDebugEnabled()) {
            this.debugCode("start(" + JdbcXid.toString(xid) + ", " + JdbcXAConnection.quoteFlags(flags) + ");");
        }
        if (flags == 0x8000000) {
            return;
        }
        if (flags == 0x200000) {
            if (this.currentTransaction != null && !this.currentTransaction.equals(xid)) {
                throw new XAException(-3);
            }
        } else if (this.currentTransaction != null) {
            throw new XAException(-4);
        }
        try {
            this.physicalConn.setAutoCommit(false);
        }
        catch (SQLException e) {
            throw JdbcXAConnection.convertException(e);
        }
        this.currentTransaction = xid;
        this.prepared = false;
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        if (this.isDebugEnabled()) {
            this.debugCode("commit(" + JdbcXid.toString(xid) + ", " + onePhase + ");");
        }
        Statement stat = null;
        try {
            if (onePhase) {
                this.physicalConn.commit();
            } else {
                stat = this.physicalConn.createStatement();
                stat.execute("COMMIT TRANSACTION " + JdbcXid.toString(xid));
                this.prepared = false;
            }
            this.physicalConn.setAutoCommit(true);
        }
        catch (SQLException e) {
            try {
                throw JdbcXAConnection.convertException(e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeSilently(stat);
                throw throwable;
            }
        }
        JdbcUtils.closeSilently(stat);
        this.currentTransaction = null;
    }

    @Override
    public void addStatementEventListener(StatementEventListener listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeStatementEventListener(StatementEventListener listener) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.getTraceObjectName() + ": " + this.physicalConn;
    }

    private static XAException convertException(SQLException e) {
        XAException xa = new XAException(e.getMessage());
        xa.initCause(e);
        return xa;
    }

    private static String quoteFlags(int flags) {
        StringBuilder buff = new StringBuilder();
        if ((flags & 0x800000) != 0) {
            buff.append("|XAResource.TMENDRSCAN");
        }
        if ((flags & 0x20000000) != 0) {
            buff.append("|XAResource.TMFAIL");
        }
        if ((flags & 0x200000) != 0) {
            buff.append("|XAResource.TMJOIN");
        }
        if ((flags & 0x40000000) != 0) {
            buff.append("|XAResource.TMONEPHASE");
        }
        if ((flags & 0x8000000) != 0) {
            buff.append("|XAResource.TMRESUME");
        }
        if ((flags & 0x1000000) != 0) {
            buff.append("|XAResource.TMSTARTRSCAN");
        }
        if ((flags & 0x4000000) != 0) {
            buff.append("|XAResource.TMSUCCESS");
        }
        if ((flags & 0x2000000) != 0) {
            buff.append("|XAResource.TMSUSPEND");
        }
        if ((flags & 3) != 0) {
            buff.append("|XAResource.XA_RDONLY");
        }
        if (buff.length() == 0) {
            buff.append("|XAResource.TMNOFLAGS");
        }
        return buff.toString().substring(1);
    }

    private void checkOpen() throws XAException {
        if (this.physicalConn == null) {
            throw new XAException(-3);
        }
    }

    static {
        Driver.load();
    }

    class PooledJdbcConnection
    extends JdbcConnection {
        private boolean isClosed;

        public PooledJdbcConnection(JdbcConnection conn) {
            super(conn);
        }

        @Override
        public synchronized void close() throws SQLException {
            if (!this.isClosed) {
                try {
                    this.rollback();
                    this.setAutoCommit(true);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                JdbcXAConnection.this.closedHandle();
                this.isClosed = true;
            }
        }

        @Override
        public synchronized boolean isClosed() throws SQLException {
            return this.isClosed || super.isClosed();
        }

        @Override
        protected synchronized void checkClosed(boolean write) {
            if (this.isClosed) {
                throw DbException.get(90007);
            }
            super.checkClosed(write);
        }
    }
}

