/*
 * Decompiled with CFR 0.152.
 */
package org.h2.result;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.h2.constant.SysProperties;
import org.h2.engine.Database;
import org.h2.expression.Expression;
import org.h2.util.StatementBuilder;
import org.h2.util.StringUtils;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public class SortOrder
implements Comparator<Value[]> {
    public static final int ASCENDING = 0;
    public static final int DESCENDING = 1;
    public static final int NULLS_FIRST = 2;
    public static final int NULLS_LAST = 4;
    private static final int DEFAULT_NULL_SORT = SysProperties.SORT_NULLS_HIGH ? 1 : -1;
    private final Database database;
    private final int[] indexes;
    private final int[] sortTypes;

    public SortOrder(Database database, int[] index, int[] sortType) {
        this.database = database;
        this.indexes = index;
        this.sortTypes = sortType;
    }

    public String getSQL(Expression[] list, int visible) {
        StatementBuilder buff = new StatementBuilder();
        int i = 0;
        for (int idx : this.indexes) {
            buff.appendExceptFirst(", ");
            if (idx < visible) {
                buff.append(idx + 1);
            } else {
                buff.append('=').append(StringUtils.unEnclose(list[idx].getSQL()));
            }
            int type = this.sortTypes[i++];
            if ((type & 1) != 0) {
                buff.append(" DESC");
            }
            if ((type & 2) != 0) {
                buff.append(" NULLS FIRST");
                continue;
            }
            if ((type & 4) == 0) continue;
            buff.append(" NULLS LAST");
        }
        return buff.toString();
    }

    public static int compareNull(boolean aNull, boolean bNull, int sortType) {
        if ((sortType & 2) != 0) {
            return aNull ? -1 : 1;
        }
        if ((sortType & 4) != 0) {
            return aNull ? 1 : -1;
        }
        int comp = aNull ? DEFAULT_NULL_SORT : -DEFAULT_NULL_SORT;
        return (sortType & 1) == 0 ? comp : -comp;
    }

    @Override
    public int compare(Value[] a, Value[] b) {
        int len = this.indexes.length;
        for (int i = 0; i < len; ++i) {
            boolean bNull;
            int idx = this.indexes[i];
            int type = this.sortTypes[i];
            Value ao = a[idx];
            Value bo = b[idx];
            boolean aNull = ao == ValueNull.INSTANCE;
            boolean bl = bNull = bo == ValueNull.INSTANCE;
            if (aNull || bNull) {
                if (aNull == bNull) continue;
                return SortOrder.compareNull(aNull, bNull, type);
            }
            int comp = this.database.compare(ao, bo);
            if (comp == 0) continue;
            return (type & 1) == 0 ? comp : -comp;
        }
        return 0;
    }

    public void sort(ArrayList<Value[]> rows) {
        Collections.sort(rows, this);
    }

    public int[] getIndexes() {
        return this.indexes;
    }

    public int[] getSortTypes() {
        return this.sortTypes;
    }
}

