/*
 * Decompiled with CFR 0.152.
 */
package org.h2.schema;

import org.h2.engine.Session;
import org.h2.message.DbException;
import org.h2.schema.Schema;
import org.h2.schema.SchemaObjectBase;
import org.h2.table.Table;

public class Sequence
extends SchemaObjectBase {
    public static final int DEFAULT_CACHE_SIZE = 32;
    private long value = 1L;
    private long valueWithMargin;
    private long increment = 1L;
    private long cacheSize = 32L;
    private boolean belongsToTable;

    public Sequence(Schema schema, int id, String name, boolean belongsToTable) {
        this.initSchemaObjectBase(schema, id, name, "sequence");
        this.belongsToTable = belongsToTable;
    }

    public synchronized void setStartValue(long value) {
        this.value = value;
        this.valueWithMargin = value;
    }

    public boolean getBelongsToTable() {
        return this.belongsToTable;
    }

    public long getIncrement() {
        return this.increment;
    }

    public void setIncrement(long inc) {
        if (inc == 0L) {
            throw DbException.getInvalidValueException("INCREMENT", 0);
        }
        this.increment = inc;
    }

    @Override
    public String getDropSQL() {
        if (this.getBelongsToTable()) {
            return null;
        }
        return "DROP SEQUENCE IF EXISTS " + this.getSQL();
    }

    @Override
    public String getCreateSQLForCopy(Table table, String quotedName) {
        throw DbException.throwInternalError();
    }

    @Override
    public synchronized String getCreateSQL() {
        StringBuilder buff = new StringBuilder("CREATE SEQUENCE ");
        buff.append(this.getSQL()).append(" START WITH ").append(this.value);
        if (this.increment != 1L) {
            buff.append(" INCREMENT BY ").append(this.increment);
        }
        if (this.cacheSize != 32L) {
            buff.append(" CACHE ").append(this.cacheSize);
        }
        if (this.belongsToTable) {
            buff.append(" BELONGS_TO_TABLE");
        }
        return buff.toString();
    }

    public synchronized long getNext(Session session) {
        if (this.increment > 0L && this.value >= this.valueWithMargin || this.increment < 0L && this.value <= this.valueWithMargin) {
            this.valueWithMargin += this.increment * this.cacheSize;
            this.flush(session);
        }
        long v = this.value;
        this.value += this.increment;
        return v;
    }

    public void flushWithoutMargin() {
        if (this.valueWithMargin != this.value) {
            this.valueWithMargin = this.value;
            this.flush(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void flush(Session session) {
        Session sysSession = this.database.getSystemSession();
        if (session == null || !this.database.isSysTableLocked()) {
            session = sysSession;
        }
        Session session2 = session;
        synchronized (session2) {
            long realValue = this.value;
            try {
                this.value = this.valueWithMargin;
                this.database.update(session, this);
            }
            finally {
                this.value = realValue;
            }
            if (session == sysSession) {
                sysSession.commit(false);
            }
        }
    }

    public void close() {
        this.flushWithoutMargin();
    }

    @Override
    public int getType() {
        return 3;
    }

    @Override
    public void removeChildrenAndResources(Session session) {
        this.database.removeMeta(session, this.getId());
        this.invalidate();
    }

    @Override
    public void checkRename() {
    }

    public synchronized long getCurrentValue() {
        return this.value - this.increment;
    }

    public void setBelongsToTable(boolean b) {
        this.belongsToTable = b;
    }

    public void setCacheSize(long cacheSize) {
        this.cacheSize = Math.max(1L, cacheSize);
    }

    public long getCacheSize() {
        return this.cacheSize;
    }
}

