/*
 * Decompiled with CFR 0.152.
 */
package org.h2.server.pg;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.Socket;
import java.sql.Connection;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import org.h2.constant.SysProperties;
import org.h2.engine.ConnectionInfo;
import org.h2.jdbc.JdbcConnection;
import org.h2.jdbc.JdbcPreparedStatement;
import org.h2.jdbc.JdbcStatement;
import org.h2.message.DbException;
import org.h2.server.pg.PgServer;
import org.h2.util.IOUtils;
import org.h2.util.JdbcUtils;
import org.h2.util.ScriptReader;
import org.h2.util.StringUtils;
import org.h2.util.Utils;
import org.h2.value.CaseInsensitiveMap;

public class PgServerThread
implements Runnable {
    private PgServer server;
    private Socket socket;
    private Connection conn;
    private boolean stop;
    private DataInputStream dataInRaw;
    private DataInputStream dataIn;
    private OutputStream out;
    private int messageType;
    private ByteArrayOutputStream outBuffer;
    private DataOutputStream dataOut;
    private Thread thread;
    private boolean initDone;
    private String userName;
    private String databaseName;
    private int processId;
    private String clientEncoding = SysProperties.PG_DEFAULT_CLIENT_ENCODING;
    private String dateStyle = "ISO";
    private HashMap<String, Prepared> prepared = new CaseInsensitiveMap<Prepared>();
    private HashMap<String, Portal> portals = new CaseInsensitiveMap<Portal>();

    PgServerThread(Socket socket, PgServer server) {
        this.server = server;
        this.socket = socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.server.trace("Connect");
            InputStream ins = this.socket.getInputStream();
            this.out = this.socket.getOutputStream();
            this.dataInRaw = new DataInputStream(ins);
            while (!this.stop) {
                this.process();
                this.out.flush();
            }
        }
        catch (EOFException e) {
        }
        catch (Exception e) {
            this.server.traceError(e);
        }
        finally {
            this.server.trace("Disconnect");
            this.close();
        }
    }

    private String readString() throws IOException {
        int x;
        ByteArrayOutputStream buff = new ByteArrayOutputStream();
        while ((x = this.dataIn.read()) > 0) {
            buff.write(x);
        }
        return new String(buff.toByteArray(), this.getEncoding());
    }

    private int readInt() throws IOException {
        return this.dataIn.readInt();
    }

    private int readShort() throws IOException {
        return this.dataIn.readShort();
    }

    private byte readByte() throws IOException {
        return this.dataIn.readByte();
    }

    private void readFully(byte[] buff) throws IOException {
        this.dataIn.readFully(buff);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void process() throws IOException {
        if (this.initDone) {
            x = this.dataInRaw.read();
            if (x < 0) {
                this.stop = true;
                return;
            }
        } else {
            x = 0;
        }
        len = this.dataInRaw.readInt();
        data = Utils.newBytes(len -= 4);
        this.dataInRaw.readFully(data, 0, len);
        this.dataIn = new DataInputStream(new ByteArrayInputStream(data, 0, len));
        block11 : switch (x) {
            case 0: {
                this.server.trace("Init");
                version = this.readInt();
                if (version == 80877102) {
                    this.server.trace("CancelRequest (not supported)");
                    this.server.trace(" pid: " + this.readInt());
                    this.server.trace(" key: " + this.readInt());
                    break;
                }
                if (version == 80877103) {
                    this.server.trace("SSLRequest");
                    this.out.write(78);
                    break;
                }
                this.server.trace("StartupMessage");
                this.server.trace(" version " + version + " (" + (version >> 16) + "." + (version & 255) + ")");
                while ((param = this.readString()).length() != 0) {
                    value = this.readString();
                    if ("user".equals(param)) {
                        this.userName = value;
                    } else if ("database".equals(param)) {
                        this.databaseName = value;
                    } else if ("client_encoding".equals(param)) {
                        this.clientEncoding = value;
                    } else if ("DateStyle".equals(param)) {
                        this.dateStyle = value;
                    }
                    this.server.trace(" param " + param + "=" + value);
                }
                this.sendAuthenticationCleartextPassword();
                this.initDone = true;
                break;
            }
            case 112: {
                this.server.trace("PasswordMessage");
                password = this.readString();
                try {
                    info = new Properties();
                    info.put("MODE", "PostgreSQL");
                    info.put("USER", this.userName);
                    info.put("PASSWORD", password);
                    url = "jdbc:h2:" + this.databaseName;
                    ci = new ConnectionInfo(url, info);
                    baseDir = this.server.getBaseDir();
                    if (baseDir == null) {
                        baseDir = SysProperties.getBaseDir();
                    }
                    if (baseDir != null) {
                        ci.setBaseDir(baseDir);
                    }
                    if (this.server.getIfExists()) {
                        ci.setProperty("IFEXISTS", "TRUE");
                    }
                    this.conn = new JdbcConnection(ci, false);
                    this.initDb();
                    this.sendAuthenticationOk();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.stop = true;
                }
                break;
            }
            case 80: {
                this.server.trace("Parse");
                p = new Prepared();
                p.name = this.readString();
                p.sql = this.getSQL(this.readString());
                count = this.readShort();
                p.paramType = new int[count];
                for (i = 0; i < count; ++i) {
                    type = this.readInt();
                    this.server.checkType(type);
                    p.paramType[i] = type;
                }
                try {
                    p.prep = (JdbcPreparedStatement)this.conn.prepareStatement(p.sql);
                    this.prepared.put(p.name, p);
                    this.sendParseComplete();
                }
                catch (Exception e) {
                    this.sendErrorResponse(e);
                }
                break;
            }
            case 66: {
                this.server.trace("Bind");
                portal = new Portal();
                portal.name = this.readString();
                prepName = this.readString();
                prep = this.prepared.get(prepName);
                if (prep == null) {
                    this.sendErrorResponse("Prepared not found");
                    break;
                }
                portal.prep = prep;
                this.portals.put(portal.name, portal);
                formatCodeCount = this.readShort();
                formatCodes = new int[formatCodeCount];
                for (i = 0; i < formatCodeCount; ++i) {
                    formatCodes[i] = this.readShort();
                }
                paramCount = this.readShort();
                for (i = 0; i < paramCount; ++i) {
                    paramLen = this.readInt();
                    d2 = Utils.newBytes(paramLen);
                    this.readFully(d2);
                    try {
                        this.setParameter(prep.prep, i, d2, formatCodes);
                        continue;
                    }
                    catch (Exception e) {
                        this.sendErrorResponse(e);
                        break block11;
                    }
                }
                resultCodeCount = this.readShort();
                portal.resultColumnFormat = new int[resultCodeCount];
                for (i = 0; i < resultCodeCount; ++i) {
                    portal.resultColumnFormat[i] = this.readShort();
                }
                this.sendBindComplete();
                break;
            }
            case 67: {
                type = (char)this.readByte();
                name = this.readString();
                this.server.trace("Close");
                if (type == 'S') {
                    p = this.prepared.remove(name);
                    if (p != null) {
                        JdbcUtils.closeSilently(p.prep);
                    }
                } else if (type == 'P') {
                    this.portals.remove(name);
                } else {
                    this.server.trace("expected S or P, got " + type);
                    this.sendErrorResponse("expected S or P");
                    break;
                }
                this.sendCloseComplete();
                break;
            }
            case 68: {
                type = (char)this.readByte();
                name = this.readString();
                this.server.trace("Describe");
                if (type == 'S') {
                    p = this.prepared.get(name);
                    if (p == null) {
                        this.sendErrorResponse("Prepared not found: " + name);
                        break;
                    }
                    this.sendParameterDescription(p);
                    break;
                }
                if (type == 'P') {
                    p = this.portals.get(name);
                    if (p == null) {
                        this.sendErrorResponse("Portal not found: " + name);
                        break;
                    }
                    prep = p.prep.prep;
                    try {
                        meta = prep.getMetaData();
                        this.sendRowDescription(meta);
                    }
                    catch (Exception e) {
                        this.sendErrorResponse(e);
                    }
                    break;
                }
                this.server.trace("expected S or P, got " + type);
                this.sendErrorResponse("expected S or P");
                break;
            }
            case 69: {
                name = this.readString();
                this.server.trace("Execute");
                p = this.portals.get(name);
                if (p == null) {
                    this.sendErrorResponse("Portal not found: " + name);
                    break;
                }
                maxRows = this.readShort();
                prepared = p.prep;
                prep = prepared.prep;
                this.server.trace(prepared.sql);
                try {
                    prep.setMaxRows(maxRows);
                    result = prep.execute();
                    if (result) {
                        try {
                            rs = prep.getResultSet();
                            meta = rs.getMetaData();
                            this.sendRowDescription(meta);
                            while (rs.next()) {
                                this.sendDataRow(rs);
                            }
                            this.sendCommandComplete(prep, 0);
                        }
                        catch (Exception e) {
                            this.sendErrorResponse(e);
                        }
                        break;
                    }
                    this.sendCommandComplete(prep, prep.getUpdateCount());
                }
                catch (Exception e) {
                    this.sendErrorResponse(e);
                }
                break;
            }
            case 83: {
                this.server.trace("Sync");
                this.sendReadyForQuery();
                break;
            }
            case 81: {
                this.server.trace("Query");
                query = this.readString();
                reader = new ScriptReader(new StringReader(query));
                while (true) {
                    stat = null;
                    try {
                        s = reader.readStatement();
                        if (s == null) ** GOTO lbl246
                        s = this.getSQL(s);
                        stat = (JdbcStatement)this.conn.createStatement();
                        result = stat.execute(s);
                        if (!result) ** GOTO lbl236
                        rs = stat.getResultSet();
                        meta = rs.getMetaData();
                        try {
                            this.sendRowDescription(meta);
                            while (rs.next()) {
                                this.sendDataRow(rs);
                            }
                            this.sendCommandComplete(stat, 0);
                            ** GOTO lbl237
                        }
                        catch (Exception e) {
                            this.sendErrorResponse(e);
                            JdbcUtils.closeSilently(stat);
                            ** GOTO lbl246
                        }
lbl236:
                        // 1 sources

                        this.sendCommandComplete(stat, stat.getUpdateCount());
lbl237:
                        // 2 sources

                        JdbcUtils.closeSilently(stat);
                    }
                    catch (SQLException e) {
                        this.sendErrorResponse(e);
                        ** GOTO lbl246
                    }
                }
                finally {
                    JdbcUtils.closeSilently(stat);
                }
lbl246:
                // 3 sources

                this.sendReadyForQuery();
                break;
            }
            case 88: {
                this.server.trace("Terminate");
                this.close();
                break;
            }
            default: {
                this.server.trace("Unsupported: " + x + " (" + (char)x + ")");
            }
        }
    }

    private String getSQL(String s) {
        String lower = StringUtils.toLowerEnglish(s);
        if (lower.startsWith("show max_identifier_length")) {
            s = "CALL 63";
        } else if (lower.startsWith("set client_encoding to")) {
            s = "set DATESTYLE ISO";
        }
        if (this.server.getTrace()) {
            this.server.trace(s + ";");
        }
        return s;
    }

    private void sendCommandComplete(JdbcStatement stat, int updateCount) throws IOException {
        this.startMessage(67);
        switch (stat.getLastExecutedCommandType()) {
            case 61: {
                this.writeStringPart("INSERT 0 ");
                this.writeString(Integer.toString(updateCount));
                break;
            }
            case 68: {
                this.writeStringPart("UPDATE ");
                this.writeString(Integer.toString(updateCount));
                break;
            }
            case 58: {
                this.writeStringPart("DELETE ");
                this.writeString(Integer.toString(updateCount));
                break;
            }
            case 57: 
            case 66: {
                this.writeString("SELECT");
                break;
            }
            case 83: {
                this.writeString("BEGIN");
                break;
            }
            default: {
                this.server.trace("check CommandComplete tag for command " + stat);
                this.writeStringPart("UPDATE ");
                this.writeString(Integer.toString(updateCount));
            }
        }
        this.sendMessage();
    }

    private void sendDataRow(ResultSet rs) throws Exception {
        int columns = rs.getMetaData().getColumnCount();
        String[] values = new String[columns];
        for (int i = 0; i < columns; ++i) {
            values[i] = rs.getString(i + 1);
        }
        this.startMessage(68);
        this.writeShort(columns);
        for (String s : values) {
            if (s == null) {
                this.writeInt(-1);
                continue;
            }
            byte[] d2 = s.getBytes(this.getEncoding());
            this.writeInt(d2.length);
            this.write(d2);
        }
        this.sendMessage();
    }

    private String getEncoding() {
        if ("UNICODE".equals(this.clientEncoding)) {
            return "UTF-8";
        }
        return this.clientEncoding;
    }

    private void setParameter(PreparedStatement prep, int i, byte[] d2, int[] formatCodes) throws SQLException {
        String s;
        boolean text = i >= formatCodes.length || formatCodes[i] == 0;
        try {
            if (text) {
                s = new String(d2, this.getEncoding());
            } else {
                this.server.trace("Binary format not supported");
                s = new String(d2, this.getEncoding());
            }
        }
        catch (Exception e) {
            this.server.traceError(e);
            s = null;
        }
        prep.setString(i + 1, s);
    }

    private void sendErrorResponse(Exception re) throws IOException {
        SQLException e = DbException.toSQLException(re);
        this.server.traceError(e);
        this.startMessage(69);
        this.write(83);
        this.writeString("ERROR");
        this.write(67);
        this.writeString(e.getSQLState());
        this.write(77);
        this.writeString(e.getMessage());
        this.write(68);
        this.writeString(e.toString());
        this.write(0);
        this.sendMessage();
    }

    private void sendParameterDescription(Prepared p) throws IOException {
        try {
            JdbcPreparedStatement prep = p.prep;
            ParameterMetaData meta = prep.getParameterMetaData();
            int count = meta.getParameterCount();
            this.startMessage(116);
            this.writeShort(count);
            for (int i = 0; i < count; ++i) {
                int type = p.paramType != null && p.paramType[i] != 0 ? p.paramType[i] : 1043;
                this.server.checkType(type);
                this.writeInt(type);
            }
            this.sendMessage();
        }
        catch (Exception e) {
            this.sendErrorResponse(e);
        }
    }

    private void sendNoData() throws IOException {
        this.startMessage(110);
        this.sendMessage();
    }

    private void sendRowDescription(ResultSetMetaData meta) throws Exception {
        if (meta == null) {
            this.sendNoData();
        } else {
            int i;
            int columns = meta.getColumnCount();
            int[] types = new int[columns];
            int[] precision = new int[columns];
            String[] names = new String[columns];
            for (i = 0; i < columns; ++i) {
                String name;
                names[i] = name = meta.getColumnName(i + 1);
                int type = meta.getColumnType(i + 1);
                type = PgServer.convertType(type);
                precision[i] = meta.getColumnDisplaySize(i + 1);
                this.server.checkType(type);
                types[i] = type;
            }
            this.startMessage(84);
            this.writeShort(columns);
            for (i = 0; i < columns; ++i) {
                this.writeString(StringUtils.toLowerEnglish(names[i]));
                this.writeInt(0);
                this.writeShort(0);
                this.writeInt(types[i]);
                this.writeShort(PgServerThread.getTypeSize(types[i], precision[i]));
                this.writeInt(-1);
                this.writeShort(0);
            }
            this.sendMessage();
        }
    }

    private static int getTypeSize(int pgType, int precision) {
        switch (pgType) {
            case 1043: {
                return Math.max(255, precision + 10);
            }
        }
        return precision + 4;
    }

    private void sendErrorResponse(String message) throws IOException {
        this.server.trace("Exception: " + message);
        this.startMessage(69);
        this.write(83);
        this.writeString("ERROR");
        this.write(67);
        this.writeString("08P01");
        this.write(77);
        this.writeString(message);
        this.sendMessage();
    }

    private void sendParseComplete() throws IOException {
        this.startMessage(49);
        this.sendMessage();
    }

    private void sendBindComplete() throws IOException {
        this.startMessage(50);
        this.sendMessage();
    }

    private void sendCloseComplete() throws IOException {
        this.startMessage(51);
        this.sendMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDb() throws SQLException {
        Statement stat = null;
        ResultSet rs = null;
        try {
            PgServer pgServer = this.server;
            synchronized (pgServer) {
                rs = this.conn.getMetaData().getTables(null, "PG_CATALOG", "PG_VERSION", null);
                boolean tableFound = rs.next();
                stat = this.conn.createStatement();
                if (!tableFound) {
                    PgServerThread.installPgCatalog(stat);
                }
                if (!(rs = stat.executeQuery("SELECT * FROM PG_CATALOG.PG_VERSION")).next() || rs.getInt(1) < 2) {
                    PgServerThread.installPgCatalog(stat);
                } else {
                    int versionRead = rs.getInt(2);
                    if (versionRead > 2) {
                        throw DbException.throwInternalError("Incompatible PG_VERSION");
                    }
                }
            }
            stat.execute("set search_path = PUBLIC, pg_catalog");
            HashSet<Integer> typeSet = this.server.getTypeSet();
            if (typeSet.size() == 0) {
                rs = stat.executeQuery("SELECT OID FROM PG_CATALOG.PG_TYPE");
                while (rs.next()) {
                    typeSet.add(rs.getInt(1));
                }
            }
        }
        catch (Throwable throwable) {
            JdbcUtils.closeSilently(stat);
            JdbcUtils.closeSilently(rs);
            throw throwable;
        }
        JdbcUtils.closeSilently(stat);
        JdbcUtils.closeSilently(rs);
    }

    private static void installPgCatalog(Statement stat) throws SQLException {
        InputStreamReader r = null;
        try {
            String sql;
            r = new InputStreamReader(new ByteArrayInputStream(Utils.getResource("/org/h2/server/pg/pg_catalog.sql")));
            ScriptReader reader = new ScriptReader(r);
            while ((sql = reader.readStatement()) != null) {
                stat.execute(sql);
            }
            reader.close();
        }
        catch (IOException e) {
            try {
                throw DbException.convertIOException(e, "Can not read pg_catalog resource");
            }
            catch (Throwable throwable) {
                IOUtils.closeSilently(r);
                throw throwable;
            }
        }
        IOUtils.closeSilently(r);
    }

    void close() {
        try {
            this.stop = true;
            JdbcUtils.closeSilently(this.conn);
            if (this.socket != null) {
                this.socket.close();
            }
            this.server.trace("Close");
        }
        catch (Exception e) {
            this.server.traceError(e);
        }
        this.conn = null;
        this.socket = null;
        this.server.remove(this);
    }

    private void sendAuthenticationCleartextPassword() throws IOException {
        this.startMessage(82);
        this.writeInt(3);
        this.sendMessage();
    }

    private void sendAuthenticationOk() throws IOException {
        this.startMessage(82);
        this.writeInt(0);
        this.sendMessage();
        this.sendParameterStatus("client_encoding", this.clientEncoding);
        this.sendParameterStatus("DateStyle", this.dateStyle);
        this.sendParameterStatus("integer_datetimes", "off");
        this.sendParameterStatus("is_superuser", "off");
        this.sendParameterStatus("server_encoding", "SQL_ASCII");
        this.sendParameterStatus("server_version", "8.1.4");
        this.sendParameterStatus("session_authorization", this.userName);
        this.sendParameterStatus("standard_conforming_strings", "off");
        this.sendParameterStatus("TimeZone", "CET");
        this.sendBackendKeyData();
        this.sendReadyForQuery();
    }

    private void sendReadyForQuery() throws IOException {
        int c;
        this.startMessage(90);
        try {
            c = this.conn.getAutoCommit() ? 73 : 84;
        }
        catch (SQLException e) {
            c = 69;
        }
        this.write((byte)c);
        this.sendMessage();
    }

    private void sendBackendKeyData() throws IOException {
        this.startMessage(75);
        this.writeInt(this.processId);
        this.writeInt(this.processId);
        this.sendMessage();
    }

    private void writeString(String s) throws IOException {
        this.writeStringPart(s);
        this.write(0);
    }

    private void writeStringPart(String s) throws IOException {
        this.write(s.getBytes(this.getEncoding()));
    }

    private void writeInt(int i) throws IOException {
        this.dataOut.writeInt(i);
    }

    private void writeShort(int i) throws IOException {
        this.dataOut.writeShort(i);
    }

    private void write(byte[] data) throws IOException {
        this.dataOut.write(data);
    }

    private void write(int b) throws IOException {
        this.dataOut.write(b);
    }

    private void startMessage(int newMessageType) {
        this.messageType = newMessageType;
        this.outBuffer = new ByteArrayOutputStream();
        this.dataOut = new DataOutputStream(this.outBuffer);
    }

    private void sendMessage() throws IOException {
        this.dataOut.flush();
        byte[] buff = this.outBuffer.toByteArray();
        int len = buff.length;
        this.dataOut = new DataOutputStream(this.out);
        this.dataOut.write(this.messageType);
        this.dataOut.writeInt(len + 4);
        this.dataOut.write(buff);
        this.dataOut.flush();
    }

    private void sendParameterStatus(String param, String value) throws IOException {
        this.startMessage(83);
        this.writeString(param);
        this.writeString(value);
        this.sendMessage();
    }

    void setThread(Thread thread) {
        this.thread = thread;
    }

    Thread getThread() {
        return this.thread;
    }

    void setProcessId(int id) {
        this.processId = id;
    }

    static class Portal {
        String name;
        int[] resultColumnFormat;
        Prepared prep;

        Portal() {
        }
    }

    static class Prepared {
        String name;
        String sql;
        JdbcPreparedStatement prep;
        int[] paramType;

        Prepared() {
        }
    }
}

