/*
 * Decompiled with CFR 0.152.
 */
package org.h2.server.web;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.h2.server.web.DbContents;

class DbColumn {
    String name;
    String quotedName;
    String dataType;

    DbColumn(DbContents contents, ResultSet rs) throws SQLException {
        this.name = rs.getString("COLUMN_NAME");
        this.quotedName = contents.quoteIdentifier(this.name);
        String type = rs.getString("TYPE_NAME");
        int size = rs.getInt(DbContents.findColumn(rs, "COLUMN_SIZE", 7));
        boolean isSQLite = contents.isSQLite;
        if (size > 0 && !isSQLite) {
            type = type + "(" + size;
            int prec = rs.getInt(DbContents.findColumn(rs, "DECIMAL_DIGITS", 9));
            if (prec > 0) {
                type = type + ", " + prec;
            }
            type = type + ")";
        }
        if (rs.getInt("NULLABLE") == 0) {
            type = type + " NOT NULL";
        }
        this.dataType = type;
    }
}

