/*
 * Decompiled with CFR 0.152.
 */
package org.h2.server.web;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import org.h2.constant.SysProperties;
import org.h2.message.TraceSystem;
import org.h2.server.web.PageParser;
import org.h2.server.web.WebApp;
import org.h2.server.web.WebServer;
import org.h2.util.IOUtils;
import org.h2.util.NetUtils;
import org.h2.util.StringUtils;
import org.h2.util.Utils;

class WebThread
extends WebApp
implements Runnable {
    protected OutputStream output;
    protected Socket socket;
    private Thread thread;
    private InputStream input;
    private int headerBytes;
    private String ifModifiedSince;

    WebThread(Socket socket, WebServer server) {
        super(server);
        this.socket = socket;
        this.thread = new Thread((Runnable)this, "H2 Console thread");
    }

    void start() {
        this.thread.start();
    }

    void join(int millis) throws InterruptedException {
        this.thread.join(millis);
    }

    void stopNow() {
        this.stop = true;
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private String getAllowedFile(String requestedFile) {
        if (!this.allow()) {
            return "notAllowed.jsp";
        }
        if (requestedFile.length() == 0) {
            return "index.do";
        }
        return requestedFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.input = new BufferedInputStream(this.socket.getInputStream());
            this.output = new BufferedOutputStream(this.socket.getOutputStream());
            while (!this.stop && this.process()) {
            }
        }
        catch (Exception e) {
            TraceSystem.traceThrowable(e);
        }
        IOUtils.closeSilently(this.output);
        IOUtils.closeSilently(this.input);
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
        }
        finally {
            this.server.remove(this);
        }
    }

    private boolean process() throws IOException {
        boolean keepAlive = false;
        String head = this.readHeaderLine();
        if (head.startsWith("GET ") || head.startsWith("POST ")) {
            String message;
            byte[] bytes;
            int begin = head.indexOf(47);
            int end = head.lastIndexOf(32);
            String file = begin < 0 || end < begin ? "" : head.substring(begin + 1, end).trim();
            this.trace(head + ": " + file);
            file = this.getAllowedFile(file);
            this.attributes = new Properties();
            int paramIndex = file.indexOf("?");
            this.session = null;
            if (paramIndex >= 0) {
                String attrib = file.substring(paramIndex + 1);
                this.parseAttributes(attrib);
                String sessionId = this.attributes.getProperty("jsessionid");
                file = file.substring(0, paramIndex);
                this.session = this.server.getSession(sessionId);
            }
            keepAlive = this.parseHeader();
            String hostAddr = this.socket.getInetAddress().getHostAddress();
            if ((file = this.processRequest(file, hostAddr)).length() == 0) {
                return true;
            }
            if (this.cache && this.ifModifiedSince != null && this.ifModifiedSince.equals(this.server.getStartDateTime())) {
                bytes = null;
                message = "HTTP/1.1 304 Not Modified\r\n";
            } else {
                bytes = this.server.getFile(file);
                if (bytes == null) {
                    message = "HTTP/1.0 404 Not Found\r\n";
                    bytes = StringUtils.utf8Encode("File not found: " + file);
                } else {
                    if (this.session != null && file.endsWith(".jsp")) {
                        Iterator it;
                        String page = StringUtils.utf8Decode(bytes);
                        if (SysProperties.CONSOLE_STREAM && (it = (Iterator)this.session.map.remove("chunks")) != null) {
                            message = "HTTP/1.1 200 OK\r\n";
                            message = message + "Content-Type: " + this.mimeType + "\r\n";
                            message = message + "Cache-Control: no-cache\r\n";
                            message = message + "Transfer-Encoding: chunked\r\n";
                            message = message + "\r\n";
                            this.trace(message);
                            this.output.write(message.getBytes());
                            while (it.hasNext()) {
                                String s = (String)it.next();
                                bytes = StringUtils.utf8Encode(s = PageParser.parse(s, this.session.map));
                                if (bytes.length == 0) continue;
                                this.output.write(Integer.toHexString(bytes.length).getBytes());
                                this.output.write("\r\n".getBytes());
                                this.output.write(bytes);
                                this.output.write("\r\n".getBytes());
                                this.output.flush();
                            }
                            this.output.write("0\r\n\r\n".getBytes());
                            this.output.flush();
                            return keepAlive;
                        }
                        page = PageParser.parse(page, this.session.map);
                        bytes = StringUtils.utf8Encode(page);
                    }
                    message = "HTTP/1.1 200 OK\r\n";
                    message = message + "Content-Type: " + this.mimeType + "\r\n";
                    if (!this.cache) {
                        message = message + "Cache-Control: no-cache\r\n";
                    } else {
                        message = message + "Cache-Control: max-age=10\r\n";
                        message = message + "Last-Modified: " + this.server.getStartDateTime() + "\r\n";
                    }
                    message = message + "Content-Length: " + bytes.length + "\r\n";
                }
            }
            message = message + "\r\n";
            this.trace(message);
            this.output.write(message.getBytes());
            if (bytes != null) {
                this.output.write(bytes);
            }
            this.output.flush();
        }
        return keepAlive;
    }

    private String readHeaderLine() throws IOException {
        StringBuilder buff = new StringBuilder();
        while (true) {
            ++this.headerBytes;
            int c = this.input.read();
            if (c == -1) {
                throw new IOException("Unexpected EOF");
            }
            if (c == 13) {
                ++this.headerBytes;
                if (this.input.read() != 10) continue;
                return buff.length() > 0 ? buff.toString() : null;
            }
            if (c == 10) {
                return buff.length() > 0 ? buff.toString() : null;
            }
            buff.append((char)c);
        }
    }

    private void parseAttributes(String s) {
        int idx;
        this.trace("data=" + s);
        while (s != null && (idx = s.indexOf(61)) >= 0) {
            String value;
            String property = s.substring(0, idx);
            if ((idx = (s = s.substring(idx + 1)).indexOf(38)) >= 0) {
                value = s.substring(0, idx);
                s = s.substring(idx + 1);
            } else {
                value = s;
            }
            String attr = StringUtils.urlDecode(value);
            this.attributes.put(property, attr);
        }
        this.trace(this.attributes.toString());
    }

    private boolean parseHeader() throws IOException {
        String line;
        boolean keepAlive = false;
        this.trace("parseHeader");
        int len = 0;
        this.ifModifiedSince = null;
        boolean multipart = false;
        block0: while ((line = this.readHeaderLine()) != null) {
            this.trace(" " + line);
            String lower = StringUtils.toLowerEnglish(line);
            if (lower.startsWith("if-modified-since")) {
                this.ifModifiedSince = WebThread.getHeaderLineValue(line);
                continue;
            }
            if (lower.startsWith("connection")) {
                String conn = WebThread.getHeaderLineValue(line);
                if (!"keep-alive".equals(conn)) continue;
                keepAlive = true;
                continue;
            }
            if (lower.startsWith("content-type")) {
                String type = WebThread.getHeaderLineValue(line);
                if (!type.startsWith("multipart/form-data")) continue;
                multipart = true;
                continue;
            }
            if (lower.startsWith("content-length")) {
                len = Integer.parseInt(WebThread.getHeaderLineValue(line));
                this.trace("len=" + len);
                continue;
            }
            if (lower.startsWith("user-agent")) {
                boolean isWebKit = lower.indexOf("webkit/") >= 0;
                if (!isWebKit || this.session == null) continue;
                this.session.put("frame-border", "1");
                this.session.put("frameset-border", "2");
                continue;
            }
            if (lower.startsWith("accept-language")) {
                Locale locale = this.session == null ? null : this.session.locale;
                if (locale != null) continue;
                String languages = WebThread.getHeaderLineValue(line);
                StringTokenizer tokenizer = new StringTokenizer(languages, ",;");
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken();
                    if (token.startsWith("q=") || !this.server.supportsLanguage(token)) continue;
                    int dash = token.indexOf(45);
                    if (dash >= 0) {
                        String language = token.substring(0, dash);
                        String country = token.substring(dash + 1);
                        locale = new Locale(language, country);
                    } else {
                        locale = new Locale(token, "");
                    }
                    this.headerLanguage = locale.getLanguage();
                    if (this.session == null) continue block0;
                    this.session.locale = locale;
                    this.session.put("language", this.headerLanguage);
                    this.server.readTranslations(this.session, this.headerLanguage);
                    continue block0;
                }
                continue;
            }
            if (line.trim().length() != 0) continue;
            break;
        }
        if (multipart) {
            this.uploadMultipart(this.input, len);
        } else if (this.session != null && len > 0) {
            byte[] bytes = Utils.newBytes(len);
            for (int pos = 0; pos < len; pos += this.input.read(bytes, pos, len - pos)) {
            }
            String s = new String(bytes);
            this.parseAttributes(s);
        }
        return keepAlive;
    }

    private void uploadMultipart(InputStream in, int len) throws IOException {
        String line;
        if (!new File("transfer").exists()) {
            return;
        }
        String fileName = "temp.bin";
        this.headerBytes = 0;
        String boundary = this.readHeaderLine();
        while ((line = this.readHeaderLine()) != null) {
            int index = line.indexOf("filename=\"");
            if (index > 0) {
                fileName = line.substring(index + "filename=\"".length(), line.lastIndexOf(34));
            }
            this.trace(" " + line);
        }
        if (!WebServer.isSimpleName(fileName)) {
            return;
        }
        File file = new File("transfer", fileName);
        FileOutputStream out = new FileOutputStream(file);
        IOUtils.copy(in, out, len -= this.headerBytes);
        ((OutputStream)out).close();
        RandomAccessFile f = new RandomAccessFile(file, "rw");
        int testSize = (int)Math.min(f.length(), 4096L);
        f.seek(f.length() - (long)testSize);
        byte[] bytes = Utils.newBytes(4096);
        f.readFully(bytes, 0, testSize);
        String s = new String(bytes, "ASCII");
        int x = s.lastIndexOf(boundary);
        f.setLength(f.length() - (long)testSize + (long)x - 2L);
        f.close();
    }

    private static String getHeaderLineValue(String line) {
        return line.substring(line.indexOf(58) + 1).trim();
    }

    @Override
    protected String adminShutdown() {
        this.stopNow();
        return super.adminShutdown();
    }

    private boolean allow() {
        if (this.server.getAllowOthers()) {
            return true;
        }
        try {
            return NetUtils.isLocalAddress(this.socket);
        }
        catch (UnknownHostException e) {
            this.server.traceError(e);
            return false;
        }
    }

    private void trace(String s) {
        this.server.trace(s);
    }
}

