/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import org.h2.message.DbException;
import org.h2.store.PageStore;

public class InDoubtTransaction {
    public static final int IN_DOUBT = 0;
    public static final int COMMIT = 1;
    public static final int ROLLBACK = 2;
    private final PageStore store;
    private final int sessionId;
    private final int pos;
    private final String transaction;
    private int state;

    public InDoubtTransaction(PageStore store, int sessionId, int pos, String transaction) {
        this.store = store;
        this.sessionId = sessionId;
        this.pos = pos;
        this.transaction = transaction;
        this.state = 0;
    }

    public void setState(int state) {
        switch (state) {
            case 1: {
                this.store.setInDoubtTransactionState(this.sessionId, this.pos, true);
                break;
            }
            case 2: {
                this.store.setInDoubtTransactionState(this.sessionId, this.pos, false);
                break;
            }
            default: {
                DbException.throwInternalError("state=" + state);
            }
        }
        this.state = state;
    }

    public String getState() {
        switch (this.state) {
            case 0: {
                return "IN_DOUBT";
            }
            case 1: {
                return "COMMIT";
            }
            case 2: {
                return "ROLLBACK";
            }
        }
        throw DbException.throwInternalError("state=" + this.state);
    }

    public String getTransaction() {
        return this.transaction;
    }
}

