/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.lang.ref.WeakReference;
import java.security.AccessControlException;
import org.h2.Driver;
import org.h2.engine.Database;
import org.h2.message.TraceSystem;

public class WriterThread
implements Runnable {
    private volatile WeakReference<Database> databaseRef;
    private int writeDelay;
    private Thread thread;
    private volatile boolean stop;

    private WriterThread(Database database, int writeDelay) {
        this.databaseRef = new WeakReference<Database>(database);
        this.writeDelay = writeDelay;
    }

    public void setWriteDelay(int writeDelay) {
        this.writeDelay = writeDelay;
    }

    public static WriterThread create(Database database, int writeDelay) {
        try {
            WriterThread writer = new WriterThread(database, writeDelay);
            writer.thread = new Thread((Runnable)writer, "H2 Log Writer " + database.getShortName());
            Driver.setThreadContextClassLoader(writer.thread);
            writer.thread.setDaemon(true);
            return writer;
        }
        catch (AccessControlException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Database database;
        while (!this.stop && (database = (Database)this.databaseRef.get()) != null) {
            int wait;
            block11: {
                wait = this.writeDelay;
                try {
                    if (database.isFileLockSerialized()) {
                        wait = 5;
                        database.checkpointIfRequired();
                    } else {
                        database.flush();
                    }
                }
                catch (Exception e) {
                    TraceSystem traceSystem = database.getTraceSystem();
                    if (traceSystem == null) break block11;
                    traceSystem.getTrace("database").error(e, "flush");
                }
            }
            WriterThread writerThread = this;
            synchronized (writerThread) {
                int w;
                for (wait = Math.max(wait, 5); !this.stop && wait > 0; wait -= w) {
                    w = Math.min(wait, 100);
                    try {
                        this.wait(w);
                        continue;
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
            }
        }
        this.databaseRef = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopThread() {
        this.stop = true;
        WriterThread writerThread = this;
        synchronized (writerThread) {
            this.notify();
        }
    }

    public void startThread() {
        this.thread.start();
        this.thread = null;
    }
}

