/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store.fs;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.h2.store.fs.FileUtils;

public class FileChannelOutputStream
extends OutputStream {
    private FileChannel channel;
    private byte[] buffer = new byte[]{0};

    public FileChannelOutputStream(FileChannel channel, boolean append) throws IOException {
        this.channel = channel;
        if (append) {
            channel.position(channel.size());
        } else {
            channel.position(0L);
            channel.truncate(0L);
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.buffer[0] = (byte)b;
        FileUtils.writeFully(this.channel, ByteBuffer.wrap(this.buffer));
    }

    @Override
    public void write(byte[] b) throws IOException {
        FileUtils.writeFully(this.channel, ByteBuffer.wrap(b));
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        FileUtils.writeFully(this.channel, ByteBuffer.wrap(b, off, len));
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }
}

