/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store.fs;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import org.h2.store.fs.FileBase;
import org.h2.store.fs.FileMemData;

class FileMem
extends FileBase {
    private final FileMemData data;
    private final boolean readOnly;
    private long pos;

    FileMem(FileMemData data, boolean readOnly) {
        this.data = data;
        this.readOnly = readOnly;
    }

    @Override
    public long size() {
        return this.data.length();
    }

    @Override
    public FileChannel truncate(long newLength) throws IOException {
        if (newLength < this.size()) {
            this.data.touch(this.readOnly);
            this.pos = Math.min(this.pos, newLength);
            this.data.truncate(newLength);
        }
        return this;
    }

    @Override
    public FileChannel position(long newPos) {
        this.pos = (int)newPos;
        return this;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        int len = src.remaining();
        if (len == 0) {
            return 0;
        }
        this.data.touch(this.readOnly);
        this.pos = this.data.readWrite(this.pos, src.array(), src.position(), len, true);
        src.position(src.position() + len);
        return len;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int len = dst.remaining();
        if (len == 0) {
            return 0;
        }
        long newPos = this.data.readWrite(this.pos, dst.array(), dst.position(), len, false);
        len = (int)(newPos - this.pos);
        if (len <= 0) {
            return -1;
        }
        dst.position(dst.position() + len);
        this.pos = newPos;
        return len;
    }

    @Override
    public long position() {
        return this.pos;
    }

    @Override
    public void implCloseChannel() throws IOException {
        this.pos = 0L;
    }

    @Override
    public void force(boolean metaData) throws IOException {
    }

    @Override
    public synchronized FileLock tryLock(long position, long size, boolean shared) throws IOException {
        return null;
    }

    public String toString() {
        return this.data.getName();
    }
}

