/*
 * Decompiled with CFR 0.152.
 */
package org.h2.upgrade;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.h2.engine.ConnectionInfo;
import org.h2.jdbc.JdbcConnection;
import org.h2.message.DbException;
import org.h2.store.fs.FileUtils;
import org.h2.util.StringUtils;
import org.h2.util.Utils;

public class DbUpgrade {
    private static boolean upgradeClassesPresent = Utils.isClassPresent("org.h2.upgrade.v1_1.Driver");
    private static boolean scriptInTempDir;
    private static boolean deleteOldDb;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connection connectOrUpgrade(String url, Properties info) throws SQLException {
        ConnectionInfo ci;
        if (!upgradeClassesPresent) {
            return null;
        }
        Properties i2 = new Properties();
        i2.putAll((Map<?, ?>)info);
        Object o = info.get("password");
        if (o != null && o instanceof char[]) {
            i2.put("password", StringUtils.cloneCharArray((char[])o));
        }
        if ((ci = new ConnectionInfo(url, info = i2)).isRemote() || !ci.isPersistent()) {
            return null;
        }
        String name = ci.getName();
        if (FileUtils.exists(name + ".h2.db")) {
            return null;
        }
        if (!FileUtils.exists(name + ".data.db")) {
            return null;
        }
        if (ci.removeProperty("NO_UPGRADE", false)) {
            return DbUpgrade.connectWithOldVersion(url, info);
        }
        Class<DbUpgrade> clazz = DbUpgrade.class;
        synchronized (DbUpgrade.class) {
            DbUpgrade.upgrade(ci, info);
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return null;
        }
    }

    public static void setScriptInTempDir(boolean scriptInTempDir) {
        DbUpgrade.scriptInTempDir = scriptInTempDir;
    }

    public static void setDeleteOldDb(boolean deleteOldDb) {
        DbUpgrade.deleteOldDb = deleteOldDb;
    }

    private static Connection connectWithOldVersion(String url, Properties info) throws SQLException {
        url = "jdbc:h2v1_1:" + url.substring("jdbc:h2:".length()) + ";IGNORE_UNKNOWN_SETTINGS=TRUE";
        return DriverManager.getConnection(url, info);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void upgrade(ConnectionInfo ci, Properties info) throws SQLException {
        String name = ci.getName();
        String data = name + ".data.db";
        String index = name + ".index.db";
        String lobs = name + ".lobs.db";
        String backupData = data + ".backup";
        String backupIndex = index + ".backup";
        String backupLobs = lobs + ".backup";
        String script = null;
        try {
            if (scriptInTempDir) {
                new File(Utils.getProperty("java.io.tmpdir", ".")).mkdirs();
                script = File.createTempFile("h2dbmigration", "backup.sql").getAbsolutePath();
            } else {
                script = name + ".script.sql";
            }
            String oldUrl = "jdbc:h2v1_1:" + name + ";UNDO_LOG=0;LOG=0;LOCK_MODE=0";
            String cipher = ci.getProperty("CIPHER", null);
            if (cipher != null) {
                oldUrl = oldUrl + ";CIPHER=" + cipher;
            }
            Connection conn = DriverManager.getConnection(oldUrl, info);
            Statement stat = conn.createStatement();
            String uuid = UUID.randomUUID().toString();
            if (cipher != null) {
                stat.execute("script to '" + script + "' cipher aes password '" + uuid + "' --hide--");
            } else {
                stat.execute("script to '" + script + "'");
            }
            conn.close();
            FileUtils.moveTo(data, backupData);
            FileUtils.moveTo(index, backupIndex);
            if (FileUtils.exists(lobs)) {
                FileUtils.moveTo(lobs, backupLobs);
            }
            ci.removeProperty("IFEXISTS", false);
            conn = new JdbcConnection(ci, true);
            stat = conn.createStatement();
            if (cipher != null) {
                stat.execute("runscript from '" + script + "' cipher aes password '" + uuid + "' --hide--");
            } else {
                stat.execute("runscript from '" + script + "'");
            }
            stat.execute("analyze");
            stat.execute("shutdown compact");
            stat.close();
            conn.close();
            if (deleteOldDb) {
                FileUtils.delete(backupData);
                FileUtils.delete(backupIndex);
                FileUtils.deleteRecursive(backupLobs, false);
            }
            if (script == null) return;
        }
        catch (Exception e) {
            try {
                if (FileUtils.exists(backupData)) {
                    FileUtils.moveTo(backupData, data);
                }
                if (FileUtils.exists(backupIndex)) {
                    FileUtils.moveTo(backupIndex, index);
                }
                if (FileUtils.exists(backupLobs)) {
                    FileUtils.moveTo(backupLobs, lobs);
                }
                FileUtils.delete(name + ".h2.db");
                throw DbException.toSQLException(e);
            }
            catch (Throwable throwable) {
                if (script == null) throw throwable;
                FileUtils.delete(script);
                throw throwable;
            }
        }
        FileUtils.delete(script);
        return;
    }
}

