/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.text.Collator;
import java.util.Locale;
import org.h2.util.StringUtils;
import org.h2.value.CompareModeDefault;
import org.h2.value.CompareModeIcu4J;

public class CompareMode {
    public static final String OFF = "OFF";
    public static final String DEFAULT = "DEFAULT_";
    public static final String ICU4J = "ICU4J_";
    private static CompareMode lastUsed;
    private static boolean canUseICU4J;
    private final String name;
    private final int strength;

    protected CompareMode(String name, int strength) {
        this.name = name;
        this.strength = strength;
    }

    public static synchronized CompareMode getInstance(String name, int strength) {
        if (lastUsed != null && StringUtils.equals(CompareMode.lastUsed.name, name) && CompareMode.lastUsed.strength == strength) {
            return lastUsed;
        }
        if (name == null || name.equals(OFF)) {
            lastUsed = new CompareMode(name, strength);
        } else {
            boolean useICU4J;
            if (name.startsWith(ICU4J)) {
                useICU4J = true;
                name = name.substring(ICU4J.length());
            } else if (name.startsWith(DEFAULT)) {
                useICU4J = false;
                name = name.substring(DEFAULT.length());
            } else {
                useICU4J = canUseICU4J;
            }
            lastUsed = useICU4J ? new CompareModeIcu4J(name, strength) : new CompareModeDefault(name, strength);
        }
        return lastUsed;
    }

    public boolean equalsChars(String a, int ai, String b, int bi, boolean ignoreCase) {
        char ca = a.charAt(ai);
        char cb = b.charAt(bi);
        if (ignoreCase) {
            ca = Character.toUpperCase(ca);
            cb = Character.toUpperCase(cb);
        }
        return ca == cb;
    }

    public int compareString(String a, String b, boolean ignoreCase) {
        if (ignoreCase) {
            return a.compareToIgnoreCase(b);
        }
        return a.compareTo(b);
    }

    public static String getName(Locale l) {
        Locale english = Locale.ENGLISH;
        String name = l.getDisplayLanguage(english) + ' ' + l.getDisplayCountry(english) + ' ' + l.getVariant();
        name = StringUtils.toUpperEnglish(name.trim().replace(' ', '_'));
        return name;
    }

    static boolean compareLocaleNames(Locale locale, String name) {
        return name.equalsIgnoreCase(locale.toString()) || name.equalsIgnoreCase(CompareMode.getName(locale));
    }

    public static Collator getCollator(String name) {
        String country;
        String language;
        Locale locale3;
        int idx;
        Collator result = null;
        if (name.startsWith(ICU4J)) {
            name = name.substring(ICU4J.length());
        } else if (name.startsWith(DEFAULT)) {
            name = name.substring(DEFAULT.length());
        }
        if (name.length() == 2) {
            Locale locale2 = new Locale(StringUtils.toLowerEnglish(name), "");
            if (CompareMode.compareLocaleNames(locale2, name)) {
                result = Collator.getInstance(locale2);
            }
        } else if (name.length() == 5 && (idx = name.indexOf(95)) >= 0 && CompareMode.compareLocaleNames(locale3 = new Locale(language = StringUtils.toLowerEnglish(name.substring(0, idx)), country = name.substring(idx + 1)), name)) {
            result = Collator.getInstance(locale3);
        }
        if (result == null) {
            for (Locale locale3 : Collator.getAvailableLocales()) {
                if (!CompareMode.compareLocaleNames(locale3, name)) continue;
                result = Collator.getInstance(locale3);
                break;
            }
        }
        return result;
    }

    public String getName() {
        return this.name == null ? OFF : this.name;
    }

    public int getStrength() {
        return this.strength;
    }

    static {
        try {
            Class.forName("com.ibm.icu.text.Collator");
            canUseICU4J = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

