/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.h2.constant.SysProperties;
import org.h2.util.MathUtils;
import org.h2.util.StringUtils;
import org.h2.value.CompareMode;
import org.h2.value.Value;

public class ValueString
extends Value {
    private static final ValueString EMPTY = new ValueString("");
    protected final String value;

    protected ValueString(String value) {
        this.value = value;
    }

    @Override
    public String getSQL() {
        return StringUtils.quoteStringSQL(this.value);
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof ValueString && this.value.equals(((ValueString)other).value);
    }

    @Override
    protected int compareSecure(Value o, CompareMode mode) {
        ValueString v = (ValueString)o;
        return mode.compareString(this.value, v.value, false);
    }

    @Override
    public String getString() {
        return this.value;
    }

    @Override
    public long getPrecision() {
        return this.value.length();
    }

    @Override
    public Object getObject() {
        return this.value;
    }

    @Override
    public void set(PreparedStatement prep, int parameterIndex) throws SQLException {
        prep.setString(parameterIndex, this.value);
    }

    @Override
    public int getDisplaySize() {
        return this.value.length();
    }

    @Override
    public int getMemory() {
        return this.value.length() * 2 + 48;
    }

    @Override
    public Value convertPrecision(long precision, boolean force) {
        if (precision == 0L || (long)this.value.length() <= precision) {
            return this;
        }
        int p = MathUtils.convertLongToInt(precision);
        return this.getNew(this.value.substring(0, p));
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public int getType() {
        return 13;
    }

    public static ValueString get(String s) {
        if (s.length() == 0) {
            return EMPTY;
        }
        ValueString obj = new ValueString(StringUtils.cache(s));
        if (s.length() > SysProperties.OBJECT_CACHE_MAX_PER_ELEMENT_SIZE) {
            return obj;
        }
        return (ValueString)Value.cache(obj);
    }

    protected ValueString getNew(String s) {
        return ValueString.get(s);
    }
}

