/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.gss.redhat_support_lib.infrastructure;

import com.redhat.gss.redhat_support_lib.api.API;
import com.redhat.gss.redhat_support_lib.errors.RequestException;
import java.io.File;
import java.io.FileNotFoundException;
import java.text.ParseException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.net.util.Base64;
import org.jboss.logging.Logger;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.plugins.providers.multipart.MultipartFormDataOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseQuery {
    private static final Logger LOGGER = Logger.getLogger((String)API.class.getName());

    protected <T> T get(ResteasyClient client, String uri, Class<T> c) throws RequestException {
        Response response = client.target(uri).request().accept(new String[]{"application/xml"}).get();
        if (response.getStatus() != 200) {
            LOGGER.debug((Object)("Failed : HTTP error code : " + response.getStatusInfo().getStatusCode() + " - " + response.getStatusInfo().getReasonPhrase()));
            throw new RequestException(response.getStatusInfo().getStatusCode() + " - " + response.getStatusInfo().getReasonPhrase());
        }
        Object returnObject = response.readEntity(c);
        return (T)returnObject;
    }

    protected Response add(ResteasyClient client, String uri, Object object) throws RequestException {
        Response response = client.target(uri).request().accept(new String[]{"application/xml"}).post(Entity.entity((Object)object, (String)"application/xml"));
        if (response.getStatus() > 399) {
            LOGGER.debug((Object)("Failed : HTTP error code : " + response.getStatusInfo().getStatusCode() + " - " + response.getStatusInfo().getReasonPhrase()));
            throw new RequestException(response.getStatusInfo().getStatusCode() + " - " + response.getStatusInfo().getReasonPhrase());
        }
        return response;
    }

    protected <T> T add(ResteasyClient client, String uri, Object object, Class<T> c) throws RequestException {
        Response response = client.target(uri).request(new String[]{"application/xml"}).accept(new String[]{"application/xml"}).post(Entity.entity((Object)object, (String)"application/xml"));
        if (response.getStatus() > 399) {
            LOGGER.debug((Object)("Failed : HTTP error code : " + response.getStatusInfo().getStatusCode() + " - " + response.getStatusInfo().getReasonPhrase()));
            throw new RequestException(response.getStatusInfo().getStatusCode() + " - " + response.getStatusInfo().getReasonPhrase());
        }
        Object returnObject = response.readEntity(c);
        return (T)returnObject;
    }

    protected Response update(ResteasyClient client, String uri, Object object) throws RequestException {
        Response response = client.target(uri).request().accept(new String[]{"application/xml"}).put(Entity.entity((Object)object, (String)"application/xml"));
        if (response.getStatus() > 399) {
            LOGGER.debug((Object)("Failed : HTTP error code : " + response.getStatusInfo().getStatusCode() + " - " + response.getStatusInfo().getReasonPhrase()));
            throw new RequestException(response.getStatusInfo().getStatusCode() + " - " + response.getStatusInfo().getReasonPhrase());
        }
        return response;
    }

    protected boolean delete(ResteasyClient client, String uri) throws RequestException {
        Response response = (Response)client.target(uri).request().accept(new String[]{"application/xml"}).delete(Response.class);
        if (response.getStatus() > 399) {
            LOGGER.debug((Object)("Failed : HTTP error code : " + response.getStatusInfo().getStatusCode() + " - " + response.getStatusInfo().getReasonPhrase()));
            throw new RequestException(response.getStatusInfo().getStatusCode() + " - " + response.getStatusInfo().getReasonPhrase());
        }
        return true;
    }

    protected Response upload(ResteasyClient client, String uri, File file, String description) throws FileNotFoundException, ParseException, RequestException {
        MultipartFormDataOutput mdo = new MultipartFormDataOutput();
        if (description != null) {
            mdo.addFormData("description", (Object)description, MediaType.APPLICATION_XML_TYPE);
        }
        mdo.addFormData("file", (Object)file, MediaType.APPLICATION_OCTET_STREAM_TYPE, file.getName());
        GenericEntity<MultipartFormDataOutput> entity = new GenericEntity<MultipartFormDataOutput>(mdo){};
        byte[] encodedString = null;
        String tmp = "sshumake:redhat1";
        encodedString = Base64.encodeBase64((byte[])tmp.getBytes());
        Invocation.Builder builder = client.target(uri).request(new String[]{"application/xml"}).header("Authorization", (Object)("Basic " + encodedString.toString()));
        if (description != null) {
            builder.header("description", (Object)description);
        }
        String blah = mdo.getBoundary();
        Response response = builder.post(Entity.entity((Object)entity, (MediaType)MediaType.MULTIPART_FORM_DATA_TYPE));
        if (response.getStatus() > 399) {
            LOGGER.debug((Object)("Failed : HTTP error code : " + response.getStatusInfo().getStatusCode() + " - " + response.getStatusInfo().getReasonPhrase()));
            throw new RequestException(response.getStatusInfo().getStatusCode() + " - " + response.getStatusInfo().getReasonPhrase());
        }
        return response;
    }
}

