/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.gss.redhat_support_lib.infrastructure;

import com.redhat.gss.redhat_support_lib.errors.RequestException;
import com.redhat.gss.redhat_support_lib.helpers.FilterHelper;
import com.redhat.gss.redhat_support_lib.helpers.QueryBuilder;
import com.redhat.gss.redhat_support_lib.infrastructure.BaseQuery;
import com.redhat.gss.redhat_support_lib.parsers.Case;
import com.redhat.gss.redhat_support_lib.parsers.Values;
import com.redhat.gss.redhat_support_lib.web.ConnectionManager;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cases
extends BaseQuery {
    private static final Logger LOGGER = Logger.getLogger((String)Cases.class.getName());
    ConnectionManager connectionManager = null;
    static String url = "/rs/cases/";

    public Cases(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public Case get(String caseNum) throws RequestException, MalformedURLException {
        String fullUrl = this.connectionManager.getConfig().getUrl() + url + caseNum;
        return this.get(this.connectionManager.getConnection(), fullUrl, Case.class);
    }

    public List<Case> list(String[] keywords, boolean includeClosed, boolean detail, String group, String startDate, String endDate, String count, String start, String[] kwargs) throws RequestException, MalformedURLException {
        StringBuilder xmlString = new StringBuilder();
        xmlString.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><caseFilter xmlns=\"http://www.redhat.com/gss/strata\">");
        if (keywords != null) {
            for (String keyword : keywords) {
                xmlString.append("<keyword>");
                xmlString.append(keyword);
                xmlString.append("</keyword>");
            }
        }
        if (includeClosed) {
            xmlString.append("<includeClosed>true</includeClosed>");
        }
        if (group != null) {
            xmlString.append("<groupNumber>");
            xmlString.append(group);
            xmlString.append("</groupNumber>");
        } else {
            xmlString.append("<onlyUngrouped>");
            xmlString.append("true");
            xmlString.append("</onlyUngrouped>");
        }
        if (startDate != null) {
            xmlString.append("<startDate>");
            xmlString.append(startDate);
            xmlString.append("</startDate>");
        }
        if (endDate != null) {
            xmlString.append("<endDate>");
            xmlString.append(endDate);
            xmlString.append("</endDate>");
        }
        if (count != null) {
            xmlString.append("<count>");
            xmlString.append(count);
            xmlString.append("</count>");
        }
        if (start != null) {
            xmlString.append("<start>");
            xmlString.append(start);
            xmlString.append("</start>");
        }
        xmlString.append("<ownerSSOName>");
        xmlString.append(this.connectionManager.getConfig().getUsername());
        xmlString.append("</ownerSSOName>");
        xmlString.append("</caseFilter>");
        ArrayList<String> queryParams = new ArrayList<String>();
        if (detail) {
            queryParams.add("detail=true");
        }
        String fullUrl = QueryBuilder.appendQuery(this.connectionManager.getConfig().getUrl() + url + "filter", queryParams);
        com.redhat.gss.redhat_support_lib.parsers.Cases cases = this.add(this.connectionManager.getConnection(), fullUrl, xmlString.toString(), com.redhat.gss.redhat_support_lib.parsers.Cases.class);
        return FilterHelper.filterResults(cases.getCase(), kwargs);
    }

    public Case add(Case cas) throws Exception {
        String fullUrl = this.connectionManager.getConfig().getUrl() + url;
        Response resp = this.add(this.connectionManager.getConnection(), fullUrl, cas);
        MultivaluedMap headers = resp.getStringHeaders();
        URL caseurl = null;
        try {
            caseurl = new URL((String)headers.getFirst((Object)"Location"));
        }
        catch (MalformedURLException e) {
            LOGGER.debug((Object)("Failed : Adding case " + cas.getSummary() + " was unsuccessful."));
            throw new Exception();
        }
        String path = caseurl.getPath();
        cas.setCaseNumber(path.substring(path.lastIndexOf(47) + 1, path.length()));
        cas.setViewUri(caseurl.toString());
        return cas;
    }

    public Case update(Case cas) throws RequestException, MalformedURLException {
        String fullUrl = this.connectionManager.getConfig().getUrl() + url + cas.getCaseNumber();
        Response resp = this.update(this.connectionManager.getConnection(), fullUrl, cas);
        return cas;
    }

    public List<Values.Value> getSeverities() throws RequestException, MalformedURLException {
        String fullUrl = this.connectionManager.getConfig().getUrl() + "/rs/values/case/severity";
        Values values = this.get(this.connectionManager.getConnection(), fullUrl, Values.class);
        return values.getValue();
    }
}

