/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.gss.redhat_support_lib.infrastructure;

import com.redhat.gss.redhat_support_lib.errors.RequestException;
import com.redhat.gss.redhat_support_lib.helpers.QueryBuilder;
import com.redhat.gss.redhat_support_lib.infrastructure.BaseQuery;
import com.redhat.gss.redhat_support_lib.parsers.Comment;
import com.redhat.gss.redhat_support_lib.web.ConnectionManager;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Comments
extends BaseQuery {
    private static final Logger LOGGER = Logger.getLogger((String)Comments.class.getName());
    ConnectionManager connectionManager = null;

    public Comments(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public Comment get(String caseNumber, String commentID) throws RequestException, MalformedURLException {
        String url = "/rs/cases/{caseNumber}/comments/{commentID}";
        url = url.replace("{caseNumber}", caseNumber);
        url = url.replace("{commentID}", commentID);
        String fullUrl = this.connectionManager.getConfig().getUrl() + url;
        return this.get(this.connectionManager.getConnection(), fullUrl, Comment.class);
    }

    public List<Comment> list(String caseNumber, String startDate, String endDate, String[] kwargs) throws RequestException, MalformedURLException {
        String url = "/rs/cases/{caseNumber}/comments";
        url = url.replace("{caseNumber}", caseNumber);
        ArrayList<String> queryParams = new ArrayList<String>();
        if (startDate != null) {
            queryParams.add("startDate=" + startDate);
        }
        if (endDate != null) {
            queryParams.add("endDate=" + endDate);
        }
        String fullUrl = QueryBuilder.appendQuery(this.connectionManager.getConfig().getUrl() + url, queryParams);
        com.redhat.gss.redhat_support_lib.parsers.Comments comments = this.get(this.connectionManager.getConnection(), fullUrl, com.redhat.gss.redhat_support_lib.parsers.Comments.class);
        return comments.getComment();
    }

    public Comment add(Comment comment) throws Exception {
        String url = "/rs/cases/{caseNumber}/comments";
        url = url.replace("{caseNumber}", comment.getCaseNumber());
        String fullUrl = this.connectionManager.getConfig().getUrl() + url;
        Response resp = this.add(this.connectionManager.getConnection(), fullUrl, comment);
        MultivaluedMap headers = resp.getStringHeaders();
        URL caseurl = null;
        try {
            caseurl = new URL((String)headers.getFirst((Object)"Location"));
        }
        catch (MalformedURLException e) {
            LOGGER.debug((Object)("Failed : Adding comment " + comment.getText() + " was unsuccessful."));
            throw new Exception();
        }
        String path = caseurl.getPath();
        comment.setCaseNumber(path.substring(path.lastIndexOf(47) + 1, path.length()));
        comment.setViewUri(caseurl.toString());
        return comment;
    }
}

