/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.gss.redhat_support_lib.web;

import com.redhat.gss.redhat_support_lib.errors.FTPException;
import com.redhat.gss.redhat_support_lib.filters.UserAgentFilter;
import com.redhat.gss.redhat_support_lib.helpers.ConfigHelper;
import com.redhat.gss.redhat_support_lib.web.CustomHttpEngine;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPHTTPClient;
import org.apache.log4j.Logger;
import org.jboss.resteasy.client.jaxrs.BasicAuthentication;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;

public class ConnectionManager {
    private static final Logger LOGGER = Logger.getLogger((String)ConnectionManager.class.getName());
    ResteasyClientBuilder clientBuilder = new ResteasyClientBuilder().connectionPoolSize(100);
    ConfigHelper config = null;

    public ConnectionManager(ConfigHelper config) {
        this.config = config;
        this.clientBuilder.connectionPoolSize(100);
        this.clientBuilder.connectionTTL((long)config.getTimeout(), TimeUnit.MILLISECONDS);
        this.clientBuilder.socketTimeout((long)config.getTimeout(), TimeUnit.MILLISECONDS);
        CustomHttpEngine httpEngine = new CustomHttpEngine(config);
        this.clientBuilder.httpEngine((ClientHttpEngine)httpEngine);
        if (config.isDevel()) {
            this.clientBuilder.disableTrustManager();
        }
        if (config.getProxyUrl() != null) {
            this.clientBuilder.defaultProxy("10.13.49.98", config.getProxyPort());
        }
    }

    public ResteasyClient getConnection() throws MalformedURLException {
        ResteasyClient client = this.clientBuilder.build();
        client.register((Object)new BasicAuthentication(this.config.getUsername(), this.config.getPassword()));
        client.register((Object)new UserAgentFilter(this.config.getUserAgent()));
        return client;
    }

    public ConfigHelper getConfig() {
        return this.config;
    }

    public FTPClient getFTP() throws IOException, FTPException {
        Object ftp = null;
        ftp = this.config.getProxyUrl() == null ? new FTPClient() : new FTPHTTPClient(this.config.getProxyUrl().getHost(), this.config.getProxyPort(), this.config.getProxyUser(), this.config.getProxyPassword());
        ftp.connect(this.config.getFtpHost(), this.config.getFtpPort());
        if (!ftp.login(this.config.getFtpUsername(), this.config.getFtpPassword())) {
            throw new FTPException("Error during FTP login");
        }
        return ftp;
    }
}

