/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.demo.activemq;

import io.fabric8.api.scr.AbstractComponent;
import java.util.Map;
import javax.jms.JMSException;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Reference;
import org.fusesource.mq.ActiveMQService;
import org.fusesource.mq.JMSService;
import org.fusesource.mq.ProducerThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(name="io.fabric8.example.mq.producer", label="ActiveMQ Producer Factory", configurationFactory=true, immediate=true, metatype=true)
public class ActiveMQProducerFactory
extends AbstractComponent {
    private static final Logger LOG = LoggerFactory.getLogger(ActiveMQProducerFactory.class);
    ProducerThread producer;
    ActiveMQService producerService;
    @Reference(referenceInterface=ActiveMQConnectionFactory.class)
    private ActiveMQConnectionFactory connectionFactory;

    @Activate
    void activate(Map<String, ?> properties) throws Exception {
        this.updateInternal(properties);
        this.activateComponent();
    }

    @Modified
    public void modified(Map<String, ?> configuration) throws Exception {
        this.updateInternal(configuration);
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
        if (this.producer != null) {
            this.producer.setRunning(false);
            this.producerService.stop();
        }
    }

    private void updateInternal(Map<String, ?> configuration) throws Exception {
        try {
            this.producerService = new ActiveMQService(this.connectionFactory);
            this.producerService.setMaxAttempts(10);
            this.producerService.start();
            String destination = (String)configuration.get("destination");
            this.producer = new ProducerThread((JMSService)this.producerService, destination);
            this.producer.setSleep(500);
            this.producer.start();
            LOG.info("Producer started");
        }
        catch (JMSException e) {
            throw new Exception("Cannot start producer", e);
        }
    }

    protected void bindConnectionFactory(ActiveMQConnectionFactory activeMQConnectionFactory) {
        this.connectionFactory = activeMQConnectionFactory;
    }

    protected void unbindConnectionFactory(ActiveMQConnectionFactory activeMQConnectionFactory) {
        if (this.connectionFactory == activeMQConnectionFactory) {
            this.connectionFactory = null;
        }
    }
}

