/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.demo.activemq;

import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.demo.activemq.ActiveMQProducerFactory;
import java.util.Map;
import javax.jms.JMSException;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Reference;
import org.fusesource.mq.ActiveMQService;
import org.fusesource.mq.ConsumerThread;
import org.fusesource.mq.JMSService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(name="io.fabric8.example.mq.consumer", label="ActiveMQ Consumer Factory", configurationFactory=true, immediate=true, metatype=true)
public class ActiveMQConsumerFactory
extends AbstractComponent {
    private static final Logger LOG = LoggerFactory.getLogger(ActiveMQProducerFactory.class);
    ConsumerThread consumer;
    ActiveMQService consumerService;
    @Reference(referenceInterface=ActiveMQConnectionFactory.class)
    private ActiveMQConnectionFactory connectionFactory;

    @Activate
    void activate(Map<String, ?> configuration) throws Exception {
        this.updateInternal(configuration);
        this.activateComponent();
    }

    @Modified
    void modified(Map<String, ?> configuration) throws Exception {
        this.deactivateInternal();
        this.updateInternal(configuration);
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
        this.deactivateInternal();
    }

    protected void deactivateInternal() {
        if (this.consumer != null) {
            this.consumer.setRunning(false);
            this.consumerService.stop();
        }
    }

    private void updateInternal(Map<String, ?> configuration) throws Exception {
        try {
            this.consumerService = new ActiveMQService(this.connectionFactory);
            this.consumerService.setMaxAttempts(10);
            this.consumerService.start();
            String destination = (String)configuration.get("destination");
            this.consumer = new ConsumerThread((JMSService)this.consumerService, destination);
            this.consumer.start();
            LOG.info("Consumer started");
        }
        catch (JMSException e) {
            throw new Exception("Cannot start consumer", e);
        }
    }

    protected void bindConnectionFactory(ActiveMQConnectionFactory activeMQConnectionFactory) {
        this.connectionFactory = activeMQConnectionFactory;
    }

    protected void unbindConnectionFactory(ActiveMQConnectionFactory activeMQConnectionFactory) {
        if (this.connectionFactory == activeMQConnectionFactory) {
            this.connectionFactory = null;
        }
    }
}

