/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.insight.activemq.base;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.broker.BrokerPluginSupport;
import org.apache.activemq.broker.region.MessageReference;
import org.fusesource.insight.activemq.base.InsightBrokerPlugin;
import org.fusesource.insight.activemq.base.SwichtableBrokerPluginMBean;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public class SwichtableBrokerPlugin
extends BrokerPluginSupport
implements SwichtableBrokerPluginMBean,
InsightBrokerPlugin {
    private Map<String, String> properties;
    private final boolean defaultEnable;
    private final AtomicBoolean enabled;
    private final Map<String, Boolean> perDest = new ConcurrentHashMap<String, Boolean>();

    protected SwichtableBrokerPlugin() {
        this(true);
    }

    protected SwichtableBrokerPlugin(boolean defaultEnable) {
        this.defaultEnable = defaultEnable;
        this.enabled = new AtomicBoolean(defaultEnable);
    }

    public String getPlugin() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void update(Map<String, String> properties) {
        if (properties == null) {
            properties = new HashMap<String, String>();
        }
        if (this.properties == null || !this.properties.equals(properties)) {
            this.doUpdate(properties);
        }
        this.properties = properties;
    }

    private void doUpdate(Map<String, String> properties) {
        boolean enabled = this.defaultEnable;
        HashMap<String, Boolean> perDest = new HashMap<String, Boolean>();
        if (properties != null) {
            for (String key : properties.keySet()) {
                String val = properties.get(key);
                if ("enabled".equals(key)) {
                    enabled = Boolean.parseBoolean(val);
                    continue;
                }
                if (!key.startsWith("dest.")) continue;
                perDest.put(key.substring("dest.".length()), Boolean.parseBoolean(val));
            }
        }
        this.enabled.set(enabled);
        this.updateMap(this.perDest, perDest);
    }

    public Map<String, ?> getProperties() {
        return this.properties;
    }

    private void updateMap(Map<String, Boolean> oldMap, Map<String, Boolean> newMap) {
        oldMap.putAll(newMap);
        Iterator<String> it = oldMap.keySet().iterator();
        while (it.hasNext()) {
            String key = it.next();
            if (newMap.containsKey(key)) continue;
            it.remove();
        }
    }

    @Override
    public String getConfiguration() {
        Properties props = new Properties();
        if (this.properties != null) {
            props.putAll(this.properties);
        }
        StringWriter sw = new StringWriter();
        try {
            props.store(sw, null);
        }
        catch (IOException e) {
            return null;
        }
        return sw.toString();
    }

    @Override
    public void setConfiguration(String configuration) {
        try {
            Properties props = new Properties();
            props.load(new StringReader(configuration));
            String strategy = this.getPlugin();
            BundleContext bundleContext = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
            ServiceReference sr = bundleContext.getServiceReference(ConfigurationAdmin.class);
            ConfigurationAdmin ca = (ConfigurationAdmin)bundleContext.getService(sr);
            if (ca != null) {
                Configuration config = ca.getConfiguration("org.fusesource.insight.activemq");
                Hashtable<String, String> dic = config.getProperties();
                if (dic == null) {
                    dic = new Hashtable<String, String>();
                }
                HashSet<String> s = new HashSet<String>();
                Enumeration keyEnum = ((Dictionary)dic).keys();
                while (keyEnum.hasMoreElements()) {
                    String key = (String)keyEnum.nextElement();
                    if (!key.startsWith(strategy + ".")) continue;
                    s.add(key);
                }
                for (String key : s) {
                    ((Dictionary)dic).remove(key);
                }
                for (String key : props.stringPropertyNames()) {
                    ((Dictionary)dic).put(strategy + "." + key, props.getProperty(key));
                }
                config.update(dic);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void reset() {
        this.enabled.set(this.defaultEnable);
        this.perDest.clear();
    }

    public void enable() {
        this.enabled.set(true);
    }

    public void disable() {
        this.enabled.set(false);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled.get();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled.set(enabled);
    }

    @Override
    public void enableForDest(String dest) {
        this.perDest.put(dest, true);
    }

    @Override
    public void disableForDest(String dest) {
        this.perDest.put(dest, false);
    }

    @Override
    public void clearForDest(String dest) {
        this.perDest.remove(dest);
    }

    public boolean isEnabled(MessageReference message) {
        Boolean b = this.isDestEnabled(message);
        return b == null ? this.enabled.get() : b.booleanValue();
    }

    public Boolean isDestEnabled(MessageReference message) {
        String name = this.getDestName(message);
        if (name != null) {
            return this.perDest.get(name);
        }
        return true;
    }

    private String getDestName(MessageReference message) {
        return message.getMessage().getDestination().toString();
    }
}

