/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.insight.camel.base;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Route;
import org.apache.camel.api.management.ManagedAttribute;
import org.fusesource.insight.camel.base.ContainerStrategy;
import org.fusesource.insight.camel.base.SwitchableContainerStrategyMBean;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public abstract class SwitchableContainerStrategy
implements ContainerStrategy,
SwitchableContainerStrategyMBean {
    private Map<String, String> properties;
    private final boolean defaultEnable;
    private final AtomicBoolean enabled;
    private final Map<String, Boolean> perContext = new ConcurrentHashMap<String, Boolean>();
    private final Map<String, Boolean> perRoute = new ConcurrentHashMap<String, Boolean>();

    protected SwitchableContainerStrategy() {
        this(true);
    }

    public String getStrategy() {
        return this.getClass().getSimpleName().toLowerCase();
    }

    protected SwitchableContainerStrategy(boolean defaultEnable) {
        this.defaultEnable = defaultEnable;
        this.enabled = new AtomicBoolean(defaultEnable);
    }

    @Override
    public void update(Map<String, String> properties) {
        if (properties == null) {
            properties = new HashMap<String, String>();
        }
        if (this.properties == null || !this.properties.equals(properties)) {
            this.doUpdate(properties);
        }
        this.properties = properties;
    }

    private void doUpdate(Map<String, String> properties) {
        boolean enabled = this.defaultEnable;
        HashMap<String, Boolean> perContext = new HashMap<String, Boolean>();
        HashMap<String, Boolean> perRoute = new HashMap<String, Boolean>();
        if (properties != null) {
            for (String key : properties.keySet()) {
                String val = properties.get(key);
                if ("enabled".equals(key)) {
                    enabled = Boolean.parseBoolean(val);
                    continue;
                }
                if (key.startsWith("context.")) {
                    perContext.put(key.substring("context.".length()), Boolean.parseBoolean(val));
                    continue;
                }
                if (!key.startsWith("route.")) continue;
                perRoute.put(key.substring("route.".length()), Boolean.parseBoolean(val));
            }
        }
        this.enabled.set(enabled);
        this.updateMap(this.perContext, perContext);
        this.updateMap(this.perRoute, perRoute);
    }

    public Map<String, ?> getProperties() {
        return this.properties;
    }

    private void updateMap(Map<String, Boolean> oldMap, Map<String, Boolean> newMap) {
        oldMap.putAll(newMap);
        Iterator<String> it = oldMap.keySet().iterator();
        while (it.hasNext()) {
            String key = it.next();
            if (newMap.containsKey(key)) continue;
            it.remove();
        }
    }

    @Override
    public String getConfiguration() {
        Properties props = new Properties();
        if (this.properties != null) {
            props.putAll(this.properties);
        }
        StringWriter sw = new StringWriter();
        try {
            props.store(sw, null);
        }
        catch (IOException e) {
            return null;
        }
        return sw.toString();
    }

    @Override
    public void setConfiguration(String configuration) {
        try {
            Properties props = new Properties();
            props.load(new StringReader(configuration));
            String strategy = this.getStrategy();
            BundleContext bundleContext = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
            ServiceReference sr = bundleContext.getServiceReference(ConfigurationAdmin.class);
            ConfigurationAdmin ca = (ConfigurationAdmin)bundleContext.getService(sr);
            if (ca != null) {
                Configuration config = ca.getConfiguration("org.fusesource.insight.camel");
                Hashtable<String, String> dic = config.getProperties();
                if (dic == null) {
                    dic = new Hashtable<String, String>();
                }
                HashSet<String> s = new HashSet<String>();
                Enumeration keyEnum = ((Dictionary)dic).keys();
                while (keyEnum.hasMoreElements()) {
                    String key = (String)keyEnum.nextElement();
                    if (!key.startsWith(strategy + ".")) continue;
                    s.add(key);
                }
                for (String key : s) {
                    ((Dictionary)dic).remove(key);
                }
                for (String key : props.stringPropertyNames()) {
                    ((Dictionary)dic).put(strategy + "." + key, props.getProperty(key));
                }
                config.update(dic);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void reset() {
        this.enabled.set(this.defaultEnable);
        this.perContext.clear();
        this.perRoute.clear();
    }

    public void enable() {
        this.enabled.set(true);
    }

    public void disable() {
        this.enabled.set(false);
    }

    @Override
    @ManagedAttribute(description="Is service enabled")
    public boolean isEnabled() {
        return this.enabled.get();
    }

    @Override
    @ManagedAttribute(description="Is service enabled")
    public void setEnabled(boolean enabled) {
        this.enabled.set(enabled);
    }

    @Override
    public void enableForContext(String context) {
        this.perContext.put(context, true);
    }

    @Override
    public void disableForContext(String context) {
        this.perContext.put(context, false);
    }

    @Override
    public void clearForContext(String context) {
        this.perContext.remove(context);
    }

    @Override
    public void enableForRoute(String route) {
        this.perRoute.put(route, true);
    }

    @Override
    public void disableForRoute(String route) {
        this.perRoute.put(route, false);
    }

    @Override
    public void clearForRoute(String route) {
        this.perRoute.remove(route);
    }

    public void enable(CamelContext context) {
        this.enableForContext(context.getName());
    }

    public void disable(CamelContext context) {
        this.disableForContext(context.getName());
    }

    public void clear(CamelContext context) {
        this.clearForContext(context.getName());
    }

    public void enable(Route route) {
        this.enableForRoute(route.getId());
    }

    public void disable(Route route) {
        this.disableForRoute(route.getId());
    }

    public void clear(Route route) {
        this.clearForRoute(route.getId());
    }

    public boolean isEnabled(Exchange exchange) {
        Boolean b = this.isRouteEnabled(exchange);
        if (b == null) {
            b = this.isContextEnabled(exchange);
        }
        return b == null ? this.enabled.get() : b.booleanValue();
    }

    public Boolean isRouteEnabled(Exchange exchange) {
        if (exchange.getFromRouteId() != null) {
            return this.perRoute.get(exchange.getFromRouteId());
        }
        return true;
    }

    public Boolean isContextEnabled(Exchange exchange) {
        return this.perContext.get(exchange.getContext().getName());
    }
}

