/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.insight.camel.breadcrumb;

import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.spi.ProcessorFactory;
import org.apache.camel.spi.RouteContext;
import org.fusesource.insight.camel.base.SwitchableContainerStrategy;
import org.fusesource.insight.camel.breadcrumb.BreadcrumbsMBean;
import org.fusesource.insight.camel.breadcrumb.BreadcrumbsProcessor;

@ManagedResource(description="Breadcrumbs")
public class Breadcrumbs
extends SwitchableContainerStrategy
implements BreadcrumbsMBean {
    public static final String BREADCRUMB = "ExtendedBreadcrumb";

    public Breadcrumbs() {
        this.enable();
    }

    @Override
    public void manage(CamelContext context) throws Exception {
        final ProcessorFactory delegate = context.getProcessorFactory();
        context.setProcessorFactory(new ProcessorFactory(){

            public Processor createChildProcessor(RouteContext routeContext, ProcessorDefinition<?> definition, boolean mandatory) throws Exception {
                Processor proc = delegate != null ? delegate.createChildProcessor(routeContext, definition, mandatory) : definition.createOutputsProcessor(routeContext);
                return Breadcrumbs.this.wrap(routeContext, definition, proc);
            }

            public Processor createProcessor(RouteContext routeContext, ProcessorDefinition<?> definition) throws Exception {
                Processor proc = delegate != null ? delegate.createProcessor(routeContext, definition) : definition.createProcessor(routeContext);
                return Breadcrumbs.this.wrap(routeContext, definition, proc);
            }
        });
    }

    public Processor wrap(RouteContext routeContext, ProcessorDefinition<?> definition, Processor processor) {
        if (processor == null) {
            return null;
        }
        return new BreadcrumbsProcessor(this, processor);
    }

    public static Set<String> getBreadcrumbs(Exchange exchange) {
        Object val = exchange.getIn().getHeader(BREADCRUMB);
        if (val instanceof BreadcrumbSet) {
            return (BreadcrumbSet)val;
        }
        BreadcrumbSet breadcrumbs = new BreadcrumbSet();
        exchange.getIn().setHeader(BREADCRUMB, (Object)breadcrumbs);
        if (val instanceof Iterable) {
            for (Object o : (Iterable)val) {
                if (o == null) continue;
                breadcrumbs.add(o.toString());
            }
        } else if (val != null) {
            breadcrumbs.add(val.toString());
        }
        return breadcrumbs;
    }

    public static Set<String> getBreadcrumbs(Exchange ... exchanges) {
        BreadcrumbSet breadcrumbs = new BreadcrumbSet();
        for (Exchange exchange : exchanges) {
            if (exchange == null) continue;
            breadcrumbs.addAll(Breadcrumbs.getBreadcrumbs(exchange));
        }
        return breadcrumbs;
    }

    public static void setBreadcrumbs(Exchange exchange, Set<String> breadcrumbs) {
        exchange.getIn().setHeader(BREADCRUMB, breadcrumbs);
    }

    private static class BreadcrumbSet
    extends LinkedHashSet<String> {
        private BreadcrumbSet() {
        }
    }
}

