/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.insight.camel.profiler;

import java.util.Map;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.processor.DelegateAsyncProcessor;
import org.apache.camel.spi.Synchronization;
import org.fusesource.insight.camel.profiler.ExchangeData;
import org.fusesource.insight.camel.profiler.Profiler;
import org.fusesource.insight.camel.profiler.Stats;

public class ProfilerProcessor
extends DelegateAsyncProcessor {
    private final Profiler profiler;
    private final Stats stats;
    private final Map<String, ExchangeData> exchanges;

    public ProfilerProcessor(Profiler profiler, Processor processor, Stats stats, Map<String, ExchangeData> exchanges) {
        super(processor);
        this.profiler = profiler;
        this.stats = stats;
        this.exchanges = exchanges;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean process(final Exchange exchange, final AsyncCallback callback) {
        if (!this.profiler.isEnabled(exchange)) {
            return this.processor.process(exchange, callback);
        }
        ExchangeData data = this.exchanges.get(exchange.getExchangeId());
        if (data == null) {
            data = new ExchangeData();
            this.exchanges.put(exchange.getExchangeId(), data);
            exchange.addOnCompletion((Synchronization)data);
        }
        final ExchangeData ed = data;
        ed.start(this.stats);
        try {
            boolean bl = this.processor.process(exchange, new AsyncCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void done(boolean doneSync) {
                    ed.start(ProfilerProcessor.this.stats);
                    try {
                        callback.done(doneSync);
                    }
                    finally {
                        if (ed.stop(ProfilerProcessor.this.stats)) {
                            ProfilerProcessor.this.exchanges.remove(exchange.getExchangeId());
                        }
                    }
                }
            });
            return bl;
        }
        finally {
            if (ed.stop(this.stats)) {
                this.exchanges.remove(exchange.getExchangeId());
            }
        }
    }

    public String toString() {
        return "Profiler[" + this.processor + "]";
    }
}

