/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.insight.camel.trace;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;

public class TracerEventMessage
implements Serializable {
    public static final String ROOT_TAG = "tracerEventMessage";
    public static final String TIMESTAMP_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private static final long serialVersionUID = 1L;
    private final long uid;
    private final Date timestamp;
    private final String toNode;
    private final String exchangeId;
    private final String messageAsXml;

    public TracerEventMessage(long uid, Date timestamp, String toNode, String exchangeId, String messageAsXml) {
        this.uid = uid;
        this.timestamp = timestamp;
        this.toNode = toNode;
        this.exchangeId = exchangeId;
        this.messageAsXml = messageAsXml;
    }

    public long getUid() {
        return this.uid;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public String getToNode() {
        return this.toNode;
    }

    public String getExchangeId() {
        return this.exchangeId;
    }

    public String getMessageAsXml() {
        return this.messageAsXml;
    }

    public String toString() {
        return "TracerEvent[" + this.exchangeId + " at " + this.toNode + "]";
    }

    public String toXml() {
        StringBuilder sb = new StringBuilder();
        sb.append("<").append(ROOT_TAG).append(">\n");
        sb.append("<uid>").append(this.uid).append("</uid>\n");
        String ts = new SimpleDateFormat(TIMESTAMP_FORMAT).format(this.timestamp);
        sb.append("<timestamp>").append(ts).append("</timestamp>\n");
        sb.append("<toNode>").append(this.toNode).append("</toNode>\n");
        sb.append("<exchangeId>").append(this.exchangeId).append("</exchangeId>\n");
        sb.append(this.messageAsXml).append("\n");
        sb.append("</").append(ROOT_TAG).append(">");
        return sb.toString();
    }
}

