/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.insight.camel.profiler;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.Processor;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RouteDefinitionHelper;
import org.apache.camel.spi.ProcessorFactory;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.StringHelper;
import org.fusesource.insight.camel.base.SwitchableContainerStrategy;
import org.fusesource.insight.camel.profiler.ExchangeData;
import org.fusesource.insight.camel.profiler.ProfilerMBean;
import org.fusesource.insight.camel.profiler.ProfilerProcessor;
import org.fusesource.insight.camel.profiler.Stats;

@ManagedResource(description="Profiler")
public class Profiler
extends SwitchableContainerStrategy
implements ProfilerMBean {
    private final Map<ProcessorDefinition<?>, Stats> statistics = new LinkedHashMap();
    private final Map<String, ExchangeData> exchanges = new ConcurrentHashMap<String, ExchangeData>();

    public Profiler() {
        this.disable();
    }

    @Override
    public void manage(CamelContext context) throws Exception {
        final ProcessorFactory delegate = context.getProcessorFactory();
        context.setProcessorFactory(new ProcessorFactory(){

            public Processor createChildProcessor(RouteContext routeContext, ProcessorDefinition<?> definition, boolean mandatory) throws Exception {
                Processor proc = delegate != null ? delegate.createChildProcessor(routeContext, definition, mandatory) : definition.createOutputsProcessor(routeContext);
                return Profiler.this.wrap(routeContext, definition, proc);
            }

            public Processor createProcessor(RouteContext routeContext, ProcessorDefinition<?> definition) throws Exception {
                Processor proc = delegate != null ? delegate.createProcessor(routeContext, definition) : definition.createProcessor(routeContext);
                return Profiler.this.wrap(routeContext, definition, proc);
            }
        });
    }

    public Processor wrap(RouteContext routeContext, ProcessorDefinition<?> definition, Processor proc) {
        if (proc == null) {
            return null;
        }
        RouteDefinition route = ProcessorDefinitionHelper.getRoute(definition);
        if (route != null && routeContext.getCamelContext().getNodeIdFactory() != null) {
            RouteDefinitionHelper.forceAssignIds((CamelContext)routeContext.getCamelContext(), (ProcessorDefinition)route);
        }
        return new ProfilerProcessor(this, proc, this.getStats(definition), this.exchanges);
    }

    @Override
    public String dumpStatsAsXml(String routeId) {
        HashSet<RouteDefinition> routes = new HashSet<RouteDefinition>();
        for (ProcessorDefinition<?> definition : this.statistics.keySet()) {
            RouteDefinition route = ProcessorDefinitionHelper.getRoute(definition);
            routes.add(route);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<profiling>");
        for (RouteDefinition route : routes) {
            if (routeId != null && !routeId.equals(route.getId())) continue;
            sb.append("<route");
            if (route.getId() != null) {
                sb.append(" id=\"").append(route.getId()).append("\"");
            }
            sb.append(">");
            this.appendStats(sb, (ProcessorDefinition<?>)route);
            sb.append("</route>");
        }
        sb.append("</profiling>");
        return sb.toString();
    }

    @Override
    public String dumpAllStatsAsXml() {
        return this.dumpStatsAsXml(null);
    }

    protected void appendStats(StringBuilder sb, ProcessorDefinition<?> definition) {
        Stats stats = this.statistics.get(definition);
        if (stats != null) {
            sb.append("<processor");
            if (definition.getId() != null) {
                sb.append(" id=\"").append(definition.getId()).append("\"");
            }
            sb.append(" definition=\"").append(StringHelper.xmlEncode((String)definition.toString())).append("\"");
            if (definition.getLabel() != null) {
                sb.append(" label=\"").append(definition.getLabel()).append("\"");
            }
            sb.append(" count=\"").append(stats.getCount()).append("\"");
            sb.append(" self=\"").append(stats.getSelf()).append("\"");
            sb.append(" total=\"").append(stats.getTotal()).append("\"");
            sb.append(">");
            for (ProcessorDefinition<?> child : this.statistics.keySet()) {
                if (child.getParent() != definition) continue;
                this.appendStats(sb, child);
            }
            sb.append("</processor>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stats getStats(ProcessorDefinition<?> definition) {
        if (definition != null) {
            Map<ProcessorDefinition<?>, Stats> map = this.statistics;
            synchronized (map) {
                Stats stats = this.statistics.get(definition);
                if (stats == null) {
                    stats = new Stats(definition, this.getStats(definition.getParent()));
                    this.statistics.put(definition, stats);
                }
                return stats;
            }
        }
        return null;
    }

    @Override
    public void reset() {
        for (Stats stats : this.statistics.values()) {
            stats.reset();
        }
    }

    public Map<ProcessorDefinition<?>, Stats> getStatistics() {
        return this.statistics;
    }
}

