/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.insight.camel.profiler;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.camel.model.ProcessorDefinition;

public class Stats {
    final AtomicLong count = new AtomicLong();
    final AtomicLong self = new AtomicLong();
    final AtomicLong total = new AtomicLong();
    final Stats parent;
    final ProcessorDefinition definition;

    public Stats(ProcessorDefinition definition, Stats parent) {
        this.definition = definition;
        this.parent = parent;
    }

    public synchronized void addTime(long self, long total) {
        this.count.incrementAndGet();
        this.self.addAndGet(self);
        this.total.addAndGet(total);
    }

    public Stats getParent() {
        return this.parent;
    }

    public long getCount() {
        return this.count.get();
    }

    public long getSelf() {
        return this.self.get();
    }

    public long getTotal() {
        return this.total.get();
    }

    public void reset() {
        this.count.set(0L);
        this.self.set(0L);
        this.total.set(0L);
    }

    public String toString() {
        return "Stats[" + this.definition.toString() + "]";
    }
}

