/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.insight.camel.trace;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.camel.CamelContext;
import org.apache.camel.Processor;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedOperation;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RouteDefinitionHelper;
import org.apache.camel.spi.NodeIdFactory;
import org.apache.camel.spi.ProcessorFactory;
import org.apache.camel.spi.RouteContext;
import org.fusesource.insight.camel.base.SwitchableContainerStrategy;
import org.fusesource.insight.camel.trace.TraceProcessor;
import org.fusesource.insight.camel.trace.TracerEventMessage;
import org.fusesource.insight.camel.trace.TracerMBean;

@ManagedResource(description="Tracer")
public class Tracer
extends SwitchableContainerStrategy
implements TracerMBean {
    private final AtomicLong traceCounter = new AtomicLong(0L);
    private Queue<TracerEventMessage> queue = new ArrayBlockingQueue<TracerEventMessage>(1000);
    private int queueSize = 10;
    private final Set<ProcessorDefinition<?>> processors = new HashSet();
    private final Set<RouteContext> routeContexts = new HashSet<RouteContext>();

    public Tracer() {
        this.disable();
    }

    @Override
    public void manage(CamelContext context) throws Exception {
        final ProcessorFactory delegate = context.getProcessorFactory();
        context.setProcessorFactory(new ProcessorFactory(){

            public Processor createChildProcessor(RouteContext routeContext, ProcessorDefinition<?> definition, boolean mandatory) throws Exception {
                Processor proc = delegate != null ? delegate.createChildProcessor(routeContext, definition, mandatory) : definition.createOutputsProcessor(routeContext);
                return Tracer.this.wrap(routeContext, definition, proc);
            }

            public Processor createProcessor(RouteContext routeContext, ProcessorDefinition<?> definition) throws Exception {
                Processor proc = delegate != null ? delegate.createProcessor(routeContext, definition) : definition.createProcessor(routeContext);
                return Tracer.this.wrap(routeContext, definition, proc);
            }
        });
    }

    public Processor wrap(RouteContext routeContext, ProcessorDefinition<?> definition, Processor processor) {
        if (processor == null) {
            return null;
        }
        boolean first = false;
        RouteDefinition route = ProcessorDefinitionHelper.getRoute(definition);
        if (route != null) {
            if (routeContext.getCamelContext().getNodeIdFactory() != null) {
                RouteDefinitionHelper.forceAssignIds((CamelContext)routeContext.getCamelContext(), (ProcessorDefinition)route);
            }
            if (!route.getOutputs().isEmpty()) {
                first = route.getOutputs().get(0) == definition;
            }
        }
        this.routeContexts.add(routeContext);
        this.processors.add(definition);
        return new TraceProcessor(this.queue, processor, definition, (ProcessorDefinition<?>)route, first, this);
    }

    @Override
    @ManagedAttribute(description="Is tracing enabled")
    public void setEnabled(boolean enabled) {
        if (enabled) {
            this.forceAutoAssigningIds();
            this.enable();
        } else {
            this.disable();
        }
    }

    @Override
    @ManagedAttribute(description="Number of traced messages to keep in FIFO queue")
    public int getQueueSize() {
        return this.queueSize;
    }

    @Override
    @ManagedAttribute(description="Number of traced messages to keep in FIFO queue")
    public void setQueueSize(int queueSize) {
        if (queueSize <= 0) {
            throw new IllegalArgumentException("The queue size must be a positive number, was: " + queueSize);
        }
        this.queueSize = queueSize;
    }

    @Override
    @ManagedAttribute(description="Number of total traced messages")
    public long getTraceCounter() {
        return this.traceCounter.get();
    }

    @Override
    @ManagedOperation(description="Resets the trace counter")
    public void resetTraceCounter() {
        this.traceCounter.set(0L);
    }

    @Override
    @ManagedOperation(description="Dumps the traced messages for the given node")
    public List<TracerEventMessage> dumpTracedMessages(String nodeId) {
        ArrayList<TracerEventMessage> answer = new ArrayList<TracerEventMessage>();
        if (nodeId != null) {
            for (TracerEventMessage message : this.queue) {
                if (!nodeId.equals(message.getToNode())) continue;
                answer.add(message);
            }
        }
        return answer;
    }

    @ManagedOperation(description="Dumps the traced messages for the given node in xml format")
    public String dumpTracedMessagesAsXml(String nodeId) {
        List<TracerEventMessage> events = this.dumpTracedMessages(nodeId);
        StringBuilder sb = new StringBuilder();
        sb.append("<").append("tracerEventMessage").append("s>");
        for (TracerEventMessage event : events) {
            sb.append("\n").append(event.toXml());
        }
        sb.append("\n</").append("tracerEventMessage").append("s>");
        return sb.toString();
    }

    @Override
    @ManagedOperation(description="Dumps the traced messages for all nodes")
    public List<TracerEventMessage> dumpAllTracedMessages() {
        ArrayList<TracerEventMessage> answer = new ArrayList<TracerEventMessage>();
        answer.addAll(this.queue);
        this.queue.clear();
        return answer;
    }

    @Override
    @ManagedOperation(description="Dumps the traced messages for all nodes in xml format")
    public String dumpAllTracedMessagesAsXml() {
        List<TracerEventMessage> events = this.dumpAllTracedMessages();
        StringBuilder sb = new StringBuilder();
        sb.append("<").append("tracerEventMessage").append("s>");
        for (TracerEventMessage event : events) {
            sb.append("\n").append(event.toXml());
        }
        sb.append("\n</").append("tracerEventMessage").append("s>");
        return sb.toString();
    }

    long incrementTraceCounter() {
        return this.traceCounter.incrementAndGet();
    }

    void stopProcessor(TraceProcessor processor, ProcessorDefinition<?> processorDefinition) {
        this.processors.remove(processorDefinition);
    }

    private void forceAutoAssigningIds() {
        for (RouteContext routeContext : this.routeContexts) {
            CamelContext camelContext = routeContext.getCamelContext();
            NodeIdFactory factory = camelContext.getNodeIdFactory();
            if (factory == null) continue;
            for (ProcessorDefinition<?> child : this.processors) {
                RouteDefinitionHelper.forceAssignIds((CamelContext)camelContext, child);
            }
        }
    }
}

